/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-10-07 09:10:12 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_abz7_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3405 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=32711 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=2937 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_abz7_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_jet_appointments` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `group_ID` bigint(20) DEFAULT NULL,
  `status` text DEFAULT NULL,
  `service` text DEFAULT NULL,
  `provider` text DEFAULT NULL,
  `order_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `user_name` text NOT NULL,
  `user_email` text DEFAULT NULL,
  `date` bigint(20) NOT NULL,
  `date_end` bigint(20) NOT NULL,
  `slot` bigint(20) NOT NULL,
  `slot_end` bigint(20) NOT NULL,
  `type` text DEFAULT NULL,
  `appointment_date` datetime DEFAULT current_timestamp(),
  `patient_phone_number` text DEFAULT NULL,
  `pjet_formid` bigint(20) DEFAULT NULL,
  `pjet_phone` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=258 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_jet_appointments_excluded` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `service` text DEFAULT NULL,
  `provider` text DEFAULT NULL,
  `date` bigint(20) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_jet_appointments_meta` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `appointment_id` bigint(20) DEFAULT NULL,
  `meta_key` text DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=772 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_jet_cache` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `source` varchar(191) NOT NULL DEFAULT 'default',
  `source_id` bigint(20) NOT NULL DEFAULT 0,
  `cache_key` varchar(191) DEFAULT NULL,
  `cache_data` longtext DEFAULT NULL,
  `cache_expired` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_jet_cct_reviews` (
  `_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `cct_status` text DEFAULT NULL,
  `review_name` text DEFAULT NULL,
  `review_role` text DEFAULT NULL,
  `review_text` longtext DEFAULT NULL,
  `review_pic` bigint(20) DEFAULT NULL,
  `cct_author_id` bigint(20) DEFAULT NULL,
  `cct_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `cct_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_jet_post_types` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_jet_smart_filters_indexer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `item_id` int(10) unsigned DEFAULT NULL,
  `item_query` varchar(50) DEFAULT NULL,
  `item_key` varchar(50) DEFAULT NULL,
  `item_value` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_jet_taxonomies` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `slug` text DEFAULT NULL,
  `object_type` text DEFAULT NULL,
  `status` text DEFAULT NULL,
  `labels` longtext DEFAULT NULL,
  `args` longtext DEFAULT NULL,
  `meta_fields` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=74846 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_payamito_sms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `reciever` varchar(100) DEFAULT NULL,
  `method` tinyint(1) NOT NULL,
  `slug` varchar(255) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT 0,
  `message` varchar(500) NOT NULL DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_abz7_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=31523 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=3438 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=999 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=920 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=425 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_abz7_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_abz7_actionscheduler_actions */
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("2422", "action_scheduler/migration_hook", "failed", "2023-03-31 05:34:48", "2023-03-31 09:04:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1680240888;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1680240888;}", "1", "1", "2023-03-31 05:34:52", "2023-03-31 09:04:52", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("2445", "action_scheduler/migration_hook", "failed", "2023-04-03 13:15:22", "2023-04-03 16:45:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1680527722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1680527722;}", "1", "1", "2023-04-03 13:15:34", "2023-04-03 16:45:34", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("2537", "action_scheduler/migration_hook", "failed", "2023-05-31 06:53:45", "2023-05-31 10:23:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1685516025;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1685516025;}", "1", "1", "2023-05-31 06:54:46", "2023-05-31 10:24:46", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("2539", "rocket_preload_job_check_finished", "failed", "2023-05-31 08:52:20", "2023-05-31 12:22:20", "[1685523080]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1685523140;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1685523140;}", "4", "1", "2023-05-31 08:54:12", "2023-05-31 12:24:12", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("2550", "action_scheduler/migration_hook", "failed", "2023-05-31 08:55:12", "2023-05-31 12:25:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1685523312;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1685523312;}", "1", "1", "2023-05-31 08:56:13", "2023-05-31 12:26:13", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3366", "woocommerce_cleanup_draft_orders", "complete", "2025-09-21 00:54:55", "2025-09-21 04:24:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758416095;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758416095;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-21 02:06:51", "2025-09-21 05:36:51", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3376", "woocommerce_cleanup_draft_orders", "complete", "2025-10-01 17:23:25", "2025-10-01 20:53:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759339405;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759339405;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-10-01 19:59:49", "2025-10-01 23:29:49", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3358", "woocommerce_cleanup_draft_orders", "complete", "2025-09-12 02:02:58", "2025-09-12 05:32:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757642578;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757642578;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-12 06:23:20", "2025-09-12 09:53:20", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3367", "woocommerce_cleanup_draft_orders", "complete", "2025-09-22 02:06:51", "2025-09-22 05:36:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758506811;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758506811;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-22 11:47:06", "2025-09-22 15:17:06", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3375", "woocommerce_cleanup_draft_orders", "complete", "2025-09-30 16:10:19", "2025-09-30 19:40:19", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759248619;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759248619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-30 17:23:25", "2025-09-30 20:53:25", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3355", "woocommerce_cleanup_draft_orders", "complete", "2025-09-08 21:30:34", "2025-09-09 01:00:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757367034;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757367034;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-08 21:51:36", "2025-09-09 01:21:36", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3356", "woocommerce_cleanup_draft_orders", "complete", "2025-09-09 21:51:36", "2025-09-10 01:21:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757454696;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757454696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-09 23:26:49", "2025-09-10 02:56:49", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3357", "woocommerce_cleanup_draft_orders", "complete", "2025-09-10 23:26:49", "2025-09-11 02:56:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757546809;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757546809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-11 02:02:58", "2025-09-11 05:32:58", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3368", "woocommerce_cleanup_draft_orders", "complete", "2025-09-23 11:47:06", "2025-09-23 15:17:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758628026;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758628026;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-23 13:35:38", "2025-09-23 17:05:38", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3369", "woocommerce_cleanup_draft_orders", "complete", "2025-09-24 13:35:38", "2025-09-24 17:05:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758720938;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758720938;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-24 14:00:14", "2025-09-24 17:30:14", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3370", "woocommerce_cleanup_draft_orders", "complete", "2025-09-25 14:00:14", "2025-09-25 17:30:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758808814;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758808814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-25 14:24:44", "2025-09-25 17:54:44", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3377", "woocommerce_cleanup_draft_orders", "complete", "2025-10-02 19:59:49", "2025-10-02 23:29:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759435189;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759435189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-10-02 20:40:17", "2025-10-03 00:10:17", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3378", "woocommerce_cleanup_draft_orders", "complete", "2025-10-03 20:40:17", "2025-10-04 00:10:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759524017;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759524017;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-10-03 23:15:32", "2025-10-04 02:45:32", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3379", "woocommerce_cleanup_draft_orders", "complete", "2025-10-04 23:15:32", "2025-10-05 02:45:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759619732;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759619732;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-10-05 16:02:32", "2025-10-05 19:32:32", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3353", "woocommerce_cleanup_draft_orders", "complete", "2025-09-06 17:36:17", "2025-09-06 21:06:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757180177;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757180177;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-06 18:16:42", "2025-09-06 21:46:42", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3354", "woocommerce_cleanup_draft_orders", "complete", "2025-09-07 18:16:42", "2025-09-07 21:46:42", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757269002;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757269002;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-07 21:30:34", "2025-09-08 01:00:34", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3359", "woocommerce_cleanup_draft_orders", "complete", "2025-09-13 06:23:20", "2025-09-13 09:53:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757744600;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757744600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-13 12:56:19", "2025-09-13 16:26:19", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3360", "woocommerce_cleanup_draft_orders", "complete", "2025-09-14 12:56:19", "2025-09-14 16:26:19", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757854579;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757854579;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-14 14:21:35", "2025-09-14 17:51:35", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3361", "woocommerce_cleanup_draft_orders", "complete", "2025-09-15 14:21:35", "2025-09-15 17:51:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757946095;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757946095;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-15 16:10:21", "2025-09-15 19:40:21", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3362", "woocommerce_cleanup_draft_orders", "complete", "2025-09-16 16:10:21", "2025-09-16 19:40:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758039021;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758039021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-16 16:17:25", "2025-09-16 19:47:25", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3363", "woocommerce_cleanup_draft_orders", "complete", "2025-09-17 16:17:25", "2025-09-17 19:47:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758125845;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758125845;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-17 17:25:15", "2025-09-17 20:55:15", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3364", "woocommerce_cleanup_draft_orders", "complete", "2025-09-18 17:25:15", "2025-09-18 20:55:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758216315;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758216315;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-19 00:18:58", "2025-09-19 03:48:58", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3365", "woocommerce_cleanup_draft_orders", "complete", "2025-09-20 00:18:58", "2025-09-20 03:48:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758327538;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758327538;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-20 00:54:55", "2025-09-20 04:24:55", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3371", "woocommerce_cleanup_draft_orders", "complete", "2025-09-26 14:24:44", "2025-09-26 17:54:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758896684;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758896684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-26 15:47:31", "2025-09-26 19:17:31", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3372", "woocommerce_cleanup_draft_orders", "complete", "2025-09-27 15:47:31", "2025-09-27 19:17:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758988051;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758988051;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-27 15:48:33", "2025-09-27 19:18:33", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3373", "woocommerce_cleanup_draft_orders", "complete", "2025-09-28 15:48:33", "2025-09-28 19:18:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759074513;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759074513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-28 16:04:44", "2025-09-28 19:34:44", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3374", "woocommerce_cleanup_draft_orders", "complete", "2025-09-29 16:04:44", "2025-09-29 19:34:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759161884;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759161884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-29 16:10:19", "2025-09-29 19:40:19", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3380", "woocommerce_cleanup_draft_orders", "complete", "2025-10-06 16:02:32", "2025-10-06 19:32:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759766552;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759766552;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-10-06 17:16:58", "2025-10-06 20:46:58", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3381", "woocommerce_cleanup_draft_orders", "pending", "2025-10-07 17:16:58", "2025-10-07 20:46:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759857418;s:18:\"\0*\0first_timestamp\";i:1680240753;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759857418;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3382", "fetch_patterns", "complete", "2025-10-07 08:27:35", "2025-10-07 11:57:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759825655;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759825655;}", "5", "1", "2025-10-07 08:27:50", "2025-10-07 11:57:50", "32700", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3383", "woocommerce_run_update_callback", "complete", "2025-10-07 08:27:48", "2025-10-07 11:57:48", "{\"update_callback\":\"wc_update_985_enable_new_payments_settings_page_feature\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759825668;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759825668;}", "2", "1", "2025-10-07 08:27:50", "2025-10-07 11:57:50", "32700", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3384", "woocommerce_run_update_callback", "complete", "2025-10-07 08:27:49", "2025-10-07 11:57:49", "{\"update_callback\":\"wc_update_990_remove_wc_count_comments_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759825669;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759825669;}", "2", "1", "2025-10-07 08:27:50", "2025-10-07 11:57:50", "32700", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3385", "woocommerce_run_update_callback", "complete", "2025-10-07 08:27:50", "2025-10-07 11:57:50", "{\"update_callback\":\"wc_update_990_remove_email_notes\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759825670;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759825670;}", "2", "1", "2025-10-07 08:27:50", "2025-10-07 11:57:50", "32700", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3386", "woocommerce_run_update_callback", "complete", "2025-10-07 08:27:51", "2025-10-07 11:57:51", "{\"update_callback\":\"wc_update_1000_multisite_visibility_setting\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759825671;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759825671;}", "2", "1", "2025-10-07 08:27:56", "2025-10-07 11:57:56", "32702", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3387", "woocommerce_run_update_callback", "complete", "2025-10-07 08:27:52", "2025-10-07 11:57:52", "{\"update_callback\":\"wc_update_1000_remove_patterns_toolkit_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759825672;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759825672;}", "2", "1", "2025-10-07 08:27:56", "2025-10-07 11:57:56", "32702", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3388", "woocommerce_run_update_callback", "complete", "2025-10-07 08:27:53", "2025-10-07 11:57:53", "{\"update_callback\":\"wc_update_1020_add_old_refunded_order_items_to_product_lookup_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759825673;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759825673;}", "2", "1", "2025-10-07 08:27:56", "2025-10-07 11:57:56", "32702", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3389", "woocommerce_update_db_to_current_version", "complete", "2025-10-07 08:27:54", "2025-10-07 11:57:54", "{\"version\":\"10.2.2\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759825674;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759825674;}", "2", "1", "2025-10-07 08:27:56", "2025-10-07 11:57:56", "32702", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3390", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-07 08:33:12", "2025-10-07 12:03:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759825992;s:18:\"\0*\0first_timestamp\";i:1759825992;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759825992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-10-07 08:33:15", "2025-10-07 12:03:15", "32704", NULL, "20");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3391", "woocommerce_scheduled_sales", "pending", "2025-10-07 21:00:00", "2025-10-08 00:30:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759870800;s:18:\"\0*\0first_timestamp\";i:1759870800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759870800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3392", "woocommerce_cancel_unpaid_orders", "pending", "2025-10-07 09:33:15", "2025-10-07 13:03:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759829595;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759829595;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3393", "woocommerce_cleanup_personal_data", "complete", "2025-10-07 08:33:25", "2025-10-07 12:03:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759826005;s:18:\"\0*\0first_timestamp\";i:1759826005;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759826005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-07 08:34:19", "2025-10-07 12:04:19", "32707", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3394", "woocommerce_cleanup_logs", "pending", "2025-10-07 11:33:15", "2025-10-07 15:03:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759836795;s:18:\"\0*\0first_timestamp\";i:1759836795;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759836795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3395", "woocommerce_cleanup_sessions", "pending", "2025-10-07 14:33:15", "2025-10-07 18:03:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759847595;s:18:\"\0*\0first_timestamp\";i:1759847595;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759847595;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3396", "woocommerce_geoip_updater", "complete", "2025-10-07 08:34:15", "2025-10-07 12:04:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759826055;s:18:\"\0*\0first_timestamp\";i:1759826055;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759826055;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "7", "1", "2025-10-07 08:34:19", "2025-10-07 12:04:19", "32707", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3397", "woocommerce_cleanup_rate_limits_wrapper", "pending", "2025-10-07 11:33:15", "2025-10-07 15:03:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759836795;s:18:\"\0*\0first_timestamp\";i:1759836795;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759836795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3398", "wc_admin_daily_wrapper", "complete", "2025-10-07 08:33:15", "2025-10-07 12:03:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759825995;s:18:\"\0*\0first_timestamp\";i:1759825995;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759825995;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-10-07 08:33:15", "2025-10-07 12:03:15", "32705", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3399", "generate_category_lookup_table_wrapper", "complete", "2025-10-07 08:33:25", "2025-10-07 12:03:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759826005;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759826005;}", "7", "1", "2025-10-07 08:34:19", "2025-10-07 12:04:19", "32707", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3400", "woocommerce_refresh_order_count_cache", "pending", "2025-10-07 20:33:15", "2025-10-08 00:03:15", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759869195;s:18:\"\0*\0first_timestamp\";i:1759869195;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759869195;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3401", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-10-08 08:33:15", "2025-10-08 12:03:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759912395;s:18:\"\0*\0first_timestamp\";i:1759825992;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759912395;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "20");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3402", "wc_admin_daily_wrapper", "pending", "2025-10-08 08:33:15", "2025-10-08 12:03:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759912395;s:18:\"\0*\0first_timestamp\";i:1759825995;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759912395;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3403", "woocommerce_cleanup_personal_data", "pending", "2025-10-08 08:34:19", "2025-10-08 12:04:19", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759912459;s:18:\"\0*\0first_timestamp\";i:1759826005;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759912459;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_abz7_actionscheduler_actions` VALUES("3404", "woocommerce_geoip_updater", "pending", "2025-10-22 08:34:19", "2025-10-22 12:04:19", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761122059;s:18:\"\0*\0first_timestamp\";i:1759826055;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761122059;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");

/* INSERT TABLE DATA: wp_abz7_actionscheduler_groups */
INSERT INTO `wp_abz7_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_abz7_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `wp_abz7_actionscheduler_groups` VALUES("3", "wc-admin-data");
INSERT INTO `wp_abz7_actionscheduler_groups` VALUES("4", "rocket-preload");
INSERT INTO `wp_abz7_actionscheduler_groups` VALUES("5", "");
INSERT INTO `wp_abz7_actionscheduler_groups` VALUES("6", "ActionScheduler");
INSERT INTO `wp_abz7_actionscheduler_groups` VALUES("7", "woocommerce");
INSERT INTO `wp_abz7_actionscheduler_groups` VALUES("8", "count");

/* INSERT TABLE DATA: wp_abz7_actionscheduler_logs */
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("8", "2422", "action created", "2023-03-31 05:33:48", "2023-03-31 09:03:48");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("9", "2422", "عملیات توسط Async Request شروع شد", "2023-03-31 05:34:52", "2023-03-31 09:04:52");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("10", "2422", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-03-31 05:34:52", "2023-03-31 09:04:52");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("77", "2445", "ایجاد فعالیت", "2023-04-03 13:14:22", "2023-04-03 16:44:22");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("78", "2445", "عملیات توسط WP Cron شروع شد", "2023-04-03 13:15:34", "2023-04-03 16:45:34");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("79", "2445", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-04-03 13:15:34", "2023-04-03 16:45:34");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("353", "2537", "ایجاد فعالیت", "2023-05-31 06:52:45", "2023-05-31 10:22:45");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("354", "2537", "عملیات توسط WP Cron شروع شد", "2023-05-31 06:54:46", "2023-05-31 10:24:46");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("355", "2537", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-05-31 06:54:46", "2023-05-31 10:24:46");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("357", "2539", "ایجاد فعالیت", "2023-05-31 08:51:20", "2023-05-31 12:21:20");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("388", "2539", "عملیات توسط WP Cron شروع شد", "2023-05-31 08:54:12", "2023-05-31 12:24:12");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("389", "2539", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.", "2023-05-31 08:54:12", "2023-05-31 12:24:12");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("392", "2550", "ایجاد فعالیت", "2023-05-31 08:54:12", "2023-05-31 12:24:12");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("393", "2550", "عملیات توسط WP Cron شروع شد", "2023-05-31 08:56:13", "2023-05-31 12:26:13");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("394", "2550", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-05-31 08:56:13", "2023-05-31 12:26:13");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2842", "3366", "ایجاد فعالیت", "2025-09-20 00:54:55", "2025-09-20 04:24:55");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2841", "3365", "عملیات توسط WP Cron کامل شد", "2025-09-20 00:54:55", "2025-09-20 04:24:55");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2872", "3376", "ایجاد فعالیت", "2025-09-30 17:23:25", "2025-09-30 20:53:25");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2868", "3374", "عملیات توسط WP Cron کامل شد", "2025-09-29 16:10:19", "2025-09-29 19:40:19");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2818", "3358", "ایجاد فعالیت", "2025-09-11 02:02:58", "2025-09-11 05:32:58");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2814", "3356", "عملیات توسط WP Cron کامل شد", "2025-09-09 23:26:49", "2025-09-10 02:56:49");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2817", "3357", "عملیات توسط WP Cron کامل شد", "2025-09-11 02:02:58", "2025-09-11 05:32:58");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2816", "3357", "عملیات توسط WP Cron شروع شد", "2025-09-11 02:02:58", "2025-09-11 05:32:58");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2840", "3365", "عملیات توسط WP Cron شروع شد", "2025-09-20 00:54:55", "2025-09-20 04:24:55");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2809", "3355", "ایجاد فعالیت", "2025-09-07 21:30:34", "2025-09-08 01:00:34");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2808", "3354", "عملیات توسط WP Cron کامل شد", "2025-09-07 21:30:34", "2025-09-08 01:00:34");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2807", "3354", "عملیات توسط WP Cron شروع شد", "2025-09-07 21:30:34", "2025-09-08 01:00:34");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2812", "3356", "ایجاد فعالیت", "2025-09-08 21:51:36", "2025-09-09 01:21:36");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2811", "3355", "عملیات توسط WP Cron کامل شد", "2025-09-08 21:51:36", "2025-09-09 01:21:36");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2810", "3355", "عملیات توسط WP Cron شروع شد", "2025-09-08 21:51:36", "2025-09-09 01:21:36");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2813", "3356", "عملیات توسط WP Cron شروع شد", "2025-09-09 23:26:49", "2025-09-10 02:56:49");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2845", "3367", "ایجاد فعالیت", "2025-09-21 02:06:51", "2025-09-21 05:36:51");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2844", "3366", "عملیات توسط WP Cron کامل شد", "2025-09-21 02:06:51", "2025-09-21 05:36:51");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2843", "3366", "عملیات توسط WP Cron شروع شد", "2025-09-21 02:06:51", "2025-09-21 05:36:51");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2847", "3367", "عملیات توسط Async Request کامل شد", "2025-09-22 11:47:06", "2025-09-22 15:17:06");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2846", "3367", "عملیات توسط Async Request شروع شد", "2025-09-22 11:47:06", "2025-09-22 15:17:06");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2851", "3369", "ایجاد فعالیت", "2025-09-23 13:35:38", "2025-09-23 17:05:38");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2850", "3368", "عملیات توسط WP Cron کامل شد", "2025-09-23 13:35:38", "2025-09-23 17:05:38");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2849", "3368", "عملیات توسط WP Cron شروع شد", "2025-09-23 13:35:38", "2025-09-23 17:05:38");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2854", "3370", "ایجاد فعالیت", "2025-09-24 14:00:14", "2025-09-24 17:30:14");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2853", "3369", "عملیات توسط Async Request کامل شد", "2025-09-24 14:00:14", "2025-09-24 17:30:14");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2852", "3369", "عملیات توسط Async Request شروع شد", "2025-09-24 14:00:14", "2025-09-24 17:30:14");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2867", "3374", "عملیات توسط WP Cron شروع شد", "2025-09-29 16:10:19", "2025-09-29 19:40:19");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2871", "3375", "عملیات توسط WP Cron کامل شد", "2025-09-30 17:23:25", "2025-09-30 20:53:25");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2870", "3375", "عملیات توسط WP Cron شروع شد", "2025-09-30 17:23:25", "2025-09-30 20:53:25");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2875", "3377", "ایجاد فعالیت", "2025-10-01 19:59:49", "2025-10-01 23:29:49");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2874", "3376", "عملیات توسط WP Cron کامل شد", "2025-10-01 19:59:49", "2025-10-01 23:29:49");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2873", "3376", "عملیات توسط WP Cron شروع شد", "2025-10-01 19:59:49", "2025-10-01 23:29:49");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2878", "3378", "ایجاد فعالیت", "2025-10-02 20:40:17", "2025-10-03 00:10:17");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2877", "3377", "عملیات توسط WP Cron کامل شد", "2025-10-02 20:40:17", "2025-10-03 00:10:17");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2876", "3377", "عملیات توسط WP Cron شروع شد", "2025-10-02 20:40:17", "2025-10-03 00:10:17");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2881", "3379", "ایجاد فعالیت", "2025-10-03 23:15:32", "2025-10-04 02:45:32");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2880", "3378", "عملیات توسط WP Cron کامل شد", "2025-10-03 23:15:32", "2025-10-04 02:45:32");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2879", "3378", "عملیات توسط WP Cron شروع شد", "2025-10-03 23:15:32", "2025-10-04 02:45:32");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2803", "3353", "ایجاد فعالیت", "2025-09-05 17:36:17", "2025-09-05 21:06:17");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2804", "3353", "عملیات توسط WP Cron شروع شد", "2025-09-06 18:16:42", "2025-09-06 21:46:42");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2805", "3353", "عملیات توسط WP Cron کامل شد", "2025-09-06 18:16:42", "2025-09-06 21:46:42");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2806", "3354", "ایجاد فعالیت", "2025-09-06 18:16:42", "2025-09-06 21:46:42");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2815", "3357", "ایجاد فعالیت", "2025-09-09 23:26:49", "2025-09-10 02:56:49");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2819", "3358", "عملیات توسط WP Cron شروع شد", "2025-09-12 06:23:20", "2025-09-12 09:53:20");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2820", "3358", "عملیات توسط WP Cron کامل شد", "2025-09-12 06:23:20", "2025-09-12 09:53:20");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2821", "3359", "ایجاد فعالیت", "2025-09-12 06:23:20", "2025-09-12 09:53:20");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2822", "3359", "عملیات توسط WP Cron شروع شد", "2025-09-13 12:56:19", "2025-09-13 16:26:19");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2823", "3359", "عملیات توسط WP Cron کامل شد", "2025-09-13 12:56:19", "2025-09-13 16:26:19");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2824", "3360", "ایجاد فعالیت", "2025-09-13 12:56:19", "2025-09-13 16:26:19");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2825", "3360", "عملیات توسط Async Request شروع شد", "2025-09-14 14:21:35", "2025-09-14 17:51:35");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2826", "3360", "عملیات توسط Async Request کامل شد", "2025-09-14 14:21:35", "2025-09-14 17:51:35");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2827", "3361", "ایجاد فعالیت", "2025-09-14 14:21:35", "2025-09-14 17:51:35");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2828", "3361", "عملیات توسط Async Request شروع شد", "2025-09-15 16:10:21", "2025-09-15 19:40:21");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2829", "3361", "عملیات توسط Async Request کامل شد", "2025-09-15 16:10:21", "2025-09-15 19:40:21");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2830", "3362", "ایجاد فعالیت", "2025-09-15 16:10:21", "2025-09-15 19:40:21");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2831", "3362", "عملیات توسط WP Cron شروع شد", "2025-09-16 16:17:25", "2025-09-16 19:47:25");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2832", "3362", "عملیات توسط WP Cron کامل شد", "2025-09-16 16:17:25", "2025-09-16 19:47:25");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2833", "3363", "ایجاد فعالیت", "2025-09-16 16:17:25", "2025-09-16 19:47:25");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2834", "3363", "عملیات توسط WP Cron شروع شد", "2025-09-17 17:25:15", "2025-09-17 20:55:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2835", "3363", "عملیات توسط WP Cron کامل شد", "2025-09-17 17:25:15", "2025-09-17 20:55:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2836", "3364", "ایجاد فعالیت", "2025-09-17 17:25:15", "2025-09-17 20:55:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2837", "3364", "عملیات توسط WP Cron شروع شد", "2025-09-19 00:18:58", "2025-09-19 03:48:58");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2838", "3364", "عملیات توسط WP Cron کامل شد", "2025-09-19 00:18:58", "2025-09-19 03:48:58");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2839", "3365", "ایجاد فعالیت", "2025-09-19 00:18:58", "2025-09-19 03:48:58");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2848", "3368", "ایجاد فعالیت", "2025-09-22 11:47:06", "2025-09-22 15:17:06");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2855", "3370", "عملیات توسط WP Cron شروع شد", "2025-09-25 14:24:44", "2025-09-25 17:54:44");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2856", "3370", "عملیات توسط WP Cron کامل شد", "2025-09-25 14:24:44", "2025-09-25 17:54:44");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2857", "3371", "ایجاد فعالیت", "2025-09-25 14:24:44", "2025-09-25 17:54:44");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2858", "3371", "عملیات توسط WP Cron شروع شد", "2025-09-26 15:47:31", "2025-09-26 19:17:31");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2859", "3371", "عملیات توسط WP Cron کامل شد", "2025-09-26 15:47:31", "2025-09-26 19:17:31");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2860", "3372", "ایجاد فعالیت", "2025-09-26 15:47:31", "2025-09-26 19:17:31");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2861", "3372", "عملیات توسط WP Cron شروع شد", "2025-09-27 15:48:33", "2025-09-27 19:18:33");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2862", "3372", "عملیات توسط WP Cron کامل شد", "2025-09-27 15:48:33", "2025-09-27 19:18:33");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2863", "3373", "ایجاد فعالیت", "2025-09-27 15:48:33", "2025-09-27 19:18:33");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2864", "3373", "عملیات توسط WP Cron شروع شد", "2025-09-28 16:04:44", "2025-09-28 19:34:44");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2865", "3373", "عملیات توسط WP Cron کامل شد", "2025-09-28 16:04:44", "2025-09-28 19:34:44");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2866", "3374", "ایجاد فعالیت", "2025-09-28 16:04:44", "2025-09-28 19:34:44");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2869", "3375", "ایجاد فعالیت", "2025-09-29 16:10:19", "2025-09-29 19:40:19");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2882", "3379", "عملیات توسط Async Request شروع شد", "2025-10-05 16:02:32", "2025-10-05 19:32:32");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2883", "3379", "عملیات توسط Async Request کامل شد", "2025-10-05 16:02:32", "2025-10-05 19:32:32");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2884", "3380", "ایجاد فعالیت", "2025-10-05 16:02:32", "2025-10-05 19:32:32");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2885", "3380", "عملیات توسط WP Cron شروع شد", "2025-10-06 17:16:57", "2025-10-06 20:46:57");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2886", "3380", "عملیات توسط WP Cron کامل شد", "2025-10-06 17:16:58", "2025-10-06 20:46:58");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2887", "3381", "ایجاد فعالیت", "2025-10-06 17:16:58", "2025-10-06 20:46:58");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2888", "3382", "ایجاد فعالیت", "2025-10-07 08:27:35", "2025-10-07 11:57:35");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2889", "3383", "ایجاد فعالیت", "2025-10-07 08:27:48", "2025-10-07 11:57:48");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2890", "3384", "ایجاد فعالیت", "2025-10-07 08:27:48", "2025-10-07 11:57:48");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2891", "3385", "ایجاد فعالیت", "2025-10-07 08:27:48", "2025-10-07 11:57:48");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2892", "3386", "ایجاد فعالیت", "2025-10-07 08:27:48", "2025-10-07 11:57:48");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2893", "3387", "ایجاد فعالیت", "2025-10-07 08:27:48", "2025-10-07 11:57:48");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2894", "3388", "ایجاد فعالیت", "2025-10-07 08:27:48", "2025-10-07 11:57:48");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2895", "3389", "ایجاد فعالیت", "2025-10-07 08:27:48", "2025-10-07 11:57:48");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2896", "3382", "عملیات توسط Async Request شروع شد", "2025-10-07 08:27:50", "2025-10-07 11:57:50");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2897", "3382", "عملیات توسط Async Request کامل شد", "2025-10-07 08:27:50", "2025-10-07 11:57:50");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2898", "3383", "عملیات توسط Async Request شروع شد", "2025-10-07 08:27:50", "2025-10-07 11:57:50");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2899", "3383", "عملیات توسط Async Request کامل شد", "2025-10-07 08:27:50", "2025-10-07 11:57:50");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2900", "3384", "عملیات توسط Async Request شروع شد", "2025-10-07 08:27:50", "2025-10-07 11:57:50");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2901", "3384", "عملیات توسط Async Request کامل شد", "2025-10-07 08:27:50", "2025-10-07 11:57:50");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2902", "3385", "عملیات توسط Async Request شروع شد", "2025-10-07 08:27:50", "2025-10-07 11:57:50");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2903", "3385", "عملیات توسط Async Request کامل شد", "2025-10-07 08:27:50", "2025-10-07 11:57:50");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2904", "3386", "عملیات توسط Async Request شروع شد", "2025-10-07 08:27:56", "2025-10-07 11:57:56");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2905", "3386", "عملیات توسط Async Request کامل شد", "2025-10-07 08:27:56", "2025-10-07 11:57:56");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2906", "3387", "عملیات توسط Async Request شروع شد", "2025-10-07 08:27:56", "2025-10-07 11:57:56");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2907", "3387", "عملیات توسط Async Request کامل شد", "2025-10-07 08:27:56", "2025-10-07 11:57:56");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2908", "3388", "عملیات توسط Async Request شروع شد", "2025-10-07 08:27:56", "2025-10-07 11:57:56");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2909", "3388", "عملیات توسط Async Request کامل شد", "2025-10-07 08:27:56", "2025-10-07 11:57:56");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2910", "3389", "عملیات توسط Async Request شروع شد", "2025-10-07 08:27:56", "2025-10-07 11:57:56");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2911", "3389", "عملیات توسط Async Request کامل شد", "2025-10-07 08:27:56", "2025-10-07 11:57:56");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2912", "3390", "ایجاد فعالیت", "2025-10-07 08:33:12", "2025-10-07 12:03:12");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2913", "3390", "عملیات توسط Async Request شروع شد", "2025-10-07 08:33:14", "2025-10-07 12:03:14");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2914", "3391", "ایجاد فعالیت", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2915", "3392", "ایجاد فعالیت", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2916", "3393", "ایجاد فعالیت", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2917", "3394", "ایجاد فعالیت", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2918", "3395", "ایجاد فعالیت", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2919", "3396", "ایجاد فعالیت", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2920", "3397", "ایجاد فعالیت", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2921", "3398", "ایجاد فعالیت", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2922", "3399", "ایجاد فعالیت", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2923", "3400", "ایجاد فعالیت", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2924", "3390", "عملیات توسط Async Request کامل شد", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2925", "3401", "ایجاد فعالیت", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2926", "3398", "عملیات توسط Async Request شروع شد", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2927", "3398", "عملیات توسط Async Request کامل شد", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2928", "3402", "ایجاد فعالیت", "2025-10-07 08:33:15", "2025-10-07 12:03:15");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2929", "3393", "عملیات توسط Async Request شروع شد", "2025-10-07 08:34:18", "2025-10-07 12:04:18");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2930", "3393", "عملیات توسط Async Request کامل شد", "2025-10-07 08:34:19", "2025-10-07 12:04:19");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2931", "3403", "ایجاد فعالیت", "2025-10-07 08:34:19", "2025-10-07 12:04:19");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2932", "3399", "عملیات توسط Async Request شروع شد", "2025-10-07 08:34:19", "2025-10-07 12:04:19");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2933", "3399", "عملیات توسط Async Request کامل شد", "2025-10-07 08:34:19", "2025-10-07 12:04:19");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2934", "3396", "عملیات توسط Async Request شروع شد", "2025-10-07 08:34:19", "2025-10-07 12:04:19");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2935", "3396", "عملیات توسط Async Request کامل شد", "2025-10-07 08:34:19", "2025-10-07 12:04:19");
INSERT INTO `wp_abz7_actionscheduler_logs` VALUES("2936", "3404", "ایجاد فعالیت", "2025-10-07 08:34:19", "2025-10-07 12:04:19");

/* INSERT TABLE DATA: wp_abz7_commentmeta */
INSERT INTO `wp_abz7_commentmeta` VALUES("1", "5", "akismet_history", "a:3:{s:4:\"time\";d:1679936989.626442;s:5:\"event\";s:15:\"status-approved\";s:4:\"user\";s:9:\"demoabzar\";}");
INSERT INTO `wp_abz7_commentmeta` VALUES("2", "6", "rating", "4");
INSERT INTO `wp_abz7_commentmeta` VALUES("3", "6", "verified", "0");
INSERT INTO `wp_abz7_commentmeta` VALUES("4", "7", "rating", "5");
INSERT INTO `wp_abz7_commentmeta` VALUES("5", "7", "verified", "0");

/* INSERT TABLE DATA: wp_abz7_comments */
INSERT INTO `wp_abz7_comments` VALUES("1", "1", "یک نویسنده دیدگاه وردپرس", "wapuu@wordpress.example", "https://fa.wordpress.org/", "", "2023-03-14 14:43:51", "2023-03-14 11:13:51", "سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://fa.gravatar.com/\">Gravatar</a> گرفته می‌شود.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_abz7_comments` VALUES("2", "1", "مدیریت", "info@abzarwp-plugins.ir", "", "83.123.61.105", "2023-03-25 19:08:58", "2023-03-25 15:38:58", "خوب بود", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "comment", "0", "1");
INSERT INTO `wp_abz7_comments` VALUES("3", "941", "مدیریت", "info@abzarwp-plugins.ir", "", "83.123.43.160", "2023-03-27 20:29:12", "2023-03-27 16:59:12", "خدمات شما بصورت آنلاین قابل رزرو است؟", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "comment", "0", "1");
INSERT INTO `wp_abz7_comments` VALUES("4", "941", "مدیریت", "info@abzarwp-plugins.ir", "", "83.123.43.160", "2023-03-27 20:31:08", "2023-03-27 17:01:08", "بله خدمات ما بصورت آنلاین می باشد", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "comment", "3", "1");
INSERT INTO `wp_abz7_comments` VALUES("5", "941", "رضا احمد زاده", "asad@asad.asad", "", "83.123.43.160", "2023-03-27 20:37:30", "2023-03-27 17:07:30", "ممنونم خیلی عالی بود", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_abz7_comments` VALUES("6", "2430", "مدیریت", "info@abzarwp-plugins.ir", "", "83.122.33.164", "2023-03-31 12:48:58", "2023-03-31 09:18:58", "عالی بود", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "review", "0", "1");
INSERT INTO `wp_abz7_comments` VALUES("7", "2630", "مدیریت", "info@abzarwp-plugins.ir", "", "83.122.33.164", "2023-03-31 13:01:31", "2023-03-31 09:31:31", "عالی بود", "0", "1", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "review", "0", "1");

/* INSERT TABLE DATA: wp_abz7_duplicator_packages */
INSERT INTO `wp_abz7_duplicator_packages` VALUES("4", "20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8", "2336cd244deeb0fb8681_20251007090940", "20", "2025-10-07 09:10:11", "designer", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-07 09:09:40\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:4;s:4:\"Name\";s:39:\"20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"2336cd244deeb0fb8681_20251007090940\";s:8:\"NameHash\";s:75:\"20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8_2336cd244deeb0fb8681_20251007090940\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8_2336cd244deeb0fb8681_20251007090940_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.9\";s:6:\"WPUser\";s:8:\"designer\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8_2336cd244deeb0fb8681_20251007090940_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:52:\"/home/presitei/domains/presite.ir/public_html/doctor\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3564;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:18429;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-07 09:09:40\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"2336cd244deeb0fb8681_20251007090940\";s:8:\"NameHash\";s:75:\"20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8_2336cd244deeb0fb8681_20251007090940\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8_2336cd244deeb0fb8681_20251007090940_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:66:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8_2336cd244deeb0fb8681_20251007090940_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:173:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/backups-dup-lite/tmp/20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8_2336cd244deeb0fb8681_20251007090940_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:61:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-admin\";i:1;s:64:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-includes\";i:2;s:73:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:52:\"/home/presitei/domains/presite.ir/public_html/doctor\";i:1;s:52:\"/home/presitei/domains/presite.ir/public_html/doctor\";i:2;s:63:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content\";i:3;s:71:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/uploads\";i:4;s:71:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/plugins\";i:5;s:74:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/mu-plugins\";i:6;s:70:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:84:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_abz7_e_events */
INSERT INTO `wp_abz7_e_events` VALUES("1", "{\"event\":\"modal load\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\",\\\"user_state\\\":\\\"anon\\\"}\",\"ts\":\"2023-03-14T14:46:48.057-04:30\"}", "2023-03-14 14:46:48");
INSERT INTO `wp_abz7_e_events` VALUES("2", "{\"event\":\"close modal\",\"version\":\"\",\"details\":\"{\\\"placement\\\":\\\"Onboarding wizard\\\",\\\"step\\\":\\\"account\\\"}\",\"ts\":\"2023-03-14T14:47:14.499-04:30\"}", "2023-03-14 14:47:14");

/* INSERT TABLE DATA: wp_abz7_jet_appointments_excluded */
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("1", "939", "0", "1685494800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("2", "941", "0", "1685494800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("3", "928", "0", "1685577600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("4", "941", "0", "1685754000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("5", "937", "0", "1685840400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("6", "941", "0", "1685926800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("7", "939", "0", "1685926800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("8", "937", "0", "1686445200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("9", "119", "0", "1686445200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("10", "937", "0", "1686531600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("11", "935", "0", "1686618000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("12", "941", "0", "1686963600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("13", "119", "0", "1687050000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("14", "941", "0", "1687914000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("15", "941", "0", "1688432400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("16", "937", "0", "1688515200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("17", "119", "0", "1688864400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("18", "119", "0", "1689555600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("19", "941", "0", "1690765200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("20", "941", "0", "1691283600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("21", "937", "0", "1691370000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("22", "119", "0", "1691370000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("23", "939", "0", "1691539200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("24", "937", "0", "1691542800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("25", "939", "0", "1691542800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("26", "928", "0", "1691629200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("27", "935", "0", "1691974800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("28", "939", "0", "1691974800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("29", "941", "0", "1692012600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("30", "939", "0", "1692061200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("31", "941", "0", "1694221200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("32", "119", "0", "1694307600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("33", "119", "0", "1694480400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("34", "928", "0", "1694480400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("35", "941", "0", "1694653200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("36", "937", "0", "1694826000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("37", "939", "0", "1695171600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("38", "939", "0", "1695776400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("39", "119", "0", "1696122000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("40", "939", "0", "1696381200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("41", "939", "0", "1696640400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("42", "941", "0", "1696726800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("43", "119", "0", "1696986000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("44", "941", "0", "1697936400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("45", "937", "0", "1697936400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("46", "941", "0", "1698627600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("47", "937", "0", "1699146000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("48", "119", "0", "1699491600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("49", "119", "0", "1699750800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("50", "939", "0", "1700269200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("51", "939", "0", "1700442000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("52", "935", "0", "1700442000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("53", "941", "0", "1700960400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("54", "939", "0", "1701565200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("55", "941", "0", "1702170000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("56", "941", "0", "1702256400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("57", "937", "0", "1702256400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("58", "928", "0", "1702256400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("59", "939", "0", "1702256400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("60", "935", "0", "1702256400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("61", "941", "0", "1702342800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("62", "939", "0", "1702342800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("63", "937", "0", "1702342800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("64", "941", "0", "1702429200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("65", "937", "0", "1702429200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("66", "935", "0", "1702429200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("67", "119", "0", "1702429200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("68", "119", "0", "1702515600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("69", "119", "0", "1702861200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("70", "935", "0", "1702861200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("71", "941", "0", "1702947600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("72", "941", "0", "1703120400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("73", "937", "0", "1704070800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("74", "935", "0", "1704330000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("75", "941", "0", "1704848400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("76", "937", "0", "1704848400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("77", "937", "0", "1705280400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("78", "937", "0", "1705366800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("79", "939", "0", "1705366800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("80", "941", "0", "1705366800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("81", "119", "0", "1705539600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("82", "935", "0", "1705712400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("83", "941", "0", "1705712400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("84", "941", "0", "1705885200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("85", "935", "0", "1706058000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("86", "119", "0", "1706490000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("87", "935", "0", "1706662800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("88", "119", "0", "1707008400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("89", "935", "0", "1707094800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("90", "941", "0", "1707094800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("91", "939", "0", "1707613200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("92", "937", "0", "1707872400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("93", "941", "0", "1707958800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("94", "935", "0", "1707958800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("95", "939", "0", "1707958800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("96", "937", "0", "1707958800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("97", "119", "0", "1707958800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("98", "941", "0", "1708822800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("99", "935", "0", "1708909200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("100", "937", "0", "1709600400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("101", "119", "0", "1710205200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("102", "939", "0", "1710723600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("103", "941", "0", "1711846800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("104", "119", "0", "1711873800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("105", "941", "0", "1713402000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("106", "939", "0", "1713661200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("107", "119", "0", "1714352400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("108", "935", "0", "1715043600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("109", "937", "0", "1715043600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("110", "941", "0", "1715475600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("111", "935", "0", "1715562000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("112", "939", "0", "1716166800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("113", "941", "0", "1716166800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("114", "939", "0", "1717549200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("115", "928", "0", "1718067600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("116", "928", "0", "1719709200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("117", "939", "0", "1719795600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("118", "937", "0", "1720314000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("119", "939", "0", "1720314000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("120", "939", "0", "1720400400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("121", "941", "0", "1720486800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("122", "939", "0", "1720486800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("123", "937", "0", "1721523600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("124", "941", "0", "1721523600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("125", "941", "0", "1721896200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("126", "941", "0", "1722128400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("127", "935", "0", "1722819600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("128", "939", "0", "1723338000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("129", "941", "0", "1723424400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("130", "928", "0", "1723510800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("131", "928", "0", "1723683600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("132", "935", "0", "1723942800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("133", "939", "0", "1724029200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("134", "937", "0", "1724202000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("135", "937", "0", "1724547600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("136", "941", "0", "1724547600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("137", "937", "0", "1724720400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("138", "941", "0", "1724806800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("139", "939", "0", "1727830800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("140", "941", "0", "1727830800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("141", "119", "0", "1728781200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("142", "941", "0", "1729386000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("143", "939", "0", "1729386000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("144", "935", "0", "1729472400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("145", "935", "0", "1729990800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("146", "935", "0", "1730163600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("147", "937", "0", "1730854800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("148", "935", "0", "1731459600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("149", "941", "0", "1731978000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("150", "119", "0", "1732064400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("151", "941", "0", "1732410000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("152", "935", "0", "1732496400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("153", "941", "0", "1732755600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("154", "935", "0", "1733315400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("155", "119", "0", "1733706000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("156", "928", "0", "1733965200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("157", "941", "0", "1734224400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("158", "941", "0", "1736038800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("159", "937", "0", "1736125200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("160", "928", "0", "1736816400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("161", "941", "0", "1737248400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("162", "937", "0", "1737248400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("163", "939", "0", "1739071800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("164", "939", "0", "1739235600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("165", "941", "0", "1739235600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("166", "941", "0", "1739322000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("167", "937", "0", "1739322000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("168", "928", "0", "1739754000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("169", "928", "0", "1739754000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("170", "935", "0", "1739840400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("171", "937", "0", "1739840400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("172", "941", "0", "1740272400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("173", "939", "0", "1740877200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("174", "935", "0", "1741050000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("175", "939", "0", "1741741200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("176", "939", "0", "1742086800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("177", "935", "0", "1743555600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("178", "935", "0", "1743987600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("179", "939", "0", "1744761600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("180", "939", "0", "1745107200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("181", "941", "0", "1746662400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("182", "937", "0", "1747008000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("183", "937", "0", "1748390400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("184", "941", "0", "1748390400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("185", "941", "0", "1748649600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("186", "119", "0", "1750032000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("187", "941", "0", "1751932800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("188", "935", "0", "1752105600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("189", "939", "0", "1752883200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("190", "939", "0", "1753315200");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("191", "119", "0", "1754265600");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("192", "941", "0", "1754438400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("193", "941", "0", "1755648000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("194", "941", "0", "1756166400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("195", "935", "0", "1756598400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("196", "939", "0", "1756684800");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("197", "939", "0", "1756944000");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("198", "119", "0", "1757894400");
INSERT INTO `wp_abz7_jet_appointments_excluded` VALUES("199", "941", "0", "1759190400");

/* INSERT TABLE DATA: wp_abz7_jet_appointments_meta */
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("25", "9", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=06ea65d970fa5e3c6fed081b3335078f1685603600");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("26", "9", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=06ea65d970fa5e3c6fed081b3335078f1685603600");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("27", "9", "_action_token", "06ea65d970fa5e3c6fed081b3335078f1685603600");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("28", "10", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=750ed647847edd0b51c8c2c668d02fde1685617252");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("29", "10", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=750ed647847edd0b51c8c2c668d02fde1685617252");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("30", "10", "_action_token", "750ed647847edd0b51c8c2c668d02fde1685617252");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("31", "11", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=fc5d141bd067f6a5a2f95cdf0caf72d61685617460");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("32", "11", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=fc5d141bd067f6a5a2f95cdf0caf72d61685617460");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("33", "11", "_action_token", "fc5d141bd067f6a5a2f95cdf0caf72d61685617460");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("34", "12", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=2b02f4c1afb85da988c311712b4c16441685621359");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("35", "12", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=2b02f4c1afb85da988c311712b4c16441685621359");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("36", "12", "_action_token", "2b02f4c1afb85da988c311712b4c16441685621359");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("37", "13", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=659cfecb98332bcebef66c8ebf1ecc471685621360");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("38", "13", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=659cfecb98332bcebef66c8ebf1ecc471685621360");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("39", "13", "_action_token", "659cfecb98332bcebef66c8ebf1ecc471685621360");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("40", "14", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=428b19e99d5e919a8e26cd7bf7b087431685625852");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("41", "14", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=428b19e99d5e919a8e26cd7bf7b087431685625852");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("42", "14", "_action_token", "428b19e99d5e919a8e26cd7bf7b087431685625852");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("43", "15", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=253ceb895c73c1fa07c99930512d71a01685627599");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("44", "15", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=253ceb895c73c1fa07c99930512d71a01685627599");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("45", "15", "_action_token", "253ceb895c73c1fa07c99930512d71a01685627599");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("46", "16", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=aab315e2407cbd9474f4ebc129ecf27d1685628823");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("47", "16", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=aab315e2407cbd9474f4ebc129ecf27d1685628823");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("48", "16", "_action_token", "aab315e2407cbd9474f4ebc129ecf27d1685628823");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("49", "17", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=227155d523379ff64b0fe107ae7968231685632484");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("50", "17", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=227155d523379ff64b0fe107ae7968231685632484");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("51", "17", "_action_token", "227155d523379ff64b0fe107ae7968231685632484");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("52", "18", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=c3ce7b6ed0ffdce3420e49288a9378851685632792");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("53", "18", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=c3ce7b6ed0ffdce3420e49288a9378851685632792");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("54", "18", "_action_token", "c3ce7b6ed0ffdce3420e49288a9378851685632792");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("55", "19", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=24aefd60dcd9e2457369aa47fba1458e1685647281");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("56", "19", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=24aefd60dcd9e2457369aa47fba1458e1685647281");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("57", "19", "_action_token", "24aefd60dcd9e2457369aa47fba1458e1685647281");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("58", "20", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=d541ac728e707c39fb8d0d63c7ba64de1685678399");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("59", "20", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=d541ac728e707c39fb8d0d63c7ba64de1685678399");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("60", "20", "_action_token", "d541ac728e707c39fb8d0d63c7ba64de1685678399");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("61", "21", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=5a97da4930bef193a8efd2216e5b38ff1685678805");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("62", "21", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=5a97da4930bef193a8efd2216e5b38ff1685678805");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("63", "21", "_action_token", "5a97da4930bef193a8efd2216e5b38ff1685678805");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("64", "22", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=50d95943575d0c0cccb9341af3ace2ca1685712495");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("65", "22", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=50d95943575d0c0cccb9341af3ace2ca1685712495");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("66", "22", "_action_token", "50d95943575d0c0cccb9341af3ace2ca1685712495");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("67", "23", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=dff5d2c3fa6328dc25c96fb74a8f52f31685775351");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("68", "23", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=dff5d2c3fa6328dc25c96fb74a8f52f31685775351");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("69", "23", "_action_token", "dff5d2c3fa6328dc25c96fb74a8f52f31685775351");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("70", "24", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=a70c1b7f07eceea83ae53aca49a0da761685779415");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("71", "24", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=a70c1b7f07eceea83ae53aca49a0da761685779415");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("72", "24", "_action_token", "a70c1b7f07eceea83ae53aca49a0da761685779415");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("73", "25", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=1fb7cc06a0e5ae8b402a82b1373f76b81685797676");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("74", "25", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=1fb7cc06a0e5ae8b402a82b1373f76b81685797676");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("75", "25", "_action_token", "1fb7cc06a0e5ae8b402a82b1373f76b81685797676");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("76", "26", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=54ee2552954f4dd09752994bc64b02e81685888072");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("77", "26", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=54ee2552954f4dd09752994bc64b02e81685888072");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("78", "26", "_action_token", "54ee2552954f4dd09752994bc64b02e81685888072");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("79", "27", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=fd34282b553614e33f8c76018c1d5e741685971417");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("80", "27", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=fd34282b553614e33f8c76018c1d5e741685971417");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("81", "27", "_action_token", "fd34282b553614e33f8c76018c1d5e741685971417");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("82", "28", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=d6f27025d3d67658a8f8829f46970ba81685983463");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("83", "28", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=d6f27025d3d67658a8f8829f46970ba81685983463");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("84", "28", "_action_token", "d6f27025d3d67658a8f8829f46970ba81685983463");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("85", "29", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=b66b5d6eda55d43e8aed1783d5f50d811686034818");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("86", "29", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=b66b5d6eda55d43e8aed1783d5f50d811686034818");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("87", "29", "_action_token", "b66b5d6eda55d43e8aed1783d5f50d811686034818");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("88", "30", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=477ad130c3f1764dfc653e7eb5d7b6381686052069");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("89", "30", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=477ad130c3f1764dfc653e7eb5d7b6381686052069");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("90", "30", "_action_token", "477ad130c3f1764dfc653e7eb5d7b6381686052069");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("91", "31", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=c60343e9015b64052ae8e99b63404f2b1686221900");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("92", "31", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=c60343e9015b64052ae8e99b63404f2b1686221900");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("93", "31", "_action_token", "c60343e9015b64052ae8e99b63404f2b1686221900");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("94", "32", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=37f215ac9202504058b054179679ac931686332048");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("95", "32", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=37f215ac9202504058b054179679ac931686332048");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("96", "32", "_action_token", "37f215ac9202504058b054179679ac931686332048");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("97", "33", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=2e251f20cc11010a2b693dbff1b01dcf1686524607");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("98", "33", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=2e251f20cc11010a2b693dbff1b01dcf1686524607");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("99", "33", "_action_token", "2e251f20cc11010a2b693dbff1b01dcf1686524607");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("100", "34", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=b5d9ef0a8127a840c93904fedeba5aa61686830618");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("101", "34", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=b5d9ef0a8127a840c93904fedeba5aa61686830618");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("102", "34", "_action_token", "b5d9ef0a8127a840c93904fedeba5aa61686830618");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("103", "35", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=2fd1f679a3a3a561f33ab6d6ceb6595b1686831434");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("104", "35", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=2fd1f679a3a3a561f33ab6d6ceb6595b1686831434");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("105", "35", "_action_token", "2fd1f679a3a3a561f33ab6d6ceb6595b1686831434");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("106", "36", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=1c4ed346983c3f1c5256d85f008986d21687023472");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("107", "36", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=1c4ed346983c3f1c5256d85f008986d21687023472");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("108", "36", "_action_token", "1c4ed346983c3f1c5256d85f008986d21687023472");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("109", "37", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=b6f2f94656851d58d4217a71cbaaf19c1687716496");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("110", "37", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=b6f2f94656851d58d4217a71cbaaf19c1687716496");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("111", "37", "_action_token", "b6f2f94656851d58d4217a71cbaaf19c1687716496");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("112", "38", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=4df44212ca95afd834c728cf939ad5b51688253105");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("113", "38", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=4df44212ca95afd834c728cf939ad5b51688253105");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("114", "38", "_action_token", "4df44212ca95afd834c728cf939ad5b51688253105");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("115", "39", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=88d0ff02368ffb17dd35197875a098871688377532");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("116", "39", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=88d0ff02368ffb17dd35197875a098871688377532");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("117", "39", "_action_token", "88d0ff02368ffb17dd35197875a098871688377532");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("118", "40", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=df2cd677934bbfb97073b2aa8290f2711688382695");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("119", "40", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=df2cd677934bbfb97073b2aa8290f2711688382695");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("120", "40", "_action_token", "df2cd677934bbfb97073b2aa8290f2711688382695");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("121", "41", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=9f1259c3ae0beab9a36f50216f9f92241690098906");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("122", "41", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=9f1259c3ae0beab9a36f50216f9f92241690098906");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("123", "41", "_action_token", "9f1259c3ae0beab9a36f50216f9f92241690098906");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("124", "42", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=979f1844b3260691a7868b660d765cd91690099164");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("125", "42", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=979f1844b3260691a7868b660d765cd91690099164");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("126", "42", "_action_token", "979f1844b3260691a7868b660d765cd91690099164");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("127", "43", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=51587228bb3c5342ef04dd69ef3aa41c1690194932");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("128", "43", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=51587228bb3c5342ef04dd69ef3aa41c1690194932");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("129", "43", "_action_token", "51587228bb3c5342ef04dd69ef3aa41c1690194932");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("130", "44", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=3499eb0da12c4273a1637eb54e75ddb51690283604");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("131", "44", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=3499eb0da12c4273a1637eb54e75ddb51690283604");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("132", "44", "_action_token", "3499eb0da12c4273a1637eb54e75ddb51690283604");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("133", "45", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=e68e03c244fc775add44de2fa8e27d261690369840");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("134", "45", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=e68e03c244fc775add44de2fa8e27d261690369840");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("135", "45", "_action_token", "e68e03c244fc775add44de2fa8e27d261690369840");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("136", "46", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=59e1a14ca61e2791c88dbf5885fda18d1690377686");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("137", "46", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=59e1a14ca61e2791c88dbf5885fda18d1690377686");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("138", "46", "_action_token", "59e1a14ca61e2791c88dbf5885fda18d1690377686");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("139", "47", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=99ba372accd7cef03e7dbcb9145e98491690783917");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("140", "47", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=99ba372accd7cef03e7dbcb9145e98491690783917");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("141", "47", "_action_token", "99ba372accd7cef03e7dbcb9145e98491690783917");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("142", "48", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=119a8f4ba4ca94a8efcbd26d148cda9e1690833043");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("143", "48", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=119a8f4ba4ca94a8efcbd26d148cda9e1690833043");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("144", "48", "_action_token", "119a8f4ba4ca94a8efcbd26d148cda9e1690833043");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("145", "49", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=5337134a6ff86c8ffbffe980fc6868271690833218");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("146", "49", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=5337134a6ff86c8ffbffe980fc6868271690833218");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("147", "49", "_action_token", "5337134a6ff86c8ffbffe980fc6868271690833218");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("148", "50", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=204a56a0eb79e4d7ca73368b93d15ab71691057407");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("149", "50", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=204a56a0eb79e4d7ca73368b93d15ab71691057407");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("150", "50", "_action_token", "204a56a0eb79e4d7ca73368b93d15ab71691057407");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("151", "51", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=b7192a7bda5e044439cb9289c742429d1691325550");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("152", "51", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=b7192a7bda5e044439cb9289c742429d1691325550");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("153", "51", "_action_token", "b7192a7bda5e044439cb9289c742429d1691325550");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("154", "52", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=39cc604a93af0f8547339dc77d405d8f1691596705");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("155", "52", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=39cc604a93af0f8547339dc77d405d8f1691596705");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("156", "52", "_action_token", "39cc604a93af0f8547339dc77d405d8f1691596705");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("157", "53", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=234e52a0ea025bb2cd0290ee09e4e82d1691700932");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("158", "53", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=234e52a0ea025bb2cd0290ee09e4e82d1691700932");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("159", "53", "_action_token", "234e52a0ea025bb2cd0290ee09e4e82d1691700932");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("160", "54", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=003c643384719c2d837a6e721cd0112e1691828395");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("161", "54", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=003c643384719c2d837a6e721cd0112e1691828395");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("162", "54", "_action_token", "003c643384719c2d837a6e721cd0112e1691828395");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("163", "55", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=29cc3b02c8530618869c58a5b51a66761691830865");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("164", "55", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=29cc3b02c8530618869c58a5b51a66761691830865");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("165", "55", "_action_token", "29cc3b02c8530618869c58a5b51a66761691830865");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("166", "56", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=1a86b62c13357e431600b683d8e31d841691865432");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("167", "56", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=1a86b62c13357e431600b683d8e31d841691865432");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("168", "56", "_action_token", "1a86b62c13357e431600b683d8e31d841691865432");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("169", "57", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=c392c7b061badac310fc0401b267a4d21692028795");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("170", "57", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=c392c7b061badac310fc0401b267a4d21692028795");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("171", "57", "_action_token", "c392c7b061badac310fc0401b267a4d21692028795");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("172", "58", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=9711064790e259dcda9bcdcf411022a91692170543");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("173", "58", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=9711064790e259dcda9bcdcf411022a91692170543");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("174", "58", "_action_token", "9711064790e259dcda9bcdcf411022a91692170543");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("175", "59", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=f49685a2dc6f1f22ee7e49872b83aa961692359793");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("176", "59", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=f49685a2dc6f1f22ee7e49872b83aa961692359793");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("177", "59", "_action_token", "f49685a2dc6f1f22ee7e49872b83aa961692359793");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("178", "60", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=c6208eda80578c0013f0ae97a6f8df281692908060");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("179", "60", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=c6208eda80578c0013f0ae97a6f8df281692908060");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("180", "60", "_action_token", "c6208eda80578c0013f0ae97a6f8df281692908060");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("181", "61", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=bafad6a58d6485b1da6056be6b9ba21d1692908130");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("182", "61", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=bafad6a58d6485b1da6056be6b9ba21d1692908130");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("183", "61", "_action_token", "bafad6a58d6485b1da6056be6b9ba21d1692908130");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("184", "62", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=352903ad6420df9ee77cc980ba553c161692908496");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("185", "62", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=352903ad6420df9ee77cc980ba553c161692908496");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("186", "62", "_action_token", "352903ad6420df9ee77cc980ba553c161692908496");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("187", "63", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=bcd83b016e8631c9f47af0a92bbfaf6c1692928793");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("188", "63", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=bcd83b016e8631c9f47af0a92bbfaf6c1692928793");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("189", "63", "_action_token", "bcd83b016e8631c9f47af0a92bbfaf6c1692928793");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("190", "64", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=40d64bcd1b64fb8596894652e5006faf1692976851");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("191", "64", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=40d64bcd1b64fb8596894652e5006faf1692976851");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("192", "64", "_action_token", "40d64bcd1b64fb8596894652e5006faf1692976851");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("193", "65", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=7d96db9f794648deb33fbd823613e6c71693073708");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("194", "65", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=7d96db9f794648deb33fbd823613e6c71693073708");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("195", "65", "_action_token", "7d96db9f794648deb33fbd823613e6c71693073708");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("196", "66", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=824bda080ade57638c419bfd455f24801693223594");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("197", "66", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=824bda080ade57638c419bfd455f24801693223594");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("198", "66", "_action_token", "824bda080ade57638c419bfd455f24801693223594");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("199", "67", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=c838c69ca510c69e070626f0a63149de1694099232");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("200", "67", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=c838c69ca510c69e070626f0a63149de1694099232");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("201", "67", "_action_token", "c838c69ca510c69e070626f0a63149de1694099232");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("202", "68", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=516b6de1472a203887bbc32056e54e491694256101");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("203", "68", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=516b6de1472a203887bbc32056e54e491694256101");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("204", "68", "_action_token", "516b6de1472a203887bbc32056e54e491694256101");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("205", "69", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=8b9a1160d96c44d165da8e4441f4a3091694334510");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("206", "69", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=8b9a1160d96c44d165da8e4441f4a3091694334510");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("207", "69", "_action_token", "8b9a1160d96c44d165da8e4441f4a3091694334510");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("208", "70", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=dbd1431adbe2b557a8c4cdef555e4eb41694362450");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("209", "70", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=dbd1431adbe2b557a8c4cdef555e4eb41694362450");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("210", "70", "_action_token", "dbd1431adbe2b557a8c4cdef555e4eb41694362450");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("211", "71", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=1cf6dd53487c34f214938f8ce496b7da1695057610");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("212", "71", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=1cf6dd53487c34f214938f8ce496b7da1695057610");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("213", "71", "_action_token", "1cf6dd53487c34f214938f8ce496b7da1695057610");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("214", "72", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=64b75f1ba6188323dcee0801a53c98f61695060913");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("215", "72", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=64b75f1ba6188323dcee0801a53c98f61695060913");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("216", "72", "_action_token", "64b75f1ba6188323dcee0801a53c98f61695060913");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("217", "73", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=1a1d2fdfce3b398745d2c9e6d5354c111695169491");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("218", "73", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=1a1d2fdfce3b398745d2c9e6d5354c111695169491");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("219", "73", "_action_token", "1a1d2fdfce3b398745d2c9e6d5354c111695169491");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("220", "74", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=6fb8954d0d7b6145650a98baafee40e01695652568");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("221", "74", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=6fb8954d0d7b6145650a98baafee40e01695652568");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("222", "74", "_action_token", "6fb8954d0d7b6145650a98baafee40e01695652568");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("223", "75", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=81adcf491aeb4fdfeadf29eac2cda1c21695721183");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("224", "75", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=81adcf491aeb4fdfeadf29eac2cda1c21695721183");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("225", "75", "_action_token", "81adcf491aeb4fdfeadf29eac2cda1c21695721183");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("226", "76", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=e721a6499d0827fb83aa9fbf8bd4699a1695969518");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("227", "76", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=e721a6499d0827fb83aa9fbf8bd4699a1695969518");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("228", "76", "_action_token", "e721a6499d0827fb83aa9fbf8bd4699a1695969518");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("229", "77", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=7f429264434c88097661764880e524cc1697017948");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("230", "77", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=7f429264434c88097661764880e524cc1697017948");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("231", "77", "_action_token", "7f429264434c88097661764880e524cc1697017948");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("232", "78", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=cb36958be9bef436f23421a5ca24b8b21697445549");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("233", "78", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=cb36958be9bef436f23421a5ca24b8b21697445549");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("234", "78", "_action_token", "cb36958be9bef436f23421a5ca24b8b21697445549");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("235", "79", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=4fe3eff28ee30a162f5b3940a7b3575d1697445692");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("236", "79", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=4fe3eff28ee30a162f5b3940a7b3575d1697445692");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("237", "79", "_action_token", "4fe3eff28ee30a162f5b3940a7b3575d1697445692");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("238", "80", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=373ebadaced324dcc56ce7d4e33be2391697915231");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("239", "80", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=373ebadaced324dcc56ce7d4e33be2391697915231");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("240", "80", "_action_token", "373ebadaced324dcc56ce7d4e33be2391697915231");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("241", "81", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=e7415b0df3950ccd28f91b598c049a771698152932");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("242", "81", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=e7415b0df3950ccd28f91b598c049a771698152932");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("243", "81", "_action_token", "e7415b0df3950ccd28f91b598c049a771698152932");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("244", "82", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=dd5a6d0f1a8e35a23dcb638baf8b58921698225950");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("245", "82", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=dd5a6d0f1a8e35a23dcb638baf8b58921698225950");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("246", "82", "_action_token", "dd5a6d0f1a8e35a23dcb638baf8b58921698225950");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("247", "83", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=12f5b747344a05848931625fe69fb05d1698241021");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("248", "83", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=12f5b747344a05848931625fe69fb05d1698241021");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("249", "83", "_action_token", "12f5b747344a05848931625fe69fb05d1698241021");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("250", "84", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=711c783e7a4723c7c197b491731570551698512828");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("251", "84", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=711c783e7a4723c7c197b491731570551698512828");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("252", "84", "_action_token", "711c783e7a4723c7c197b491731570551698512828");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("253", "85", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=61b82b92522b36ed1f4c658eb18290ff1698514956");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("254", "85", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=61b82b92522b36ed1f4c658eb18290ff1698514956");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("255", "85", "_action_token", "61b82b92522b36ed1f4c658eb18290ff1698514956");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("256", "86", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=eaa9d1269b1b0bc70a16e0c1c456a18a1698576152");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("257", "86", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=eaa9d1269b1b0bc70a16e0c1c456a18a1698576152");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("258", "86", "_action_token", "eaa9d1269b1b0bc70a16e0c1c456a18a1698576152");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("259", "87", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=fea82b37e2dd21676d3837626396f8481698576206");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("260", "87", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=fea82b37e2dd21676d3837626396f8481698576206");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("261", "87", "_action_token", "fea82b37e2dd21676d3837626396f8481698576206");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("262", "88", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=5df1e5099c2bbbe3951fa1b6da8f8b571698669449");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("263", "88", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=5df1e5099c2bbbe3951fa1b6da8f8b571698669449");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("264", "88", "_action_token", "5df1e5099c2bbbe3951fa1b6da8f8b571698669449");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("265", "89", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=bd9f82ff5255572ecd3f2b85a95aa2661698906654");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("266", "89", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=bd9f82ff5255572ecd3f2b85a95aa2661698906654");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("267", "89", "_action_token", "bd9f82ff5255572ecd3f2b85a95aa2661698906654");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("268", "90", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=9ddd1796be36e376b0d2e14399da24321698920983");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("269", "90", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=9ddd1796be36e376b0d2e14399da24321698920983");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("270", "90", "_action_token", "9ddd1796be36e376b0d2e14399da24321698920983");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("271", "91", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=93440ae1cd31d5fe6bf9634e967bc6381699022963");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("272", "91", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=93440ae1cd31d5fe6bf9634e967bc6381699022963");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("273", "91", "_action_token", "93440ae1cd31d5fe6bf9634e967bc6381699022963");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("274", "92", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=bc64305d13cb6c0c86531b5a93b30e421699370225");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("275", "92", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=bc64305d13cb6c0c86531b5a93b30e421699370225");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("276", "92", "_action_token", "bc64305d13cb6c0c86531b5a93b30e421699370225");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("277", "93", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=6b47a5046a476b59e33a96fade025a261700109329");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("278", "93", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=6b47a5046a476b59e33a96fade025a261700109329");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("279", "93", "_action_token", "6b47a5046a476b59e33a96fade025a261700109329");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("280", "94", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=cda8395c408586864020bbf47574414c1700304720");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("281", "94", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=cda8395c408586864020bbf47574414c1700304720");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("282", "94", "_action_token", "cda8395c408586864020bbf47574414c1700304720");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("283", "95", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=b9d2e1c7442d7474b3435a24176be17f1700479634");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("284", "95", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=b9d2e1c7442d7474b3435a24176be17f1700479634");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("285", "95", "_action_token", "b9d2e1c7442d7474b3435a24176be17f1700479634");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("286", "96", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=5b329df8a421fea47db748e4408b86ed1700858028");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("287", "96", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=5b329df8a421fea47db748e4408b86ed1700858028");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("288", "96", "_action_token", "5b329df8a421fea47db748e4408b86ed1700858028");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("289", "97", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=e3b2a543b30327407774d58c80f513311700998358");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("290", "97", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=e3b2a543b30327407774d58c80f513311700998358");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("291", "97", "_action_token", "e3b2a543b30327407774d58c80f513311700998358");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("292", "98", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=fec6effb1cd19f389df73627cd7661221701163446");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("293", "98", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=fec6effb1cd19f389df73627cd7661221701163446");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("294", "98", "_action_token", "fec6effb1cd19f389df73627cd7661221701163446");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("295", "99", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=56649302d94db56550363441b828fc721702022463");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("296", "99", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=56649302d94db56550363441b828fc721702022463");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("297", "99", "_action_token", "56649302d94db56550363441b828fc721702022463");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("298", "100", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=133b7ae6e1654910b4f03811d14c851d1702309072");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("299", "100", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=133b7ae6e1654910b4f03811d14c851d1702309072");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("300", "100", "_action_token", "133b7ae6e1654910b4f03811d14c851d1702309072");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("301", "101", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=dfefeb23d604392e0966e137d91d89ff1702312508");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("302", "101", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=dfefeb23d604392e0966e137d91d89ff1702312508");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("303", "101", "_action_token", "dfefeb23d604392e0966e137d91d89ff1702312508");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("304", "102", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=1d5df597da6dc59232da718b8a8eb20f1702320895");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("305", "102", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=1d5df597da6dc59232da718b8a8eb20f1702320895");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("306", "102", "_action_token", "1d5df597da6dc59232da718b8a8eb20f1702320895");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("307", "103", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=672700056d1c897305cb755ae9fb98b01702324215");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("308", "103", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=672700056d1c897305cb755ae9fb98b01702324215");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("309", "103", "_action_token", "672700056d1c897305cb755ae9fb98b01702324215");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("310", "104", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=2fe2000ce2b374af1c7302578a9708341702325034");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("311", "104", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=2fe2000ce2b374af1c7302578a9708341702325034");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("312", "104", "_action_token", "2fe2000ce2b374af1c7302578a9708341702325034");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("313", "105", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=076b99bf6ceed0c75ddae856fa69e1151702405411");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("314", "105", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=076b99bf6ceed0c75ddae856fa69e1151702405411");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("315", "105", "_action_token", "076b99bf6ceed0c75ddae856fa69e1151702405411");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("316", "106", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=18ebd2d4a68cd418009c0a0db23433ea1702406003");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("317", "106", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=18ebd2d4a68cd418009c0a0db23433ea1702406003");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("318", "106", "_action_token", "18ebd2d4a68cd418009c0a0db23433ea1702406003");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("319", "107", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=a3e2d357f867512a3cba7330cd079a381702428073");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("320", "107", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=a3e2d357f867512a3cba7330cd079a381702428073");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("321", "107", "_action_token", "a3e2d357f867512a3cba7330cd079a381702428073");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("322", "108", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=5c762ce4a15c32289c94fa934164dd711702456435");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("323", "108", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=5c762ce4a15c32289c94fa934164dd711702456435");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("324", "108", "_action_token", "5c762ce4a15c32289c94fa934164dd711702456435");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("325", "109", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=c88c311ef50af11733453cb3fe02841f1702546355");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("326", "109", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=c88c311ef50af11733453cb3fe02841f1702546355");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("327", "109", "_action_token", "c88c311ef50af11733453cb3fe02841f1702546355");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("328", "110", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=691921f7eb7c33689184d9b64a4938bd1702551290");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("329", "110", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=691921f7eb7c33689184d9b64a4938bd1702551290");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("330", "110", "_action_token", "691921f7eb7c33689184d9b64a4938bd1702551290");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("331", "111", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=df80b3afef9366253273123a79c709ef1702712457");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("332", "111", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=df80b3afef9366253273123a79c709ef1702712457");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("333", "111", "_action_token", "df80b3afef9366253273123a79c709ef1702712457");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("334", "112", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=05e7bdddf5a6756512e2c6629f8c68fa1702850533");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("335", "112", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=05e7bdddf5a6756512e2c6629f8c68fa1702850533");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("336", "112", "_action_token", "05e7bdddf5a6756512e2c6629f8c68fa1702850533");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("337", "113", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=2bce71f641dce647b5c73d424a7ebd251703592344");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("338", "113", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=2bce71f641dce647b5c73d424a7ebd251703592344");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("339", "113", "_action_token", "2bce71f641dce647b5c73d424a7ebd251703592344");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("340", "114", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=26b64c957be8dbb4d5119bcc9bdc1b761703594250");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("341", "114", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=26b64c957be8dbb4d5119bcc9bdc1b761703594250");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("342", "114", "_action_token", "26b64c957be8dbb4d5119bcc9bdc1b761703594250");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("343", "115", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=91132c09fa8bbdab80ef31ae9fb5f0671703918410");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("344", "115", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=91132c09fa8bbdab80ef31ae9fb5f0671703918410");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("345", "115", "_action_token", "91132c09fa8bbdab80ef31ae9fb5f0671703918410");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("346", "116", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=820e54765541c036a95403153d6783631704127308");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("347", "116", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=820e54765541c036a95403153d6783631704127308");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("348", "116", "_action_token", "820e54765541c036a95403153d6783631704127308");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("349", "117", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=60b946b158fab6152efe0a52982d323d1704127439");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("350", "117", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=60b946b158fab6152efe0a52982d323d1704127439");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("351", "117", "_action_token", "60b946b158fab6152efe0a52982d323d1704127439");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("352", "118", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=f3994a414e4edf4dbe93ab5ea31b0d081704147218");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("353", "118", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=f3994a414e4edf4dbe93ab5ea31b0d081704147218");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("354", "118", "_action_token", "f3994a414e4edf4dbe93ab5ea31b0d081704147218");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("355", "119", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=ebda01d4a871129f101e7a793f7afe3b1704568290");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("356", "119", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=ebda01d4a871129f101e7a793f7afe3b1704568290");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("357", "119", "_action_token", "ebda01d4a871129f101e7a793f7afe3b1704568290");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("358", "120", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=5efddec913e4cde8c3e0b5bdab6e5f711704955412");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("359", "120", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=5efddec913e4cde8c3e0b5bdab6e5f711704955412");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("360", "120", "_action_token", "5efddec913e4cde8c3e0b5bdab6e5f711704955412");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("361", "121", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=0fedf53763683c090cc5ca37399fd07d1705094227");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("362", "121", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=0fedf53763683c090cc5ca37399fd07d1705094227");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("363", "121", "_action_token", "0fedf53763683c090cc5ca37399fd07d1705094227");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("364", "122", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=136d32b537b30b007192095b8bf487911705162910");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("365", "122", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=136d32b537b30b007192095b8bf487911705162910");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("366", "122", "_action_token", "136d32b537b30b007192095b8bf487911705162910");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("367", "123", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=cfad1852c946e358ab6326ba2664a0311705214112");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("368", "123", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=cfad1852c946e358ab6326ba2664a0311705214112");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("369", "123", "_action_token", "cfad1852c946e358ab6326ba2664a0311705214112");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("370", "124", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=c5bc8bed4b19acfcf6f99df6177d05db1705413739");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("371", "124", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=c5bc8bed4b19acfcf6f99df6177d05db1705413739");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("372", "124", "_action_token", "c5bc8bed4b19acfcf6f99df6177d05db1705413739");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("373", "125", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=5f55cb7e69a0b56637ea54b00c01af4a1705518350");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("374", "125", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=5f55cb7e69a0b56637ea54b00c01af4a1705518350");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("375", "125", "_action_token", "5f55cb7e69a0b56637ea54b00c01af4a1705518350");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("376", "126", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=9483ecd7ca394a0f4fe79b02391ade531705952738");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("377", "126", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=9483ecd7ca394a0f4fe79b02391ade531705952738");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("378", "126", "_action_token", "9483ecd7ca394a0f4fe79b02391ade531705952738");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("379", "127", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=0e91b018a9c8d7816c6539611ccc870b1705964448");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("380", "127", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=0e91b018a9c8d7816c6539611ccc870b1705964448");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("381", "127", "_action_token", "0e91b018a9c8d7816c6539611ccc870b1705964448");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("382", "128", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=76cf80620d9bfe9ba710a58fe3b0e2131706266506");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("383", "128", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=76cf80620d9bfe9ba710a58fe3b0e2131706266506");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("384", "128", "_action_token", "76cf80620d9bfe9ba710a58fe3b0e2131706266506");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("385", "129", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=7bfc334bb917ab7db957eaa0cb7e84121706479611");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("386", "129", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=7bfc334bb917ab7db957eaa0cb7e84121706479611");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("387", "129", "_action_token", "7bfc334bb917ab7db957eaa0cb7e84121706479611");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("388", "130", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=34a810e9f992bc210d099ac6a31429721707015797");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("389", "130", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=34a810e9f992bc210d099ac6a31429721707015797");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("390", "130", "_action_token", "34a810e9f992bc210d099ac6a31429721707015797");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("391", "131", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=fabed2eb248af081a067568dc34f8be21707393082");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("392", "131", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=fabed2eb248af081a067568dc34f8be21707393082");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("393", "131", "_action_token", "fabed2eb248af081a067568dc34f8be21707393082");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("394", "132", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=ee0217813c5e9d27f5a74adad8b6f7fa1707990284");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("395", "132", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=ee0217813c5e9d27f5a74adad8b6f7fa1707990284");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("396", "132", "_action_token", "ee0217813c5e9d27f5a74adad8b6f7fa1707990284");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("397", "133", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=4f7846d87a436622dfaaf9749221aba71708001326");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("398", "133", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=4f7846d87a436622dfaaf9749221aba71708001326");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("399", "133", "_action_token", "4f7846d87a436622dfaaf9749221aba71708001326");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("400", "134", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=22be9c3d45398a86dc5033f7dede3b1e1708009303");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("401", "134", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=22be9c3d45398a86dc5033f7dede3b1e1708009303");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("402", "134", "_action_token", "22be9c3d45398a86dc5033f7dede3b1e1708009303");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("403", "135", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=e01ec78f5a7956bec0d654ffb515daff1708013396");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("404", "135", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=e01ec78f5a7956bec0d654ffb515daff1708013396");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("405", "135", "_action_token", "e01ec78f5a7956bec0d654ffb515daff1708013396");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("406", "136", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=fcfb5fa48a18f5035021d62380f706d81708018210");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("407", "136", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=fcfb5fa48a18f5035021d62380f706d81708018210");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("408", "136", "_action_token", "fcfb5fa48a18f5035021d62380f706d81708018210");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("409", "137", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=30a51a5284abd73242d4bc3ccb63e61b1708026402");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("410", "137", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=30a51a5284abd73242d4bc3ccb63e61b1708026402");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("411", "137", "_action_token", "30a51a5284abd73242d4bc3ccb63e61b1708026402");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("412", "138", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=402da35ae552b92fd88556718c2aee161708180022");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("413", "138", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=402da35ae552b92fd88556718c2aee161708180022");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("414", "138", "_action_token", "402da35ae552b92fd88556718c2aee161708180022");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("415", "139", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=623224926d9cc4f2e3d4cba16e898e181708546540");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("416", "139", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=623224926d9cc4f2e3d4cba16e898e181708546540");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("417", "139", "_action_token", "623224926d9cc4f2e3d4cba16e898e181708546540");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("418", "140", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=11a97c9e40ce058076f04009759c83e71708580431");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("419", "140", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=11a97c9e40ce058076f04009759c83e71708580431");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("420", "140", "_action_token", "11a97c9e40ce058076f04009759c83e71708580431");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("421", "141", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=64060c792f1416bf31df6e01a8d98e061709063750");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("422", "141", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=64060c792f1416bf31df6e01a8d98e061709063750");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("423", "141", "_action_token", "64060c792f1416bf31df6e01a8d98e061709063750");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("424", "142", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=0aebd4f1bed7d940dc925f5a1c0b5d421709626151");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("425", "142", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=0aebd4f1bed7d940dc925f5a1c0b5d421709626151");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("426", "142", "_action_token", "0aebd4f1bed7d940dc925f5a1c0b5d421709626151");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("427", "143", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=2d510d9de85e35ec3b91ef6e0395e3e81709626172");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("428", "143", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=2d510d9de85e35ec3b91ef6e0395e3e81709626172");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("429", "143", "_action_token", "2d510d9de85e35ec3b91ef6e0395e3e81709626172");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("430", "144", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=2d510d9de85e35ec3b91ef6e0395e3e81709626214");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("431", "144", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=2d510d9de85e35ec3b91ef6e0395e3e81709626214");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("432", "144", "_action_token", "2d510d9de85e35ec3b91ef6e0395e3e81709626214");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("433", "145", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=2d510d9de85e35ec3b91ef6e0395e3e81709626269");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("434", "145", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=2d510d9de85e35ec3b91ef6e0395e3e81709626269");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("435", "145", "_action_token", "2d510d9de85e35ec3b91ef6e0395e3e81709626269");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("436", "146", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=eee26e121bab68e71c4e61e4e773d5851709744254");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("437", "146", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=eee26e121bab68e71c4e61e4e773d5851709744254");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("438", "146", "_action_token", "eee26e121bab68e71c4e61e4e773d5851709744254");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("439", "147", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=5376db4a969cf49d165bbe5b1390f9d11710151642");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("440", "147", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=5376db4a969cf49d165bbe5b1390f9d11710151642");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("441", "147", "_action_token", "5376db4a969cf49d165bbe5b1390f9d11710151642");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("442", "148", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=ff6ec887f4f40927b661e6b11ac7ae8d1710540423");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("443", "148", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=ff6ec887f4f40927b661e6b11ac7ae8d1710540423");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("444", "148", "_action_token", "ff6ec887f4f40927b661e6b11ac7ae8d1710540423");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("445", "149", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=6e2f27c3d417afd49e0262c3bdd534b61711610553");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("446", "149", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=6e2f27c3d417afd49e0262c3bdd534b61711610553");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("447", "149", "_action_token", "6e2f27c3d417afd49e0262c3bdd534b61711610553");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("448", "150", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=9030167b6203c8ce106d8c6e2fac8e5b1711756997");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("449", "150", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=9030167b6203c8ce106d8c6e2fac8e5b1711756997");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("450", "150", "_action_token", "9030167b6203c8ce106d8c6e2fac8e5b1711756997");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("451", "151", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=8e379644c29186a11199a739dc4bd4e21712238682");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("452", "151", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=8e379644c29186a11199a739dc4bd4e21712238682");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("453", "151", "_action_token", "8e379644c29186a11199a739dc4bd4e21712238682");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("454", "152", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=68eab73ee488d909109e96d03dab69e81712518324");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("455", "152", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=68eab73ee488d909109e96d03dab69e81712518324");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("456", "152", "_action_token", "68eab73ee488d909109e96d03dab69e81712518324");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("457", "153", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=4a49fa1343770b5d9beaf430f02c076f1713025555");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("458", "153", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=4a49fa1343770b5d9beaf430f02c076f1713025555");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("459", "153", "_action_token", "4a49fa1343770b5d9beaf430f02c076f1713025555");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("460", "154", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=925b6a70fb9aca9c38a7860aac824d181713516221");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("461", "154", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=925b6a70fb9aca9c38a7860aac824d181713516221");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("462", "154", "_action_token", "925b6a70fb9aca9c38a7860aac824d181713516221");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("463", "155", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=925b6a70fb9aca9c38a7860aac824d181713516271");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("464", "155", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=925b6a70fb9aca9c38a7860aac824d181713516271");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("465", "155", "_action_token", "925b6a70fb9aca9c38a7860aac824d181713516271");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("466", "156", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=7ededbcf82a5a3825eb86afb2674ce741713782426");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("467", "156", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=7ededbcf82a5a3825eb86afb2674ce741713782426");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("468", "156", "_action_token", "7ededbcf82a5a3825eb86afb2674ce741713782426");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("469", "157", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=262d9bea83abe6c5a84c9e20401701c01714226729");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("470", "157", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=262d9bea83abe6c5a84c9e20401701c01714226729");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("471", "157", "_action_token", "262d9bea83abe6c5a84c9e20401701c01714226729");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("472", "158", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=f523b249c953a39785670e26f02eb8951714882473");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("473", "158", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=f523b249c953a39785670e26f02eb8951714882473");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("474", "158", "_action_token", "f523b249c953a39785670e26f02eb8951714882473");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("475", "159", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=99e9a6e52032bfa1d9178897fea0b2e11715103031");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("476", "159", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=99e9a6e52032bfa1d9178897fea0b2e11715103031");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("477", "159", "_action_token", "99e9a6e52032bfa1d9178897fea0b2e11715103031");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("478", "160", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=cfe2c7fd4d18060cd9781d7a304f74041715781260");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("479", "160", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=cfe2c7fd4d18060cd9781d7a304f74041715781260");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("480", "160", "_action_token", "cfe2c7fd4d18060cd9781d7a304f74041715781260");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("481", "161", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=ddb5f151273c838cdc1ecc70d9923a4a1716044652");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("482", "161", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=ddb5f151273c838cdc1ecc70d9923a4a1716044652");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("483", "161", "_action_token", "ddb5f151273c838cdc1ecc70d9923a4a1716044652");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("484", "162", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=6354220e019a8ba58d3a7fc03a20703a1716082779");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("485", "162", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=6354220e019a8ba58d3a7fc03a20703a1716082779");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("486", "162", "_action_token", "6354220e019a8ba58d3a7fc03a20703a1716082779");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("487", "163", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=7514f9dbc57de2fef5b54c88212fd8cd1716103461");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("488", "163", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=7514f9dbc57de2fef5b54c88212fd8cd1716103461");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("489", "163", "_action_token", "7514f9dbc57de2fef5b54c88212fd8cd1716103461");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("490", "164", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=e85cb99aebe92a20d79dcb4b13ca6d741716627514");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("491", "164", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=e85cb99aebe92a20d79dcb4b13ca6d741716627514");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("492", "164", "_action_token", "e85cb99aebe92a20d79dcb4b13ca6d741716627514");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("493", "165", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=a62bcadbc2941de0f2e89546a6a8e5361717104597");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("494", "165", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=a62bcadbc2941de0f2e89546a6a8e5361717104597");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("495", "165", "_action_token", "a62bcadbc2941de0f2e89546a6a8e5361717104597");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("496", "166", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=3ada38f429ac25ae79e57dcaa5a4bb381717571163");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("497", "166", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=3ada38f429ac25ae79e57dcaa5a4bb381717571163");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("498", "166", "_action_token", "3ada38f429ac25ae79e57dcaa5a4bb381717571163");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("499", "167", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=44fbb64fa3840d42b98dd1a8fcc0a2561718026248");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("500", "167", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=44fbb64fa3840d42b98dd1a8fcc0a2561718026248");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("501", "167", "_action_token", "44fbb64fa3840d42b98dd1a8fcc0a2561718026248");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("502", "168", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=ef0ed7e2e58e8040f5990667f6cf0f271718178796");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("503", "168", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=ef0ed7e2e58e8040f5990667f6cf0f271718178796");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("504", "168", "_action_token", "ef0ed7e2e58e8040f5990667f6cf0f271718178796");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("505", "169", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=0bdafa00a238990e8f04e4e60b88c10b1718787691");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("506", "169", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=0bdafa00a238990e8f04e4e60b88c10b1718787691");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("507", "169", "_action_token", "0bdafa00a238990e8f04e4e60b88c10b1718787691");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("508", "170", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=7e76cc8388336affb91baa48aba89dfd1719981272");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("509", "170", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=7e76cc8388336affb91baa48aba89dfd1719981272");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("510", "170", "_action_token", "7e76cc8388336affb91baa48aba89dfd1719981272");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("511", "171", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=28aa42cd27416b63c9f6d2beb53d9fee1720642525");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("512", "171", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=28aa42cd27416b63c9f6d2beb53d9fee1720642525");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("513", "171", "_action_token", "28aa42cd27416b63c9f6d2beb53d9fee1720642525");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("514", "172", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=7268826e5953e25908eb130cdd576ce81720679964");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("515", "172", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=7268826e5953e25908eb130cdd576ce81720679964");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("516", "172", "_action_token", "7268826e5953e25908eb130cdd576ce81720679964");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("517", "173", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=7a46619a3f8fb6eeed17a85ed2fdad571721365042");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("518", "173", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=7a46619a3f8fb6eeed17a85ed2fdad571721365042");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("519", "173", "_action_token", "7a46619a3f8fb6eeed17a85ed2fdad571721365042");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("520", "174", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=0fc02a0036c53e23b9ce0b24076494ad1721392170");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("521", "174", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=0fc02a0036c53e23b9ce0b24076494ad1721392170");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("522", "174", "_action_token", "0fc02a0036c53e23b9ce0b24076494ad1721392170");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("523", "175", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=ae593ab6f23ea4544017920e883369601721753943");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("524", "175", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=ae593ab6f23ea4544017920e883369601721753943");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("525", "175", "_action_token", "ae593ab6f23ea4544017920e883369601721753943");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("526", "176", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=50460db0924494a97a14111f34b950ab1721767901");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("527", "176", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=50460db0924494a97a14111f34b950ab1721767901");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("528", "176", "_action_token", "50460db0924494a97a14111f34b950ab1721767901");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("529", "177", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=492da7a2b063fd9e4eeeb89992d21a491721898196");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("530", "177", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=492da7a2b063fd9e4eeeb89992d21a491721898196");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("531", "177", "_action_token", "492da7a2b063fd9e4eeeb89992d21a491721898196");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("532", "178", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=6fbf5abb0c48551828034e69155b6ccd1722336170");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("533", "178", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=6fbf5abb0c48551828034e69155b6ccd1722336170");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("534", "178", "_action_token", "6fbf5abb0c48551828034e69155b6ccd1722336170");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("535", "179", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=c96138d09e4a8db50818cd5b072210f91722430189");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("536", "179", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=c96138d09e4a8db50818cd5b072210f91722430189");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("537", "179", "_action_token", "c96138d09e4a8db50818cd5b072210f91722430189");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("538", "180", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=cc954a45f5c5ca84f770dde25ca163f91722755778");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("539", "180", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=cc954a45f5c5ca84f770dde25ca163f91722755778");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("540", "180", "_action_token", "cc954a45f5c5ca84f770dde25ca163f91722755778");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("541", "181", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=a41707ade4b1620d95111ef79900c2e61722882926");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("542", "181", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=a41707ade4b1620d95111ef79900c2e61722882926");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("543", "181", "_action_token", "a41707ade4b1620d95111ef79900c2e61722882926");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("544", "182", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=d7fbe713a19b1f2d59768e3dd3540e131723180337");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("545", "182", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=d7fbe713a19b1f2d59768e3dd3540e131723180337");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("546", "182", "_action_token", "d7fbe713a19b1f2d59768e3dd3540e131723180337");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("547", "183", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=b819fc8536a646f559a2bcb13a9f4b881723956621");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("548", "183", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=b819fc8536a646f559a2bcb13a9f4b881723956621");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("549", "183", "_action_token", "b819fc8536a646f559a2bcb13a9f4b881723956621");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("550", "184", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=0ce8c870c1177d8fd38fc9a6185853311724613063");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("551", "184", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=0ce8c870c1177d8fd38fc9a6185853311724613063");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("552", "184", "_action_token", "0ce8c870c1177d8fd38fc9a6185853311724613063");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("553", "185", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=de250b088071da77d3d4230b303d683b1725101934");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("554", "185", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=de250b088071da77d3d4230b303d683b1725101934");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("555", "185", "_action_token", "de250b088071da77d3d4230b303d683b1725101934");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("556", "186", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=117623e85036ff42fcbcde42e8791b311725527685");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("557", "186", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=117623e85036ff42fcbcde42e8791b311725527685");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("558", "186", "_action_token", "117623e85036ff42fcbcde42e8791b311725527685");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("559", "187", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=d298a8c55883d4f841ad41322e01b1401725791055");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("560", "187", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=d298a8c55883d4f841ad41322e01b1401725791055");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("561", "187", "_action_token", "d298a8c55883d4f841ad41322e01b1401725791055");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("562", "188", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=9ef69d8e6a7e7bfaccbcf410ca3731ec1726233472");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("563", "188", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=9ef69d8e6a7e7bfaccbcf410ca3731ec1726233472");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("564", "188", "_action_token", "9ef69d8e6a7e7bfaccbcf410ca3731ec1726233472");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("565", "189", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=611f07872cba1bcbbe0541dcff163d131727090065");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("566", "189", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=611f07872cba1bcbbe0541dcff163d131727090065");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("567", "189", "_action_token", "611f07872cba1bcbbe0541dcff163d131727090065");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("568", "190", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=8b44526422544656d79d82956d45b7ec1727118055");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("569", "190", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=8b44526422544656d79d82956d45b7ec1727118055");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("570", "190", "_action_token", "8b44526422544656d79d82956d45b7ec1727118055");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("571", "191", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=ac50634ce7dc6e2387168f90284684701727708840");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("572", "191", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=ac50634ce7dc6e2387168f90284684701727708840");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("573", "191", "_action_token", "ac50634ce7dc6e2387168f90284684701727708840");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("574", "192", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=62a74aef1aeda93355bc7f7a40cd50c91728045301");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("575", "192", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=62a74aef1aeda93355bc7f7a40cd50c91728045301");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("576", "192", "_action_token", "62a74aef1aeda93355bc7f7a40cd50c91728045301");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("577", "193", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=02400ccc3c373dab5e99fc2c201022a41728249846");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("578", "193", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=02400ccc3c373dab5e99fc2c201022a41728249846");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("579", "193", "_action_token", "02400ccc3c373dab5e99fc2c201022a41728249846");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("580", "194", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=ce8a9bb4a481f1e5a7162c63f31ab0d61728383305");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("581", "194", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=ce8a9bb4a481f1e5a7162c63f31ab0d61728383305");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("582", "194", "_action_token", "ce8a9bb4a481f1e5a7162c63f31ab0d61728383305");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("583", "195", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=c7e8d78ec824c30a4cbacf4bee9dc5911728751508");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("584", "195", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=c7e8d78ec824c30a4cbacf4bee9dc5911728751508");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("585", "195", "_action_token", "c7e8d78ec824c30a4cbacf4bee9dc5911728751508");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("586", "196", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=53500c1c8d1be789a60611f39088f3e91729676137");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("587", "196", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=53500c1c8d1be789a60611f39088f3e91729676137");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("588", "196", "_action_token", "53500c1c8d1be789a60611f39088f3e91729676137");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("589", "197", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=6b67793e0c3c505dbb92e08530f6af481730212727");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("590", "197", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=6b67793e0c3c505dbb92e08530f6af481730212727");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("591", "197", "_action_token", "6b67793e0c3c505dbb92e08530f6af481730212727");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("592", "198", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=99cedd3fdac9271cb4698b83a16c7eaf1730388753");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("593", "198", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=99cedd3fdac9271cb4698b83a16c7eaf1730388753");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("594", "198", "_action_token", "99cedd3fdac9271cb4698b83a16c7eaf1730388753");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("595", "199", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=3711434c4fb1e3892738b3570d90eaa41732468482");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("596", "199", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=3711434c4fb1e3892738b3570d90eaa41732468482");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("597", "199", "_action_token", "3711434c4fb1e3892738b3570d90eaa41732468482");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("598", "200", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=4c29d12c2d110c84c93e2ba7060eac621732524674");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("599", "200", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=4c29d12c2d110c84c93e2ba7060eac621732524674");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("600", "200", "_action_token", "4c29d12c2d110c84c93e2ba7060eac621732524674");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("601", "201", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=040f6be25c4e334fb6c33aff682ceec61732706592");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("602", "201", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=040f6be25c4e334fb6c33aff682ceec61732706592");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("603", "201", "_action_token", "040f6be25c4e334fb6c33aff682ceec61732706592");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("604", "202", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=c7c1f76b2ac1bab8278b37c02dc191861732720339");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("605", "202", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=c7c1f76b2ac1bab8278b37c02dc191861732720339");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("606", "202", "_action_token", "c7c1f76b2ac1bab8278b37c02dc191861732720339");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("607", "203", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=ff7969c273c880b1089395786b0c44a21732726098");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("608", "203", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=ff7969c273c880b1089395786b0c44a21732726098");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("609", "203", "_action_token", "ff7969c273c880b1089395786b0c44a21732726098");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("610", "204", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=add7cbd29f46f8c7ce3cb0762a4954201732883529");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("611", "204", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=add7cbd29f46f8c7ce3cb0762a4954201732883529");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("612", "204", "_action_token", "add7cbd29f46f8c7ce3cb0762a4954201732883529");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("613", "205", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=9d26c8e26f162cb1956ac1f7868310f01732944910");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("614", "205", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=9d26c8e26f162cb1956ac1f7868310f01732944910");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("615", "205", "_action_token", "9d26c8e26f162cb1956ac1f7868310f01732944910");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("616", "206", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=5e09deab9ebf834f34819b941e757ffc1733052177");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("617", "206", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=5e09deab9ebf834f34819b941e757ffc1733052177");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("618", "206", "_action_token", "5e09deab9ebf834f34819b941e757ffc1733052177");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("619", "207", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=3cdeddc9d99f9f7e09a6e32e70eae7941733103778");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("620", "207", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=3cdeddc9d99f9f7e09a6e32e70eae7941733103778");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("621", "207", "_action_token", "3cdeddc9d99f9f7e09a6e32e70eae7941733103778");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("622", "208", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=6bfd38d7f35cad58857a59e0abbba3c51733160829");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("623", "208", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=6bfd38d7f35cad58857a59e0abbba3c51733160829");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("624", "208", "_action_token", "6bfd38d7f35cad58857a59e0abbba3c51733160829");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("625", "209", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=59468a196df9a84b2e2355edfb36d0b21733480684");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("626", "209", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=59468a196df9a84b2e2355edfb36d0b21733480684");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("627", "209", "_action_token", "59468a196df9a84b2e2355edfb36d0b21733480684");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("628", "210", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=016eed46c88d8edf61b2b7bcbb8101b01733839572");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("629", "210", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=016eed46c88d8edf61b2b7bcbb8101b01733839572");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("630", "210", "_action_token", "016eed46c88d8edf61b2b7bcbb8101b01733839572");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("631", "211", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=f57e2a1f83055317131e8fadeec687dd1734326064");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("632", "211", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=f57e2a1f83055317131e8fadeec687dd1734326064");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("633", "211", "_action_token", "f57e2a1f83055317131e8fadeec687dd1734326064");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("634", "212", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=c6999645ac63e77d8e5306d578457eef1734340405");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("635", "212", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=c6999645ac63e77d8e5306d578457eef1734340405");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("636", "212", "_action_token", "c6999645ac63e77d8e5306d578457eef1734340405");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("637", "213", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=a187f8d5daf45518bdaa5a57858da34a1734436528");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("638", "213", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=a187f8d5daf45518bdaa5a57858da34a1734436528");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("639", "213", "_action_token", "a187f8d5daf45518bdaa5a57858da34a1734436528");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("640", "214", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=0090d59286c704e0d2e214671dbac89f1734453097");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("641", "214", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=0090d59286c704e0d2e214671dbac89f1734453097");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("642", "214", "_action_token", "0090d59286c704e0d2e214671dbac89f1734453097");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("643", "215", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=d30605b66e8e744467aeeaf774ce160c1734641616");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("644", "215", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=d30605b66e8e744467aeeaf774ce160c1734641616");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("645", "215", "_action_token", "d30605b66e8e744467aeeaf774ce160c1734641616");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("646", "216", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=f748c3e94d87fcdca48ef314bb0de7b51734797549");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("647", "216", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=f748c3e94d87fcdca48ef314bb0de7b51734797549");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("648", "216", "_action_token", "f748c3e94d87fcdca48ef314bb0de7b51734797549");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("649", "217", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=8475ec9b1565361e0b26c7fc6d94613b1734845196");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("650", "217", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=8475ec9b1565361e0b26c7fc6d94613b1734845196");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("651", "217", "_action_token", "8475ec9b1565361e0b26c7fc6d94613b1734845196");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("652", "218", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=4b6e70924b32ae4c61a35bd5b154f3391735190335");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("653", "218", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=4b6e70924b32ae4c61a35bd5b154f3391735190335");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("654", "218", "_action_token", "4b6e70924b32ae4c61a35bd5b154f3391735190335");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("655", "219", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=b9717ee63e54ced5e6faf479fe6c90cd1735540464");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("656", "219", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=b9717ee63e54ced5e6faf479fe6c90cd1735540464");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("657", "219", "_action_token", "b9717ee63e54ced5e6faf479fe6c90cd1735540464");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("658", "220", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=e91ebaa0716721c4135c9ad3171e1e0c1735579740");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("659", "220", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=e91ebaa0716721c4135c9ad3171e1e0c1735579740");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("660", "220", "_action_token", "e91ebaa0716721c4135c9ad3171e1e0c1735579740");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("661", "221", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=aa4a450ae7c326a733c623be60cc60ce1735672544");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("662", "221", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=aa4a450ae7c326a733c623be60cc60ce1735672544");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("663", "221", "_action_token", "aa4a450ae7c326a733c623be60cc60ce1735672544");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("664", "222", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=6f0e82c0fd8415ccbe39cf10d399c02d1735688864");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("665", "222", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=6f0e82c0fd8415ccbe39cf10d399c02d1735688864");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("666", "222", "_action_token", "6f0e82c0fd8415ccbe39cf10d399c02d1735688864");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("667", "223", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=a8fbed3315705ba5ddfe4fbb5d969b311735916564");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("668", "223", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=a8fbed3315705ba5ddfe4fbb5d969b311735916564");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("669", "223", "_action_token", "a8fbed3315705ba5ddfe4fbb5d969b311735916564");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("670", "224", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=817905a018e47817f1dd3ad6f02dc0891736545641");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("671", "224", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=817905a018e47817f1dd3ad6f02dc0891736545641");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("672", "224", "_action_token", "817905a018e47817f1dd3ad6f02dc0891736545641");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("673", "225", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=54877e2ddb9b9090fa5b72930b241b3a1737276680");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("674", "225", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=54877e2ddb9b9090fa5b72930b241b3a1737276680");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("675", "225", "_action_token", "54877e2ddb9b9090fa5b72930b241b3a1737276680");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("676", "226", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=e1ea92a83c76494bf0fcea826e1e019a1737832990");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("677", "226", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=e1ea92a83c76494bf0fcea826e1e019a1737832990");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("678", "226", "_action_token", "e1ea92a83c76494bf0fcea826e1e019a1737832990");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("679", "227", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=0d177d0b9262c7fd1fc819bab4ebf7971738083098");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("680", "227", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=0d177d0b9262c7fd1fc819bab4ebf7971738083098");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("681", "227", "_action_token", "0d177d0b9262c7fd1fc819bab4ebf7971738083098");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("682", "228", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=68531906c0655c3afcf8ffdf77469f291738088800");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("683", "228", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=68531906c0655c3afcf8ffdf77469f291738088800");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("684", "228", "_action_token", "68531906c0655c3afcf8ffdf77469f291738088800");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("685", "229", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=6eead2c422a9f1fa56e795fa0a44f98a1738445305");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("686", "229", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=6eead2c422a9f1fa56e795fa0a44f98a1738445305");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("687", "229", "_action_token", "6eead2c422a9f1fa56e795fa0a44f98a1738445305");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("688", "230", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=b41abc125d7bf39e16698eb5db2e8e8b1739210241");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("689", "230", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=b41abc125d7bf39e16698eb5db2e8e8b1739210241");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("690", "230", "_action_token", "b41abc125d7bf39e16698eb5db2e8e8b1739210241");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("691", "231", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=12c06ffec67961c1bd7b12475f28124c1739829302");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("692", "231", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=12c06ffec67961c1bd7b12475f28124c1739829302");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("693", "231", "_action_token", "12c06ffec67961c1bd7b12475f28124c1739829302");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("694", "232", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=eb13256700f3f4f503c4d44957c6138a1739962162");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("695", "232", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=eb13256700f3f4f503c4d44957c6138a1739962162");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("696", "232", "_action_token", "eb13256700f3f4f503c4d44957c6138a1739962162");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("697", "233", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=d503256a8fda857fd9bfa3b2c5327fd51740925248");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("698", "233", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=d503256a8fda857fd9bfa3b2c5327fd51740925248");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("699", "233", "_action_token", "d503256a8fda857fd9bfa3b2c5327fd51740925248");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("700", "234", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=cfb40a5d61dca9b55bbd121ed471122d1741543108");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("701", "234", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=cfb40a5d61dca9b55bbd121ed471122d1741543108");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("702", "234", "_action_token", "cfb40a5d61dca9b55bbd121ed471122d1741543108");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("703", "235", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=38f108c69245af04e8a7da34149b83751741673274");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("704", "235", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=38f108c69245af04e8a7da34149b83751741673274");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("705", "235", "_action_token", "38f108c69245af04e8a7da34149b83751741673274");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("706", "236", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=2e450f79d8ee6d316a21897658e60de21742207996");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("707", "236", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=2e450f79d8ee6d316a21897658e60de21742207996");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("708", "236", "_action_token", "2e450f79d8ee6d316a21897658e60de21742207996");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("709", "237", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=c389f9bc3cc38551396461cf7881184b1742868614");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("710", "237", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=c389f9bc3cc38551396461cf7881184b1742868614");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("711", "237", "_action_token", "c389f9bc3cc38551396461cf7881184b1742868614");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("712", "238", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=31e0c7541ad110a81700f643da94d0ac1742897711");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("713", "238", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=31e0c7541ad110a81700f643da94d0ac1742897711");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("714", "238", "_action_token", "31e0c7541ad110a81700f643da94d0ac1742897711");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("715", "239", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=7ce6fc6437a81ef197522df184520b081743232099");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("716", "239", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=7ce6fc6437a81ef197522df184520b081743232099");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("717", "239", "_action_token", "7ce6fc6437a81ef197522df184520b081743232099");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("718", "240", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=0a68b528be4d61d1435f7b6337e78b161743279578");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("719", "240", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=0a68b528be4d61d1435f7b6337e78b161743279578");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("720", "240", "_action_token", "0a68b528be4d61d1435f7b6337e78b161743279578");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("721", "241", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=b47d71505d66c894a022617222d26ed31743676471");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("722", "241", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=b47d71505d66c894a022617222d26ed31743676471");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("723", "241", "_action_token", "b47d71505d66c894a022617222d26ed31743676471");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("724", "242", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=676b17806b9ff057efbb8327ab31d4e51744288113");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("725", "242", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=676b17806b9ff057efbb8327ab31d4e51744288113");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("726", "242", "_action_token", "676b17806b9ff057efbb8327ab31d4e51744288113");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("727", "243", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=c2355d706d1f0f96d907136c92f8d24c1744775938");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("728", "243", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=c2355d706d1f0f96d907136c92f8d24c1744775938");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("729", "243", "_action_token", "c2355d706d1f0f96d907136c92f8d24c1744775938");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("730", "244", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=8e9d613d64c2968ecfb6ddcc4bb690961744906800");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("731", "244", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=8e9d613d64c2968ecfb6ddcc4bb690961744906800");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("732", "244", "_action_token", "8e9d613d64c2968ecfb6ddcc4bb690961744906800");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("733", "245", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=aa1c757ca15c99cdea61b99a52843b521745257267");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("734", "245", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=aa1c757ca15c99cdea61b99a52843b521745257267");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("735", "245", "_action_token", "aa1c757ca15c99cdea61b99a52843b521745257267");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("736", "246", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=755b05c79bf54d5fd02ee7448babbeed1746302804");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("737", "246", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=755b05c79bf54d5fd02ee7448babbeed1746302804");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("738", "246", "_action_token", "755b05c79bf54d5fd02ee7448babbeed1746302804");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("739", "247", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=8716cd8609dc4d60212cd8d22ac858a01746636291");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("740", "247", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=8716cd8609dc4d60212cd8d22ac858a01746636291");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("741", "247", "_action_token", "8716cd8609dc4d60212cd8d22ac858a01746636291");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("742", "248", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=09bdb19df2c69956472ac8bb9067ddd91747033143");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("743", "248", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=09bdb19df2c69956472ac8bb9067ddd91747033143");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("744", "248", "_action_token", "09bdb19df2c69956472ac8bb9067ddd91747033143");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("745", "249", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=ed9f18199362e474141f2fde4361cb7b1749038982");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("746", "249", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=ed9f18199362e474141f2fde4361cb7b1749038982");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("747", "249", "_action_token", "ed9f18199362e474141f2fde4361cb7b1749038982");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("748", "250", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=42241dcb6fffbb8e136eece647e4e1b11749575657");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("749", "250", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=42241dcb6fffbb8e136eece647e4e1b11749575657");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("750", "250", "_action_token", "42241dcb6fffbb8e136eece647e4e1b11749575657");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("751", "251", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=2416a97ef7ec7e0238153c5f5fce6e7a1751194541");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("752", "251", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=2416a97ef7ec7e0238153c5f5fce6e7a1751194541");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("753", "251", "_action_token", "2416a97ef7ec7e0238153c5f5fce6e7a1751194541");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("754", "252", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=2807fed361d646b62a519cd153aa0fb41751722180");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("755", "252", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=2807fed361d646b62a519cd153aa0fb41751722180");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("756", "252", "_action_token", "2807fed361d646b62a519cd153aa0fb41751722180");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("757", "253", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=78f5df2f18443cb977152f354d4c91b61753346629");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("758", "253", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=78f5df2f18443cb977152f354d4c91b61753346629");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("759", "253", "_action_token", "78f5df2f18443cb977152f354d4c91b61753346629");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("760", "254", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=9e76fb40034799925385d3f9c97f3a2d1753697046");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("761", "254", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=9e76fb40034799925385d3f9c97f3a2d1753697046");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("762", "254", "_action_token", "9e76fb40034799925385d3f9c97f3a2d1753697046");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("763", "255", "_confirm_url", "https://presite.ir/doctor/?_jet_apb_action=confirm&_action_token=cf635c9e309cf9863c7ed732703834ec1755727796");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("764", "255", "_cancel_url", "https://presite.ir/doctor/?_jet_apb_action=cancel&_action_token=cf635c9e309cf9863c7ed732703834ec1755727796");
INSERT INTO `wp_abz7_jet_appointments_meta` VALUES("765", "255", "_action_token", "cf635c9e309cf9863c7ed732703834ec1755727796");

/* INSERT TABLE DATA: wp_abz7_jet_cct_reviews */
INSERT INTO `wp_abz7_jet_cct_reviews` VALUES("1", "publish", "مریم حسنی", "بیمار", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی ارایه و در اختیار شما قرار گرفته است.", "709", "1", "2023-03-26 16:11:06", "2023-03-26 16:11:06");
INSERT INTO `wp_abz7_jet_cct_reviews` VALUES("2", "publish", "محسن ایرانی", "متخصص قلب", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی ارایه و در اختیار شما قرار گرفته است.", "725", "1", "2023-03-26 16:26:35", "2023-03-26 16:26:35");
INSERT INTO `wp_abz7_jet_cct_reviews` VALUES("3", "publish", "محمد ایمانی", "مدیر عامل شرکت", "لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ، و با استفاده از طراحان گرافیک است، چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است، و برای شرایط فعلی تکنولوژی مورد نیاز، و کاربردهای متنوع با هدف بهبود ابزارهای کاربردی ارایه و در اختیار شما قرار گرفته است.", "726", "1", "2023-03-26 16:28:30", "2023-03-26 16:28:30");

/* INSERT TABLE DATA: wp_abz7_jet_post_types */
INSERT INTO `wp_abz7_jet_post_types` VALUES("1", "service", "publish", "a:1:{s:4:\"name\";s:10:\"خدمات\";}", "a:21:{s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:9:\"query_var\";b:1;s:7:\"rewrite\";b:1;s:11:\"has_archive\";b:1;s:12:\"hierarchical\";b:0;s:19:\"exclude_from_search\";b:0;s:10:\"with_front\";b:0;s:14:\"show_edit_link\";b:0;s:16:\"hide_field_names\";b:0;s:12:\"rewrite_slug\";s:7:\"service\";s:15:\"capability_type\";s:4:\"post\";s:13:\"menu_position\";N;s:9:\"menu_icon\";s:15:\"dashicons-forms\";s:8:\"supports\";a:4:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:8:\"comments\";i:3;s:9:\"thumbnail\";}s:13:\"admin_columns\";a:0:{}s:13:\"admin_filters\";a:0:{}}", "a:0:{}");
INSERT INTO `wp_abz7_jet_post_types` VALUES("2", "reviews", "content-type", NULL, "a:20:{s:10:\"has_single\";b:0;s:12:\"create_index\";b:0;s:16:\"rest_get_enabled\";b:0;s:16:\"rest_put_enabled\";b:0;s:17:\"rest_post_enabled\";b:0;s:19:\"rest_delete_enabled\";b:0;s:16:\"hide_field_names\";b:0;s:4:\"name\";s:25:\"نظرات کاربران\";s:4:\"slug\";s:7:\"reviews\";s:8:\"position\";i:4;s:4:\"icon\";s:23:\"dashicons-format-status\";s:10:\"capability\";s:14:\"manage_options\";s:17:\"related_post_type\";s:0:\"\";s:23:\"related_post_type_title\";s:0:\"\";s:25:\"related_post_type_content\";s:0:\"\";s:15:\"rest_get_access\";s:0:\"\";s:15:\"rest_put_access\";s:10:\"edit_posts\";s:16:\"rest_post_access\";s:10:\"edit_posts\";s:18:\"rest_delete_access\";s:10:\"edit_posts\";s:13:\"admin_columns\";a:10:{s:3:\"_ID\";a:4:{s:7:\"enabled\";b:1;s:11:\"is_sortable\";b:1;s:6:\"is_num\";b:1;s:6:\"prefix\";s:1:\"#\";}s:18:\"cct_single_post_id\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:13:\"cct_author_id\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:11:\"cct_created\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:12:\"cct_modified\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:10:\"cct_status\";a:3:{s:7:\"enabled\";b:1;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:11:\"review_name\";a:3:{s:7:\"enabled\";b:1;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:11:\"review_role\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:11:\"review_text\";a:3:{s:7:\"enabled\";b:0;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}s:10:\"review_pic\";a:3:{s:7:\"enabled\";b:1;s:11:\"is_sortable\";b:0;s:6:\"is_num\";b:0;}}}", "a:4:{i:0;a:8:{s:5:\"title\";s:21:\"نام نویسنده\";s:4:\"name\";s:11:\"review_name\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:1804;s:8:\"isNested\";b:0;}i:1;a:8:{s:5:\"title\";s:21:\"سمت نویسنده\";s:4:\"name\";s:11:\"review_role\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:4:\"type\";s:4:\"text\";s:2:\"id\";i:8003;s:8:\"isNested\";b:0;}i:2;a:8:{s:5:\"title\";s:13:\"متن نظر\";s:4:\"name\";s:11:\"review_text\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:4:\"type\";s:8:\"textarea\";s:2:\"id\";i:8822;s:8:\"isNested\";b:0;}i:3;a:8:{s:5:\"title\";s:25:\"تصویر نویسنده\";s:4:\"name\";s:10:\"review_pic\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:4:\"type\";s:5:\"media\";s:2:\"id\";i:7526;s:8:\"isNested\";b:0;}}");
INSERT INTO `wp_abz7_jet_post_types` VALUES("3", NULL, "query", "a:1:{s:4:\"name\";s:38:\"محصولات ویژه ووکامرس\";}", "a:8:{s:10:\"query_type\";s:16:\"wc-product-query\";s:16:\"wc-product-query\";a:6:{s:14:\"specific_query\";a:1:{i:0;a:4:{s:3:\"_id\";i:682455;s:9:\"collapsed\";b:0;s:7:\"feature\";s:8:\"featured\";s:6:\"status\";b:1;}}s:10:\"date_query\";a:0:{}s:8:\"paginate\";b:1;s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:0:{}s:6:\"status\";a:1:{i:0;s:7:\"publish\";}}s:26:\"__dynamic_wc-product-query\";a:3:{s:10:\"date_query\";a:0:{}s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:0:{}}s:12:\"show_preview\";b:0;s:12:\"preview_page\";N;s:18:\"preview_page_title\";N;s:20:\"preview_query_string\";N;s:8:\"query_id\";s:16:\"featured_product\";}", "a:0:{}");
INSERT INTO `wp_abz7_jet_post_types` VALUES("4", NULL, "query", "a:1:{s:4:\"name\";s:36:\"کوئری آرشیو محصولات\";}", "a:9:{s:10:\"query_type\";s:16:\"wc-product-query\";s:16:\"wc-product-query\";a:8:{s:14:\"specific_query\";a:0:{}s:10:\"date_query\";a:0:{}s:8:\"paginate\";b:1;s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:1:{i:0;a:4:{s:3:\"_id\";i:693750;s:9:\"collapsed\";b:0;s:8:\"taxonomy\";s:11:\"product_cat\";s:5:\"field\";s:7:\"term_id\";}}s:7:\"exclude\";s:4:\"3165\";s:5:\"limit\";s:0:\"\";s:4:\"page\";s:0:\"\";}s:26:\"__dynamic_wc-product-query\";a:3:{s:10:\"date_query\";a:0:{}s:10:\"meta_query\";a:0:{}s:9:\"tax_query\";a:1:{i:693750;a:1:{s:5:\"terms\";s:42:\"%queried_term%{\"context\":\"default_object\"}\";}}}s:12:\"show_preview\";b:0;s:12:\"preview_page\";N;s:18:\"preview_page_title\";N;s:20:\"preview_query_string\";N;s:8:\"query_id\";N;s:11:\"description\";N;}", "a:0:{}");

/* INSERT TABLE DATA: wp_abz7_options */
INSERT INTO `wp_abz7_options` VALUES("1", "siteurl", "https://presite.ir/doctor/", "yes");
INSERT INTO `wp_abz7_options` VALUES("2", "home", "https://presite.ir/doctor", "yes");
INSERT INTO `wp_abz7_options` VALUES("3", "blogname", "سایت آماده پزشک متخصص + رزرو نوبت", "yes");
INSERT INTO `wp_abz7_options` VALUES("4", "blogdescription", "یک سایت دیگر از ابزار وردپرس", "yes");
INSERT INTO `wp_abz7_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_abz7_options` VALUES("6", "admin_email", "info@abzarwp-plugins.ir", "yes");
INSERT INTO `wp_abz7_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_abz7_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_abz7_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_abz7_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_abz7_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_abz7_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_abz7_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_abz7_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_abz7_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_abz7_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_abz7_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_abz7_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wp_abz7_options` VALUES("24", "time_format", "H:i", "yes");
INSERT INTO `wp_abz7_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_abz7_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_abz7_options` VALUES("29", "rewrite_rules", "a:249:{s:11:\"jsf/(.*)/?$\";s:25:\"index.php?jsf=$matches[1]\";s:16:\"shop/jsf/(.*)/?$\";s:43:\"index.php?post_type=product&jsf=$matches[1]\";s:27:\"product/([^/]*)/jsf/(.*)/?$\";s:45:\"index.php?product=$matches[1]&jsf=$matches[2]\";s:24:\"shop/([^/]*)/jsf/(.*)/?$\";s:45:\"index.php?product=$matches[1]&jsf=$matches[2]\";s:32:\"shop/([^/]*)/([^/]*)/jsf/(.*)/?$\";s:69:\"index.php?product_cat=$matches[1]&product=$matches[2]&jsf=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{2})/([0-9]{2})/([^/]+)/jsf/(.*)/?$\";s:96:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&jsf=$matches[5]\";s:41:\"([0-9]{4})/([0-9]{2})/([^/]+)/jsf/(.*)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&name=$matches[3]&jsf=$matches[4]\";s:29:\"archives/([0-9]+)/jsf/(.*)/?$\";s:39:\"index.php?p=$matches[1]&jsf=$matches[2]\";s:20:\"([0-9]+)/jsf/(.*)/?$\";s:39:\"index.php?p=$matches[1]&jsf=$matches[2]\";s:19:\"(.?.+?)/jsf/(.*)/?$\";s:46:\"index.php?pagename=$matches[1]&jsf=$matches[2]\";s:19:\"([^/]+)/jsf/(.*)/?$\";s:42:\"index.php?name=$matches[1]&jsf=$matches[2]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:24:\"^custom_wp_die_action/?$\";s:32:\"index.php?custom_wp_die_action=1\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:10:\"service/?$\";s:27:\"index.php?post_type=service\";s:40:\"service/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=service&feed=$matches[1]\";s:35:\"service/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=service&feed=$matches[1]\";s:27:\"service/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=service&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:55:\"e-floating-buttons/([^/]+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?e-floating-buttons=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"e-floating-buttons/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?e-floating-buttons=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"e-floating-buttons/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"برند/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:42:\"برند/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:23:\"برند/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:35:\"برند/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:17:\"برند/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"service/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"service/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"service/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"service/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"service/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"service/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"service/([^/]+)/embed/?$\";s:40:\"index.php?service=$matches[1]&embed=true\";s:28:\"service/([^/]+)/trackback/?$\";s:34:\"index.php?service=$matches[1]&tb=1\";s:48:\"service/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?service=$matches[1]&feed=$matches[2]\";s:43:\"service/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?service=$matches[1]&feed=$matches[2]\";s:36:\"service/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?service=$matches[1]&paged=$matches[2]\";s:43:\"service/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?service=$matches[1]&cpage=$matches[2]\";s:44:\"service/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?service=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"service/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?service=$matches[1]&wc-api=$matches[3]\";s:50:\"service/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"service/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"service/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"service/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"service/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?service=$matches[1]&page=$matches[2]\";s:24:\"service/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"service/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"service/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"service/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"service/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"service/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=6&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_abz7_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_abz7_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_abz7_options` VALUES("33", "active_plugins", "a:16:{i:0;s:37:\"3r-elementor-timeline-widget/init.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:59:\"checkout-field-editor-and-manager-for-woocommerce/start.php\";i:3;s:25:\"demo-modal/demo-modal.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:25:\"duplicator/duplicator.php\";i:6;s:31:\"elementor-pro/elementor-pro.php\";i:7;s:23:\"elementor/elementor.php\";i:8;s:53:\"jet-appointments-booking/jet-appointments-booking.php\";i:9;s:60:\"jet-engine-trim-callback-master/jet-engine-trim-callback.php\";i:10;s:25:\"jet-engine/jet-engine.php\";i:11;s:24:\"jet-plugin-pro/index.php\";i:12;s:39:\"jet-smart-filters/jet-smart-filters.php\";i:13;s:21:\"jet-tabs/jet-tabs.php\";i:14;s:37:\"payamito-sms-jet-engine/bootstrap.php\";i:15;s:27:\"woocommerce/woocommerce.php\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("35", "ping_sites", "https://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_abz7_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_abz7_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_abz7_options` VALUES("40", "template", "hello-elementor", "yes");
INSERT INTO `wp_abz7_options` VALUES("41", "stylesheet", "hello-elementor", "yes");
INSERT INTO `wp_abz7_options` VALUES("42", "comment_registration", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_abz7_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_abz7_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_abz7_options` VALUES("46", "db_version", "60421", "yes");
INSERT INTO `wp_abz7_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_abz7_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_abz7_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_abz7_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_abz7_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_abz7_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_abz7_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_abz7_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_abz7_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_abz7_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_abz7_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_abz7_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_abz7_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_abz7_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_abz7_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_abz7_options` VALUES("74", "comment_order", "desc", "yes");
INSERT INTO `wp_abz7_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_abz7_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("79", "uninstall_plugins", "a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_abz7_options` VALUES("80", "timezone_string", "Asia/Tehran", "yes");
INSERT INTO `wp_abz7_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_abz7_options` VALUES("82", "page_on_front", "6", "yes");
INSERT INTO `wp_abz7_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_abz7_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_abz7_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("86", "site_icon", "3304", "yes");
INSERT INTO `wp_abz7_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_abz7_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_abz7_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_abz7_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("91", "admin_email_lifespan", "1723124463", "yes");
INSERT INTO `wp_abz7_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_abz7_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_abz7_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_abz7_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_abz7_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_abz7_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_abz7_options` VALUES("99", "initial_db_version", "53496", "yes");
INSERT INTO `wp_abz7_options` VALUES("100", "wp_abz7_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:122:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:93:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}}", "yes");
INSERT INTO `wp_abz7_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `wp_abz7_options` VALUES("102", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_abz7_options` VALUES("103", "user_count", "1", "off");
INSERT INTO `wp_abz7_options` VALUES("104", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("105", "sidebars_widgets", "a:2:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("106", "cron", "a:19:{i:1759827128;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1759828231;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1759828394;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1759828495;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1759829288;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1759830118;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1759835631;a:3:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1759835654;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1759835805;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1759836115;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1759837711;a:1:{s:46:\"puc_cron_check_updates-payamito-sms-jet-engine\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1759838110;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1759901526;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1759909318;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1759922031;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1759970199;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1760221421;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1760351400;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_abz7_options` VALUES("74792", "woocommerce_attribute_lookup_enabled", "yes", "auto");
INSERT INTO `wp_abz7_options` VALUES("74793", "_transient_timeout__woocommerce_upload_directory_status", "1759912068", "off");
INSERT INTO `wp_abz7_options` VALUES("74794", "_transient__woocommerce_upload_directory_status", "protected", "off");
INSERT INTO `wp_abz7_options` VALUES("6681", "action_scheduler_migration_status", "complete", "yes");
INSERT INTO `wp_abz7_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("122", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_abz7_options` VALUES("125", "theme_mods_twentytwentythree", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1678792576;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_abz7_options` VALUES("128", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wp_abz7_options` VALUES("315", "elementor_pro_theme_builder_conditions", "a:4:{s:6:\"single\";a:3:{i:2570;a:1:{i:0;s:15:\"include/product\";}i:1619;a:1:{i:0;s:24:\"include/singular/service\";}i:946;a:1:{i:0;s:21:\"include/singular/post\";}}s:7:\"archive\";a:2:{i:2444;a:1:{i:0;s:23:\"include/product_archive\";}i:974;a:1:{i:0;s:15:\"include/archive\";}}s:6:\"header\";a:1:{i:793;a:1:{i:0;s:15:\"include/general\";}}s:6:\"footer\";a:1:{i:738;a:1:{i:0;s:15:\"include/general\";}}}", "yes");
INSERT INTO `wp_abz7_options` VALUES("912", "jet-tabs-db-version", "2.2.10", "yes");
INSERT INTO `wp_abz7_options` VALUES("170", "hello_theme_version", "3.4.4", "yes");
INSERT INTO `wp_abz7_options` VALUES("154", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_abz7_options` VALUES("159", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("12831", "db_upgraded", "", "on");
INSERT INTO `wp_abz7_options` VALUES("949", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_abz7_options` VALUES("776", "wp_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("533", "aep_tl_notice", "tb_tl_never_show", "yes");
INSERT INTO `wp_abz7_options` VALUES("167", "current_theme", "Hello Elementor", "yes");
INSERT INTO `wp_abz7_options` VALUES("168", "theme_mods_hello-elementor", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:25;s:11:\"custom_logo\";i:2750;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("169", "theme_switched", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("161", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("178", "elementor_active_kit", "5", "yes");
INSERT INTO `wp_abz7_options` VALUES("179", "elementor_font_display", "swap", "yes");
INSERT INTO `wp_abz7_options` VALUES("182", "elementor_version", "3.32.4", "yes");
INSERT INTO `wp_abz7_options` VALUES("183", "elementor_install_history", "a:8:{s:6:\"3.10.2\";i:1680516413;s:6:\"3.11.5\";i:1678792873;s:6:\"3.11.7\";i:1685429935;s:6:\"3.12.0\";i:1680111170;s:6:\"3.12.1\";i:1680516414;s:6:\"3.13.4\";i:1685429941;s:6:\"3.28.3\";i:1744449956;s:6:\"3.32.4\";i:1759825636;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("184", "elementor_events_db_version", "1.0.0", "no");
INSERT INTO `wp_abz7_options` VALUES("186", "elementor_onboarded", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("187", "_elementor_installed_time", "1678792635", "yes");
INSERT INTO `wp_abz7_options` VALUES("188", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_abz7_options` VALUES("74749", "_transient_timeout_wc_upgrade_notice_10.2.2", "1759912003", "off");
INSERT INTO `wp_abz7_options` VALUES("74750", "_transient_wc_upgrade_notice_10.2.2", "", "off");
INSERT INTO `wp_abz7_options` VALUES("74751", "_transient_timeout_wc_tracks_blog_details", "1759912003", "off");
INSERT INTO `wp_abz7_options` VALUES("74752", "_transient_wc_tracks_blog_details", "a:6:{s:3:\"url\";s:25:\"https://presite.ir/doctor\";s:9:\"blog_lang\";s:5:\"fa_IR\";s:7:\"blog_id\";b:0;s:8:\"store_id\";s:36:\"51228c79-863f-4280-926c-ae0be13e8b94\";s:14:\"products_count\";s:2:\"15\";s:10:\"wc_version\";s:5:\"9.8.1\";}", "off");
INSERT INTO `wp_abz7_options` VALUES("74753", "_transient_timeout_orders-all-statuses", "1760430404", "off");
INSERT INTO `wp_abz7_options` VALUES("74754", "_transient_orders-all-statuses", "a:2:{s:7:\"version\";s:10:\"1755371210\";s:5:\"value\";a:0:{}}", "off");
INSERT INTO `wp_abz7_options` VALUES("74755", "_transient_timeout_woocommerce_admin_payment_method_promotion_specs", "1759836407", "off");
INSERT INTO `wp_abz7_options` VALUES("74756", "_transient_woocommerce_admin_payment_method_promotion_specs", "a:1:{s:5:\"fa_IR\";a:2:{i:0;a:7:{s:2:\"id\";s:27:\"woocommerce_payments:woopay\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:110:\"پرداخت‌ها ساده شدند - از جمله WooPay، یک ویژگی جدید پرداخت سریع.\";s:5:\"image\";s:91:\"https://presite.ir/doctor/wp-content/plugins/woocommerce/assets/images/onboarding/wcpay.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:1:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}}}}s:9:\"sub_title\";s:810:\"<img class=\"wcpay-visa-icon wcpay-icon\" src=\"https://presite.ir/doctor/wp-content/plugins/woocommerce/assets/images/payment-methods/visa.svg\" alt=\"Visa\"><img class=\"wcpay-mastercard-icon wcpay-icon\" src=\"https://presite.ir/doctor/wp-content/plugins/woocommerce/assets/images/payment-methods/mastercard.svg\" alt=\"Mastercard\"><img class=\"wcpay-amex-icon wcpay-icon\" src=\"https://presite.ir/doctor/wp-content/plugins/woocommerce/assets/images/payment-methods/amex.svg\" alt=\"Amex\"><img class=\"wcpay-googlepay-icon wcpay-icon\" src=\"https://presite.ir/doctor/wp-content/plugins/woocommerce/assets/images/payment-methods/googlepay.svg\" alt=\"Googlepay\"><img class=\"wcpay-applepay-icon wcpay-icon\" src=\"https://presite.ir/doctor/wp-content/plugins/woocommerce/assets/images/payment-methods/applepay.svg\" alt=\"Applepay\">\";}i:1;a:7:{s:2:\"id\";s:20:\"woocommerce_payments\";s:5:\"title\";s:11:\"WooPayments\";s:7:\"content\";s:313:\"پرداخت‌ها ساده و بدون کارمزد ماهانه انجام می‌شود - منحصرا برای فروشگاه‌های ووکامرس طراحی شده است. کارت‌های اعتباری، کارت‌های نقدی و سایر روش‌های پرداخت رایج را بپذیرید.\";s:5:\"image\";s:91:\"https://presite.ir/doctor/wp-content/plugins/woocommerce/assets/images/onboarding/wcpay.svg\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}s:10:\"is_visible\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:2:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:8:\"industry\";}}i:1;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"array_column\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:3:\"key\";s:4:\"slug\";}}}s:11:\"option_name\";s:30:\"woocommerce_onboarding_profile\";s:9:\"operation\";s:9:\"!contains\";s:5:\"value\";s:31:\"cbd-other-hemp-derived-products\";s:7:\"default\";a:0:{}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:39:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PR\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AU\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CA\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CY\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DE\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"DK\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"EE\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"ES\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FI\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"FR\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GB\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"GR\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IE\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"IT\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LU\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LT\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"LV\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NO\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NZ\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"MT\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AT\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BE\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"NL\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PL\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"PT\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CH\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HK\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SI\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SK\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SG\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"BG\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"CZ\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HR\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"HU\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"RO\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"SE\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"JP\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"AE\";s:9:\"operation\";s:1:\"=\";}}}}s:9:\"sub_title\";s:810:\"<img class=\"wcpay-visa-icon wcpay-icon\" src=\"https://presite.ir/doctor/wp-content/plugins/woocommerce/assets/images/payment-methods/visa.svg\" alt=\"Visa\"><img class=\"wcpay-mastercard-icon wcpay-icon\" src=\"https://presite.ir/doctor/wp-content/plugins/woocommerce/assets/images/payment-methods/mastercard.svg\" alt=\"Mastercard\"><img class=\"wcpay-amex-icon wcpay-icon\" src=\"https://presite.ir/doctor/wp-content/plugins/woocommerce/assets/images/payment-methods/amex.svg\" alt=\"Amex\"><img class=\"wcpay-googlepay-icon wcpay-icon\" src=\"https://presite.ir/doctor/wp-content/plugins/woocommerce/assets/images/payment-methods/googlepay.svg\" alt=\"Googlepay\"><img class=\"wcpay-applepay-icon wcpay-icon\" src=\"https://presite.ir/doctor/wp-content/plugins/woocommerce/assets/images/payment-methods/applepay.svg\" alt=\"Applepay\">\";}}}", "off");
INSERT INTO `wp_abz7_options` VALUES("74757", "can_compress_scripts", "0", "on");
INSERT INTO `wp_abz7_options` VALUES("74807", "_elementor_element_cache_unique_id", "9621ebf92bb7bda5ada216fb3dfffd13", "auto");
INSERT INTO `wp_abz7_options` VALUES("74831", "_transient_woocommerce_analytics_orders_statuses_all", "a:0:{}", "off");
INSERT INTO `wp_abz7_options` VALUES("74832", "_transient_woocommerce_product_task_has_product_transient", "yes", "on");
INSERT INTO `wp_abz7_options` VALUES("74833", "_site_transient_timeout_browser_a3f57bbe21c4e30379228ad7788f224d", "1760432458", "off");
INSERT INTO `wp_abz7_options` VALUES("74834", "_site_transient_browser_a3f57bbe21c4e30379228ad7788f224d", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"140.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_abz7_options` VALUES("74837", "_elementor_notifications_data", "a:2:{s:7:\"timeout\";i:1759844340;s:5:\"value\";s:15038:\"[{\"id\":\"transform-3.32\",\"title\":\"Design with depth using Transform\",\"description\":\"Move, scale, rotate, and skew any element with ease. Transform controls add depth, stacked effects, and seamless States for hover, focus, and active micro-interactions.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transform.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"size-variable-3.32\",\"title\":\"Consistency with Size Variables\",\"description\":\"Define reusable values for properties like spacing or typography, then update them once to scale changes instantly across your site.\",\"topic\":\"Elementor Pro 3.32\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-size-variables.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-size-variable\\/\"},{\"id\":\"transitions-3.32\",\"title\":\"Smooth interactions with Transitions\",\"description\":\"Bring polish to every interaction. Transitions let you animate style changes smoothly between states. In Pro, layer multiple transitions by property for refined, modern micro-animations.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.32-transition.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.32-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"variables-3.31\",\"title\":\"Scalable design with Variables\",\"description\":\"Define once, reuse everywhere. Color & Font Variables help you build consistent, scalable design systems that update globally and are perfect for large sites or teams.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-variables.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"filters-3.31\",\"title\":\"Visual effects with Filters and Backdrop Filters\",\"description\":\"Apply multiple Filters like blur, brightness, and contrast. Stack, reorder, and preview in real time without writing a line of code.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-filters.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-assistant\",\"title\":\"New! Fix accessibility issues with Ally Assistant\",\"description\":\"Scan any page for accessibility issues and fix them in one click. From color contrast to missing alt text, Ally Assistant provides guided steps or AI-powered fixes to make your site more inclusive.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-assistant.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Scan for free\",\"ctaLink\":\"http:\\/\\/go.elementor.com\\/acc-assistant-launch-whats-new\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"classes-3.31\",\"title\":\"Smarter Class Manager tools\",\"description\":\"Quickly locate and manage Global Classes with usage counts, a new locator panel, and full class search. Perfect for scaling and refactoring complex design systems.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-classes.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"send-notification-august\",\"title\":\"All Your Assets, One Library\",\"description\":\"Save time and skip the re-uploads - now you can pull images straight from your WordPress Media Library into Send. Faster, simpler, and built for WordPress.\",\"topic\":\"Send: Email & SMS built for WooCommerce\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aug_send.png\",\"chipTags\":[\"Cart abandonment\"],\"cta\":\"Upload Your Assets\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/ML_WN\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"send-app\\/send-app.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"attributes-3.31\",\"title\":\"Add semantic HTML with Attributes\",\"description\":\"Add custom HTML attributes like aria-*, data-*, and role to any element. Structure your markup for better accessibility, performance, and compliance.\",\"topic\":\"Elementor Pro 3.31\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/3.31-attributes.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.31-attributes\\/\"},{\"id\":\"classes-3.30\",\"title\":\"Better class control\",\"description\":\"Get popovers with your class name, breakpoint, state and possible conflicts. Plus, the exact class names you define are now reflected in the code, making debugging and working with external tools easier!\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/classes-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-websites-3.30\",\"title\":\"Full Website Templates in the cloud\",\"description\":\"Save and apply entire websites, including multiple pages, styles, site settings, media, and layout configurations - directly from the cloud.\",\"topic\":\"Elementor Pro 3.30\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-3.30.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade now\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.30-cloud-websites\\/\"},{\"id\":\"youtube-3.30\",\"title\":\"YouTube Element\",\"description\":\"The new YouTube Element is purpose-built to support V4 capabilities with faster rendering, better performance, and familiar controls like autoplay, loop, mute, and aspect ratio.\",\"topic\":\"Editor V4 Alpha\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/youtube-3.30.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.39-v4-blog\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"host-google-cloud\",\"title\":\"Deliver fast, secure websites at scale - free migration included!\",\"description\":\"Host your site on Elementor\\u2019s infrastructure - built for speed, security, and scale. Powered by Google Cloud, with free migration and 24\\/7 expert support.\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/host-google-cloud.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/elementor-host-google-cloud\",\"readMoreText\":\"Read More\"},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipPlan\":\"Pro\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates-blog\\/\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"plugin\",\"plugin\":\"elementor-pro\\/elementor-pro.php\"}]]},{\"id\":\"cloud-templates-3.29\",\"title\":\"Your Templates, available everywhere\",\"description\":\"Store sections, containers, and full pages in the cloud\\u2014making them accessible across all your Pro-connected sites. Style once, reuse anywhere!\",\"topic\":\"Elementor Pro 3.29\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/cloud-templates.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Upgrade\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/go-pro-notification-3.29-cloud-templates\\/\"},{\"id\":\"migration-host\",\"title\":\"Move to Better Cloud Hosting, Painlessly\",\"description\":\"Migrate your Elementor website for free to a home that\\u2019s perfect for it, in minutes, with a combination of\\u2028advanced automation and free expert support\",\"topic\":\"Host\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/migration-host.png\",\"chipTags\":[\"Cloud Hosting\"],\"link\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\",\"readMoreText\":\"Learn More\",\"cta\":\"Migrate for free\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/hosting-free-migration\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"conditions\":[[{\"type\":\"introduction_meta\",\"meta\":\"ai_get_started\"}]],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"ai-isolate-object\",\"title\":\"Sharper product images, instantly\",\"description\":\"Remove distractions and reframe your shots with the new Isolate Object tool powered by Elementor AI \\u2014 perfect for a polished, uniform Woo storefront.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/isolate-object-ai.png\",\"chipTags\":[\"New Feature\"],\"cta\":\"Start Free Trial\",\"link\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\",\"readMoreText\":\"Learn More\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/Isolateobjectblog\"},{\"id\":\"hello-biz-contact\",\"title\":\"New Contact Widget, Visual Layout Presets & more\",\"description\":\"Hello Biz just got an update! Explore the new Contact Widget, Visual Layout Presets, Form Submissions integration, and fresh new kits.\",\"topic\":\"Hello Biz\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/hello-biz-contact.png\",\"chipTags\":[\"New Features\"],\"link\":\"https:\\/\\/go.elementor.com\\/hello-biz-updates\",\"readMoreText\":\"Learn More\"},{\"id\":\"ai-site-planner-colors\",\"title\":\"Style Your Wireframe, Speed Up Your Store Build\",\"description\":\"Site Planner now lets you style your wireframe with fonts and colors - instantly visualizing your site\\u2019s look and feel. Plus, it predesigns pages for WooCommerce like Cart and Checkout, so you can dive straight into customizations\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/site-planner-colors.png\",\"chipTags\":[\"New Feature\"],\"link\":\"http:\\/\\/www.elementor.com\\/ai-site-planner\",\"readMoreText\":\"Learn More\"},{\"id\":\"ally-notification\",\"title\":\"Just released! Ally - a new plugin for web accessibility & usability\",\"description\":\"Ally simplifies the complexities of making your website more accessible. With new regulations here and coming, making your website more usable and inclusive is no longer just an option, but a must.\",\"topic\":\"Ally by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/ally-notification.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get it free\",\"ctaLink\":\"https:\\/\\/wordpress.org\\/plugins\\/pojo-accessibility\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"pojo-accessibility\\/pojo-accessibility.php\"}]]},{\"id\":\"ai-site-planner\",\"title\":\"Instant Sitemaps & Wireframes\",\"description\":\"Get your website plan in minutes with AI Site Planner. Describe your desired site and AI will generate a sitemap, brief and wireframe populated with initial content, ready for you to customize.\",\"topic\":\"Elementor AI\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/aI-site-planner.png\",\"chipTags\":[\"New Feature\"],\"link\":\"https:\\/\\/go.elementor.com\\/ai-notification-site-planner\\/\",\"readMoreText\":\"Learn More\"},{\"id\":\"image-optimizer-3.19\",\"title\":\"Effortlessly optimize images for a stunning, high-speed website with the Image Optimizer plugin.\",\"description\":\"Image Optimizer perfectly balances between image quality and performance to boost your website.  Resize, compress, and convert images to WebP, for faster loading times and and better user experience.\",\"topic\":\"Image Optimizer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/image-optimizer-3.19.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Get the Image Optimizer\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/io-notification-wp-dash-learn-more\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"image-optimization\\/image-optimization.php\"}]]},{\"id\":\"5-star-rating-prompt\",\"title\":\"Love the New Features? Let Us Know with 5 Stars!\",\"description\":\"Help spread the word by telling the world what you love about Elementor.\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/5-star-rating-prompt.png\",\"cta\":\"Leave a Review\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/wp-dash-notification-five-stars\\/\"},{\"id\":\"site-mailer-introducing\",\"title\":\"Introducing Site Mailer\",\"description\":\"Keep your WordPress emails out of the spam folder with improved deliverability and an easy setup\\u2014no need for an SMTP plugin or complicated configurations.\",\"topic\":\"Site Mailer Plugin by Elementor\",\"imageSrc\":\"https:\\/\\/assets.elementor.com\\/notifications\\/v1\\/images\\/Site-mailer.png\",\"chipTags\":[\"New plugin\"],\"cta\":\"Start Free Trial\",\"ctaLink\":\"https:\\/\\/go.elementor.com\\/sm-wp-dash-whatsnew\\/\",\"conditions\":[[{\"type\":\"plugin\",\"operator\":\"!=\",\"plugin\":\"site-mailer\\/site-mailer.php\"}]]}]\";}", "off");
INSERT INTO `wp_abz7_options` VALUES("74838", "_transient_timeout_elementor_unread_notifications_1", "1759831740", "off");
INSERT INTO `wp_abz7_options` VALUES("74839", "_transient_elementor_unread_notifications_1", "a:23:{i:0;s:14:\"transform-3.32\";i:1;s:18:\"size-variable-3.32\";i:2;s:16:\"transitions-3.32\";i:3;s:14:\"variables-3.31\";i:4;s:12:\"filters-3.31\";i:5;s:14:\"ally-assistant\";i:6;s:12:\"classes-3.31\";i:7;s:24:\"send-notification-august\";i:8;s:15:\"attributes-3.31\";i:9;s:12:\"classes-3.30\";i:10;s:19:\"cloud-websites-3.30\";i:11;s:12:\"youtube-3.30\";i:12;s:17:\"host-google-cloud\";i:13;s:20:\"cloud-templates-3.29\";i:14;s:14:\"migration-host\";i:15;s:17:\"ai-isolate-object\";i:16;s:17:\"hello-biz-contact\";i:17;s:22:\"ai-site-planner-colors\";i:18;s:17:\"ally-notification\";i:19;s:15:\"ai-site-planner\";i:20;s:20:\"image-optimizer-3.19\";i:21;s:20:\"5-star-rating-prompt\";i:22;s:23:\"site-mailer-introducing\";}", "off");
INSERT INTO `wp_abz7_options` VALUES("74840", "hello_elementor_settings_description_meta_tag", "true", "auto");
INSERT INTO `wp_abz7_options` VALUES("74841", "hello_elementor_settings_skip_link", "false", "auto");
INSERT INTO `wp_abz7_options` VALUES("74842", "hello_elementor_settings_header_footer", "false", "auto");
INSERT INTO `wp_abz7_options` VALUES("74843", "hello_elementor_settings_page_title", "false", "auto");
INSERT INTO `wp_abz7_options` VALUES("74844", "hello_elementor_settings_hello_style", "false", "auto");
INSERT INTO `wp_abz7_options` VALUES("74845", "hello_elementor_settings_hello_theme", "false", "auto");
INSERT INTO `wp_abz7_options` VALUES("189", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_abz7_options` VALUES("74747", "_transient_timeout_elementor_remote_info_api_data_3.28.3", "1759868802", "off");
INSERT INTO `wp_abz7_options` VALUES("74748", "_transient_elementor_remote_info_api_data_3.28.3", "a:4:{s:9:\"timestamp\";s:10:\"1759824164\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:82:{i:0;a:4:{s:4:\"name\";s:6:\"search\";s:5:\"title\";s:6:\"Search\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-2\";s:5:\"title\";s:7:\"Classic\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:4;a:4:{s:4:\"name\";s:9:\"mega-menu\";s:5:\"title\";s:4:\"Menu\";s:4:\"icon\";s:15:\"eicon-mega-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:5;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-3\";s:5:\"title\";s:8:\"Showcase\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:6;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-4\";s:5:\"title\";s:5:\"Links\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:8;a:4:{s:4:\"name\";s:9:\"loop-grid\";s:5:\"title\";s:9:\"Loop Grid\";s:4:\"icon\";s:18:\"eicon-loop-builder\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:9;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-5\";s:5:\"title\";s:8:\"Services\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:10;a:4:{s:4:\"name\";s:13:\"loop-carousel\";s:5:\"title\";s:13:\"Loop Carousel\";s:4:\"icon\";s:19:\"eicon-carousel-loop\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:11;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-6\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:12;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-7\";s:5:\"title\";s:13:\"Business Card\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:14;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:16;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:19;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:20;a:4:{s:4:\"name\";s:15:\"nested-carousel\";s:5:\"title\";s:8:\"Carousel\";s:4:\"icon\";s:21:\"eicon-nested-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:21;a:4:{s:4:\"name\";s:10:\"off-canvas\";s:5:\"title\";s:10:\"Off-Canvas\";s:4:\"icon\";s:16:\"eicon-off-canvas\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:23;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:24;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:25;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:27;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:28;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:29;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:30;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:31;a:4:{s:4:\"name\";s:13:\"stripe-button\";s:5:\"title\";s:13:\"Stripe Button\";s:4:\"icon\";s:19:\"eicon-stripe-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:32;a:4:{s:4:\"name\";s:16:\"progress-tracker\";s:5:\"title\";s:16:\"Progress Tracker\";s:4:\"icon\";s:22:\"eicon-progress-tracker\";s:10:\"categories\";s:40:\"[\"pro-elements\",\"theme-elements-single\"]\";}i:33;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:34;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:35;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:36;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:37;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:38;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:39;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:40;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:41;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:42;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:43;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:44;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:45;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:46;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:47;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:48;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:49;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:50;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:51;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:58;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:59;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:60;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:61;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:62;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:63;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:64;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:65;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:66;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:67;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:68;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:69;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:70;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:71;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:72;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:73;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:74;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:75;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:76;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:77;a:4:{s:4:\"name\";s:25:\"woocommerce-checkout-page\";s:5:\"title\";s:8:\"Checkout\";s:4:\"icon\";s:14:\"eicon-checkout\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:78;a:4:{s:4:\"name\";s:16:\"woocommerce-cart\";s:5:\"title\";s:4:\"Cart\";s:4:\"icon\";s:14:\"eicon-woo-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:79;a:4:{s:4:\"name\";s:22:\"woocommerce-my-account\";s:5:\"title\";s:10:\"My Account\";s:4:\"icon\";s:16:\"eicon-my-account\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:80;a:4:{s:4:\"name\";s:28:\"woocommerce-purchase-summary\";s:5:\"title\";s:16:\"Purchase Summary\";s:4:\"icon\";s:22:\"eicon-purchase-summary\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:81;a:4:{s:4:\"name\";s:19:\"woocommerce-notices\";s:5:\"title\";s:19:\"WooCommerce Notices\";s:4:\"icon\";s:25:\"eicon-woocommerce-notices\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:0:{}}}", "off");
INSERT INTO `wp_abz7_options` VALUES("192", "elementor_pro_version", "3.32.2", "yes");
INSERT INTO `wp_abz7_options` VALUES("193", "widget_elementor-library", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("194", "_elementor_pro_installed_time", "1678792873", "yes");
INSERT INTO `wp_abz7_options` VALUES("195", "elementor_notes_db_version", "5", "yes");
INSERT INTO `wp_abz7_options` VALUES("196", "elementor_submissions_db_version", "5", "yes");
INSERT INTO `wp_abz7_options` VALUES("199", "jet_is_modify_tm_license_data", "true", "yes");
INSERT INTO `wp_abz7_options` VALUES("200", "_elementor_settings_update_time", "1678792905", "yes");
INSERT INTO `wp_abz7_options` VALUES("201", "elementor_cpt_support", "a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("202", "elementor_disable_color_schemes", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("203", "elementor_disable_typography_schemes", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("204", "elementor_google_maps_api_key", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("205", "elementor_pro_recaptcha_site_key", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("206", "elementor_pro_recaptcha_secret_key", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("207", "elementor_pro_recaptcha_v3_site_key", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("208", "elementor_pro_recaptcha_v3_secret_key", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("209", "elementor_pro_recaptcha_v3_threshold", "0.5", "yes");
INSERT INTO `wp_abz7_options` VALUES("210", "elementor_pro_facebook_app_id", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("211", "elementor_pro_mailchimp_api_key", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("212", "elementor_validate_api_data", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("213", "elementor_pro_drip_api_token", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("214", "elementor_pro_activecampaign_api_key", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("215", "elementor_pro_activecampaign_api_url", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("216", "elementor_pro_getresponse_api_key", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("217", "elementor_pro_convertkit_api_key", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("218", "elementor_pro_mailerlite_api_key", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("219", "elementor_typekit-kit-id", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("220", "elementor_font_awesome_pro_kit_id", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("221", "elementor_pro_stripe_test_secret_key", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("222", "elementor_validate_stripe_api_test_secret_key_button", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("223", "elementor_pro_stripe_live_secret_key", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("224", "elementor_validate_stripe_api_live_secret_key_button", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("225", "elementor_stripe_legal_disclaimer", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("226", "elementor_css_print_method", "external", "yes");
INSERT INTO `wp_abz7_options` VALUES("227", "elementor_editor_break_lines", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("228", "elementor_unfiltered_files_upload", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("229", "elementor_google_font", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("230", "elementor_load_fa4_shim", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("231", "elementor_meta_generator_tag", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("232", "elementor_experiment-e_font_icon_svg", "default", "yes");
INSERT INTO `wp_abz7_options` VALUES("233", "elementor_experiment-container", "active", "yes");
INSERT INTO `wp_abz7_options` VALUES("234", "elementor_experiment-e_swiper_latest", "default", "yes");
INSERT INTO `wp_abz7_options` VALUES("235", "elementor_experiment-nested-elements", "default", "yes");
INSERT INTO `wp_abz7_options` VALUES("242", "elementor_experiment-a11y_improvements", "default", "yes");
INSERT INTO `wp_abz7_options` VALUES("243", "elementor_experiment-additional_custom_breakpoints", "default", "yes");
INSERT INTO `wp_abz7_options` VALUES("244", "elementor_experiment-theme_builder_v2", "default", "yes");
INSERT INTO `wp_abz7_options` VALUES("245", "elementor_experiment-hello-theme-header-footer", "default", "yes");
INSERT INTO `wp_abz7_options` VALUES("246", "elementor_experiment-landing-pages", "default", "yes");
INSERT INTO `wp_abz7_options` VALUES("247", "elementor_experiment-kit-elements-defaults", "default", "yes");
INSERT INTO `wp_abz7_options` VALUES("2159", "elementor_pro_tracker_notice", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("2160", "elementor_tracker_notice", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("2262", "jet_engine_meta_boxes", "a:1:{s:6:\"meta-1\";a:3:{s:4:\"args\";a:7:{s:11:\"object_type\";s:4:\"post\";s:11:\"allowed_tax\";a:0:{}s:17:\"allowed_post_type\";a:1:{i:0;s:7:\"service\";}s:13:\"allowed_posts\";a:0:{}s:14:\"excluded_posts\";a:0:{}s:17:\"active_conditions\";a:0:{}s:4:\"name\";s:25:\"فیلدهای خدمات\";}s:11:\"meta_fields\";a:1:{i:0;a:8:{s:5:\"title\";s:23:\"تصاویر گالری\";s:4:\"name\";s:15:\"service-gallery\";s:11:\"object_type\";s:5:\"field\";s:5:\"width\";s:4:\"100%\";s:7:\"options\";a:0:{}s:4:\"type\";s:7:\"gallery\";s:2:\"id\";i:4162;s:8:\"isNested\";b:0;}}s:2:\"id\";s:6:\"meta-1\";}}", "yes");
INSERT INTO `wp_abz7_options` VALUES("260", "elementor_custom_icon_sets_config", "a:0:{}", "yes");
INSERT INTO `wp_abz7_options` VALUES("265", "elementor_scheme_color", "a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("266", "elementor_scheme_typography", "a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}", "yes");
INSERT INTO `wp_abz7_options` VALUES("267", "elementor_scheme_color-picker", "a:8:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("269", "elementor_log", "a:43:{s:32:\"bbbffdc8e466721ce8434489721b62ee\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-05-30 10:29:01\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-30 10:29:01\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"87eda2287740a3238aab9c0e5e411b4e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2023-05-30 10:29:01\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.12.1\";s:2:\"to\";s:6:\"3.13.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-30 10:29:01\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.12.1\";s:2:\"to\";s:6:\"3.13.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"195d696cb4fbf46d88fb5f763a371b48\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"19952\";s:7:\"\0*\0file\";s:114:\"https://presite.ir/doctor/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:7:\"\0*\0date\";s:19:\"2023-05-30 08:19:44\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view4965&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-30 08:19:44\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1685434784\";s:7:\"message\";s:69:\"View (cid: \"view4965\") has already been destroyed and cannot be used.\";s:3:\"url\";s:114:\"https://presite.ir/doctor/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}}s:32:\"8bd74455e26359a42048c55fef5732b4\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"19952\";s:7:\"\0*\0file\";s:114:\"https://presite.ir/doctor/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:7:\"\0*\0date\";s:19:\"2023-05-30 08:19:50\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view7415&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-30 08:19:50\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1685434790\";s:7:\"message\";s:69:\"View (cid: \"view7415\") has already been destroyed and cannot be used.\";s:3:\"url\";s:114:\"https://presite.ir/doctor/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}}s:32:\"a75a490a4269733da5114045e3e3e0e9\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"19952\";s:7:\"\0*\0file\";s:114:\"https://presite.ir/doctor/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:7:\"\0*\0date\";s:19:\"2023-05-30 08:28:39\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:80:\"View (cid: &quot;view18655&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-30 08:28:39\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1685435319\";s:7:\"message\";s:70:\"View (cid: \"view18655\") has already been destroyed and cannot be used.\";s:3:\"url\";s:114:\"https://presite.ir/doctor/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}}s:32:\"124dbea16d0e902471384981a945ec6b\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"19952\";s:7:\"\0*\0file\";s:114:\"https://presite.ir/doctor/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:7:\"\0*\0date\";s:19:\"2023-05-30 08:48:56\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:79:\"View (cid: &quot;view9212&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-30 08:48:56\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1685436536\";s:7:\"message\";s:69:\"View (cid: \"view9212\") has already been destroyed and cannot be used.\";s:3:\"url\";s:114:\"https://presite.ir/doctor/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}}s:32:\"2cc3fadf832176ee6086ee0cb2692535\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:117:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/plugins/elementor/core/common/modules/ajax/module.php\";s:7:\"\0*\0line\";i:175;s:7:\"\0*\0date\";s:19:\"2023-05-30 14:26:37\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:21:\"Undefined index: data\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-30 14:26:37\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:21:\"Undefined index: data\";s:4:\"file\";s:117:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/plugins/elementor/core/common/modules/ajax/module.php\";s:4:\"line\";i:175;s:5:\"trace\";b:1;}}s:32:\"ece867867f24a200ff1698b3eef30def\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"19952\";s:7:\"\0*\0file\";s:114:\"https://presite.ir/doctor/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:7:\"\0*\0line\";s:2:\"24\";s:7:\"\0*\0date\";s:19:\"2023-05-31 07:46:00\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:80:\"View (cid: &quot;view33257&quot;) has already been destroyed and cannot be used.\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2023-05-31 07:46:00\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1685519160\";s:7:\"message\";s:70:\"View (cid: \"view33257\") has already been destroyed and cannot be used.\";s:3:\"url\";s:114:\"https://presite.ir/doctor/wp-content/plugins/elementor/assets/lib/backbone/backbone.marionette.min.js?ver=2.4.5.e1\";s:4:\"line\";s:2:\"24\";s:6:\"column\";s:5:\"19952\";}}s:32:\"c3c4be3b1be2a43a0c2a2706f3dbea8c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 12:55:55\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.13.4\";s:2:\"to\";s:6:\"3.28.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 12:55:55\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.13.4\";s:2:\"to\";s:6:\"3.28.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"6c0a5a71b306eff0c2d48600b7951af0\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 12:55:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 12:55:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"c9b6184cbcd292d69d57a184f413c5cd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 12:55:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 12:55:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"1126c892b96942cf489f77c2576456ea\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 12:55:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 12:55:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"1aec55b82443b89ac20b80aafe31df1e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 12:55:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:60:\"المنتور/Upgrades - _v_3_16_0_container_updates Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 12:55:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:60:\"المنتور/Upgrades - _v_3_16_0_container_updates Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"ebcdc1bbc30ddc25b238f2bdc329239d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 12:55:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:62:\"المنتور/Upgrades - _v_3_16_0_container_updates Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 12:55:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:62:\"المنتور/Upgrades - _v_3_16_0_container_updates Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"13df4f1cbdfa8a71cbc2f98098c38d0c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 12:55:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:64:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 12:55:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:64:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"51aa5938de6372ced0f7b5cd05ff583d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 12:55:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:66:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 12:55:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:66:\"المنتور/Upgrades - _v_3_17_0_site_settings_updates Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"2ce08482c9203959780254ad54f5ee53\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 12:55:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:42:\"المنتور/Upgrades - _v_3_26_0 Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 12:55:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:42:\"المنتور/Upgrades - _v_3_26_0 Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"a695c262267cf4710e34d21ae706dd6a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 12:55:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"المنتور/Upgrades - _v_3_26_0 Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 12:55:56\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"المنتور/Upgrades - _v_3_26_0 Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"2b9599b45dbbef9c4251df94cc8a6648\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 12:55:56\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.13.4\";s:2:\"to\";s:6:\"3.28.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 12:55:56\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.13.4\";s:2:\"to\";s:6:\"3.28.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"c64a57b995da78722bea4371d69538c7\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:129:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/plugins/elementor-pro/modules/theme-builder/widgets/site-logo.php\";s:7:\"\0*\0line\";i:194;s:7:\"\0*\0date\";s:19:\"2025-04-12 12:57:46\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:24:\"Undefined index: options\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 12:57:46\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:24:\"Undefined index: options\";s:4:\"file\";s:129:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/plugins/elementor-pro/modules/theme-builder/widgets/site-logo.php\";s:4:\"line\";i:194;s:5:\"trace\";b:1;}}s:32:\"27da588327f47018015b18f10aff3036\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 13:04:53\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.13.1\";s:2:\"to\";s:6:\"3.27.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 13:04:53\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.13.1\";s:2:\"to\";s:6:\"3.27.6\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"6961a5c519e8847fd422941b1258ece9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 13:05:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 13:05:11\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"eabd172bed36e48dd36f0d5c344dd77d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 13:05:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 13:05:11\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"85a42a6e0eb757ce7ff17b5604f4c81e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 13:05:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 13:05:11\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"a2b6ec9cddbc7b97d41cc9a431da7923\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 13:05:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.13.1\";s:2:\"to\";s:6:\"3.27.6\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 13:05:11\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.13.1\";s:2:\"to\";s:6:\"3.27.6\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"a164e76fbc794969e6ca666bb861db22\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 13:11:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 13:11:17\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"178273b32c38676ae7c7186a7c9c419d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 13:11:18\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 13:11:18\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"f83879195e6123000f0746ffb144b06c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 13:11:18\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 13:11:18\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"f08bf490109180743a5b209d04a0ee8e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 13:11:18\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 13:11:18\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"69781ae414ac512e77cc196c2ea0f149\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-12 13:11:18\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-12 13:11:18\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"edd4a959ec7eb5728d478c75fce23b6d\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:105:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/plugins/elementor/includes/conditions.php\";s:7:\"\0*\0line\";i:87;s:7:\"\0*\0date\";s:19:\"2025-04-16 07:29:02\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:32:\"Undefined index: checkout_layout\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:21;s:14:\"\0*\0times_dates\";a:21:{i:0;s:19:\"2025-04-16 07:29:02\";i:1;s:19:\"2025-04-17 19:50:05\";i:2;s:19:\"2025-04-21 21:11:14\";i:3;s:19:\"2025-05-03 23:36:47\";i:4;s:19:\"2025-05-07 20:14:58\";i:5;s:19:\"2025-05-12 10:29:07\";i:6;s:19:\"2025-06-04 15:39:49\";i:7;s:19:\"2025-06-10 20:44:28\";i:8;s:19:\"2025-06-29 14:25:48\";i:9;s:19:\"2025-06-30 20:26:06\";i:10;s:19:\"2025-07-05 16:59:45\";i:11;s:19:\"2025-07-09 10:24:31\";i:12;s:19:\"2025-07-11 13:25:57\";i:13;s:19:\"2025-07-11 13:26:16\";i:14;s:19:\"2025-07-24 12:13:54\";i:15;s:19:\"2025-07-28 13:34:11\";i:16;s:19:\"2025-08-21 01:40:06\";i:17;s:19:\"2025-08-30 07:12:10\";i:18;s:19:\"2025-09-15 14:11:40\";i:19;s:19:\"2025-10-02 16:52:52\";i:20;s:19:\"2025-10-04 20:12:45\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:32:\"Undefined index: checkout_layout\";s:4:\"file\";s:105:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/plugins/elementor/includes/conditions.php\";s:4:\"line\";i:87;s:5:\"trace\";b:1;}}s:32:\"cb0fd769913fb5109b770fee373aa6bb\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 11:57:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.32.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 11:57:16\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.32.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"b9a992bd89d4aeb6d6442f90a03b94e9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 11:57:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 11:57:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"7a43c4f9270b2012527b3b96352e1e0e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 11:57:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 11:57:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"8ef6b7fbdd82f2be0f66c746a568cdac\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 11:57:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 11:57:16\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"ef34761cddf8511341de04e680884698\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 11:57:16\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.32.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 11:57:16\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.32.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"352f78e854a52b7d3cfd87bff05f21bf\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 12:29:42\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.28.2\";s:2:\"to\";s:6:\"3.32.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 12:29:42\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.28.2\";s:2:\"to\";s:6:\"3.32.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"5c2984f12e4a5a1f913aa6ad68fa5fdc\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 12:29:43\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 12:29:43\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"2362e370aff1253c8bca039b06b0dd7b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 12:29:43\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 12:29:43\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:56:\"المنتور پرو/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"aa6d2fc24a043e25eb41de81cc7dae76\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 12:29:43\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 12:29:43\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:58:\"المنتور پرو/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"1d948dbc273ad3822240f4d6cfed8de4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 12:29:43\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:78:\"المنتور پرو/Upgrades - _v_3_30_0_post_navigation_inline_icons Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 12:29:43\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:78:\"المنتور پرو/Upgrades - _v_3_30_0_post_navigation_inline_icons Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"b4d0817200ffeb2c3c6d365c28553695\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 12:29:43\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:80:\"المنتور پرو/Upgrades - _v_3_30_0_post_navigation_inline_icons Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 12:29:43\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:80:\"المنتور پرو/Upgrades - _v_3_30_0_post_navigation_inline_icons Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"396d6086223d03c091590d0edaaf6ca3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-07 12:29:43\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.28.2\";s:2:\"to\";s:6:\"3.32.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-07 12:29:43\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:21:\"المنتور پرو\";s:4:\"from\";s:6:\"3.28.2\";s:2:\"to\";s:6:\"3.32.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `wp_abz7_options` VALUES("74805", "_transient_timeout_elementor_remote_info_api_data_3.32.4", "1759869194", "off");
INSERT INTO `wp_abz7_options` VALUES("74806", "_transient_elementor_remote_info_api_data_3.32.4", "a:4:{s:9:\"timestamp\";s:10:\"1759823773\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:82:{i:0;a:4:{s:4:\"name\";s:6:\"search\";s:5:\"title\";s:6:\"Search\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-2\";s:5:\"title\";s:7:\"Classic\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:4;a:4:{s:4:\"name\";s:9:\"mega-menu\";s:5:\"title\";s:4:\"Menu\";s:4:\"icon\";s:15:\"eicon-mega-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:5;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-3\";s:5:\"title\";s:8:\"Showcase\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:6;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-4\";s:5:\"title\";s:5:\"Links\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:8;a:4:{s:4:\"name\";s:9:\"loop-grid\";s:5:\"title\";s:9:\"Loop Grid\";s:4:\"icon\";s:18:\"eicon-loop-builder\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:9;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-5\";s:5:\"title\";s:8:\"Services\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:10;a:4:{s:4:\"name\";s:13:\"loop-carousel\";s:5:\"title\";s:13:\"Loop Carousel\";s:4:\"icon\";s:19:\"eicon-carousel-loop\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:11;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-6\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:12;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-7\";s:5:\"title\";s:13:\"Business Card\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:14;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:16;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:19;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:20;a:4:{s:4:\"name\";s:15:\"nested-carousel\";s:5:\"title\";s:8:\"Carousel\";s:4:\"icon\";s:21:\"eicon-nested-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:21;a:4:{s:4:\"name\";s:10:\"off-canvas\";s:5:\"title\";s:10:\"Off-Canvas\";s:4:\"icon\";s:16:\"eicon-off-canvas\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:23;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:24;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:25;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:27;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:28;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:29;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:30;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:31;a:4:{s:4:\"name\";s:13:\"stripe-button\";s:5:\"title\";s:13:\"Stripe Button\";s:4:\"icon\";s:19:\"eicon-stripe-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:32;a:4:{s:4:\"name\";s:16:\"progress-tracker\";s:5:\"title\";s:16:\"Progress Tracker\";s:4:\"icon\";s:22:\"eicon-progress-tracker\";s:10:\"categories\";s:40:\"[\"pro-elements\",\"theme-elements-single\"]\";}i:33;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:34;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:35;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:36;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:37;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:38;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:39;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:40;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:41;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:42;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:43;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:44;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:45;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:46;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:47;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:48;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:49;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:50;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:51;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:58;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:59;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:60;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:61;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:62;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:63;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:64;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:65;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:66;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:67;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:68;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:69;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:70;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:71;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:72;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:73;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:74;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:75;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:76;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:77;a:4:{s:4:\"name\";s:25:\"woocommerce-checkout-page\";s:5:\"title\";s:8:\"Checkout\";s:4:\"icon\";s:14:\"eicon-checkout\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:78;a:4:{s:4:\"name\";s:16:\"woocommerce-cart\";s:5:\"title\";s:4:\"Cart\";s:4:\"icon\";s:14:\"eicon-woo-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:79;a:4:{s:4:\"name\";s:22:\"woocommerce-my-account\";s:5:\"title\";s:10:\"My Account\";s:4:\"icon\";s:16:\"eicon-my-account\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:80;a:4:{s:4:\"name\";s:28:\"woocommerce-purchase-summary\";s:5:\"title\";s:16:\"Purchase Summary\";s:4:\"icon\";s:22:\"eicon-purchase-summary\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:81;a:4:{s:4:\"name\";s:19:\"woocommerce-notices\";s:5:\"title\";s:19:\"WooCommerce Notices\";s:4:\"icon\";s:25:\"eicon-woocommerce-notices\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:0:{}}}", "off");
INSERT INTO `wp_abz7_options` VALUES("61932", "elementor_checklist", "{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header_pro\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}", "auto");
INSERT INTO `wp_abz7_options` VALUES("61953", "woocommerce_share_key", "VYLyTD66Cdlmb39gsYzUrE1TvaxNaYKJ", "auto");
INSERT INTO `wp_abz7_options` VALUES("5088", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `wp_abz7_options` VALUES("270", "new_admin_email", "info@abzarwp-plugins.ir", "yes");
INSERT INTO `wp_abz7_options` VALUES("295", "_elementor_pro_api_requests_lock", "a:1:{s:11:\"get_version\";i:1759827639;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("4679", "woocommerce_task_list_reminder_bar_hidden", "yes", "yes");
INSERT INTO `wp_abz7_options` VALUES("4694", "woocommerce_admin_last_orders_milestone", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("3806", "payamito_core_version", "s:238:\"a:3:{s:7:\"version\";s:5:\"2.2.0\";s:13:\"absolute_path\";s:37:\"payamito-sms-jet-engine/bootstrap.php\";s:9:\"core_path\";s:115:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/plugins/payamito-sms-jet-engine/core/payamito-core/\";}\";", "yes");
INSERT INTO `wp_abz7_options` VALUES("3807", "payamito_jet_col_pjet_formid", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("3808", "payamito_jet_col_pjet_phone", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("3809", "payamito", "a:16:{s:8:\"username\";s:0:\"\";s:8:\"password\";s:0:\"\";s:14:\"Exclusive_line\";s:0:\"\";s:15:\"SMS_line_number\";s:0:\"\";s:30:\"payamito_direct_mobile_numbers\";s:0:\"\";s:30:\"payamito_direct_send_separator\";s:0:\"\";s:35:\"payamito_direct_send_active_pattern\";s:0:\"\";s:31:\"payamito_direct_send_pattern_id\";s:0:\"\";s:29:\"payamito_direct_send_repeater\";s:0:\"\";s:23:\"payamito_direct_message\";s:0:\"\";s:29:\"payamito_direct_sender_number\";s:0:\"\";s:10:\"log_active\";s:0:\"\";s:14:\"log_recurrence\";s:0:\"\";s:9:\"log_order\";s:0:\"\";s:16:\"log_logic_active\";s:0:\"\";s:9:\"log_logic\";s:0:\"\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3811", "external_updates-payamito-sms-jet-engine", "O:8:\"stdClass\":2:{s:9:\"lastCheck\";i:1759825600;s:14:\"checkedVersion\";s:5:\"1.2.0\";}", "off");
INSERT INTO `wp_abz7_options` VALUES("3462", "site_logo", "2750", "yes");
INSERT INTO `wp_abz7_options` VALUES("3475", "jet_booking_meta_table_recreated", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("3476", "jet-appointments-booking-db-version", "1.5.0", "yes");
INSERT INTO `wp_abz7_options` VALUES("1064", "jet_engine_modules", "a:3:{i:0;s:20:\"custom-content-types\";i:1;s:18:\"dynamic-visibility\";i:2;s:13:\"booking-forms\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("1182", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_abz7_options` VALUES("1217", "elementor_library_category_children", "a:0:{}", "yes");
INSERT INTO `wp_abz7_options` VALUES("1726", "elementor_fonts_manager_font_types", "a:2:{s:19:\"YekanBakhBold_FaNum\";s:6:\"custom\";s:15:\"YekanBakh_FaNum\";s:6:\"custom\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("1727", "elementor_fonts_manager_fonts", "a:2:{s:19:\"YekanBakhBold_FaNum\";a:2:{s:9:\"font_face\";s:328:\"@font-face {\n	font-family: \'YekanBakhBold_FaNum\';\n	font-style: normal;\n	font-weight: normal;\n	font-display: auto;\n	src: url(\'https://presite.ir/doctor/wp-content/uploads/2023/03/YekanBakhFaNum-Bold.woff2\') format(\'woff2\'),\n		url(\'https://presite.ir/doctor/wp-content/uploads/2023/03/YekanBakhFaNum-Bold.woff\') format(\'woff\');\n}\n\";s:7:\"post_id\";i:1163;}s:15:\"YekanBakh_FaNum\";a:2:{s:9:\"font_face\";s:330:\"@font-face {\n	font-family: \'YekanBakh_FaNum\';\n	font-style: normal;\n	font-weight: normal;\n	font-display: auto;\n	src: url(\'https://presite.ir/doctor/wp-content/uploads/2023/03/YekanBakhFaNum-Regular.woff2\') format(\'woff2\'),\n		url(\'https://presite.ir/doctor/wp-content/uploads/2023/03/YekanBakhFaNum-Regular.woff\') format(\'woff\');\n}\n\";s:7:\"post_id\";i:12;}}", "yes");
INSERT INTO `wp_abz7_options` VALUES("4955", "elementor_maintenance_mode_exclude_mode", "logged_in", "yes");
INSERT INTO `wp_abz7_options` VALUES("4952", "elementor_re_migrate_globals", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("4953", "elementor_beta", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("4954", "elementor_maintenance_mode_mode", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("4956", "elementor_maintenance_mode_exclude_roles", "a:0:{}", "yes");
INSERT INTO `wp_abz7_options` VALUES("4957", "elementor_maintenance_mode_template_id", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("4931", "elementor_use_mini_cart_template", "yes", "yes");
INSERT INTO `wp_abz7_options` VALUES("4943", "elementor_clear_cache", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("4944", "elementor_reset_api_data", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("4946", "elementor_enable_inspector", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("4947", "elementor_replace_url", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("4948", "elementor_rollback", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("4949", "elementor_rollback_pro_separator", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("4950", "elementor_rollback_pro", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("4951", "elementor_re_migrate_globals_separator", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("3634", "jet-apb-settings", "a:45:{s:16:\"slot_time_format\";s:3:\"H:i\";s:13:\"buffer_before\";i:600;s:12:\"buffer_after\";i:600;s:12:\"default_slot\";i:1800;s:11:\"locked_time\";i:1200;s:12:\"booking_type\";s:4:\"slot\";s:12:\"max_duration\";s:4:\"3600\";s:13:\"step_duration\";s:3:\"300\";s:12:\"several_days\";b:0;s:10:\"only_start\";b:1;s:13:\"multi_booking\";b:0;s:14:\"min_slot_count\";i:1;s:14:\"max_slot_count\";i:1;s:19:\"min_recurring_count\";s:1:\"1\";s:19:\"max_recurring_count\";s:1:\"5\";s:8:\"days_off\";a:0:{}s:12:\"working_days\";a:0:{}s:17:\"working_days_mode\";s:13:\"override_full\";s:10:\"re_booking\";a:0:{}s:18:\"appointments_range\";a:3:{s:4:\"type\";s:3:\"all\";s:9:\"range_num\";s:2:\"60\";s:10:\"range_unit\";s:4:\"days\";}s:13:\"working_hours\";a:6:{s:6:\"monday\";a:1:{i:0;a:2:{s:4:\"from\";s:5:\"08:00\";s:2:\"to\";s:5:\"17:00\";}}s:7:\"tuesday\";a:1:{i:0;a:2:{s:4:\"from\";s:5:\"09:00\";s:2:\"to\";s:5:\"17:00\";}}s:9:\"wednesday\";a:1:{i:0;a:2:{s:4:\"from\";s:5:\"08:00\";s:2:\"to\";s:5:\"15:00\";}}s:8:\"thursday\";a:1:{i:0;a:2:{s:4:\"from\";s:5:\"08:00\";s:2:\"to\";s:5:\"15:00\";}}s:8:\"saturday\";a:1:{i:0;a:2:{s:4:\"from\";s:5:\"09:00\";s:2:\"to\";s:5:\"20:00\";}}s:6:\"sunday\";a:1:{i:0;a:2:{s:4:\"from\";s:5:\"07:00\";s:2:\"to\";s:5:\"13:00\";}}}s:6:\"is_set\";b:1;s:12:\"services_cpt\";s:7:\"service\";s:13:\"providers_cpt\";s:0:\"\";s:10:\"db_columns\";a:1:{i:0;s:20:\"patient_phone_number\";}s:14:\"wc_integration\";b:1;s:13:\"wc_product_id\";i:3165;s:15:\"wc_synch_orders\";b:1;s:10:\"hide_setup\";b:0;s:8:\"check_by\";s:6:\"global\";s:15:\"manage_capacity\";b:0;s:21:\"show_capacity_counter\";b:0;s:17:\"use_custom_labels\";b:0;s:15:\"process_on_hold\";s:7:\"invalid\";s:13:\"switch_status\";b:0;s:14:\"show_timezones\";b:0;s:18:\"allow_action_links\";s:5:\"false\";s:22:\"confirm_action_message\";s:0:\"\";s:21:\"cancel_action_message\";s:0:\"\";s:20:\"switch_status_period\";s:6:\"hourly\";s:18:\"switch_status_from\";a:1:{i:0;s:7:\"on-hold\";}s:16:\"switch_status_to\";s:6:\"failed\";s:15:\"calendar_layout\";s:7:\"default\";s:17:\"scroll_to_details\";b:0;s:13:\"custom_labels\";a:19:{s:3:\"Sun\";s:3:\"Sun\";s:3:\"Mon\";s:3:\"Mon\";s:3:\"Tue\";s:3:\"Tue\";s:3:\"Wed\";s:3:\"Wed\";s:3:\"Thu\";s:3:\"Thu\";s:3:\"Fri\";s:3:\"Fri\";s:3:\"Sat\";s:3:\"Sat\";s:7:\"January\";s:7:\"January\";s:8:\"February\";s:8:\"February\";s:5:\"March\";s:5:\"March\";s:5:\"April\";s:5:\"April\";s:3:\"May\";s:3:\"May\";s:4:\"June\";s:4:\"June\";s:4:\"July\";s:4:\"July\";s:6:\"August\";s:6:\"August\";s:9:\"September\";s:9:\"September\";s:7:\"October\";s:7:\"October\";s:8:\"November\";s:8:\"November\";s:8:\"December\";s:8:\"December\";}}", "no");
INSERT INTO `wp_abz7_options` VALUES("5081", "duplicator_version_plugin", "1.5.13.3", "yes");
INSERT INTO `wp_abz7_options` VALUES("5082", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("5083", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("4586", "jet-smart-filters-settings", "a:13:{s:19:\"avaliable_providers\";a:11:{s:48:\"Jet_Smart_Filters_Provider_EPro_Archive_Products\";s:5:\"false\";s:39:\"Jet_Smart_Filters_Provider_EPro_Archive\";s:5:\"false\";s:41:\"Jet_Smart_Filters_Provider_EPro_Portfolio\";s:5:\"false\";s:37:\"Jet_Smart_Filters_Provider_EPro_Posts\";s:5:\"false\";s:40:\"Jet_Smart_Filters_Provider_EPro_Products\";s:5:\"false\";s:46:\"Jet_Smart_Filters_Provider_Jet_Engine_Calendar\";s:5:\"false\";s:37:\"Jet_Smart_Filters_Provider_Jet_Engine\";s:4:\"true\";s:39:\"Jet_Smart_Filters_Provider_Jet_Woo_Grid\";s:5:\"false\";s:39:\"Jet_Smart_Filters_Provider_Jet_Woo_List\";s:5:\"false\";s:46:\"Jet_Smart_Filters_Provider_WooCommerce_Archive\";s:5:\"false\";s:48:\"Jet_Smart_Filters_Provider_WooCommerce_Shortcode\";s:5:\"false\";}s:19:\"use_indexed_filters\";s:5:\"false\";s:20:\"avaliable_post_types\";a:5:{s:4:\"post\";s:5:\"false\";s:4:\"page\";s:5:\"false\";s:7:\"product\";s:5:\"false\";s:7:\"service\";s:5:\"false\";s:5:\"users\";s:5:\"false\";}s:17:\"use_auto_indexing\";s:5:\"false\";s:18:\"url_structure_type\";s:5:\"plain\";s:21:\"rewritable_post_types\";a:4:{s:4:\"post\";s:5:\"false\";s:14:\"e-landing-page\";s:5:\"false\";s:7:\"product\";s:5:\"false\";s:7:\"service\";s:5:\"false\";}s:15:\"use_url_aliases\";s:5:\"false\";s:11:\"url_aliases\";a:1:{i:0;a:2:{s:6:\"needle\";s:16:\"/jsf/jet-engine/\";s:11:\"replacement\";s:8:\"/filter/\";}}s:23:\"use_url_aliases_example\";s:5:\"false\";s:19:\"url_aliases_example\";s:68:\"/page/jsf/jet-engine/tax/category:1;post_tag:2/meta/meta-key:data-1/\";s:18:\"ajax_request_types\";s:7:\"default\";s:12:\"use_tabindex\";s:5:\"false\";s:14:\"tabindex_color\";s:7:\"#0085f2\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("4317", "woocommerce_maybe_regenerate_images_hash", "991b1ca641921cf0f5baf7a2fe85861b", "yes");
INSERT INTO `wp_abz7_options` VALUES("3847", "action_scheduler_hybrid_store_demarkation", "2418", "yes");
INSERT INTO `wp_abz7_options` VALUES("3848", "schema-ActionScheduler_StoreSchema", "8.0.1759825668", "yes");
INSERT INTO `wp_abz7_options` VALUES("3849", "schema-ActionScheduler_LoggerSchema", "3.0.1680240726", "yes");
INSERT INTO `wp_abz7_options` VALUES("3982", "woocommerce_admin_install_timestamp", "1680240727", "yes");
INSERT INTO `wp_abz7_options` VALUES("3852", "woocommerce_schema_version", "920", "yes");
INSERT INTO `wp_abz7_options` VALUES("3853", "woocommerce_store_address", "تهران", "yes");
INSERT INTO `wp_abz7_options` VALUES("3854", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("3855", "woocommerce_store_city", "تهران", "yes");
INSERT INTO `wp_abz7_options` VALUES("3856", "woocommerce_default_country", "IR:THR", "yes");
INSERT INTO `wp_abz7_options` VALUES("3857", "woocommerce_store_postcode", "12345", "yes");
INSERT INTO `wp_abz7_options` VALUES("3858", "woocommerce_allowed_countries", "specific", "yes");
INSERT INTO `wp_abz7_options` VALUES("3859", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3860", "woocommerce_specific_allowed_countries", "a:1:{i:0;s:2:\"IR\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3861", "woocommerce_ship_to_countries", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("3862", "woocommerce_specific_ship_to_countries", "a:0:{}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3863", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_abz7_options` VALUES("3864", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("3865", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_abz7_options` VALUES("3866", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_abz7_options` VALUES("3867", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_abz7_options` VALUES("3868", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `wp_abz7_options` VALUES("3869", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_abz7_options` VALUES("3870", "woocommerce_price_decimal_sep", ",", "yes");
INSERT INTO `wp_abz7_options` VALUES("3871", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `wp_abz7_options` VALUES("3872", "woocommerce_shop_page_id", "2421", "yes");
INSERT INTO `wp_abz7_options` VALUES("3873", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("3874", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_abz7_options` VALUES("3875", "woocommerce_placeholder_image", "2420", "yes");
INSERT INTO `wp_abz7_options` VALUES("3876", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_abz7_options` VALUES("3877", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_abz7_options` VALUES("3878", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_abz7_options` VALUES("3879", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_abz7_options` VALUES("3880", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_abz7_options` VALUES("3881", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_abz7_options` VALUES("3882", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_abz7_options` VALUES("3883", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_abz7_options` VALUES("3884", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_abz7_options` VALUES("3885", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_abz7_options` VALUES("3886", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_abz7_options` VALUES("3887", "woocommerce_stock_email_recipient", "info@abzarwp-plugins.ir", "no");
INSERT INTO `wp_abz7_options` VALUES("3888", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_abz7_options` VALUES("3889", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_abz7_options` VALUES("3890", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("3891", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("3892", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_abz7_options` VALUES("3893", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `wp_abz7_options` VALUES("3894", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_abz7_options` VALUES("3895", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_abz7_options` VALUES("3896", "woocommerce_downloads_deliver_inline", "", "no");
INSERT INTO `wp_abz7_options` VALUES("3897", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_abz7_options` VALUES("3899", "woocommerce_attribute_lookup_direct_updates", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("3900", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("3901", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_abz7_options` VALUES("3902", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_abz7_options` VALUES("3903", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("3904", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("3905", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_abz7_options` VALUES("3906", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_abz7_options` VALUES("3907", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("3908", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_abz7_options` VALUES("3909", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_abz7_options` VALUES("3910", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("3911", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_abz7_options` VALUES("3912", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("3913", "woocommerce_enable_guest_checkout", "no", "no");
INSERT INTO `wp_abz7_options` VALUES("3914", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `wp_abz7_options` VALUES("3915", "woocommerce_enable_signup_and_login_from_checkout", "yes", "no");
INSERT INTO `wp_abz7_options` VALUES("3916", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `wp_abz7_options` VALUES("3917", "woocommerce_registration_generate_username", "no", "no");
INSERT INTO `wp_abz7_options` VALUES("3918", "woocommerce_registration_generate_password", "no", "no");
INSERT INTO `wp_abz7_options` VALUES("3919", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_abz7_options` VALUES("3920", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_abz7_options` VALUES("3921", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_abz7_options` VALUES("3922", "woocommerce_registration_privacy_policy_text", "داده های شخصی شما برای پشتیبانی از تجربه شما در سراسر این وب سایت، برای مدیریت دسترسی به حساب شما، و برای اهداف دیگری که در [privacy_policy] ما توضیح داده شده است، استفاده خواهد شد.", "yes");
INSERT INTO `wp_abz7_options` VALUES("3923", "woocommerce_checkout_privacy_policy_text", "داده های شخصی شما برای پشتیبانی از تجربه شما در سراسر این وب سایت، برای مدیریت دسترسی به حساب شما، و برای اهداف دیگری که در [privacy_policy] ما توضیح داده شده است، استفاده خواهد شد.", "yes");
INSERT INTO `wp_abz7_options` VALUES("3924", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_abz7_options` VALUES("3925", "woocommerce_trash_pending_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_abz7_options` VALUES("3926", "woocommerce_trash_failed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_abz7_options` VALUES("3927", "woocommerce_trash_cancelled_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:4:\"days\";}", "no");
INSERT INTO `wp_abz7_options` VALUES("3928", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_abz7_options` VALUES("3929", "woocommerce_email_from_name", "دکتر محمد قاسمی", "no");
INSERT INTO `wp_abz7_options` VALUES("3930", "woocommerce_email_from_address", "info@abzarwp-plugins.ir", "no");
INSERT INTO `wp_abz7_options` VALUES("3931", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_abz7_options` VALUES("3932", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_abz7_options` VALUES("3933", "woocommerce_email_base_color", "#720eec", "no");
INSERT INTO `wp_abz7_options` VALUES("3934", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_abz7_options` VALUES("3935", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_abz7_options` VALUES("3936", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_abz7_options` VALUES("3937", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `wp_abz7_options` VALUES("3938", "woocommerce_cart_page_id", "2422", "no");
INSERT INTO `wp_abz7_options` VALUES("3939", "woocommerce_checkout_page_id", "2423", "no");
INSERT INTO `wp_abz7_options` VALUES("3940", "woocommerce_myaccount_page_id", "2424", "no");
INSERT INTO `wp_abz7_options` VALUES("3941", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_abz7_options` VALUES("3942", "woocommerce_force_ssl_checkout", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("3943", "woocommerce_unforce_ssl_checkout", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("3944", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_abz7_options` VALUES("3945", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_abz7_options` VALUES("3946", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_abz7_options` VALUES("3947", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_abz7_options` VALUES("3948", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_abz7_options` VALUES("3949", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_abz7_options` VALUES("3950", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_abz7_options` VALUES("3951", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_abz7_options` VALUES("3952", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_abz7_options` VALUES("3953", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_abz7_options` VALUES("3954", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_abz7_options` VALUES("3955", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_abz7_options` VALUES("3956", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_abz7_options` VALUES("3957", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("3958", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_abz7_options` VALUES("3959", "woocommerce_show_marketplace_suggestions", "no", "no");
INSERT INTO `wp_abz7_options` VALUES("3960", "woocommerce_analytics_enabled", "yes", "yes");
INSERT INTO `wp_abz7_options` VALUES("3961", "woocommerce_navigation_enabled", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("3962", "woocommerce_new_product_management_enabled", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("3963", "woocommerce_feature_custom_order_tables_enabled", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("3964", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wp_abz7_options` VALUES("3965", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `wp_abz7_options` VALUES("3966", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_abz7_options` VALUES("3967", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_abz7_options` VALUES("3968", "wc_downloads_approved_directories_mode", "enabled", "yes");
INSERT INTO `wp_abz7_options` VALUES("3969", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3970", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_abz7_options` VALUES("3971", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_abz7_options` VALUES("4236", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3974", "default_product_cat", "30", "yes");
INSERT INTO `wp_abz7_options` VALUES("3976", "woocommerce_refund_returns_page_id", "2425", "yes");
INSERT INTO `wp_abz7_options` VALUES("4014", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_abz7_options` VALUES("3979", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:85:\"Pay via PayPal; you can pay with your credit card if you don\'t have a PayPal account.\";s:5:\"email\";s:23:\"info@abzarwp-plugins.ir\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:23:\"info@abzarwp-plugins.ir\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3980", "woocommerce_version", "10.2.2", "yes");
INSERT INTO `wp_abz7_options` VALUES("3981", "woocommerce_db_version", "10.2.2", "yes");
INSERT INTO `wp_abz7_options` VALUES("3983", "woocommerce_inbox_variant_assignment", "10", "yes");
INSERT INTO `wp_abz7_options` VALUES("3990", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"JcKKIZbCUsbhOUpJT5ir7gugUDfrzBpr\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3988", "action_scheduler_lock_async-request-runner", "68e4d8dc65b2c1.04661112|1759828248", "yes");
INSERT INTO `wp_abz7_options` VALUES("3989", "woocommerce_admin_notices", "a:1:{i:0;s:6:\"update\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3992", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3993", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3994", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3995", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3996", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3997", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3998", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("3999", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("4000", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("4001", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("4002", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("4003", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("4015", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:0;}", "no");
INSERT INTO `wp_abz7_options` VALUES("4035", "woocommerce_task_list_tracked_completed_tasks", "a:6:{i:0;s:8:\"purchase\";i:1;s:13:\"store_details\";i:2;s:8:\"shipping\";i:3;s:8:\"products\";i:4;s:8:\"payments\";i:5;s:17:\"launch-your-store\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("4036", "woocommerce_onboarding_profile", "a:11:{s:18:\"is_agree_marketing\";b:0;s:11:\"store_email\";s:23:\"info@abzarwp-plugins.ir\";s:20:\"is_store_country_set\";b:1;s:8:\"industry\";a:1:{i:0;a:1:{s:4:\"slug\";s:27:\"fashion-apparel-accessories\";}}s:13:\"product_types\";a:1:{i:0;s:8:\"physical\";}s:13:\"product_count\";s:6:\"11-100\";s:14:\"selling_venues\";s:2:\"no\";s:12:\"setup_client\";b:0;s:19:\"business_extensions\";a:0:{}s:5:\"theme\";s:15:\"hello-elementor\";s:9:\"completed\";b:1;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("4037", "woocommerce_task_list_dismissed_tasks", "a:0:{}", "yes");
INSERT INTO `wp_abz7_options` VALUES("4040", "woocommerce_admin_created_default_shipping_zones", "yes", "yes");
INSERT INTO `wp_abz7_options` VALUES("4042", "woocommerce_task_list_prompt_shown", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("4145", "jet_smart_filters_version", "3.6.10", "off");
INSERT INTO `wp_abz7_options` VALUES("4263", "bsr_data", "a:8:{s:13:\"select_tables\";a:60:{i:0;s:31:\"wp_abz7_actionscheduler_actions\";i:1;s:30:\"wp_abz7_actionscheduler_claims\";i:2;s:30:\"wp_abz7_actionscheduler_groups\";i:3;s:28:\"wp_abz7_actionscheduler_logs\";i:4;s:19:\"wp_abz7_commentmeta\";i:5;s:16:\"wp_abz7_comments\";i:6;s:16:\"wp_abz7_e_events\";i:7;s:15:\"wp_abz7_e_notes\";i:8;s:31:\"wp_abz7_e_notes_users_relations\";i:9;s:21:\"wp_abz7_e_submissions\";i:10;s:33:\"wp_abz7_e_submissions_actions_log\";i:11;s:28:\"wp_abz7_e_submissions_values\";i:12;s:24:\"wp_abz7_jet_appointments\";i:13;s:33:\"wp_abz7_jet_appointments_excluded\";i:14;s:29:\"wp_abz7_jet_appointments_meta\";i:15;s:23:\"wp_abz7_jet_cct_reviews\";i:16;s:22:\"wp_abz7_jet_post_types\";i:17;s:33:\"wp_abz7_jet_smart_filters_indexer\";i:18;s:22:\"wp_abz7_jet_taxonomies\";i:19;s:13:\"wp_abz7_links\";i:20;s:15:\"wp_abz7_options\";i:21;s:20:\"wp_abz7_payamito_sms\";i:22;s:16:\"wp_abz7_postmeta\";i:23;s:13:\"wp_abz7_posts\";i:24;s:26:\"wp_abz7_term_relationships\";i:25;s:21:\"wp_abz7_term_taxonomy\";i:26;s:16:\"wp_abz7_termmeta\";i:27;s:13:\"wp_abz7_terms\";i:28;s:16:\"wp_abz7_usermeta\";i:29;s:13:\"wp_abz7_users\";i:30;s:29:\"wp_abz7_wc_admin_note_actions\";i:31;s:22:\"wp_abz7_wc_admin_notes\";i:32;s:26:\"wp_abz7_wc_category_lookup\";i:33;s:26:\"wp_abz7_wc_customer_lookup\";i:34;s:23:\"wp_abz7_wc_download_log\";i:35;s:30:\"wp_abz7_wc_order_coupon_lookup\";i:36;s:31:\"wp_abz7_wc_order_product_lookup\";i:37;s:22:\"wp_abz7_wc_order_stats\";i:38;s:27:\"wp_abz7_wc_order_tax_lookup\";i:39;s:36:\"wp_abz7_wc_product_attributes_lookup\";i:40;s:39:\"wp_abz7_wc_product_download_directories\";i:41;s:30:\"wp_abz7_wc_product_meta_lookup\";i:42;s:22:\"wp_abz7_wc_rate_limits\";i:43;s:25:\"wp_abz7_wc_reserved_stock\";i:44;s:27:\"wp_abz7_wc_tax_rate_classes\";i:45;s:19:\"wp_abz7_wc_webhooks\";i:46;s:28:\"wp_abz7_woocommerce_api_keys\";i:47;s:40:\"wp_abz7_woocommerce_attribute_taxonomies\";i:48;s:52:\"wp_abz7_woocommerce_downloadable_product_permissions\";i:49;s:23:\"wp_abz7_woocommerce_log\";i:50;s:34:\"wp_abz7_woocommerce_order_itemmeta\";i:51;s:31:\"wp_abz7_woocommerce_order_items\";i:52;s:37:\"wp_abz7_woocommerce_payment_tokenmeta\";i:53;s:34:\"wp_abz7_woocommerce_payment_tokens\";i:54;s:28:\"wp_abz7_woocommerce_sessions\";i:55;s:43:\"wp_abz7_woocommerce_shipping_zone_locations\";i:56;s:41:\"wp_abz7_woocommerce_shipping_zone_methods\";i:57;s:34:\"wp_abz7_woocommerce_shipping_zones\";i:58;s:38:\"wp_abz7_woocommerce_tax_rate_locations\";i:59;s:29:\"wp_abz7_woocommerce_tax_rates\";}s:16:\"case_insensitive\";s:3:\"off\";s:13:\"replace_guids\";s:3:\"off\";s:7:\"dry_run\";s:3:\"off\";s:10:\"search_for\";s:25:\"https://presite.ir/doctor\";s:12:\"replace_with\";s:25:\"https://presite.ir/doctor\";s:15:\"completed_pages\";i:60;s:11:\"total_pages\";i:60;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("4247", "https_migration_required", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("4656", "woocommerce_cod_settings", "a:6:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:36:\"پرداخت هنگام دریافت\";s:11:\"description\";s:42:\"پرداخت نقدی پس از تحویل\";s:12:\"instructions\";s:42:\"پرداخت نقدی پس از تحویل\";s:18:\"enable_for_methods\";a:0:{}s:18:\"enable_for_virtual\";s:3:\"yes\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("4657", "woocommerce_gateway_order", "a:4:{s:33:\"_wc_offline_payment_methods_group\";i:0;s:4:\"bacs\";i:1;s:6:\"cheque\";i:2;s:3:\"cod\";i:3;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("5151", "duplicator_settings", "a:19:{s:7:\"version\";s:8:\"1.5.13.3\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:4;s:14:\"usage_tracking\";b:0;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("5089", "duplicator_activate_plugins_after_installation", "a:0:{}", "yes");
INSERT INTO `wp_abz7_options` VALUES("5091", "duplicator_migration_data", "{\n    \"time\": 1685254638,\n    \"installType\": -1,\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/presitei\\/domains\\/presite.ir\\/public_html\\/doctor\\/Doctor-Quick-Pack.zip\",\n    \"packageHash\": \"4e0bb22-03134638\",\n    \"installerPath\": \"\\/home\\/presitei\\/domains\\/presite.ir\\/public_html\\/doctor\\/installer.php\",\n    \"installerBootLog\": \"\\/home\\/presitei\\/domains\\/presite.ir\\/public_html\\/doctor\\/dup-installer-bootlog__8e6ffd9-03134638.txt\",\n    \"installerLog\": \"\\/home\\/presitei\\/domains\\/presite.ir\\/public_html\\/doctor\\/dup-installer\\/dup-installer-log__8e6ffd9-03134638.txt\",\n    \"dupInstallerPath\": \"\\/home\\/presitei\\/domains\\/presite.ir\\/public_html\\/doctor\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/presitei\\/domains\\/presite.ir\\/public_html\\/doctor\\/dup-installer\\/original_files_4e0bb22-03134638\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true\n}", "no");
INSERT INTO `wp_abz7_options` VALUES("5118", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:23:\"info@abzarwp-plugins.ir\";s:7:\"version\";s:5:\"6.8.3\";s:9:\"timestamp\";i:1759279751;}", "off");
INSERT INTO `wp_abz7_options` VALUES("5071", "elementor_safe_mode", "", "yes");
INSERT INTO `wp_abz7_options` VALUES("5928", "_elementor_global_css", "a:6:{s:4:\"time\";i:1685430169;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:0:{}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;b:0;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("74802", "duplicator_install_info", "a:3:{s:7:\"version\";s:5:\"1.5.4\";s:4:\"time\";i:1680529580;s:10:\"updateTime\";i:1759825675;}", "off");
INSERT INTO `wp_abz7_options` VALUES("61886", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"ynD.B4LfRDu+6l_QYPlyMg2e9kZmIKMDvQLCm390SP75\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 1,\n    \"buildLastDate\": 1744451614,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 321.54000000000002,\n    \"siteNumFiles\": 21993,\n    \"siteDbSizeMB\": 3.3399999999999999,\n    \"siteDbNumTables\": 66\n}", "auto");
INSERT INTO `wp_abz7_options` VALUES("61890", "duplicator_notifications", "a:4:{s:6:\"update\";i:1759821579;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_abz7_options` VALUES("61963", "woocommerce_coming_soon", "no", "auto");
INSERT INTO `wp_abz7_options` VALUES("61900", "woocommerce_feature_reactify-classic-payments-settings_enabled", "yes", "auto");
INSERT INTO `wp_abz7_options` VALUES("61937", "elementor_pro_install_history", "a:4:{s:6:\"3.13.1\";i:1744450510;s:6:\"3.27.6\";i:1744450511;s:6:\"3.28.2\";i:1744450878;s:6:\"3.32.2\";i:1759827583;}", "auto");
INSERT INTO `wp_abz7_options` VALUES("61962", "woocommerce_show_lys_tour", "yes", "auto");
INSERT INTO `wp_abz7_options` VALUES("61954", "_transient_woocommerce_shipping_task_zone_count_transient", "1", "on");
INSERT INTO `wp_abz7_options` VALUES("6319", "awcfe_version", "2.2.13", "yes");
INSERT INTO `wp_abz7_options` VALUES("6320", "awcfe_install_date", "30-05-2023", "yes");
INSERT INTO `wp_abz7_options` VALUES("6321", "awcfe_fields", "a:1:{s:6:\"fields\";a:3:{s:7:\"billing\";a:2:{s:5:\"extra\";a:4:{s:3:\"key\";s:7:\"billing\";s:4:\"name\";s:35:\"صورت حساب زمینه‌ها\";s:6:\"status\";i:1;s:5:\"error\";b:0;}s:6:\"fields\";a:10:{i:0;a:2:{i:0;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:6:\"نام\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:1:{i:0;s:14:\"form-row-first\";}s:8:\"priority\";s:2:\"20\";s:9:\"elementId\";s:15:\"text-4412591891\";s:3:\"col\";i:3;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:18:\"billing_first_name\";s:8:\"required\";b:1;s:10:\"bindingKey\";s:18:\"billing_first_name\";s:7:\"subtype\";s:4:\"text\";}i:1;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:23:\"نام خانوادگی\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:1:{i:0;s:13:\"form-row-last\";}s:8:\"priority\";s:2:\"30\";s:9:\"elementId\";s:15:\"text-4412591892\";s:3:\"col\";i:3;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:17:\"billing_last_name\";s:8:\"required\";b:1;s:10:\"bindingKey\";s:17:\"billing_last_name\";s:7:\"subtype\";s:4:\"text\";}}i:1;a:1:{i:0;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:15:\"نام شرکت\";s:6:\"custom\";b:0;s:6:\"active\";b:0;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:8:\"priority\";s:2:\"40\";s:9:\"elementId\";s:15:\"text-4412591893\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:15:\"billing_company\";s:8:\"required\";b:0;s:10:\"bindingKey\";s:15:\"billing_company\";s:7:\"subtype\";s:4:\"text\";}}i:2;a:1:{i:0;a:16:{s:4:\"type\";s:7:\"country\";s:5:\"label\";s:21:\"کشور / منطقه\";s:6:\"custom\";b:0;s:6:\"active\";b:0;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:3:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";i:2;s:23:\"update_totals_on_change\";}s:8:\"priority\";s:2:\"50\";s:9:\"elementId\";s:18:\"country-4412591894\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:15:\"billing_country\";s:8:\"required\";b:0;s:10:\"bindingKey\";s:15:\"billing_country\";}}i:3;a:1:{i:0;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:21:\"آدرس خیابان\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:40:\"نام خیابان و پلاک خانه\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"priority\";s:2:\"60\";s:9:\"elementId\";s:15:\"text-4412591895\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:17:\"billing_address_1\";s:8:\"required\";b:0;s:10:\"bindingKey\";s:17:\"billing_address_1\";s:7:\"subtype\";s:4:\"text\";}}i:4;a:1:{i:0;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:46:\"آپارتمان، مجتمع، واحد و...\";s:6:\"custom\";b:0;s:6:\"active\";b:0;s:11:\"placeholder\";s:63:\"آپارتمان، مجتمع، واحد و... (اختیاری)\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"priority\";s:2:\"70\";s:9:\"elementId\";s:15:\"text-4412591896\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:17:\"billing_address_2\";s:8:\"required\";b:0;s:10:\"bindingKey\";s:17:\"billing_address_2\";s:7:\"subtype\";s:4:\"text\";}}i:5;a:1:{i:0;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:6:\"شهر\";s:6:\"custom\";b:0;s:6:\"active\";b:0;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"priority\";s:2:\"80\";s:9:\"elementId\";s:15:\"text-4412591897\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:12:\"billing_city\";s:8:\"required\";b:0;s:10:\"bindingKey\";s:12:\"billing_city\";s:7:\"subtype\";s:4:\"text\";}}i:6;a:1:{i:0;a:16:{s:4:\"type\";s:5:\"state\";s:5:\"label\";s:10:\"استان\";s:6:\"custom\";b:0;s:6:\"active\";b:0;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"priority\";s:2:\"90\";s:9:\"elementId\";s:16:\"state-4412591898\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:13:\"billing_state\";s:8:\"required\";b:0;s:10:\"bindingKey\";s:13:\"billing_state\";}}i:7;a:1:{i:0;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:68:\"کدپستی (بدون فاصله و با اعداد انگلیسی)\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"priority\";s:3:\"100\";s:9:\"elementId\";s:15:\"text-4412591899\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:16:\"billing_postcode\";s:8:\"required\";b:0;s:10:\"bindingKey\";s:16:\"billing_postcode\";s:7:\"subtype\";s:4:\"text\";}}i:8;a:1:{i:0;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:8:\"تلفن\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:8:\"priority\";s:3:\"110\";s:9:\"elementId\";s:15:\"text-4125918910\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:13:\"billing_phone\";s:8:\"required\";b:1;s:10:\"bindingKey\";s:13:\"billing_phone\";s:7:\"subtype\";s:3:\"tel\";}}i:9;a:1:{i:0;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:19:\"آدرس ایمیل\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:8:\"priority\";s:3:\"120\";s:9:\"elementId\";s:15:\"text-4125918911\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:13:\"billing_email\";s:8:\"required\";b:1;s:10:\"bindingKey\";s:13:\"billing_email\";s:7:\"subtype\";s:5:\"email\";}}}}s:8:\"shipping\";a:2:{s:5:\"extra\";a:4:{s:3:\"key\";s:8:\"shipping\";s:4:\"name\";s:34:\"حمل و نقل زمینه‌ها\";s:6:\"status\";i:1;s:5:\"error\";b:0;}s:6:\"fields\";a:8:{i:0;a:2:{i:0;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:6:\"نام\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:1:{i:0;s:14:\"form-row-first\";}s:8:\"priority\";s:2:\"20\";s:9:\"elementId\";s:15:\"text-4125918912\";s:3:\"col\";i:3;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:19:\"shipping_first_name\";s:8:\"required\";b:1;s:10:\"bindingKey\";s:19:\"shipping_first_name\";s:7:\"subtype\";s:4:\"text\";}i:1;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:23:\"نام خانوادگی\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:1:{i:0;s:13:\"form-row-last\";}s:8:\"priority\";s:2:\"30\";s:9:\"elementId\";s:15:\"text-4125918913\";s:3:\"col\";i:3;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:18:\"shipping_last_name\";s:8:\"required\";b:1;s:10:\"bindingKey\";s:18:\"shipping_last_name\";s:7:\"subtype\";s:4:\"text\";}}i:1;a:1:{i:0;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:15:\"نام شرکت\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:1:{i:0;s:13:\"form-row-wide\";}s:8:\"priority\";s:2:\"40\";s:9:\"elementId\";s:15:\"text-4125918914\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:16:\"shipping_company\";s:8:\"required\";b:0;s:10:\"bindingKey\";s:16:\"shipping_company\";s:7:\"subtype\";s:4:\"text\";}}i:2;a:1:{i:0;a:16:{s:4:\"type\";s:7:\"country\";s:5:\"label\";s:21:\"کشور / منطقه\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:3:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";i:2;s:23:\"update_totals_on_change\";}s:8:\"priority\";s:2:\"50\";s:9:\"elementId\";s:18:\"country-4125918915\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:16:\"shipping_country\";s:8:\"required\";b:1;s:10:\"bindingKey\";s:16:\"shipping_country\";}}i:3;a:1:{i:0;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:21:\"آدرس خیابان\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:40:\"نام خیابان و پلاک خانه\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"priority\";s:2:\"60\";s:9:\"elementId\";s:15:\"text-4125918916\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:18:\"shipping_address_1\";s:8:\"required\";b:1;s:10:\"bindingKey\";s:18:\"shipping_address_1\";s:7:\"subtype\";s:4:\"text\";}}i:4;a:1:{i:0;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:46:\"آپارتمان، مجتمع، واحد و...\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:63:\"آپارتمان، مجتمع، واحد و... (اختیاری)\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"priority\";s:2:\"70\";s:9:\"elementId\";s:15:\"text-4125918917\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:18:\"shipping_address_2\";s:8:\"required\";b:0;s:10:\"bindingKey\";s:18:\"shipping_address_2\";s:7:\"subtype\";s:4:\"text\";}}i:5;a:1:{i:0;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:6:\"شهر\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"priority\";s:2:\"80\";s:9:\"elementId\";s:15:\"text-4125919018\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:13:\"shipping_city\";s:8:\"required\";b:1;s:10:\"bindingKey\";s:13:\"shipping_city\";s:7:\"subtype\";s:4:\"text\";}}i:6;a:1:{i:0;a:16:{s:4:\"type\";s:5:\"state\";s:5:\"label\";s:10:\"استان\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"priority\";s:2:\"90\";s:9:\"elementId\";s:16:\"state-4125919019\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:14:\"shipping_state\";s:8:\"required\";b:1;s:10:\"bindingKey\";s:14:\"shipping_state\";}}i:7;a:1:{i:0;a:17:{s:4:\"type\";s:4:\"text\";s:5:\"label\";s:68:\"کدپستی (بدون فاصله و با اعداد انگلیسی)\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:0:\"\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:2:{i:0;s:13:\"form-row-wide\";i:1;s:13:\"address-field\";}s:8:\"priority\";s:3:\"100\";s:9:\"elementId\";s:15:\"text-4125919020\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:17:\"shipping_postcode\";s:8:\"required\";b:1;s:10:\"bindingKey\";s:17:\"shipping_postcode\";s:7:\"subtype\";s:4:\"text\";}}}}s:5:\"order\";a:2:{s:5:\"extra\";a:4:{s:3:\"key\";s:5:\"order\";s:4:\"name\";s:28:\"سفارش زمینه‌ها\";s:6:\"status\";i:1;s:5:\"error\";b:0;}s:6:\"fields\";a:1:{i:0;a:1:{i:0;a:15:{s:4:\"type\";s:8:\"textarea\";s:5:\"label\";s:25:\"توضیحات سفارش\";s:6:\"custom\";b:0;s:6:\"active\";b:1;s:11:\"placeholder\";s:132:\"یادداشت‌ها درباره سفارش شما، برای مثال نکات مهم درباره نحوه تحویل سفارش\";s:13:\"show_in_email\";b:1;s:18:\"show_in_order_page\";b:1;s:5:\"class\";a:1:{i:0;s:5:\"notes\";}s:8:\"priority\";s:2:\"20\";s:9:\"elementId\";s:19:\"textarea-4125919021\";s:3:\"col\";i:6;s:7:\"default\";s:0:\"\";s:12:\"custom_class\";s:0:\"\";s:4:\"name\";s:14:\"order_comments\";s:10:\"bindingKey\";s:14:\"order_comments\";}}}}}}", "yes");
INSERT INTO `wp_abz7_options` VALUES("6767", "_transient_woocommerce_reports-transient-version", "1759828084", "yes");
INSERT INTO `wp_abz7_options` VALUES("6647", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "yes");
INSERT INTO `wp_abz7_options` VALUES("59021", "woocommerce_downloads_count_partial", "yes", "on");
INSERT INTO `wp_abz7_options` VALUES("59022", "woocommerce_attribute_lookup_optimized_updates", "no", "on");
INSERT INTO `wp_abz7_options` VALUES("59023", "woocommerce_product_match_featured_image_by_sku", "no", "on");
INSERT INTO `wp_abz7_options` VALUES("59024", "woocommerce_email_footer_text_color", "#3c3c3c", "off");
INSERT INTO `wp_abz7_options` VALUES("59025", "woocommerce_custom_orders_table_created", "yes", "auto");
INSERT INTO `wp_abz7_options` VALUES("59026", "woocommerce_custom_orders_table_enabled", "no", "on");
INSERT INTO `wp_abz7_options` VALUES("59027", "woocommerce_feature_rate_limit_checkout_enabled", "no", "on");
INSERT INTO `wp_abz7_options` VALUES("74825", "_site_transient_timeout_theme_roots", "1759829438", "off");
INSERT INTO `wp_abz7_options` VALUES("74826", "_site_transient_theme_roots", "a:1:{s:15:\"hello-elementor\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_abz7_options` VALUES("6723", "_transient_shipping-transient-version", "1685528520", "yes");
INSERT INTO `wp_abz7_options` VALUES("6691", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-07 09:09:40\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"2336cd244deeb0fb8681_20251007090940\";s:8:\"NameHash\";s:75:\"20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8_2336cd244deeb0fb8681_20251007090940\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8_2336cd244deeb0fb8681_20251007090940_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:52:\"/home/presitei/domains/presite.ir/public_html/doctor\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3564;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:18429;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-07 09:09:40\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8\";s:4:\"Hash\";s:35:\"2336cd244deeb0fb8681_20251007090940\";s:8:\"NameHash\";s:75:\"20230531_d8b3d8a7db8cd8aad8a2d985d8a7d8_2336cd244deeb0fb8681_20251007090940\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:66:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:61:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-admin\";i:1;s:64:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-includes\";i:2;s:73:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:52:\"/home/presitei/domains/presite.ir/public_html/doctor\";i:1;s:52:\"/home/presitei/domains/presite.ir/public_html/doctor\";i:2;s:63:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content\";i:3;s:71:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/uploads\";i:4;s:71:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/plugins\";i:5;s:74:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/mu-plugins\";i:6;s:70:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:84:\"/home/presitei/domains/presite.ir/public_html/doctor/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `wp_abz7_options` VALUES("6733", "_transient_product_query-transient-version", "1759827658", "yes");
INSERT INTO `wp_abz7_options` VALUES("6748", "_transient_health-check-site-status-result", "{\"good\":16,\"recommended\":3,\"critical\":4}", "yes");
INSERT INTO `wp_abz7_options` VALUES("6675", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "yes");
INSERT INTO `wp_abz7_options` VALUES("19240", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `wp_abz7_options` VALUES("39057", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_abz7_options` VALUES("47754", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"e4db2e247eccf33a2af3e11c37e80bd8\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_abz7_options` VALUES("59014", "wc_blocks_use_blockified_product_grid_block_as_template", "no", "auto");
INSERT INTO `wp_abz7_options` VALUES("59015", "wc_blocks_version", "11.8.0-dev", "auto");
INSERT INTO `wp_abz7_options` VALUES("59016", "widget_wc_brands_brand_description", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_abz7_options` VALUES("59017", "widget_woocommerce_brand_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_abz7_options` VALUES("59018", "widget_wc_brands_brand_thumbnails", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_abz7_options` VALUES("72968", "_site_transient_timeout_woocommerce_blocks_patterns", "1762417668", "off");
INSERT INTO `wp_abz7_options` VALUES("72969", "_site_transient_woocommerce_blocks_patterns", "a:2:{s:7:\"version\";s:6:\"10.2.2\";s:8:\"patterns\";a:41:{i:0;a:11:{s:5:\"title\";s:6:\"Banner\";s:4:\"slug\";s:25:\"woocommerce-blocks/banner\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:10:\"banner.php\";}i:1;a:11:{s:5:\"title\";s:23:\"Coming Soon Entire Site\";s:4:\"slug\";s:35:\"woocommerce/coming-soon-entire-site\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"coming-soon-entire-site.php\";}i:2;a:11:{s:5:\"title\";s:22:\"Coming Soon Store Only\";s:4:\"slug\";s:34:\"woocommerce/coming-soon-store-only\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"coming-soon-store-only.php\";}i:3;a:11:{s:5:\"title\";s:11:\"Coming Soon\";s:4:\"slug\";s:23:\"woocommerce/coming-soon\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:15:\"coming-soon.php\";}i:4;a:11:{s:5:\"title\";s:29:\"Content right with image left\";s:4:\"slug\";s:48:\"woocommerce-blocks/content-right-with-image-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"content-right-image-left.php\";}i:5;a:11:{s:5:\"title\";s:29:\"Featured Category Cover Image\";s:4:\"slug\";s:48:\"woocommerce-blocks/featured-category-cover-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"featured-category-cover-image.php\";}i:6;a:11:{s:5:\"title\";s:24:\"Featured Category Triple\";s:4:\"slug\";s:43:\"woocommerce-blocks/featured-category-triple\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"featured-category-triple.php\";}i:7;a:11:{s:5:\"title\";s:12:\"Large Footer\";s:4:\"slug\";s:31:\"woocommerce-blocks/footer-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"footer-large.php\";}i:8;a:11:{s:5:\"title\";s:23:\"Footer with Simple Menu\";s:4:\"slug\";s:37:\"woocommerce-blocks/footer-simple-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"footer-simple-menu.php\";}i:9;a:11:{s:5:\"title\";s:17:\"Footer with menus\";s:4:\"slug\";s:38:\"woocommerce-blocks/footer-with-3-menus\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"footer-with-3-menus.php\";}i:10;a:11:{s:5:\"title\";s:28:\"Four Image Grid Content Left\";s:4:\"slug\";s:47:\"woocommerce-blocks/form-image-grid-content-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"four-image-grid-content-left.php\";}i:11;a:11:{s:5:\"title\";s:20:\"Centered Header Menu\";s:4:\"slug\";s:39:\"woocommerce-blocks/header-centered-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-centered-pattern.php\";}i:12;a:11:{s:5:\"title\";s:23:\"Distraction Free Header\";s:4:\"slug\";s:42:\"woocommerce-blocks/header-distraction-free\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-distraction-free.php\";}i:13;a:11:{s:5:\"title\";s:16:\"Essential Header\";s:4:\"slug\";s:35:\"woocommerce-blocks/header-essential\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"header-essential.php\";}i:14;a:11:{s:5:\"title\";s:12:\"Large Header\";s:4:\"slug\";s:31:\"woocommerce-blocks/header-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"header-large.php\";}i:15;a:11:{s:5:\"title\";s:14:\"Minimal Header\";s:4:\"slug\";s:33:\"woocommerce-blocks/header-minimal\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:18:\"header-minimal.php\";}i:16;a:11:{s:5:\"title\";s:47:\"Heading with three columns of content with link\";s:4:\"slug\";s:66:\"woocommerce-blocks/heading-with-three-columns-of-content-with-link\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:51:\"heading-with-three-columns-of-content-with-link.php\";}i:17;a:11:{s:5:\"title\";s:20:\"Hero Product 3 Split\";s:4:\"slug\";s:39:\"woocommerce-blocks/hero-product-3-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:24:\"hero-product-3-split.php\";}i:18;a:11:{s:5:\"title\";s:23:\"Hero Product Chessboard\";s:4:\"slug\";s:42:\"woocommerce-blocks/hero-product-chessboard\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"hero-product-chessboard.php\";}i:19;a:11:{s:5:\"title\";s:18:\"Hero Product Split\";s:4:\"slug\";s:37:\"woocommerce-blocks/hero-product-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"hero-product-split.php\";}i:20;a:11:{s:5:\"title\";s:33:\"Centered content with image below\";s:4:\"slug\";s:52:\"woocommerce-blocks/centered-content-with-image-below\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:43:\"intro-centered-content-with-image-below.php\";}i:21;a:11:{s:5:\"title\";s:22:\"Just Arrived Full Hero\";s:4:\"slug\";s:41:\"woocommerce-blocks/just-arrived-full-hero\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"just-arrived-full-hero.php\";}i:22;a:11:{s:5:\"title\";s:33:\"No Products Found - Clear Filters\";s:4:\"slug\";s:43:\"woocommerce/no-products-found-clear-filters\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:29:\"no-products-found-filters.php\";}i:23;a:11:{s:5:\"title\";s:17:\"No Products Found\";s:4:\"slug\";s:29:\"woocommerce/no-products-found\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:21:\"no-products-found.php\";}i:24;a:11:{s:5:\"title\";s:19:\"Default Coming Soon\";s:4:\"slug\";s:36:\"woocommerce/page-coming-soon-default\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:28:\"page-coming-soon-default.php\";}i:25;a:11:{s:5:\"title\";s:25:\"Coming Soon Image Gallery\";s:4:\"slug\";s:42:\"woocommerce/page-coming-soon-image-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:34:\"page-coming-soon-image-gallery.php\";}i:26;a:11:{s:5:\"title\";s:30:\"Coming Soon Minimal Left Image\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-minimal-left-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-minimal-left-image.php\";}i:27;a:11:{s:5:\"title\";s:24:\"Coming Soon Modern Black\";s:4:\"slug\";s:41:\"woocommerce/page-coming-soon-modern-black\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:33:\"page-coming-soon-modern-black.php\";}i:28;a:11:{s:5:\"title\";s:29:\"Coming Soon Split Right Image\";s:4:\"slug\";s:46:\"woocommerce/page-coming-soon-split-right-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:38:\"page-coming-soon-split-right-image.php\";}i:29;a:11:{s:5:\"title\";s:34:\"Coming Soon With Header and Footer\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-with-header-footer\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-with-header-footer.php\";}i:30;a:11:{s:5:\"title\";s:28:\"Product Collection 3 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-3-columns.php\";}i:31;a:11:{s:5:\"title\";s:28:\"Product Collection 4 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-4-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-4-columns.php\";}i:32;a:11:{s:5:\"title\";s:28:\"Product Collection 5 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-5-columns.php\";}i:33;a:11:{s:5:\"title\";s:47:\"Product Collection: Featured Products 5 Columns\";s:4:\"slug\";s:65:\"woocommerce-blocks/product-collection-featured-products-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:50:\"product-collection-featured-products-5-columns.php\";}i:34;a:11:{s:5:\"title\";s:15:\"Product Gallery\";s:4:\"slug\";s:48:\"woocommerce-blocks/product-query-product-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:36:\"core/query/woocommerce/product-query\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"product-query-product-gallery.php\";}i:35;a:11:{s:5:\"title\";s:14:\"Product Search\";s:4:\"slug\";s:31:\"woocommerce/product-search-form\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"product-search-form.php\";}i:36;a:11:{s:5:\"title\";s:16:\"Related Products\";s:4:\"slug\";s:35:\"woocommerce-blocks/related-products\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"related-products.php\";}i:37;a:11:{s:5:\"title\";s:33:\"Social: Follow us on social media\";s:4:\"slug\";s:51:\"woocommerce-blocks/social-follow-us-in-social-media\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:25:\"WooCommerce, social-media\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:36:\"social-follow-us-in-social-media.php\";}i:38;a:11:{s:5:\"title\";s:22:\"Testimonials 3 Columns\";s:4:\"slug\";s:41:\"woocommerce-blocks/testimonials-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"testimonials-3-columns.php\";}i:39;a:11:{s:5:\"title\";s:19:\"Testimonials Single\";s:4:\"slug\";s:38:\"woocommerce-blocks/testimonials-single\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"testimonials-single.php\";}i:40;a:11:{s:5:\"title\";s:37:\"Three columns with images and content\";s:4:\"slug\";s:56:\"woocommerce-blocks/three-columns-with-images-and-content\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:41:\"three-columns-with-images-and-content.php\";}}}", "off");
INSERT INTO `wp_abz7_options` VALUES("74795", "_transient_timeout_wc_block_product_filter_attribute_default_attribute", "1759912069", "off");
INSERT INTO `wp_abz7_options` VALUES("74796", "_transient_wc_block_product_filter_attribute_default_attribute", "O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"1\";s:14:\"attribute_name\";s:5:\"brand\";s:15:\"attribute_label\";s:8:\"برند\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";i:0;}", "off");
INSERT INTO `wp_abz7_options` VALUES("74798", "_transient_wc_attribute_taxonomies", "a:2:{i:0;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"1\";s:14:\"attribute_name\";s:5:\"brand\";s:15:\"attribute_label\";s:8:\"برند\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}i:1;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"2\";s:14:\"attribute_name\";s:5:\"color\";s:15:\"attribute_label\";s:6:\"رنگ\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}}", "on");
INSERT INTO `wp_abz7_options` VALUES("74803", "_transient_timeout_woocommerce_admin_settings_payments_has_providers_with_incentive", "1759829592", "off");
INSERT INTO `wp_abz7_options` VALUES("74804", "_transient_woocommerce_admin_settings_payments_has_providers_with_incentive", "no", "off");
INSERT INTO `wp_abz7_options` VALUES("74776", "woocommerce_shipping_hide_rates_when_free", "no", "off");
INSERT INTO `wp_abz7_options` VALUES("74777", "woocommerce_email_header_image_width", "120", "on");
INSERT INTO `wp_abz7_options` VALUES("74778", "woocommerce_email_header_alignment", "left", "on");
INSERT INTO `wp_abz7_options` VALUES("74779", "woocommerce_email_font_family", "Helvetica", "on");
INSERT INTO `wp_abz7_options` VALUES("74780", "woocommerce_pos_store_name", "سایت آماده پزشک متخصص + رزرو نوبت", "on");
INSERT INTO `wp_abz7_options` VALUES("74781", "woocommerce_pos_store_address", "تهران\nتهران\nتهران\n12345", "on");
INSERT INTO `wp_abz7_options` VALUES("59028", "woocommerce_feature_order_attribution_enabled", "yes", "on");
INSERT INTO `wp_abz7_options` VALUES("59029", "woocommerce_feature_site_visibility_badge_enabled", "yes", "on");
INSERT INTO `wp_abz7_options` VALUES("59030", "woocommerce_feature_remote_logging_enabled", "yes", "on");
INSERT INTO `wp_abz7_options` VALUES("59031", "woocommerce_feature_product_block_editor_enabled", "no", "on");
INSERT INTO `wp_abz7_options` VALUES("59032", "woocommerce_hpos_fts_index_enabled", "no", "on");
INSERT INTO `wp_abz7_options` VALUES("59033", "woocommerce_feature_email_improvements_enabled", "no", "on");
INSERT INTO `wp_abz7_options` VALUES("59034", "woocommerce_feature_cost_of_goods_sold_enabled", "no", "on");
INSERT INTO `wp_abz7_options` VALUES("59035", "woocommerce_store_id", "51228c79-863f-4280-926c-ae0be13e8b94", "auto");
INSERT INTO `wp_abz7_options` VALUES("59036", "woocommerce_remote_variant_assignment", "66", "auto");
INSERT INTO `wp_abz7_options` VALUES("72970", "_transient_timeout_woocommerce_blocks_asset_api_script_data_ssl", "1762418002", "off");
INSERT INTO `wp_abz7_options` VALUES("72971", "_transient_woocommerce_blocks_asset_api_script_data_ssl", "{\"script_data\":{\"assets\\/client\\/blocks\\/wc-settings.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-settings.js\",\"version\":\"508473c3c2ece9af8f8f\",\"dependencies\":[\"wc-types\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-types.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-types.js\",\"version\":\"35dee88875b85ff65531\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-middleware.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-middleware.js\",\"version\":\"d79dedade2f2e4dc9df4\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-data.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-data.js\",\"version\":\"330a6892721994aa0779\",\"dependencies\":[\"wc-blocks-checkout-events\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors.js\",\"version\":\"4c07b2711966da9d83b1\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-registry.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-registry.js\",\"version\":\"a16aa912ffa0a15063f1\",\"dependencies\":[\"react-jsx-runtime\",\"wc-settings\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.js\",\"version\":\"18f8bdb0b0aeee4adc32\",\"dependencies\":[\"react-jsx-runtime\",\"wp-blocks\",\"wp-compose\",\"wp-core-data\",\"wp-data\",\"wp-element\",\"wp-hooks\",\"wp-i18n\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-context.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-context.js\",\"version\":\"5afd527de106cd5139ef\",\"dependencies\":[\"react-jsx-runtime\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\",\"version\":\"a1c1ed405307cfa86966\",\"dependencies\":[\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-format.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-format.js\",\"version\":\"57e176e7cc02bdd27978\",\"dependencies\":[\"wc-settings\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\",\"version\":\"2a67f05c7f92833d4e15\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\",\"version\":\"c939a893efb4febadc26\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\",\"version\":\"e4e433ec1187f2d5da6e\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-checkout.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout.js\",\"version\":\"a1c2e7c31247ee1ae717\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/blocks-checkout-events.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout-events.js\",\"version\":\"2d0fd4590f6cc663947c\",\"dependencies\":[\"wc-types\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-components.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-components.js\",\"version\":\"14f739e1c451e591f9da\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-schema-parser.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-schema-parser.js\",\"version\":\"f762078aeb4207fe9c3d\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/admin\\/customer-effort-score\\/index.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/admin\\/customer-effort-score\\/index.js\",\"version\":\"ebdc0b2d7487174621e6\",\"dependencies\":[\"react\",\"wc-experimental\",\"wc-navigation\",\"wc-store-data\",\"wc-tracks\",\"wp-api-fetch\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-data-controls\",\"wp-element\",\"wp-i18n\"]},\"assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\",\"version\":\"0446a66f2604add5f739\",\"dependencies\":[\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]},\"assets\\/client\\/blocks\\/mini-cart-component-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-component-frontend.js\",\"version\":\"5ce325604a08b049ca56\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-jsx-runtime\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-10.2.2\",\"dependencies\":[]}},\"version\":\"wc-10.2.2\",\"hash\":\"f777766927806ed5e814f522e7260bbc\"}", "off");
INSERT INTO `wp_abz7_options` VALUES("61903", "woocommerce_anonymize_refunded_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_abz7_options` VALUES("61904", "woocommerce_email_auto_sync_with_theme", "no", "off");
INSERT INTO `wp_abz7_options` VALUES("59047", "jetpack_options", "a:1:{s:14:\"last_heartbeat\";i:1759826978;}", "auto");
INSERT INTO `wp_abz7_options` VALUES("59072", "product_brand_children", "a:0:{}", "auto");
INSERT INTO `wp_abz7_options` VALUES("74700", "_transient_timeout_wc_term_counts", "1762418165", "off");
INSERT INTO `wp_abz7_options` VALUES("74701", "_transient_wc_term_counts", "a:22:{i:17;s:0:\"\";i:30;s:0:\"\";i:23;s:0:\"\";i:28;s:0:\"\";i:29;s:0:\"\";i:37;s:0:\"\";i:34;s:0:\"\";i:42;s:0:\"\";i:44;s:0:\"\";i:41;s:0:\"\";i:38;s:0:\"\";i:33;s:0:\"\";i:45;s:0:\"\";i:40;s:0:\"\";i:32;s:0:\"\";i:39;s:0:\"\";i:36;s:0:\"\";i:43;s:0:\"\";s:14:\"30_product_cat\";i:6;s:14:\"33_product_cat\";i:7;s:14:\"32_product_cat\";i:5;s:14:\"34_product_cat\";i:5;}", "off");
INSERT INTO `wp_abz7_options` VALUES("61874", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `wp_abz7_options` VALUES("61837", "_transient_timeout_woocommerce_marketplace_promotions_v2", "1759873857", "off");
INSERT INTO `wp_abz7_options` VALUES("61838", "_transient_woocommerce_marketplace_promotions_v2", "a:2:{s:6:\"notice\";a:8:{s:13:\"date_from_gmt\";s:16:\"2024-11-17 00:00\";s:11:\"date_to_gmt\";s:16:\"2024-11-20 23:59\";s:6:\"format\";s:6:\"notice\";s:5:\"style\";s:4:\"info\";s:5:\"pages\";a:5:{i:0;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:0:\"\";s:4:\"name\";s:8:\"Discover\";}i:1;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:10:\"extensions\";s:4:\"name\";s:6:\"Browse\";}i:2;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:6:\"themes\";s:4:\"name\";s:6:\"Themes\";}i:3;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:17:\"business-services\";s:4:\"name\";s:17:\"Business Services\";}i:4;a:4:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";s:3:\"tab\";s:16:\"my-subscriptions\";s:4:\"name\";s:16:\"My Subscriptions\";}}s:7:\"content\";a:1:{s:5:\"en_US\";s:192:\"<strong>Save 40%</strong> in the WooCommerce Marketplace sale. Offer ends December 3 at 3 pm UTC. <a href=\"https://woocommerce.com/products/#sale-ts-and-cs\" target=\"_blank\">T&amp;Cs</a> apply.\";}s:4:\"icon\";s:7:\"percent\";s:14:\"is_dismissible\";b:1;}s:6:\"promos\";a:1:{i:0;a:10:{s:13:\"date_from_gmt\";s:16:\"2025-07-15 06:20\";s:11:\"date_to_gmt\";s:16:\"2025-08-15 23:59\";s:6:\"format\";s:10:\"promo-card\";s:5:\"pages\";a:1:{i:0;a:2:{s:4:\"page\";s:8:\"wc-admin\";s:4:\"path\";s:11:\"/extensions\";}}s:9:\"cta_label\";a:1:{s:5:\"en_US\";s:19:\"View all extensions\";}s:8:\"cta_link\";s:67:\"/wp-admin/admin.php?page=wc-admin&tab=extensions&path=%2Fextensions\";s:7:\"content\";a:1:{s:5:\"en_US\";s:114:\"Use the WOOHOO10 coupon at checkout to get a 10% discount on extensions and themes. Valid until August 15th, 2025.\";}s:5:\"title\";a:1:{s:5:\"en_US\";s:24:\"WooCommerce 10.0 is here\";}s:5:\"style\";s:14:\"has-background\";s:4:\"icon\";s:7:\"percent\";}}}", "off");
INSERT INTO `wp_abz7_options` VALUES("61853", "_transient_woocommerce_product_task_product_count_transient", "15", "on");
INSERT INTO `wp_abz7_options` VALUES("61961", "_hello-elementor_notifications", "a:2:{s:7:\"timeout\";i:1759864781;s:5:\"value\";s:7532:\"[{\"id\":\"hello-theme-3.4.4\",\"title\":\"3.4.4 - 2025-06-08\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Improve Header\\/Footer edit access from theme Home<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.3\",\"title\":\"3.4.3 - 2025-05-26\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Fix: Settings page empty after 3.4.0 in translated sites<\\/li>\\n\\t\\t\\t\\t<li>Fix: PHP 8.4 deprecation notice<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.2\",\"title\":\"3.4.2 - 2025-05-19\",\"description\":\"\\n            <ul>\\n\\t\\t\\t\\t<li>Tweak: Set Home links font weight to regular<\\/li>\\n  \\t\\t        <li>Tweak: Dart SASS 3.0.0 - resolve scss deprecated warnings<\\/li>\\n    \\t\\t    <li>Fix: Settings page empty after 3.4.0<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.4.0\",\"title\":\"3.4.0 - 2025-05-05\",\"description\":\"\\n            <ul>\\n                <li>New: Added Theme Home<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update theme settings page style<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Update tested up to version 6.8<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.3.0\",\"title\":\"3.3.0 - 2025-01-21\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Added changelog link in theme settings<\\/li>\\n\\t\\t\\t\\t<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n  \\t\\t        <li>Tweak: Update autoprefixer to latest versions<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.1\",\"title\":\"3.2.1 - 2024-12-16\",\"description\":\"\\n            <ul>\\n                <li>\\n                    Fix: Gutenberg editor expanded disproportionately after adding support for <code>theme.json<\\/code>\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/430\\\" target=\\\"_blank\\\">#430<\\/a>)\\n                <\\/li>\\n                <li>Fix: Use CSS logical properties in the theme<\\/li>\\n                <li>Fix: Add ARIA attributes to header nav menu<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.2.0\",\"title\":\"3.2.0 - 2024-12-15\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Convert classic to hybrid theme with block-editor support<\\/li>\\n                <li>Tweak: Added new design options to header\\/footer<\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.7<\\/code><\\/li>\\n                <li>\\n                    Fix: Minify JS files\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/419\\\" target=\\\"_blank\\\">#419<\\/a>)\\n                <\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.1\",\"title\":\"3.1.1 - 2024-07-30\",\"description\":\"\\n            <ul>\\n                <li>Fix: Use consistent <code>&lt;h2&gt;<\\/code> for comments title and comment form<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.1.0\",\"title\":\"3.1.0 - 2024-06-19\",\"description\":\"\\n            <ul>\\n                <li>Tweak: Update <code>Requires PHP 7.4<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.5<\\/code><\\/li>\\n                <li>Tweak: Add the ability to style the brand layout<\\/li>\\n                <li>Tweak: Remove deprecated Elementor code<\\/li>\\n                <li>Tweak: Restore default focus styling inside the theme<\\/li>\\n                <li>Tweak: Add <code>aria-label<\\/code> attribute to various <code>&lt;nav&gt;<\\/code> elements<\\/li>\\n                <li>Tweak: Improve mobile menu keyboard accessibility<\\/li>\\n                <li>Tweak: Semantic mobile menu toggle button<\\/li>\\n                <li>Fix: The header renders redundant <code>&lt;p&gt;<\\/code> when tagline is empty<\\/li>\\n                <li>Fix: Single post renders redundant wrapping <code>&lt;div&gt;<\\/code> when it has no tags<\\/li>\\n                <li>Fix: Remove redundant wrapping <code>&lt;div&gt;<\\/code> from <code>wp_nav_menu()<\\/code> output<\\/li>\\n                <li>Fix: Wrap page <code>&lt;h1&gt;<\\/code> with <code>&lt;div&gt;<\\/code>, not <code>&lt;header&gt;<\\/code><\\/li>\\n                <li>Fix: Use consistent <code>&lt;h3&gt;<\\/code> for comments title and comment form<\\/li>\\n                <li>Fix: Remove heading tags from dynamic header\\/footer<\\/li>\\n                <li>\\n                    Fix: Mobile Menu hamburger is not visible for logged-out users in some cases\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/369\\\" target=\\\"_blank\\\">#369<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove duplicate ID attributes in the header mobile menu<\\/li>\\n                <li>\\n                    Fix: Remove redundant table styles\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/311\\\" target=\\\"_blank\\\">#311<\\/a>)\\n                <\\/li>\\n                <li>Fix: Remove redundant space below Site Logo in the header\\/footer<\\/li>\\n                <li>Fix: Remove redundant CSS from dynamic header\\/footer layout<\\/li>\\n                <li>\\n                    Fix: Separate post tags in single post\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/304\\\" target=\\\"_blank\\\">#304<\\/a>)\\n                <\\/li>\\n                <li>Fix: Display <code>the_tags()<\\/code> after <code>wp_link_pages()<\\/code><\\/li>\\n                <li>Fix: Remove page break navigation from archives when using <code>&lt;!--nextpage--&gt;<\\/code><\\/li>\\n                <li>Fix: Style posts pagination component layout<\\/li>\\n                <li>Fix: Add RTL support to pagination arrows in archive pages<\\/li>\\n                <li>\\n                    Fix: Update pagination prev\\/next labels and positions\\n                    (<a href=\\\"https:\\/\\/github.com\\/elementor\\/hello-theme\\/issues\\/404\\\" target=\\\"_blank\\\">#404<\\/a>)\\n                <\\/li>\\n                <li>Fix: Check if Elementor is loaded when using dynamic header & footer<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.2\",\"title\":\"3.0.2 - 2024-05-28\",\"description\":\"\\n            <ul>\\n                <li>Internal: Version bump release to refresh WordPress repository<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.1\",\"title\":\"3.0.1 - 2024-01-24\",\"description\":\"\\n            <ul>\\n                <li>Fix: Harden security for admin notice dismiss button<\\/li>\\n                <li>Fix: Add <code>alt<\\/code> attribute to all the images in the dashboard<\\/li>\\n            <\\/ul>\"},{\"id\":\"hello-theme-3.0.0\",\"title\":\"3.0.0 - 2023-12-26\",\"description\":\"\\n            <ul>\\n                <li>New: Option to disable cross-site header & footer<\\/li>\\n                <li>Tweak: Update <code>Requires PHP 7.3<\\/code><\\/li>\\n                <li>Tweak: Update <code>Tested up to 6.4<\\/code><\\/li>\\n                <li>Tweak: Move cross-site header & footer styles to a separate CSS file<\\/li>\\n                <li>Tweak: Don\'t load <code>header-footer.min.css<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Don\'t load <code>hello-frontend.min.js<\\/code> when disabling header & footer<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in the frontend<\\/li>\\n                <li>Tweak: Replace jQuery code with vanilla JS in WordPress admin<\\/li>\\n                <li>Tweak: Remove unused JS code from the frontend<\\/li>\\n                <li>Tweak: Remove unused CSS code from the editor<\\/li>\\n                <li>Tweak: Remove unnecessary <code>role<\\/code> attributes from HTML landmark elements<\\/li>\\n                <li>Tweak: Link from Elementor Site Settings to Hello Theme Settings<\\/li>\\n                <li>Fix: Dynamic script version for better caching<\\/li>\\n            <\\/ul>\"}]\";}", "off");
INSERT INTO `wp_abz7_options` VALUES("61976", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[]}", "auto");
INSERT INTO `wp_abz7_options` VALUES("74823", "_transient_timeout__woocommerce_helper_subscriptions", "1759828538", "off");
INSERT INTO `wp_abz7_options` VALUES("74824", "_transient__woocommerce_helper_subscriptions", "a:0:{}", "off");
INSERT INTO `wp_abz7_options` VALUES("74736", "_site_transient_timeout_jet_dashboard_license_expire_check", "1759864779", "off");
INSERT INTO `wp_abz7_options` VALUES("74737", "_site_transient_jet_dashboard_license_expire_check", "true", "off");
INSERT INTO `wp_abz7_options` VALUES("73321", "_transient_timeout_wc_shipping_method_count", "1760524892", "off");
INSERT INTO `wp_abz7_options` VALUES("73322", "_transient_wc_shipping_method_count", "a:4:{s:7:\"version\";s:10:\"1685528520\";s:6:\"legacy\";i:0;s:7:\"enabled\";i:1;s:8:\"disabled\";i:0;}", "off");
INSERT INTO `wp_abz7_options` VALUES("74429", "_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447", "1759926812", "off");
INSERT INTO `wp_abz7_options` VALUES("74430", "_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:0;s:13:\"is_acceptable\";b:0;}", "off");
INSERT INTO `wp_abz7_options` VALUES("74771", "_transient_timeout_last_fetch_patterns_request", "1759829255", "off");
INSERT INTO `wp_abz7_options` VALUES("74772", "_transient_last_fetch_patterns_request", "1759825655", "off");
INSERT INTO `wp_abz7_options` VALUES("74782", "woocommerce_pos_store_phone", "", "on");
INSERT INTO `wp_abz7_options` VALUES("74783", "woocommerce_pos_store_email", "info@abzarwp-plugins.ir", "on");
INSERT INTO `wp_abz7_options` VALUES("74784", "woocommerce_pos_refund_returns_policy", "", "on");
INSERT INTO `wp_abz7_options` VALUES("74785", "woocommerce_feature_blueprint_enabled", "yes", "on");
INSERT INTO `wp_abz7_options` VALUES("74786", "woocommerce_feature_experimental-iapi-mini-cart_enabled", "no", "on");
INSERT INTO `wp_abz7_options` VALUES("74787", "woocommerce_feature_point_of_sale_enabled", "yes", "on");
INSERT INTO `wp_abz7_options` VALUES("74788", "woocommerce_feature_block_email_editor_enabled", "no", "on");
INSERT INTO `wp_abz7_options` VALUES("74789", "woocommerce_hpos_datastore_caching_enabled", "no", "on");
INSERT INTO `wp_abz7_options` VALUES("74835", "_site_transient_timeout_wp_theme_files_patterns-2a400dfe9f9f6034de553bda90d68456", "1759829684", "off");
INSERT INTO `wp_abz7_options` VALUES("74836", "_site_transient_wp_theme_files_patterns-2a400dfe9f9f6034de553bda90d68456", "a:2:{s:7:\"version\";s:5:\"3.4.4\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_abz7_options` VALUES("74816", "payamito_jet_1.5.6", "1", "auto");
INSERT INTO `wp_abz7_options` VALUES("74830", "_transient_timeout_woocommerce_analytics_orders_statuses_all", "1791363644", "off");
INSERT INTO `wp_abz7_options` VALUES("74822", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.8.3.zip\";s:6:\"locale\";s:5:\"fa_IR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.8.3.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.3\";s:7:\"version\";s:5:\"6.8.3\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1759827638;s:15:\"version_checked\";s:5:\"6.8.3\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_abz7_options` VALUES("74818", "abzarwp_elementor_pro_jalali_options", "{\"use_jalali_datepicker\":false,\"show_jalali_date\":false,\"use_farsi_numbers\":false}", "auto");
INSERT INTO `wp_abz7_options` VALUES("74815", "_transient_doing_cron", "1759828188.3447010517120361328125", "on");
INSERT INTO `wp_abz7_options` VALUES("74827", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1759827639;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:6:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"5.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.5.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";}s:59:\"checkout-field-editor-and-manager-for-woocommerce/start.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:63:\"w.org/plugins/checkout-field-editor-and-manager-for-woocommerce\";s:4:\"slug\";s:49:\"checkout-field-editor-and-manager-for-woocommerce\";s:6:\"plugin\";s:59:\"checkout-field-editor-and-manager-for-woocommerce/start.php\";s:11:\"new_version\";s:5:\"3.0.0\";s:3:\"url\";s:80:\"https://wordpress.org/plugins/checkout-field-editor-and-manager-for-woocommerce/\";s:7:\"package\";s:98:\"https://downloads.wordpress.org/plugin/checkout-field-editor-and-manager-for-woocommerce.3.0.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:102:\"https://ps.w.org/checkout-field-editor-and-manager-for-woocommerce/assets/icon-256x256.gif?rev=3327936\";s:2:\"1x\";s:102:\"https://ps.w.org/checkout-field-editor-and-manager-for-woocommerce/assets/icon-128x128.gif?rev=3327936\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:105:\"https://ps.w.org/checkout-field-editor-and-manager-for-woocommerce/assets/banner-1544x500.png?rev=2823938\";s:2:\"1x\";s:104:\"https://ps.w.org/checkout-field-editor-and-manager-for-woocommerce/assets/banner-772x250.png?rev=2823938\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:8:\"1.5.13.3\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/duplicator.1.5.13.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}s:23:\"elementor/elementor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.32.4\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.32.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:37:\"3r-elementor-timeline-widget/init.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:42:\"w.org/plugins/3r-elementor-timeline-widget\";s:4:\"slug\";s:28:\"3r-elementor-timeline-widget\";s:6:\"plugin\";s:37:\"3r-elementor-timeline-widget/init.php\";s:11:\"new_version\";s:3:\"2.6\";s:3:\"url\";s:59:\"https://wordpress.org/plugins/3r-elementor-timeline-widget/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/3r-elementor-timeline-widget.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:81:\"https://ps.w.org/3r-elementor-timeline-widget/assets/icon-256x256.png?rev=3328907\";s:2:\"1x\";s:81:\"https://ps.w.org/3r-elementor-timeline-widget/assets/icon-128x128.png?rev=3327687\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:83:\"https://ps.w.org/3r-elementor-timeline-widget/assets/banner-772x250.png?rev=3327687\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.2\";}s:27:\"woocommerce/woocommerce.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:6:\"plugin\";s:27:\"woocommerce/woocommerce.php\";s:11:\"new_version\";s:6:\"10.2.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/woocommerce/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/woocommerce.10.2.2.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";s:3:\"svg\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=3234504\";s:2:\"1x\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=3234504\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.7\";}}s:7:\"checked\";a:15:{s:19:\"akismet/akismet.php\";s:3:\"5.5\";s:59:\"checkout-field-editor-and-manager-for-woocommerce/start.php\";s:5:\"3.0.0\";s:25:\"demo-modal/demo-modal.php\";s:5:\"1.0.0\";s:25:\"duplicator/duplicator.php\";s:8:\"1.5.13.3\";s:23:\"elementor/elementor.php\";s:6:\"3.32.4\";s:31:\"elementor-pro/elementor-pro.php\";s:6:\"3.32.2\";s:53:\"jet-appointments-booking/jet-appointments-booking.php\";s:5:\"2.1.2\";s:25:\"jet-engine/jet-engine.php\";s:5:\"3.7.4\";s:60:\"jet-engine-trim-callback-master/jet-engine-trim-callback.php\";s:5:\"1.0.1\";s:24:\"jet-plugin-pro/index.php\";s:5:\"1.6.0\";s:39:\"jet-smart-filters/jet-smart-filters.php\";s:6:\"3.6.10\";s:21:\"jet-tabs/jet-tabs.php\";s:6:\"2.2.10\";s:37:\"payamito-sms-jet-engine/bootstrap.php\";s:5:\"1.5.6\";s:37:\"3r-elementor-timeline-widget/init.php\";s:3:\"2.6\";s:27:\"woocommerce/woocommerce.php\";s:6:\"10.2.2\";}}", "off");
INSERT INTO `wp_abz7_options` VALUES("74828", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1759827641;s:7:\"checked\";a:1:{s:15:\"hello-elementor\";s:5:\"3.4.4\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:1:{s:15:\"hello-elementor\";a:6:{s:5:\"theme\";s:15:\"hello-elementor\";s:11:\"new_version\";s:5:\"3.4.4\";s:3:\"url\";s:45:\"https://wordpress.org/themes/hello-elementor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/hello-elementor.3.4.4.zip\";s:8:\"requires\";s:3:\"6.0\";s:12:\"requires_php\";s:3:\"7.4\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_abz7_options` VALUES("74829", "elementor_pro_remote_info_api_data_3.32.2", "a:2:{s:7:\"timeout\";i:1759883440;s:5:\"value\";s:248311:\"{\"stable_version\":\"3.32.2\",\"last_updated\":\"2025-09-29 12:32:45\",\"sections\":\"a:2:{s:11:\\\"description\\\";s:161:\\\"Elementor Pro adds new features to the Elementor Page Builder plugin. Control your conversions, your user engagement, your entire website, from one page builder.\\\";s:9:\\\"changelog\\\";s:231955:\\\"<h2>Elementor Pro - by Elementor.com<\\/h2>\\n<h4>3.32.2 - 2025-09-29<\\/h4>\\n<ul>\\n<li>Fix: Exported taxonomies are not displayed correctly on the summary page in Website Templates export<\\/li>\\n<li>Fix: Certain taxonomies are not exported as expected in Website Templates export<\\/li>\\n<\\/ul>\\n<h4>3.32.1 - 2025-09-16<\\/h4>\\n<ul>\\n<li>Fix: Theme Builder fails to load when containers are disabled<\\/li>\\n<li>Fix: Popup and single product templates not imported or exported as expected<\\/li>\\n<\\/ul>\\n<h4>3.32.0 - 2025-09-15<\\/h4>\\n<ul>\\n<li>New: Introducing Size Variables to store and reuse numeric values across spacing, typography, layout, and borders - Editor V4<\\/li>\\n<li>New: Introducing granular Transitions with property-level control for advanced micro-animations - Editor V4<\\/li>\\n<li>New: Added granular content selection for Website Templates import and export, including pages, menus, post types, and taxonomies<\\/li>\\n<li>Tweak: Enhanced accessibility of background images in Slides widget with proper aria attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23543\\\">#23543<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/31063\\\">#31063<\\/a>)<\\/li>\\n<li>Tweak: Added REST API support for the Custom Code feature<\\/li>\\n<li>Tweak: Moved Background control from Content tab to Style tab in Flip Box widget<\\/li>\\n<li>Tweak: Removed SVG icons from the accessibility tree in Share Buttons widget<\\/li>\\n<li>Tweak: Removed dropdown indicator icons from the accessibility tree in WordPress Menu widget<\\/li>\\n<li>Fix: PHP 8.4 deprecation notices when running with <code>WP_DEBUG<\\/code> enabled<\\/li>\\n<li>Fix: Reduced-motion preferences are not applied to Animated Headline widget<\\/li>\\n<li>Fix: Reduced-motion preferences are not applied in Motion Effects<\\/li>\\n<li>Fix: Added required PHP and WordPress versions to the plugin header<\\/li>\\n<\\/ul>\\n<h4>3.31.3 - 2025-09-08<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in WordPress Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.31.2 - 2025-08-10<\\/h4>\\n<ul>\\n<li>Tweak: Improved release version functionality<\\/li>\\n<\\/ul>\\n<h4>3.31.1 - 2025-08-06<\\/h4>\\n<ul>\\n<li>Tweak: Updated <code>form-data<\\/code> package version<\\/li>\\n<\\/ul>\\n<h4>3.31.0 - 2025-08-05<\\/h4>\\n<ul>\\n<li>New: Introducing Attributes - add custom HTML attributes to elements for advanced control - Editor V4<\\/li>\\n<li>Tweak: Optimized Custom Code styles by removing redundant RTL file<\\/li>\\n<li>Tweak: Improved performance by loading ribbon styles only when used in Call to Action and Price Table widgets<\\/li>\\n<li>Tweak: Improved semantic markup structure for header and footer documents<\\/li>\\n<li>Tweak: Reorganized design controls in Animated Headline widget<\\/li>\\n<li>Tweak: Reorganized design controls in Blockquote widget<\\/li>\\n<li>Tweak: Reorganized design controls in Countdown widget<\\/li>\\n<li>Tweak: Replaced SASS mixins and functions with native CSS logical properties<\\/li>\\n<li>Fix: Empty headers are rendered in Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28167\\\">#28167<\\/a>)<\\/li>\\n<li>Fix: <code>TypeError<\\/code> bug in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.30.1 - 2025-07-22<\\/h4>\\n<ul>\\n<li>Security Fix: Improved content sanitization in multiple widgets<\\/li>\\n<li>Fix: UI issue in Hotspot widget when Optimized Markup experiment is enabled<\\/li>\\n<li>Fix: Taxonomy filter not working in the Editor when Optimized Markup experiment is enabled<\\/li>\\n<\\/ul>\\n<h4>3.30.0 - 2025-07-01<\\/h4>\\n<ul>\\n<li>New: Introduced Full Website Templates in the Cloud - export, manage, and reuse full site kits across all your websites from one place<\\/li>\\n<li>Tweak: Activated &quot;Optimized Markup&quot; feature on new sites<\\/li>\\n<li>Tweak: Activated &quot;Menu&quot; feature on new sites<\\/li>\\n<li>Tweak: Improved error handling for Theme Builder display conditions<\\/li>\\n<li>Tweak: Added styling controls to Post Excerpt widget<\\/li>\\n<li>Tweak: Improved accessibility with <code>role<\\/code> and <code>aria-label<\\/code> attributes Post Navigation widget<\\/li>\\n<li>Tweak: Added <code>aria-label<\\/code> in Form widget<\\/li>\\n<li>Tweak: Added <code>aria-label<\\/code> in Login widget<\\/li>\\n<li>Tweak: Arranged content as lists in Portfolio and Posts widgets<\\/li>\\n<li>Tweak: Added Box Shadow and Text Shadow controls in Countdown widget<\\/li>\\n<li>Tweak: Moved image resolution control to content tab in Price List widget<\\/li>\\n<li>Tweak: Renamed and reorganized style sections in Price List widget<\\/li>\\n<li>Tweak: Added conditional logic to controls in Price Table widget<\\/li>\\n<li>Tweak: Grouped layout controls under list section in Price List widget<\\/li>\\n<li>Tweak: Updated minimum required WordPress version to 6.6<\\/li>\\n<li>Fix: Inline font icons support doesn\'t work in Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24367\\\">#24367<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18343\\\">#18343<\\/a>)<\\/li>\\n<li>Fix: Page Title condition doesn\'t work on child pages in Widget Display Conditions<\\/li>\\n<li>Fix: Editor users with &quot;Access to edit content only&quot; are able to delete elements<\\/li>\\n<li>Fix: Links are not crawlable in Video Playlist widget<\\/li>\\n<li>Fix: Uses hardcoded admin fonts in Video Playlist widget<\\/li>\\n<li>Fix: Editor freezes when the Form widget is used with a high PHP upload size limit<\\/li>\\n<li>Fix: Errors occur when Debug mode is enabled in Slides widget<\\/li>\\n<li>Fix: Plugin dependency not enforced in Elementor Pro<\\/li>\\n<li>Fix: Console shows deprecation warning in Global Widgets<\\/li>\\n<\\/ul>\\n<h4>3.29.2 - 2025-06-04<\\/h4>\\n<ul>\\n<li>Tweak: Added selectors to Menu widget for compatibility with Optimized Markup experiment<\\/li>\\n<\\/ul>\\n<h4>3.29.1 - 2025-05-28<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Animated Headline widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Price Table widget<\\/li>\\n<\\/ul>\\n<h4>3.29.0 - 2025-05-19<\\/h4>\\n<ul>\\n<li>New: Introduced Cloud Templates - save, manage, and reuse your templates across all your sites from a single cloud library<\\/li>\\n<li>Tweak: Improved accessibility with <code>role<\\/code> attributes in Share Buttons widget<\\/li>\\n<li>Tweak: Improved accessibility by grouping content with <code>role=region<\\/code> in the Video Playlist widget<\\/li>\\n<li>Fix: Focus color is not applied correctly for accessibility in WordPress Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24239\\\">#24239<\\/a>)<\\/li>\\n<li>Fix: Common scripts loaded late when using the Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.28.4 - 2025-05-05<\\/h4>\\n<ul>\\n<li>Fix: Empty results appeared on the frontend when using the Taxonomy Filter with the \'Avoid Duplicates\' option in Loop Grid widget<\\/li>\\n<li>Fix: Errors occur when Debug mode is enabled and the Optimized Markup experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.28.3 - 2025-04-16<\\/h4>\\n<ul>\\n<li>Tweak: Improved sidebar navigation flow on the Elementor Home screen<\\/li>\\n<\\/ul>\\n<h4>3.28.2 - 2025-03-30<\\/h4>\\n<ul>\\n<li>Fix: Default Elementor animation shown for logged-out users when using an &quot;External URL&quot; source in Lottie widget<\\/li>\\n<\\/ul>\\n<h4>3.28.1 - 2025-03-23<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Animated Headline and Form widgets<\\/li>\\n<\\/ul>\\n<h4>3.28.0 - 2025-03-17<\\/h4>\\n<ul>\\n<li>Tweak: Ensured File Upload field styles are overridden by global styles in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11651\\\">#11651<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17223\\\">#17223<\\/a>)<\\/li>\\n<li>Tweak: Updated Scroll Snap description to clarify incompatibility with animations and motion effects<\\/li>\\n<li>Tweak: Prevented special characters from being encoded in the email subject field in Form widget<\\/li>\\n<li>Tweak: Loaded module styles within the module instead of registering them in <code>plugin.php<\\/code><\\/li>\\n<li>Tweak: Updated minimum required WordPress version to 6.5<\\/li>\\n<li>Tweak: Improved keyboard accessibility for menus in Editor Top Bar<\\/li>\\n<li>Tweak: Made the edit button accessible in the Template widget<\\/li>\\n<li>Tweak: Optimized Form widget performance by caching field assets <code>using get_style_depends()<\\/code> and <code>get_script_depends()<\\/code> methods<\\/li>\\n<li>Tweak: Added Text Shadow control in Testimonial Carousel, Call to Action and Animated Headline widgets<\\/li>\\n<li>Fix: Button icon alignment breaks when Inline Font Icons feature is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16077\\\">#16077<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16511\\\">#16511<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17692\\\">#17692<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17922\\\">#17922<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19253\\\">#19253<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19370\\\">#19370<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21236\\\">#21236<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21844\\\">#21844<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28080\\\">#28080<\\/a>)<\\/li>\\n<li>Fix: Dropdown caret color did not follow menu item color when Inline Font Icons feature is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17500\\\">#17500<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18466\\\">#18466<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21664\\\">#21664<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24929\\\">#24929<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28064\\\">#28064<\\/a>)<\\/li>\\n<li>Fix: Page doesn\'t scroll up when a coupon error notice appears in Checkout widget<\\/li>\\n<\\/ul>\\n<h4>3.27.7 - 2025-03-13<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Lottie widget<\\/li>\\n<\\/ul>\\n<h4>3.27.6 - 2025-03-10<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Template Condition<\\/li>\\n<\\/ul>\\n<h4>3.27.5 - 2025-03-03<\\/h4>\\n<ul>\\n<li>Fix: The <code>wp_trigger_error<\\/code> function causes the site to crash instead of triggering a warning when used with ACF text<\\/li>\\n<\\/ul>\\n<h4>3.27.4 - 2025-02-16<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Screenshots module<\\/li>\\n<li>Security Fix: Improved code security enforcement in Query control<\\/li>\\n<li>Fix: ACF <code>true_false<\\/code> field causing a fatal error when used as a dynamic tag with third-party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/30170\\\">#30170<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.27.3 - 2025-02-06<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Stripe Button widget<\\/li>\\n<\\/ul>\\n<h4>3.27.2 - 2025-02-03<\\/h4>\\n<ul>\\n<li>Fix: Value type configuration issue causing errors when using ACF<\\/li>\\n<li>Fix: Hide content on responsive breakpoint option is not working on WordPress Menu widget when Optimized Markup experiment is activated<\\/li>\\n<\\/ul>\\n<h4>3.27.1 - 2025-01-27<\\/h4>\\n<ul>\\n<li>Tweak: Increased the number of items allowed in Dynamic Tags options in Display Conditions for Elements<\\/li>\\n<li>Security Fix: Improved code security enforcement in Global widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Lottie widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Admin settings<\\/li>\\n<li>Fix: Accessible navigation in popups caused unintended scrolling of the page when triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29175\\\">#29175<\\/a>)<\\/li>\\n<li>Fix: Empty custom fields are missing in the Dynamic Tags options in Display Conditions for Elements<\\/li>\\n<\\/ul>\\n<h4>3.27.0 - 2025-01-20<\\/h4>\\n<ul>\\n<li>Tweak: Removed the <code>elementor-widget-container<\\/code> div from the Menu, Loop, Table of Contents, Form, and Hotspot widgets as part of the Optimized Markup experiment to improve HTML structure<\\/li>\\n<li>Tweak: Reduced DOM size by optimizing the submit button markup in Search widget<\\/li>\\n<li>Tweak: Moved style loading to the head instead of the footer to improve CLS<\\/li>\\n<li>Tweak: Enabled conditional loading of Swiper.js based on widget dependencies to reduce unnecessary assets and improve page load times<\\/li>\\n<li>Tweak: Standardized navigation elements like arrows and bullets across all carousel and slider widgets for improved accessibility<\\/li>\\n<li>Tweak: Improved accessibility when the submit button has only an icon and no text in Search widget<\\/li>\\n<li>Tweak: Removed <code>load_plugin_textdomain()<\\/code> function from Elementor Pro<\\/li>\\n<\\/ul>\\n<h4>3.26.3 - 2025-01-07<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Search widget<\\/li>\\n<li>Fix: Height issues cause slideshow thumbnails to display incorrectly in Media Carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29663\\\">#29663<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.26.2 - 2024-12-22<\\/h4>\\n<ul>\\n<li>Fix: Menu items are not clickable in various scenarios in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29191\\\">#29191<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.26.1 - 2024-12-17<\\/h4>\\n<ul>\\n<li>Fix: Restore deprecated <code>Plugin::enqueue_styles()<\\/code> function to avoid errors with 3rd party plugins<\\/li>\\n<\\/ul>\\n<h4>3.26.0 - 2024-12-16<\\/h4>\\n<ul>\\n<li>New: Introducing dynamic content support for Off-canvas in Loop Grid widget templates - enabling seamless display of additional content dynamically (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29049\\\">#29049<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28935\\\">#28935<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7106\\\">#7106<\\/a>)<\\/li>\\n<li>New: AdBlock Detection trigger for Popups - display targeted popups for visitors using ad blockers<\\/li>\\n<li>New: Added Reload Page link action for Dynamic Tags<\\/li>\\n<li>Tweak: Added &quot;Space Between Dots&quot; control to Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2526\\\">#2526<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3277\\\">#3277<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21697\\\">#21697<\\/a>)<\\/li>\\n<li>Tweak: Replaced hidden <code>elementor-screen-only<\\/code> div with <code>aria-label<\\/code> attributes<\\/li>\\n<li>Tweak: Removed <code>elementor-widget-container<\\/code> div from Elementor widgets as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Optimize popup styling by loading it only when necessary<\\/li>\\n<li>Tweak: Updated Gap between slides control to support only PX units in Carousel widget<\\/li>\\n<li>Tweak: Removed the dependency between the Tabs handler and the Menu handler<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> in Carousel widgets<\\/li>\\n<li>Tweak: Added <code>aria-roledescription=carousel<\\/code> to carousel wrapper<\\/li>\\n<li>Tweak: Added <code>aria-roledescription=slide<\\/code> to slide wrapper<\\/li>\\n<li>Tweak: Optimized carousel widgets markup as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Updated minimum required Safari version to 15.5<\\/li>\\n<li>Tweak: Facebook widgets are no longer supported on mobile due to Facebook functionality changes<\\/li>\\n<li>Fix: Motion Effects sticky feature is not working when Scroll Snap is enabled<\\/li>\\n<li>Fix: Custom Image Resolution option is not working in Gallery widget<\\/li>\\n<li>Fix: \'Reading Settings\' unexpectedly reduces the number of posts displayed when using the Archive with Pagination setting<\\/li>\\n<li>Fix: Step Form does not scroll to the top when the first field is not an input field in Form widget<\\/li>\\n<li>Fix: Display Condition feature is available without an active Elementor license in Floating Elements<\\/li>\\n<li>Fix: Background options of Flip Box in Loop Grid widget are not working when images are added using ACF Dynamic Tags<\\/li>\\n<li>Fix: Dropdown icon in the Select field of the Form widget is cut off when the Inline Font Icons feature is activated<\\/li>\\n<li>Fix: Incompatibility between Form widget and WPML when using Nested Elements<\\/li>\\n<li>Fix: Performance issues when changing the title name in the Menu widget<\\/li>\\n<li>Fix: Warnings appear when Element Caching is set to Inactive in Carousel widgets<\\/li>\\n<li>Fix: Swiper styling missing from Lightbox inside Gallery widgets<\\/li>\\n<\\/ul>\\n<h4>3.25.5 - 2024-12-10<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Fix: Accessible navigation in popups caused unintended scrolling of the page when triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29175\\\">#29175<\\/a>)<\\/li>\\n<li>Fix: Popup overlay shown for non-logged users even when disabled<\\/li>\\n<\\/ul>\\n<h4>3.25.4 - 2024-11-20<\\/h4>\\n<ul>\\n<li>Tweak: Improved Global Widget loading method to enhance performance<\\/li>\\n<\\/ul>\\n<h4>3.25.3 - 2024-11-13<\\/h4>\\n<ul>\\n<li>Fix: Nested Elements are activated even when the Container experiment is inactive<\\/li>\\n<\\/ul>\\n<h4>3.25.2 - 2024-11-03<\\/h4>\\n<ul>\\n<li>Fix: Styling issues affecting popup layout when using a Dynamic Tag to open the popup<\\/li>\\n<li>Fix: Image captions are not displaying for non-logged-in users in Media Carousel widget<\\/li>\\n<li>Fix: Custom Add to Cart widget with Quantity enabled causes critical error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/29159\\\">#29159<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.25.1 - 2024-10-31<\\/h4>\\n<ul>\\n<li>Fix: Multiple Custom Add to Cart widgets on the same page are adding the same product<\\/li>\\n<\\/ul>\\n<h4>3.25.0 - 2024-10-28<\\/h4>\\n<ul>\\n<li>Tweak: Added pagination functionality to the Live Results in Search widget<\\/li>\\n<li>Tweak: Added Anchor Offset control to allow precise positioning when scrolling to anchor links on the page<\\/li>\\n<li>Tweak: Load motion effects styles only when they are in use<\\/li>\\n<li>Tweak: Load sticky styles only when they are in use<\\/li>\\n<li>Tweak: Load popup styles only when they are in use<\\/li>\\n<li>Tweak: Load theme builder styles only when they are in use<\\/li>\\n<li>Tweak: Load transition styles for Call to Action and Gallery widgets only when they are in use<\\/li>\\n<li>Tweak: Load styles for Form widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for WooCommerce widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Theme Elements widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Carousel widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Pricing widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Floating Elements separately to enhance performance<\\/li>\\n<li>Tweak: Load styles for Link in Bio widgets separately to enhance performance<\\/li>\\n<li>Tweak: Load minified CSS in the Loop Builder\'s Call to Action button in the Editor<\\/li>\\n<li>Tweak: Removed &quot;Payments&quot; module styles<\\/li>\\n<li>Tweak: Removed <code>elementor-button-wrapper<\\/code> div from Payapl widget as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Removed <code>elementor-button-wrapper<\\/code> div from Stripe widget as part of the Optimized Markup experiment<\\/li>\\n<li>Tweak: Merged &quot;Form Submissions&quot; feature into the version and moved it to the Advanced tab<\\/li>\\n<li>Tweak: Merged &quot;Display Conditions&quot; into the version<\\/li>\\n<li>Fix: Missing translation string for the empty message in the Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27580\\\">#27580<\\/a>)<\\/li>\\n<li>Fix: Local Storage and Session Storage were being used even when popups were not in use (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7151\\\">#7151<\\/a>)<\\/li>\\n<li>Fix: Masonry layout is not working when pagination is set to &quot;Load More&quot; or &quot;Infinite Scroll&quot; in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23684\\\">#23684<\\/a>)<\\/li>\\n<li>Fix: Extra gap between widgets on the frontend when using Off-canvas widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27706\\\">#27706<\\/a>)<\\/li>\\n<li>Fix: Pagination and custom queries did not work when the Posts Widget was saved as a Global Widget or used via shortcode<\\/li>\\n<li>Fix: Lightbox videos are missing controls and displayed at the wrong size in Media Carousel widget<\\/li>\\n<li>Fix: Pagination options with Individual Pagination not working as expected in Posts and Loop Grid widgets<\\/li>\\n<li>Fix: Justified or Masonry layouts for the Pro Gallery would not display images on the frontend when inserted via nested tabs<\\/li>\\n<li>Fix: Error issue in the Loop Grid widget when used in theme parts with the Taxonomy Filter<\\/li>\\n<li>Fix: Removed the focus ring after clicking to open the Off Canvas inside the Editor<\\/li>\\n<li>Fix: Background gradient colors from the dynamic color tag values are not rendering on the frontend<\\/li>\\n<li>Fix: Excessive database requests generated by the Loop Grid widget<\\/li>\\n<li>Fix: Colors from Dynamic Tags were not rendered on the frontend<\\/li>\\n<li>Fix: Display issue in the Menu widget caused by the \'Native Intersection Observer API<\\/li>\\n<li>Fix: Dropdown area not working in certain scenarios in Menu widget<\\/li>\\n<li>Fix: Content Width control inside the Mega Menu is displaying an empty value<\\/li>\\n<\\/ul>\\n<h4>3.24.4 - 2024-10-09<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Media Carousel widget<\\/li>\\n<\\/ul>\\n<h4>3.24.3 - 2024-10-01<\\/h4>\\n<ul>\\n<li>Fix: Floating Elements template not loading when Single Page template is set with All Singular condition<\\/li>\\n<li>Fix: Form field styles not loading properly in various scenarios<\\/li>\\n<\\/ul>\\n<h4>3.24.2 - 2024-09-18<\\/h4>\\n<ul>\\n<li>Fix: Icons not displaying when Inline SVG Icons experiment is active in Link In Bio widgets and Floating Elements<\\/li>\\n<\\/ul>\\n<h4>3.24.1 - 2024-09-12<\\/h4>\\n<ul>\\n<li>Fix: Widget styles not loading correctly on front causing alignment inconsistencies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28676\\\">#28676<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.24.0 - 2024-09-10<\\/h4>\\n<ul>\\n<li>New: Introducing support for Variable Fonts - allowing for more dynamic and flexible text styling (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6703\\\">#6703<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11333\\\">#11333<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19277\\\">#19277<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25485\\\">#25485<\\/a>)<\\/li>\\n<li>Tweak: Added \'Structure\' indication for widgets with Display Conditions applied (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28027\\\">#28027<\\/a>)<\\/li>\\n<li>Tweak: Added a new option for setting the live search results width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28280\\\">#28280<\\/a>)<\\/li>\\n<li>Tweak: Improved Honeypot field functionality in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28480\\\">#28480<\\/a>)<\\/li>\\n<li>Tweak: Added options to \'Copy\', \'Paste\', and \'Clear\' Display Conditions in Context Menu<\\/li>\\n<li>Tweak: Improved performance of the Menu widget when using Dynamic Tags in the URL field<\\/li>\\n<li>Tweak: Improved performance when using Dynamic Tags in Nested Elements<\\/li>\\n<li>Tweak: Added the option for users to disable Akismet for specific Elementor forms<\\/li>\\n<li>Tweak: Adjusted URL structure when presenting the Search Archive page in Search widget<\\/li>\\n<li>Tweak: Added the \'Create Template\' button in Search widget<\\/li>\\n<li>Tweak: Added an option to enable the \'Loader\' animation while live results are loading in Search widget<\\/li>\\n<li>Tweak: Load share buttons compatibility styles only when they are in use<\\/li>\\n<li>Tweak: Load dialog styles only when they are in use<\\/li>\\n<li>Tweak: Load global widget styles only during Editor preview<\\/li>\\n<li>Tweak: Conditionally load widget styles only when the widgets are used<\\/li>\\n<li>Tweak: Load styles for CTA hover animations only when they are in use<\\/li>\\n<li>Tweak: Load notes styles only when the WordPress Toolbar is displayed<\\/li>\\n<li>Tweak: Split <code>animations.min.css<\\/code> into multiple CSS files and load them conditionally<\\/li>\\n<li>Tweak: Promoted Display Conditions feature to Stable status<\\/li>\\n<li>Tweak: Merged Taxonomy Filter feature into the version<\\/li>\\n<li>Tweak: Merged Search feature into the version<\\/li>\\n<li>Tweak: Added a note to \'Current Query\' explaining the impact of WordPress settings on pagination within Archives<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for the Off-Canvas widget<\\/li>\\n<li>Fix: Manual Selection option is not excluding sticky posts in Posts and Loop Grid widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18689\\\">#18689<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23331\\\">#23331<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28179\\\">#28179<\\/a>)<\\/li>\\n<li>Fix: Template ID does not change according to the imported Loop Item (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21404\\\">#21404<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22202\\\">#22202<\\/a>)<\\/li>\\n<li>Fix: \'Editing Mode\' for the Off-canvas was not functioning correctly in certain scenarios<\\/li>\\n<li>Fix: Added definition to <code>clear_custom_image_sizes<\\/code> hook to prevent edge case issues<\\/li>\\n<li>Fix: Flickering issue with search result buttons when closing results using the keyboard escape key in Search widget<\\/li>\\n<li>Fix: Theme Style settings for buttons were overriding the text styling in Search widget<\\/li>\\n<li>Fix: Nesting menu inside another menu causes functionality issues in Menu widget<\\/li>\\n<li>Fix: Error when using array as custom fields value in Dynamic Tags<\\/li>\\n<\\/ul>\\n<h4>3.23.3 - 2024-08-05<\\/h4>\\n<ul>\\n<li>Fix: Dropdown area not working in certain scenarios in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28194\\\">#28194<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.23.2 - 2024-07-29<\\/h4>\\n<ul>\\n<li>Fix: Horizontal scroll bar appearing on the page when using Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/28087\\\">#28087<\\/a>)<\\/li>\\n<li>Fix: Dropdown area disappearing in certain scenarios in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.23.1 - 2024-07-23<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in link URL<\\/li>\\n<\\/ul>\\n<h4>3.23.0 - 2024-07-15<\\/h4>\\n<ul>\\n<li>New: Search Widget with Live Results - Display live search results as visitors type into the search box, enhancing user experience and engagement (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27664\\\">#27664<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24931\\\">#24931<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21459\\\">#21459<\\/a>)<\\/li>\\n<li>Tweak: Renamed <code>width<\\/code> to <code>Min width<\\/code> and added <code>Max width<\\/code> control to Hotspot tooltips (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18930\\\">#18930<\\/a>)<\\/li>\\n<li>Tweak: Applied a logical DOM order to the Mega Menu widget to improve accessibility<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for WordPress Menu widget<\\/li>\\n<li>Tweak: Added the ability to set <code>aria-label<\\/code> for Menu widget<\\/li>\\n<li>Tweak: Added a bottom option to the Image Position control in Call to Action widget<\\/li>\\n<li>Fix: Missing version string in included CSS query string when Improved CSS Loading is enabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21879\\\">#21879<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23821\\\">#23821<\\/a>)<\\/li>\\n<li>Fix: Form submission icon message does not display correctly when Inline Font Icons feature is activated<\\/li>\\n<li>Fix: Save and Close button position issues in the conditions screen in Theme Builder.<\\/li>\\n<li>Fix: Focus appears on the first element when using the mouse to open Off-Canvas <\\/li>\\n<li>Fix: Links to Elementor Settings are broken in various locations<\\/li>\\n<li>Fix: Conditions field not showing all relevant conditions in Theme Builder<\\/li>\\n<li>Fix: Off-Canvas flickering in sticky containers with exit animations triggered by sticky effects<\\/li>\\n<\\/ul>\\n<h4>3.22.1 - 2024-06-24<\\/h4>\\n<ul>\\n<li>Fix: Styling of Global widgets not loading when Element Caching experiment is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27704\\\">#27704<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.22.0 - 2024-06-16<\\/h4>\\n<ul>\\n<li>New: Introducing Off-Canvas widget - create engaging and creative layers triggered by a link (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6225\\\">#6225<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21769\\\">#21769<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25770\\\">#25770<\\/a>)<\\/li>\\n<li>Tweak: Added option to remove \'User IP\' and \'User Agent\' from the form submissions metadata (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14285\\\">#14285<\\/a>)<\\/li>\\n<li>Tweak: Replaced <code>waypoints.js<\\/code> library with the native Intersection Observer API<\\/li>\\n<li>Tweak: Extended Alignment and Position capabilities in Form widget<\\/li>\\n<li>Tweak: Moved icon View control to style tab in Flip Box widget<\\/li>\\n<li>Tweak: Moved icon View control to style tab in Call to Action widget<\\/li>\\n<li>Tweak: Optimized Form widget to eliminate unnecessary markup when the button icon is empty<\\/li>\\n<li>Tweak: Optimized Posts widget to eliminate unnecessary markup when Load More button text is empty<\\/li>\\n<li>Tweak: Remove <code>placeholder<\\/code> arguments from URL controls<\\/li>\\n<li>Tweak: Implemented CSS logical properties to Icon Position in Form, Posts and Menu Cart widgets<\\/li>\\n<li>Tweak: Activated Display Conditions feature for existing sites<\\/li>\\n<li>Tweak: Activated Taxonomy Filter feature for existing sites<\\/li>\\n<li>Tweak: Added functionality to delay the running of the ready triggers on inner elements<\\/li>\\n<li>Fix: Icons are now part of the link in the Menu Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24298\\\">#24298<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25112\\\">#25112<\\/a>)<\\/li>\\n<li>Fix: <code>all: unset<\\/code> assigned to buttons cause focus issues (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24322\\\">#24322<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25448\\\">#25448<\\/a>)<\\/li>\\n<li>Fix: Menu cart SVG icon disappears on front when Optimized Control Loading experiment is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/27342\\\">#27342<\\/a>)<\\/li>\\n<li>Fix: Elementor Pro auto-updates are not working on multisite networks (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12615\\\">#12615<\\/a>)<\\/li>\\n<li>Fix: PHP error appears in the editor when using Loop Grid in an archive template<\\/li>\\n<li>Fix: UI glitch on Icon Position control in Paypal and Stripe Buttons widgets<\\/li>\\n<li>Fix: Icon Position control RTL issue in Hotspot widget<\\/li>\\n<li>Fix: Manual Selection &quot;Include By&quot; Query doesn\'t work with product categories<\\/li>\\n<\\/ul>\\n<h4>3.21.3 - 2024-05-20<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Loop Grid widget<\\/li>\\n<li>Fix: License expired affects the Display Conditions functionality in the front end<\\/li>\\n<\\/ul>\\n<h4>3.21.2 - 2024-04-30<\\/h4>\\n<ul>\\n<li>Fix: Special characters are not displayed correctly when using the Excerpt widget in Loop template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25860\\\">#25860<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.21.1 - 2024-04-24<\\/h4>\\n<ul>\\n<li>Fix: Excerpt Length setting doesn\'t function correctly for languages with non-English characters in Post Excerpt widget<\\/li>\\n<\\/ul>\\n<h4>3.21.0 - 2024-04-15<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Taxonomy Query - Enabling the display of post and product categories and tags within Loop Grid and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21372\\\">#21372<\\/a>)<\\/li>\\n<li>Tweak: Optimized Hotspot widget to prevent rendering when no image is provided<\\/li>\\n<li>Tweak: Optimized Blockquote widget to eliminate unnecessary markup when devoid of content<\\/li>\\n<li>Tweak: Optimized Template widget to eliminate unnecessary markup when no template is selected<\\/li>\\n<li>Tweak: Optimized Code Highlight widget to eliminate unnecessary markup when there is no content<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Portfolio widget<\\/li>\\n<li>Tweak: Implemented accessibility improvements of Author Avatar image alt text in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25440\\\">#25440<\\/a>)<\\/li>\\n<li>Tweak: Notes feature merged to version<\\/li>\\n<li>Tweak: Implemented accessibility improvements of Profile Picture alt text in Author widget<\\/li>\\n<li>Fix: Display issue on hover state in WooCommerce Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.20.3 - 2024-04-10<\\/h4>\\n<ul>\\n<li>Fix: Compatibility issue between the My Account widget and other third-party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20986\\\">#20986<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.20.2 - 2024-03-26<\\/h4>\\n<ul>\\n<li>Security Fix: Improved code security enforcement in Media Carousel widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Post Navigation widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Gallery widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.20.1 - 2024-03-20<\\/h4>\\n<ul>\\n<li>Fix: Strengthened code integrity in deprecated Woo Single Element widget<\\/li>\\n<li>Fix: PHP error notice appears when using Loop Grid with the Taxonomy Filter widgets<\\/li>\\n<\\/ul>\\n<h4>3.20.0 - 2024-03-11<\\/h4>\\n<ul>\\n<li>Tweak: Implemented OR logic in the Display Conditions feature<\\/li>\\n<li>Tweak: Added X and Threads social networks to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/25299\\\">#25299<\\/a>)<\\/li>\\n<li>Tweak: Added Archive Title dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Title dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Alt dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image Caption dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Bio dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Email dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Author Website dynamic tag rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Page Title rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Post Title rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Featured Image rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Comments Number rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added Archive Author rule in Display Conditions feature<\\/li>\\n<li>Tweak: Added support for WordPress Custom Fields in Display Conditions feature<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23875\\\">#23875<\\/a>)<\\/li>\\n<li>Tweak: Implemented accessibility improvements in Login widget<\\/li>\\n<li>Tweak: Added additional style controls in the Table of Contents widget<\\/li>\\n<li>Tweak: Added Transition Duration option in Blockquote widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21295\\\">#21295<\\/a>)<\\/li>\\n<li>Tweak: Added Transition Duration to button in Flip Box widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Author Box widget<\\/li>\\n<li>Tweak: Added Transition Duration to List in Table of Contents widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Login widget<\\/li>\\n<li>Tweak: Added Transition Duration in Post Navigation widget<\\/li>\\n<li>Tweak: Added Transition Duration Show More in Video Playlist widget<\\/li>\\n<li>Tweak: Added Transition Duration to button in Form widget<\\/li>\\n<li>Tweak: Removed separator-none argument from all Editor controls<\\/li>\\n<li>Tweak: Add <code>&lt;time&gt;<\\/code> wrapper for Date and Time items in Post Info widget<\\/li>\\n<li>Tweak: Page Transitions feature merged to version<\\/li>\\n<li>Tweak: Scroll Snap feature merged to version<\\/li>\\n<li>Tweak: Promoted Display Conditions feature to Beta status and activated for new sites<\\/li>\\n<li>Tweak: Promoted Taxonomy Filter feature to beta status and activated for new sites<\\/li>\\n<li>Fix: Page Transitions feature and Load Font Awesome 4 Support cause a console error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18885\\\">#18885<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19334\\\">#19334<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21082\\\">#21082<\\/a>)<\\/li>\\n<li>Fix: Added better output escaping in Taxonomy Filter widget<\\/li>\\n<\\/ul>\\n<h4>3.19.3 - 2024-02-26<\\/h4>\\n<ul>\\n<li>Tweak: Improved Loop CSS loading structure in Loop Grid item<\\/li>\\n<li>Security Fix: Addressed security weaknesses in Dynamic Tags<\\/li>\\n<\\/ul>\\n<h4>3.19.2 - 2024-02-07<\\/h4>\\n<ul>\\n<li>Fix: Export data inconsistencies when using form actions in Form widget<\\/li>\\n<\\/ul>\\n<h4>3.19.1 - 2024-02-05<\\/h4>\\n<ul>\\n<li>Fix: Enqueuing non-existing Loop Template CSS file in Loop Item template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24959\\\">#24959<\\/a>)<\\/li>\\n<li>Fix: Improved code security enforcement in Countdown widget<\\/li>\\n<\\/ul>\\n<h4>3.19.0 - 2024-01-29<\\/h4>\\n<ul>\\n<li>New: Introducing Display Conditions for Elements - allowing users to customize content visibility based on specified criteria (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4246\\\">#4246<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21152\\\">#21152<\\/a>)<\\/li>\\n<li>New: Implemented Akismet Integration for enhanced spam protection and security in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11401\\\">#11401<\\/a>)<\\/li>\\n<li>New: Introducing Permissions functionality to Element Manager - providing users with enhanced control over access and management capabilities<\\/li>\\n<li>Tweak: Added styling option for dropdown indicator in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21907\\\">#21907<\\/a>)<\\/li>\\n<li>Tweak: Added additional size units and custom units in all elements<\\/li>\\n<li>Tweak: Implemented CSS logical properties in WordPress Menu widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Reviews widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Countdown widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor Editor<\\/li>\\n<li>Tweak: Updated <code>jquery.smartmenus.js<\\/code> version from 1.1.1 to 1.2.0<\\/li>\\n<li>Fix: Dynamic Background Image does not load on the first Loop Item in a Loop Grid (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21489\\\">#21489<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22368\\\">#22368<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23085\\\">#23085<\\/a>)<\\/li>\\n<li>Fix: History panel deprecation notices in console log<\\/li>\\n<li>Fix: Second Pro rollback installed the latest version instead of the specifically selected older version<\\/li>\\n<li>Fix: Incorrect position of the dropdown content when applying entrance animation in Menu Widget<\\/li>\\n<li>Fix: UX issues when using in-place editing in Menu widget<\\/li>\\n<li>Fix: Pagination with page reload is not working when used with the Taxonomy filter and Loop Grid widget in Archive template<\\/li>\\n<\\/ul>\\n<h4>3.18.2 - 2023-12-20<\\/h4>\\n<ul>\\n<li>Fix: Modified controls sanitization to enforce better security policies in Price List widget<\\/li>\\n<li>Fix: Error messages related to loop filter appear on front when using PHP 8.X and <code>WP_DEBUG<\\/code> is true<\\/li>\\n<\\/ul>\\n<h4>3.18.1 - 2023-12-06<\\/h4>\\n<ul>\\n<li>Fix: No results appeared when reloading the page with deep link and de-selecting terms in Taxonomy Filter widget<\\/li>\\n<li>Fix: No results appeared when filtering the Uncategorized category in Filter Taxonomy widget<\\/li>\\n<li>Fix: Notes still available when the Notes feature is deactivated<\\/li>\\n<\\/ul>\\n<h4>3.18.0 - 2023-12-04<\\/h4>\\n<ul>\\n<li>Tweak: Added the ability to upload files as attachments to emails in the File Upload field in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4868\\\">#4868<\\/a>)<\\/li>\\n<li>Tweak: Introduced the capability to design and edit the empty state in the Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/24261\\\">#24261<\\/a>)<\\/li>\\n<li>Tweak: Implemented the option to close the menu content area with a click anywhere on the screen in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22686\\\">#22686<\\/a>)<\\/li>\\n<li>Tweak: Improve scrolling behavior inside the content area when there is not enough space in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22712\\\">#22712<\\/a>)<\\/li>\\n<li>Tweak: Expanded breakpoint options in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22488\\\">#22488<\\/a>)<\\/li>\\n<li>Tweak: Added Logical Combination control in Taxonomy Filter widget<\\/li>\\n<li>Tweak: Added additional units to Horizontal and Vertical padding for Dropdown in WordPress Menu widget<\\/li>\\n<li>Tweak: Hide navigation arrows when there is only one slide in Loop Carousel and Carousel widgets<\\/li>\\n<li>Tweak: Added various HTML Tag controls in Video Playlist widget<\\/li>\\n<li>Tweak: Added responsive control to navigation size in Slides, Reviews, Media Carousel and Testimonial Carousel widgets<\\/li>\\n<li>Tweak: Added semantic <code>&lt;search&gt;<\\/code> wrapper in Search Form widget<\\/li>\\n<li>Tweak: Added semantic <code>&lt;search&gt;<\\/code> wrapper in Taxonomy Filter widget<\\/li>\\n<li>Tweak: Added Multiple Selection control in Taxonomy Filter widget<\\/li>\\n<li>Fix: Deprecated notice when using ${var} in strings instead of {$var} with PHP 8.2 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23927\\\">#23927<\\/a>)<\\/li>\\n<li>Fix: Dropdown indicator position issue in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23947\\\">#23947<\\/a>)<\\/li>\\n<li>Fix: Dynamic Tags are not available when choosing \'self-hosted\' source in Video widget<\\/li>\\n<li>Fix: Telephone field placeholder is aligned to the left in RTL websites in Form widget<\\/li>\\n<\\/ul>\\n<h4>3.17.1 - 2023-11-01<\\/h4>\\n<ul>\\n<li>Fix: Modified controls sanitization to enforce better security policies in Code Highlight, Form, Lottie, Price List, and Video Playlist widgets<\\/li>\\n<\\/ul>\\n<h4>3.17.0 - 2023-10-25<\\/h4>\\n<ul>\\n<li>Tweak: Added AJAX pagination option or seamless page navigation between content in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1284\\\">#1284<\\/a>)<\\/li>\\n<li>Tweak: Introduced Individual Pagination option when multiple Post widgets are on the same page, providing enhanced control over pagination<\\/li>\\n<li>Tweak: Introduced Individual Pagination option when multiple Loop Grid widgets are on the same page, providing enhanced control over pagination<\\/li>\\n<li>Tweak: Added a None option to the breakpoint options in Menu widget<\\/li>\\n<li>Tweak: Added a horizontal scrolling option in Menu widget<\\/li>\\n<li>Tweak: Upgraded minimum required PHP version to 7.3<\\/li>\\n<li>Tweak: Improved accessibility when minimize button is disabled in Table of Content widget<\\/li>\\n<li>Fix: Table of Content widget without icons displays <code>undefined<\\/code> error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17523\\\">#17523<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17768\\\">#17768<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18463\\\">#18463<\\/a>)<\\/li>\\n<li>Fix: Hover behavior issues on menu items in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23430\\\">#23430<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22431\\\">#22431<\\/a>)<\\/li>\\n<li>Fix: Links inside Loop Carousel are not working on initial load in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23705\\\">#23705<\\/a>)<\\/li>\\n<li>Fix: Popups accessible navigation adds outlines to the wrong first focusable element<\\/li>\\n<li>Fix: Dropdown area aligned to the left side of the screen if contains Tabs widget in Menu widget<\\/li>\\n<li>Fix: Content horizontal position not aligning correctly when used with carousel widgets in Menu widget<\\/li>\\n<li>Fix: Accessibility errors in PageSpeed Insights in Table of Contents widget<\\/li>\\n<\\/ul>\\n<h4>3.16.2 - 2023-09-20<\\/h4>\\n<ul>\\n<li>Fix: Fit to Content dropdown position calculation is incorrect in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23808\\\">#23808<\\/a>)<\\/li>\\n<li>Fix: Reverted hide navigation arrows when there is only one slide in the Loop or Nested carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23804\\\">#23804<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.16.1 - 2023-09-14<\\/h4>\\n<ul>\\n<li>Fix: Dynamic tag for ACF image field is not working as expected (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23757\\\">#23757<\\/a>)<\\/li>\\n<li>Fix: Sticky functionality affects padding values in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23758\\\">#23758<\\/a>)<\\/li>\\n<li>Fix: HTML list issues for padding and margin in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.16.0 - 2023-09-12<\\/h4>\\n<ul>\\n<li>Tweak: Implemented accessibility improvements in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23607\\\">#23607<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22554\\\">#22554<\\/a>)<\\/li>\\n<li>Fix: \'Fallback: Recent Posts\' option malfunctions in the Query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21436\\\">#21436<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23259\\\">#23259<\\/a>)<\\/li>\\n<li>Tweak: Hide navigation arrows when there is only one slide in the Loop or Nested carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22056\\\">#22056<\\/a>)<\\/li>\\n<li>Tweak: Used appropriate image <code>alt<\\/code> in Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17680\\\">#17680<\\/a>)<\\/li>\\n<li>Tweak: Optimized Scroll Snap functionality when using Container widget<\\/li>\\n<li>Tweak: Enhanced Elementor Role Manager functionality when using Containers<\\/li>\\n<li>Tweak: Added Notes feature to the Editor Top Bar<\\/li>\\n<li>Tweak: Replace CSS <code>float<\\/code> with other layouts in the Editor<\\/li>\\n<li>Tweak: Upgraded HTML Structure for the Menu widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Carousel and Menu widgets<\\/li>\\n<li>Tweak: Added keyboard accessibility to a link in Posts widget<\\/li>\\n<li>Tweak: Loop Builder feature merged to version<\\/li>\\n<li>Fix: Addressed inconsistency in hover effect durations between icon, dropdown indicator colors, and text colors in the Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22376\\\">#22376<\\/a>)<\\/li>\\n<li>Fix: Slides break if the parent container is set to HTML A tag in Loop Carousel and Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22678\\\">#22678<\\/a>)<\\/li>\\n<li>Fix: The icon size setting is not affecting uploaded SVG icons in the Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22372\\\">#22372<\\/a>)<\\/li>\\n<li>Fix: Taxonomy filter does not work with slug in foreign characters (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/23315\\\">#23315<\\/a>)<\\/li>\\n<li>Fix: Improved code security enforcement in Dynamic Tags<\\/li>\\n<li>Fix: Sticky container incorrectly adjusts its width when transitioning from a smaller breakpoint to a larger one within the Editor<\\/li>\\n<\\/ul>\\n<h4>3.15.1 - 2023-08-09<\\/h4>\\n<ul>\\n<li>Fix: Improved code security enforcement in Table of Contents widget<\\/li>\\n<\\/ul>\\n<h4>3.15.0 - 2023-07-31<\\/h4>\\n<ul>\\n<li>New: Introducing Taxonomy Filter widget - Empower visitors to seamlessly filter listings in Loop Grids based on taxonomies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3140\\\">#3140<\\/a>)<\\/li>\\n<li>Tweak: Added an &quot;Offset Sides&quot; functionality in Carousel and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21114\\\">#21114<\\/a>)<\\/li>\\n<li>Tweak: Modified the size of the Publish button in the Editor Top Bar feature (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22472\\\">#22472<\\/a>)<\\/li>\\n<li>Tweak: Improved Ajax permissions functionality for better security enforcement<\\/li>\\n<li>Tweak: Added option for pagination custom position in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added option for navigation custom position in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added additional styling options for navigation in Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Added labels to shortcode column in WordPress admin<\\/li>\\n<li>Tweak: Unified the appearance of <code>stretch<\\/code> and <code>center<\\/code> buttons in Menu widget<\\/li>\\n<li>Tweak: Unified the appearance of <code>stretch<\\/code> and <code>center<\\/code> buttons in My Account widget<\\/li>\\n<li>Tweak: Improved panel UI in Video Playlist widget<\\/li>\\n<li>Tweak: Implemented CSS logical properties in Elementor Editor<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Price List widget<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Slides widget<\\/li>\\n<li>Tweak: Added &quot;Title HTML Tag&quot; and &quot;Description HTML Tag&quot; in Flip Box widget<\\/li>\\n<li>Tweak: Added &quot;Description HTML Tag&quot; in Call To Action widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Share Buttons widget<\\/li>\\n<li>Security Fix: Improved code security enforcement in Form widget<\\/li>\\n<li>Fix: WooCommerce Status page failed to recognize Elementor WooCommerce widgets<\\/li>\\n<li>Fix: Pagination does not work inside single templates when using Posts and Loop Grid widgets<\\/li>\\n<li>Fix: Incorrect saving of WooCommerce page settings in Elementor site settings under certain scenarios<\\/li>\\n<\\/ul>\\n<h4>3.14.1 - 2023-06-26<\\/h4>\\n<ul>\\n<li>Tweak: Improved navigation on touch devices in Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22827\\\">#22827<\\/a>)<\\/li>\\n<li>Fix: Missing navigation arrows on lightbox in Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22870\\\">#22870<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.14.0 - 2023-06-19<\\/h4>\\n<ul>\\n<li>New: Introducing Carousel widget - Infinite design possibilities, and nesting capabilities (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2587\\\">#2587<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/219\\\">#219<\\/a>)<\\/li>\\n<li>Tweak: Added Static Item Position functionality to Alternate template in Loop Grid widget<\\/li>\\n<li>Tweak: Added visual indication of Page Parts<\\/li>\\n<li>Tweak: Added dividers option between menu items in Menu widget<\\/li>\\n<li>Tweak: Changed the HTML structure of Pagination and Navigation in Loop Carousel and Nested Carousel widgets<\\/li>\\n<li>Tweak: Added shop page in WooCommerce Pages section in Site Settings<\\/li>\\n<li>Tweak: Added Text Shadow, Box Shadow and Padding control to button in Call to Action widget<\\/li>\\n<li>Tweak: Added Lazy Load support for images in Video Playlist widget<\\/li>\\n<li>Tweak: Added <code>alt<\\/code> attribute to images in Video Playlist widget<\\/li>\\n<li>Tweak: Replaced select control with choose control for Flip Direction control in Flip Box widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to Carousel and Loop Carousel widgets<\\/li>\\n<li>Tweak: Use <code>media_types<\\/code> array in Media controls<\\/li>\\n<li>Fix: Lightbox is still enabled after disabling it in the Site Settings in Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11193\\\">#11193<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19871\\\">#19871<\\/a>)<\\/li>\\n<li>Fix: Responsive settings for templates don\'t work as expected when Additional Custom Breakpoints feature is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16819\\\">#16819<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19394\\\">#19394<\\/a>)<\\/li>\\n<li>Fix: Inner containers are not presented as expected in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21813\\\">#21813<\\/a>)<\\/li>\\n<li>Fix: Popup width does not support percentages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22413\\\">#22413<\\/a>)<\\/li>\\n<li>Fix: PHP 8.x throws errors when using WooCommerce Ajax response (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22199\\\">#22199<\\/a>)<\\/li>\\n<li>Fix: Mini cart template appears as empty in various scenarios in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22789\\\">#22789<\\/a>)<\\/li>\\n<li>Fix: Order by Price doesn\'t work for the Latest products or Manual Selection in Products widget<\\/li>\\n<li>Fix: Dropdown indicator icon is not vertically aligned to the text when using icon in Menu Widget<\\/li>\\n<li>Fix: Mixed content warning in the console for Video Playlist widget<\\/li>\\n<li>Fix: Preview settings are not presented as expected after first save in Loop Template<\\/li>\\n<li>Fix: Not-crawlable link error in Video Playlist widget<\\/li>\\n<li>Fix: Lightbox is still enabled after disabling it in the Site Settings in Logo widget<\\/li>\\n<li>Fix: Focus state issue on page load when using Table of Content widget<\\/li>\\n<\\/ul>\\n<h4>3.13.2 - 2023-05-22<\\/h4>\\n<ul>\\n<li>Fix: Hover settings not working as expected on Touch-Enabled devices in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22258\\\">#22258<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.13.1 - 2023-05-11<\\/h4>\\n<ul>\\n<li>Security Fix: Addressed security weaknesses in access management related functions<\\/li>\\n<li>Fix: Excerpt content pulled from post content is showing with HTML tags in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22367\\\">#22367<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.13.0 - 2023-05-08<\\/h4>\\n<ul>\\n<li>Tweak: Provided an option to assign excerpt automatically from post content in Post Excerpt dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20256\\\">#20256<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21715\\\">#21715<\\/a>)<\\/li>\\n<li>Tweak: Added Display Conditions functionality in Editor Top bar (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21675\\\">#21675<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/22050\\\">#22050<\\/a>)<\\/li>\\n<li>Tweak: Removed <code>elementor_page_id<\\/code> from request URLs in the WC AJAX calls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18675\\\">#18675<\\/a>)<\\/li>\\n<li>Tweak: Added icons to menu items in Mega Menu widget (<a href=\\\"https:\\/\\/github.com\\/orgs\\/elementor\\/discussions\\/21602\\\">#21602<\\/a>)<\\/li>\\n<li>Tweak: Added keyboard accessibility to Toggle Button in WordPress Menu widget (<a href=\\\"https:\\/\\/github.com\\/orgs\\/elementor\\/discussions\\/2348\\\">#2348<\\/a>)<\\/li>\\n<li>Tweak: Added \'Active item state\' to top-level menu items for anchor links in the Menu widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Loop Carousel widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Slides widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to navigation arrows in Media, Testimonial and Reviews Carousel widgets<\\/li>\\n<li>Tweak: Added keyboard accessibility to Table of Content widget<\\/li>\\n<li>Tweak: Added keyboard accessibility to Search Form widget<\\/li>\\n<li>Tweak: Added accessibility to images in Slides widget<\\/li>\\n<li>Tweak: Added accessibility to images in Call To Action widget<\\/li>\\n<li>Tweak: Added accessibility to images in Media Carousel widget<\\/li>\\n<li>Tweak: Added accessibility to images in Gallery widget<\\/li>\\n<li>Tweak: Added Lazy Load support for avatar image in Post Info widget<\\/li>\\n<li>Tweak: Added Lazy Load support to various Elementor Editor and Admin images<\\/li>\\n<li>Tweak: Added Lazy Load support for author image in Author Box widget<\\/li>\\n<li>Tweak: Added Lazy Load support for images in Price List widget<\\/li>\\n<li>Fix: Content width is affected by the widget\'s width when Content Width is set to Fit to Content in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21842\\\">#21842<\\/a>)<\\/li>\\n<li>Fix: Empty value on Rows field causes an error in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21451\\\">#21451<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.12.2 - 2023-04-09<\\/h4>\\n<ul>\\n<li>Fix: Mini cart template appears as empty in various WordPress themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21836\\\">#21836<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.12.1 - 2023-04-02<\\/h4>\\n<ul>\\n<li>Fix: Default background colors are presented as transparent in Popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21824\\\">#21824<\\/a>)<\\/li>\\n<li>Fix: Reverted the tweak of Form Submissions feature merged to the version (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21821\\\">#21821<\\/a>)<\\/li>\\n<li>Fix: Dropdown area is not closing when hovering outside of the content area in Menu widget<\\/li>\\n<\\/ul>\\n<h4>3.12.0 - 2023-03-29<\\/h4>\\n<ul>\\n<li>New: Introducing the Mega Menu with the new Menu widget - empowers you to achieve a much higher level of menu design, customization, and creativity<\\/li>\\n<li>New: Diversify your design with a Loop Alternate template - apply another template within your Loop Grid for design creativity<\\/li>\\n<li>New: Kickstart your workflow with predesigned Loop container-based templates<\\/li>\\n<li>Tweak: Added custom icon controls to various locations in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13678\\\">#13678<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17941\\\">#17941<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19295\\\">#19295<\\/a>)<\\/li>\\n<li>Tweak: Added a spacing control between navigation and slides in the Loop Carousel<\\/li>\\n<li>Tweak: Added responsive control to the \'Gap between slides\' control in the Loop Carousel<\\/li>\\n<li>Tweak: Added Custom CSS section in Loop Item template<\\/li>\\n<li>Tweak: Added an Article class metadata in Loop Item template<\\/li>\\n<li>Tweak: Added Lazy Load support for background images in CTA widget when using the Lazy Load Background Images experiment<\\/li>\\n<li>Tweak: Added Lazy Load support for background images in Flipbox widget when using the Lazy Load Background Images experiment<\\/li>\\n<li>Tweak: Added additional size units and custom units in all elements<\\/li>\\n<li>Tweak: Changed Nav Menu widget name to WordPress Menu widget<\\/li>\\n<li>Tweak: Added &quot;Form Validation&quot; control to Form widget<\\/li>\\n<li>Tweak: Updated custom messages in the Form widget<\\/li>\\n<li>Tweak: Improved accessibility in various elements in Gallery widget<\\/li>\\n<li>Tweak: Form Submissions feature merged to version<\\/li>\\n<li>Tweak: Loop feature promoted to Stable status<\\/li>\\n<li>Tweak: Page Transitions feature promoted to Stable status<\\/li>\\n<li>Tweak: Improved accessibility in filter bar in Gallery widget<\\/li>\\n<li>Tweak: Remove unused <code>aspect-ratio-*<\\/code> CSS classes<\\/li>\\n<li>Fix: Not all active breakpoints appear under &quot;Advanced Rules&quot; in popup publish settings (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17020\\\">#17020<\\/a>)<\\/li>\\n<li>Fix: Dynamic background image and video is not working with ACF in Loop Grid widget<\\/li>\\n<\\/ul>\\n<h4>3.11.7 - 2023-03-22<\\/h4>\\n<ul>\\n<li>Tweak: Improved code security enforcement in WooCommerce components<\\/li>\\n<\\/ul>\\n<h4>3.11.6 - 2023-03-14<\\/h4>\\n<ul>\\n<li>Tweak: Improved code security enforcement in Author Box and Countdown widgets<\\/li>\\n<\\/ul>\\n<h4>3.11.5 - 2023-03-12<\\/h4>\\n<ul>\\n<li>Fix: Hamburger Menu Toggle not showing if breakpoint is set to Tablet Extra in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21003\\\">#21003<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.11.4 - 2023-03-07<\\/h4>\\n<ul>\\n<li>Tweak: Prevented SVG file upload for better security enforcement in Forms widget<\\/li>\\n<\\/ul>\\n<h4>3.11.3 - 2023-02-26<\\/h4>\\n<ul>\\n<li>Fix: Error message appears when submitting a form placed below Loop Grid and Loop Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21432\\\">#21432<\\/a>)<\\/li>\\n<li>Fix: PHP 8.x compatibility issues in various places<\\/li>\\n<\\/ul>\\n<h4>3.11.2 - 2023-02-22<\\/h4>\\n<ul>\\n<li>Fix: Save &amp; Back handle becomes inaccessible in various scenarios cases in Loop Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21316\\\">#21316<\\/a>)<\\/li>\\n<li>Fix: Can\'t edit page when using \'Content Tabs\' and \'Section\' options in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.11.1 - 2023-02-15<\\/h4>\\n<ul>\\n<li>Fix: Featured Image dynamic tag is not working in Background images (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21313\\\">#21313<\\/a>)<\\/li>\\n<li>Fix: Time zone is not correct in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17485\\\">#17485<\\/a>)<\\/li>\\n<li>Fix: File upload field is not working in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21341\\\">#21341<\\/a>)<\\/li>\\n<li>Fix: Post Image Attachments dynamic tag is not working in various widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21314\\\">#21314<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.11.0 - 2023-02-13<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Carousel widget - Create powerful &amp; repeating loop templates and populate each one with dynamic content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/219\\\">#219<\\/a>)<\\/li>\\n<li>New: Added Date and Time Range option to Advanced Rules in Popup<\\/li>\\n<li>Tweak: Improved accessibility when opening and closing a popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9788\\\">#9788<\\/a>)<\\/li>\\n<li>Tweak: Improved accessibility of full-screen mode in Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19907\\\">#19907<\\/a>)<\\/li>\\n<li>Tweak: Added keyboard accessibility support to Flip Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5861\\\">#5861<\\/a>)<\\/li>\\n<li>Tweak: Add <code>aria-label<\\/code> to read more link in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13784\\\">#13784<\\/a>)<\\/li>\\n<li>Tweak: Use <code>aspect-ratio<\\/code> property instead of CSS trick in Media Carousel widget<\\/li>\\n<li>Tweak: Updated translation string in Stripe widget<\\/li>\\n<li>Fix: Masonry and Columns controls are not working as expected with responsive in Posts and Loop Grid widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20670\\\">#20670<\\/a>)<\\/li>\\n<li>Fix: Invalid attributes names in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17400\\\">#17400<\\/a>)<\\/li>\\n<li>Fix: Post Image Attachments dynamic tag is not working as expected in various widgets<\\/li>\\n<li>Fix: Form fields order is not presented correctly when exported to CSV in Form Submissions<\\/li>\\n<li>Fix: Dynamic background image and video are not working with ACF in Loop Grid widget<\\/li>\\n<\\/ul>\\n<h4>3.10.3 - 2023-01-29<\\/h4>\\n<ul>\\n<li>Tweak: Added introduction video to loop item information modal in Theme Builder<\\/li>\\n<li>Fix: PHP 8.x throws errors and notices in some cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/21087\\\">#21087<\\/a>)<\\/li>\\n<li>Fix: Infinite Scroll and Load on click pagination are not working as expected in Archive template<\\/li>\\n<li>Fix: Show row even when values do not exist in Form Submissions<\\/li>\\n<\\/ul>\\n<h4>3.10.2 - 2023-01-17<\\/h4>\\n<ul>\\n<li>Fix: Updated compatibility tag for Elementor v3.10<\\/li>\\n<\\/ul>\\n<h4>3.10.1 - 2023-01-09<\\/h4>\\n<p>Fix: Preview Could not be loaded error message appears on pages containing the Loop Grid in a header or footer templates<\\/p>\\n<h4>3.10.0 - 2023-01-09<\\/h4>\\n<ul>\\n<li>New: Added new dynamic tag for due date in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7737\\\">#7737<\\/a>)<\\/li>\\n<li>Tweak: Added <code>modified<\\/code> and <code>comment_count<\\/code> to Order By in posts query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11159\\\">#11159<\\/a>)<\\/li>\\n<li>Tweak: Replaced <code>footer<\\/code> tag in Blockquote and Comments widgets for better semantics<\\/li>\\n<li>Fix: Compatibility issue in Imagify Media Library filters due to <code>_elementor_is_screenshot<\\/code> meta filter (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19988\\\">#19988<\\/a>)<\\/li>\\n<li>Fix: Hotspot Widget label icon height issues when Inline Font Icons experiment is active<\\/li>\\n<li>Fix: Editing glitch when using two loop grid widgets on the same page with the same loop item template<\\/li>\\n<li>Fix: Equal height is not working when using sections in Loop Grid widget<\\/li>\\n<li>Fix: Large amount of menu items are not appearing correctly on a mobile device in Nav Menu widget<\\/li>\\n<li>Fix: Featured Image does not change dynamically when using infinite\\/click pagination in Loop Grid widget<\\/li>\\n<li>Fix: Removed action call of non-existent <code>display_empty_cart_template()<\\/code> method in Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.9.2 - 2022-12-21<\\/h4>\\n<ul>\\n<li>Fix: JS events do not trigger in Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20708\\\">#20708<\\/a>)<\\/li>\\n<li>Fix: PHP Errors appear when not using the toggle menu in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18636\\\">#18636<\\/a>)<\\/li>\\n<li>Fix: Popups\' backgrounds disappear when using Lazy Load Background Images experiment<\\/li>\\n<\\/ul>\\n<h4>3.9.1 - 2022-12-14<\\/h4>\\n<ul>\\n<li>Fix: WooCommerce Product Gallery dynamic tag is not working in Basic Gallery, Gallery and Image Carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20678\\\">#20678<\\/a>)<\\/li>\\n<li>Fix: Hide Empty option is not working in Menu Cart widget<\\/li>\\n<li>Fix: The Stripe Button widget doesn\'t work in Templates<\\/li>\\n<\\/ul>\\n<h4>3.9.0 - 2022-12-06<\\/h4>\\n<ul>\\n<li>New: Added support for WooCommerce to Loop Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20020\\\">#20020<\\/a>)<\\/li>\\n<li>Tweak: Added more options to \'Show up to X times\' advanced rule in Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8187\\\">#8187<\\/a>)<\\/li>\\n<li>Tweak: Allow saving and reloading a page while editing in-place loop item template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19882\\\">#19882<\\/a>)<\\/li>\\n<li>Tweak: Added <code>$location param<\\/code> to <code>elementor\\/theme\\/get_location_templates\\/template_id<\\/code> hook (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18453\\\">#18453<\\/a>)<\\/li>\\n<li>Tweak: Removed redundant labels from group controls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11666\\\">#11666<\\/a>)<\\/li>\\n<li>Tweak: Added support to use sections and columns as the layout structure of a Loop item template<\\/li>\\n<li>Tweak: Disabled movement when a repeater item is in focus in edit mode<\\/li>\\n<li>Tweak: Upgrade the autoprefixer package to better minify CSS files<\\/li>\\n<li>Tweak: Removed duplicate SQL queries on every page for better performance<\\/li>\\n<li>Tweak: Improved License validation mechanism to avoid limitations<\\/li>\\n<li>Tweak: Added more units options to Border Width control in various elements<\\/li>\\n<li>Tweak: Added <code>em<\\/code> units to Border Radius control in various elements<\\/li>\\n<li>Tweak: Added \'Equal height\' functionality to Loop Grid widget<\\/li>\\n<li>Fix: Issue with Related Products widget and WooCommerce Pixel Manager plugin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16934\\\">#16934<\\/a>)<\\/li>\\n<li>Fix: My Account widget gets hidden when using a single page template with post content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19627\\\">#19627<\\/a>)<\\/li>\\n<li>Fix: Cart is not updated when cache enabled in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19312\\\">#19312<\\/a>)<\\/li>\\n<li>Fix: Entrance animations are not working as expected with Infinite Loop and Load on CLick pagination in Loop Grid widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20293\\\">#20293<\\/a>)<\\/li>\\n<li>Fix: Loading page issues in Form Submissions screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19973\\\">#19973<\\/a>)<\\/li>\\n<li>Fix: Recently Edited date and time not working as expected in Elementor Overview plugin in WordPress dashboard (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17966\\\">#17966<\\/a>)<\\/li>\\n<li>Fix: Recurring license mismatch error message when using translators plugins<\\/li>\\n<li>Fix: Submenu items triggers page transition instead of opening in Nav Menu widget<\\/li>\\n<li>Fix: Query values of Posts widget are not imported correctly when importing a Kit<\\/li>\\n<li>Fix: Loop items are exceeding the widget boundaries in Loop Grid widget<\\/li>\\n<li>Fix: Order by option is not working as expected when choosing Upsells, Cross-Sells and Related Products query in Products widget<\\/li>\\n<li>Fix: Various widgets disappear in certain scenarios when choosing direction Row or Column in Container<\\/li>\\n<\\/ul>\\n<h4>3.8.2 - 2022-11-20<\\/h4>\\n<ul>\\n<li>Fix: Z-index issues when applying sticky to Container<\\/li>\\n<li>Fix: Error message appears on front with Editor and Shop Manager roles when using the Loop Builder widget<\\/li>\\n<\\/ul>\\n<h4>3.8.1 - 2022-11-06<\\/h4>\\n<ul>\\n<li>Fix: Sticky inner section is not staying in the column when applying sticky option in Sections (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20203\\\">#20203<\\/a>)<\\/li>\\n<li>Fix: Post Title widget located in a loop item template disappears when enabling the hide title option inside page settings (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20207\\\">#20207<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20255\\\">#20255<\\/a>)<\\/li>\\n<li>Fix: ACF Dynamic data not rendering correctly in various scenarios (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20235\\\">#20235<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20258\\\">#20258<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20277\\\">#20277<\\/a>)<\\/li>\\n<li>Fix: Z-index issues when applying sticky to Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/20227\\\">#20227<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.8.0 - 2022-10-30<\\/h4>\\n<ul>\\n<li>New: Introducing Loop Builder as a beta status experiment - Create powerful &amp; repeating loop templates and populate each one with dynamic content and design flexibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4440\\\">#4440<\\/a>)<\\/li>\\n<li>Tweak: Add <code>wp_body_open()<\\/code> to header in Header template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11562\\\">#11562<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15828\\\">#15828<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13089\\\">#13089<\\/a>)<\\/li>\\n<li>Tweak: Added support border-radius option to the Code Highlight widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14316\\\">#14316<\\/a>)<\\/li>\\n<li>Tweak: Import\\/Export CLI and UI mechanisms were merged into a unified service<\\/li>\\n<li>Tweak: User with no permission to Notes cannot be mentioned in a note<\\/li>\\n<li>Tweak: User with no permission to view a post cannot be mentioned in a note<\\/li>\\n<li>Tweak: Notes was added to the right click context-menu<\\/li>\\n<li>Tweak: Notes panel can be resizable<\\/li>\\n<li>Tweak: Notes panel can be dragged outside of the canvas in responsive mode in the editor<\\/li>\\n<li>Tweak: Updated form validation messages translation strings in Form widget<\\/li>\\n<li>Tweak: Updated translators comments<\\/li>\\n<li>Tweak: Theme Builder logo and Title should be clickable<\\/li>\\n<li>Tweak: Reduced API requests and DB calls on non-write setup<\\/li>\\n<li>Tweak: Added media queries to the Table of Contents widget<\\/li>\\n<li>Fix: Sticky option is not working as expected in various scenarios in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18357\\\">#18357<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19540\\\">#19540<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19618\\\">#19618<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19777\\\">#19777<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19827\\\">#19827<\\/a>)<\\/li>\\n<li>Fix: Mixed Content errors on HTTPS in Video Playlist Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18895\\\">#18895<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18945\\\">#18945<\\/a>)<\\/li>\\n<li>Fix: Note\'s timestamp is being updated according to the last activity in Notes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19123\\\">#19123<\\/a>)<\\/li>\\n<li>Fix: Accessibility attribute <code>role=navigation<\\/code> is redundant in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17582\\\">#17582<\\/a>)<\\/li>\\n<li>Fix: Accessibility attribute <code>role=navigation<\\/code> is redundant in pagination in Posts widget<\\/li>\\n<li>Fix: Share buttons is accessible with keyboard but not clickable<\\/li>\\n<li>Fix: Sub-items icons style is missing in preview with Inline Font Icons experiment in Nav Menu widget<\\/li>\\n<li>Fix: Quotes are appearing as HTML when editing a note in Notes<\\/li>\\n<li>Fix: Label\'s Icon height increases when Inline Font Icons experiment is active in Hotspot Widget<\\/li>\\n<li>Fix: Sub conditions of templates are not overridden when importing a Kit<\\/li>\\n<li>Fix: X\\/Y Anchor Point controls were not visible for Scale and Rotate effects<\\/li>\\n<li>Fix: PHP warning notice appears in some situations when using motion effects<\\/li>\\n<\\/ul>\\n<h4>3.7.7 - 2022-09-20<\\/h4>\\n<ul>\\n<li>Fix: Default Flex Grow affects the layout when the container is set to direction Column in various widgets<\\/li>\\n<\\/ul>\\n<h4>3.7.6 - 2022-09-14<\\/h4>\\n<ul>\\n<li>Fix: Submissions menu item appears at the bottom of Elementor section in WordPress dashboard<\\/li>\\n<\\/ul>\\n<h4>3.7.5 - 2022-08-31<\\/h4>\\n<ul>\\n<li>Fix: Error message appears on front if WooCommerce is activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19553\\\">#19553<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.7.4 - 2022-08-29<\\/h4>\\n<ul>\\n<li>Tweak: PHP 5.6 Is deprecated<\\/li>\\n<li>Fix: Triangle icon is not being displayed in the Select field when Inline Font Icons Experiment is active in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18598\\\">#18598<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/19495\\\">#19495<\\/a>)<\\/li>\\n<li>Fix: The page jumps or flickers to the video playlist on page reload in Video Playlist Widget<\\/li>\\n<\\/ul>\\n<h4>3.7.3 - 2022-07-31<\\/h4>\\n<ul>\\n<li>Tweak: Improved license mechanism for correct validation<\\/li>\\n<li>Fix: Sticky option causes unexpected results when using the Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18357\\\">#18357<\\/a>)<\\/li>\\n<li>Fix: Price list, Portfolio, Flip Box and Gallery widgets disappear when the direction is set to column in Container (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18880\\\">#18880<\\/a>)<\\/li>\\n<li>Fix: Quotes character is showing up as <code>&amp;quot;<\\/code> when editing a note in Notes<\\/li>\\n<\\/ul>\\n<h4>3.7.2 - 2022-06-15<\\/h4>\\n<ul>\\n<li>Tweak: Applied optimized file handling in various modules<\\/li>\\n<li>Fix: Related posts query options are missing in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18633\\\">#18633<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18641\\\">#18641<\\/a>)<\\/li>\\n<li>Fix: Menu Cart Icon is not being displayed on all browsers when Inline Font Icons Experiment is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17705\\\">#17705<\\/a>)<\\/li>\\n<li>Fix: Gallery widget is not working as expected in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18408\\\">#18408<\\/a>)<\\/li>\\n<li>Fix: Flip box is not visible when the direction is set to Row in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18413\\\">#18413<\\/a>)<\\/li>\\n<li>Fix: Portfolio widget is not visible when dragged into &quot;Row&quot; direction Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17653\\\">#17653<\\/a>)<\\/li>\\n<li>Fix: Menu cart is open automatically in Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18629\\\">#18629<\\/a>)<\\/li>\\n<li>Fix: PHP error is being shown the license is expired in License screen<\\/li>\\n<\\/ul>\\n<h4>3.7.1 - 2022-05-16<\\/h4>\\n<ul>\\n<li>Fix: Notes icon appears as an empty square in admin top bar for users with permissions lower than Editor<\\/li>\\n<li>Fix: Notes experiment causes a PHP fatal error on some cases<\\/li>\\n<li>Fix: UI glitches in Notes feature<\\/li>\\n<\\/ul>\\n<h4>3.7.0 - 2022-05-10<\\/h4>\\n<ul>\\n<li>New: Introducing Notes - Work collaboratively directly within Elementor<\\/li>\\n<li>New: Stripe Button widget - Collect Stripe payments directly from your site (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14748\\\">#14748<\\/a>)<\\/li>\\n<li>New: Meet WooCommerce Add to Cart dynamic tag - add products to cart from every widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10607\\\">#10607<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11801\\\">#11801<\\/a>)<\\/li>\\n<li>New: Added WooCommerce Product Content dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16367\\\">#16367<\\/a>)<\\/li>\\n<li>Tweak: Added Related, Upsells and Cross-Sells query sources to Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8071\\\">#8071<\\/a>)<\\/li>\\n<li>Tweak: Added custom icon control to Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18007\\\">#18007<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14357\\\">#14357<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13151\\\">#13151<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11361\\\">#11361<\\/a>)<\\/li>\\n<li>Tweak: Added an option to minimize on Desktop device in Table of Contents widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9933\\\">#9933<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10729\\\">#10729<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10314\\\">#10314<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6327\\\">#6327<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6691\\\">#6691<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11774\\\">#11774<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9051\\\">#9051<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6327\\\">#6327<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag controls to Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5760\\\">#5760<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9774\\\">#9774<\\/a>)<\\/li>\\n<li>Tweak: Added align button to bottom option in various Product widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10263\\\">#10263<\\/a>)<\\/li>\\n<li>Tweak: Added align button to bottom control in Posts and Archive Posts widgets<\\/li>\\n<li>Tweak: Added the ability to hide and show the coupon section in WooCommerce Cart widget<\\/li>\\n<li>Tweak: Added the ability to hide and show the coupon section in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added alignment option to various buttons in WooCommerce Cart widget<\\/li>\\n<li>Tweak: Added alignment option to various buttons in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added percentage unit to padding control in Additional Information customize section in WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added quick link to create new theme parts directly from the Finder<\\/li>\\n<li>Tweak: Added the option to add a custom template to Dashboard screen in My Account widget<\\/li>\\n<li>Tweak: Added spacing control to view cart button in various product widgets<\\/li>\\n<li>Tweak: Added the option to add a custom template to empty cart state in Cart widget<\\/li>\\n<li>Tweak: Adjusted the layout of the Payment Methods screen in the My Account widget<\\/li>\\n<li>Tweak: Added lazy load option to Media Carousel, Reviews and Testimonial Carousel widgets<\\/li>\\n<li>Tweak: Added Site Identity quick link to Logo widget<\\/li>\\n<li>Tweak: Added Site Identity quick link to Site Title widget<\\/li>\\n<li>Tweak: Created an attribute that allows disabling page transition for specific links<\\/li>\\n<li>Tweak: Added dynamic tag controls to Gallery widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Countdown widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Portfolio widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Price Table widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Login widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Blockquote widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Facebook Comments widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Post Navigation widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Search Form widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Author Box widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Post info widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Archive Posts widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Product Meta widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Archive Products widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Sitemap widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Reviews widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to Code Highlight widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to PayPal Button widget<\\/li>\\n<li>Tweak: Added dynamic tag controls to WooCommerce Checkout widget<\\/li>\\n<li>Tweak: Added missing PHP documentation to hooks<\\/li>\\n<li>Fix: Scrolling glitches on mobile devices when Sticky Effect is enabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17767\\\">#17767<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18330\\\">#18330<\\/a>)<\\/li>\\n<li>Fix: Only 1st honypot field is validated when using multiple honeypot fields in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18136\\\">#18136<\\/a>)<\\/li>\\n<li>Fix: Checkout button background color is not working as expected in Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18289\\\">#18289<\\/a>)<\\/li>\\n<li>Fix: Button labels are not accessible for screen readers in Share buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8615\\\">#8615<\\/a>)<\\/li>\\n<li>Fix: Downloads titles controls are not working in responsive in WooCommerce Purchase Summary widget<\\/li>\\n<li>Fix: Excerpt length is not working as expected in Posts and Archive Posts widgets<\\/li>\\n<li>Fix: Titles &amp; Totals weight is not working in WooCommerce Checkout widget<\\/li>\\n<li>Fix: Product image is not appearing on Single Product Page on template load<\\/li>\\n<li>Fix: Additional Information title not editable in some scenarios in WooCommerce Checkout widget<\\/li>\\n<li>Fix: Cart is not updating automatically on mobile in Cart widget<\\/li>\\n<li>Fix: UI Glitch in Masonry control in Portfolio widget<\\/li>\\n<li>Fix: Custom breakpoints experiment didn\'t work on Single post and page templates<\\/li>\\n<li>Fix: Testimonial carousel &amp; Reviews widgets disregards the <code>alt<\\/code> attribute<\\/li>\\n<li>Fix: Playlist widget deeplink didn\'t send user directly to the widget in the page<\\/li>\\n<li>Fix: Masonry option causes the images to disappear in the Editor in Posts widget<\\/li>\\n<li>Fix: Scrollbar appears after clicking on the dropdown toggle in Nav Menu widget<\\/li>\\n<li>Fix: Custom icons disappear on frontend if the pack name contains numbers<\\/li>\\n<li>Fix: Custom Font disappears if the name contains only numbers<\\/li>\\n<li>Fix: <code>end-section()<\\/code> is missing from Progress Tracker and Facebook Embed widgets<\\/li>\\n<li>Tweak: Added a filter for conditions cache query in Theme Builder<\\/li>\\n<li>Fix: Customizations lost on Ajax refresh in WooCommerce Cart widget<\\/li>\\n<li>Fix: Hello theme Header and Footer experiment is not working when WooCommerce plugin is active<\\/li>\\n<li>Fix: Color controls are not working as expected in Checkout widget<\\/li>\\n<li>Fix: Color controls are not working as expected in My Account widget<\\/li>\\n<li>Fix: Empty state widget preview in the editor is disappearing in various widgets<\\/li>\\n<li>Fix: Cart is not updating automatically on mobile in WooCommerce Cart widget<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-7-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.6.5 - 2022-04-12<\\/h4>\\n<ul>\\n<li>Fix: Compatibility issues for several widgets in iOS 14 and macOS 13 devices (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18090\\\">#18090<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15910\\\">#15910<\\/a>)<\\/li>\\n<li>Fix: Button Alignment doesn\'t work in Custom Add To Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17810\\\">#17810<\\/a>)<\\/li>\\n<li>Fix: PHP warning is thrown in some cases in PayPal button widget<\\/li>\\n<li>Fix: PHP 8.1 throws errors and notices in some cases<\\/li>\\n<li>Fix: PHP notice was thrown when Kit Import process initiated without display conditions<\\/li>\\n<li>Fix: Create Account button always opens on the Sign Up screen even if the user has an account in Onboarding process<\\/li>\\n<\\/ul>\\n<h4>3.6.4 - 2022-03-15<\\/h4>\\n<ul>\\n<li>Tweak: Kit import dynamic reference support for templates and dynamic tags<\\/li>\\n<li>Tweak: Updated tested up to version tag to <code>3.6.0<\\/code><\\/li>\\n<li>Fix: Sticky caused scrolling issues after clicking an element that expands the page height (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17821\\\">#17821<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17839\\\">#17839<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18069\\\">#18069<\\/a>)<\\/li>\\n<li>Fix: When saving Global widget JS error is being thrown and editor fails to load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17954\\\">#17954<\\/a>)<\\/li>\\n<li>Fix: Motion effects are missing from Background section under Style tab in Container element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/18063\\\">#18063<\\/a>)<\\/li>\\n<li>Fix: Imported Kit doesn\'t appear in the theme builder after successful import in some cases<\\/li>\\n<li>Fix: Added future Pro support to fix the Cart icon that shifted aside in Menu cart widget<\\/li>\\n<\\/ul>\\n<h4>3.6.3 - 2022-02-28<\\/h4>\\n<ul>\\n<li>Fix: Custom Code display conditions modal is not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17865\\\">#17865<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17942\\\">#17942<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17994\\\">#17994<\\/a>)<\\/li>\\n<li>Fix: Share buttons are not accessible for keyboard navigation (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8615\\\">#8615<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.6.2 - 2022-02-14<\\/h4>\\n<ul>\\n<li>Fix: Auto updates mechanism is not working as expected (this version might be also installed automatically)<\\/li>\\n<\\/ul>\\n<h4>3.6.1 - 2022-02-09<\\/h4>\\n<ul>\\n<li>Tweak: Allow connecting via generic source for future feature support<\\/li>\\n<li>Fix: Custom Code doesn\'t work when WooCommerce is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17675\\\">#17675<\\/a>)<\\/li>\\n<li>Fix: Content animation didn\'t work when Improved asset loading experiment is active Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17055\\\">#17055<\\/a>)<\\/li>\\n<li>Fix: PHP warning appears some times when trying to force-check for available updates<\\/li>\\n<li>Fix: Page transitions are being triggered when not needed<\\/li>\\n<li>Fix: Text alignment on Tablet responsive device affects base device in Testimonial Carousel widget<\\/li>\\n<li>Fix: Harden Submissions feature to prevent potential security issues<\\/li>\\n<li>Fix: Page Transitions Icon option Preloader doesn\'t work on frontend<\\/li>\\n<\\/ul>\\n<h4>3.6.0 - 2022-01-31<\\/h4>\\n<ul>\\n<li>New: WooCommerce Purchase Summary widget - Fully customize the content and style of your order summary page (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5756\\\">#5756<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15862\\\">#15862<\\/a>)<\\/li>\\n<li>New: WooCommerce Notices styling on Site Settings - Customize the appearance of WooCommerce notices (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14570\\\">#14570<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15896\\\">#15896<\\/a>)<\\/li>\\n<li>New: WooCommerce Notices widget - Set the position of WooCommerce notices on your shop pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8124\\\">#8124<\\/a>)<\\/li>\\n<li>Experiment: Page Transitions - Customize the page loading experience, and increase brand recognition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10576\\\">#10576<\\/a>)<\\/li>\\n<li>Tweak: Added WooCommerce &amp; Theme Elements widgets to Improved CSS Loading experiment to save up 126KB per page load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17412\\\">#17412<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17337\\\">#17337<\\/a>)<\\/li>\\n<li>Tweak: Added new layout options in WooCommerce Add To Cart and WooCommerce Custom Add To Cart widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5437\\\">#5437<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10617\\\">#10617<\\/a>)<\\/li>\\n<li>Tweak: Added Stroke functionality for typography control in various widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11158\\\">#11158<\\/a>)<\\/li>\\n<li>Tweak: Removed <code>elementor-section-wrap<\\/code> by adding it to the Optimized DOM Output experiment (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16950\\\">#16950<\\/a>)<\\/li>\\n<li>Tweak: Added style controls for variations in WooCommerce Menu Cart widget<\\/li>\\n<li>Tweak: Added color control to navigation dots in Media Carousel, Reviews, and Slides widgets<\\/li>\\n<li>Tweak: Disabled Vimeo autoplay on edit mode when getting video data in Video Playlist widget<\\/li>\\n<li>Tweak: Added notice about Facebook\'s new EU consent policy in Facebook Button, Facebook Comments, Facebook Embed, and Facebook Page widgets<\\/li>\\n<li>Tweak: Refactor string translation calls to use native WP translation methods<\\/li>\\n<li>Tweak: Convert <code>home_url<\\/code> license API call to <code>get_site_url<\\/code> for better compatibility<\\/li>\\n<li>Tweak: Promoted Default to New Theme Builder and Scroll Snap experiments to Stable status in Experiments screen<\\/li>\\n<li>Tweak: Scroll Snap experiment set to active by default for all websites in Experiments screen<\\/li>\\n<li>Tweak: Scrolling Effects in Header and Section backgrounds are not working as expected when effects are relative to the entire page<\\/li>\\n<li>Tweak: Added &quot;Auto Updates&quot; capability to Pro versions<\\/li>\\n<li>Tweak: Removed sequenced animation hover effect option from Classic skin in Call to Action widget<\\/li>\\n<li>Tweak: Added &quot;Excerpt Length&quot; control in Post Excerpt widget<\\/li>\\n<li>Tweak: Deleted deprecated methods from Query Control module<\\/li>\\n<li>Tweak: Adjusted Inline-CSS Experiment to work with Additional Custom Breakpoints experiment<\\/li>\\n<li>Fix: Automatically open cart functionality didn\'t work in product page in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5921\\\">#5921<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16276\\\">#16276<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16879\\\">#16879<\\/a>)<\\/li>\\n<li>Fix: Buttons are not visible when there are too many products in the cart in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16221\\\">#16221<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17283\\\">#17283<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16333\\\">#16333<\\/a>,<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13005\\\">#13005<\\/a>)<\\/li>\\n<li>Fix: Mini cart modal z-index is too low in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16333\\\">#16333<\\/a>)<\\/li>\\n<li>Fix: Side cart buttons are not visible at first glance on mobile in WooCommerce Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16221\\\">#16221<\\/a>)<\\/li>\\n<li>Fix: Read More field recognizes inline HTML elements as plain text in Posts and Archive Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16985\\\">#16985<\\/a>)<\\/li>\\n<li>Fix: Load More functionality caused JS error console in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17036\\\">#17036<\\/a>)<\\/li>\\n<li>Fix: Autoplay is not working as expected when the lazy load is active in Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15304\\\">#15304<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16274\\\">#16274<\\/a>)<\\/li>\\n<li>Fix: Right navigation area wasn\'t 100% clickable in Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14252\\\">#14252<\\/a>)<\\/li>\\n<li>Fix: Posts duplicate when there are two Posts widgets inside a page using pagination functionality (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/17056\\\">#17056<\\/a>)<\\/li>\\n<li>Fix: Global widget changes are not reflected on frontend (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16820\\\">#16820<\\/a>)<\\/li>\\n<li>Fix: JS Error console message when using the Load More functionality and Post Per Page option in Posts widget<\\/li>\\n<li>Fix: Heading styling is not being loaded when Inline CSS experiment is active in Post and Page Title widgets<\\/li>\\n<li>Fix: Sticky offset not working as expected when changing device mode on the browser<\\/li>\\n<li>Fix: Scroll Snap functionality wasn\'t applied on Templates and Archives<\\/li>\\n<li>Fix: Toggle icon color didn\'t work on hover state when Inline Font Icons experiment is activated in Nav Menu widget<\\/li>\\n<li>Fix: Variations style controls are not working as expected in WooCommerce Add to Cart widget<\\/li>\\n<li>Fix: Display conditions module is not working as expected when using the new Theme Builder UI<\\/li>\\n<li>Fix: Edit header handles <code>z-index<\\/code> issues in Header document<\\/li>\\n<li>Fix: Panel icons UI glitch in Call To Action widget<\\/li>\\n<li>Fix: WordPress 5.9 <code>WP_User_query<\\/code> <code>who<\\/code> argument deprecation adjustments<\\/li>\\n<\\/ul>\\n<h4>3.5.2 - 2021-11-28<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted license mechanism to support trial period<\\/li>\\n<li>Fix: Updates made to Global Widgets do not reflect accordingly to linked widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16815\\\">#16815<\\/a>)<\\/li>\\n<li>Fix: Hamburger toggle button doesn\'t change to \\u201cclose\\u201d when menu is collapsed in Nav Menu widget when Inline Font Awesome experiment is active<\\/li>\\n<li>Fix: Global Widget cannot be unlinked<\\/li>\\n<\\/ul>\\n<h4>3.5.1 - 2021-11-10<\\/h4>\\n<ul>\\n<li>Fix: Inline HTML elements appear as plain text in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16816\\\">#16816<\\/a>)<\\/li>\\n<li>Fix: Dropdown items inherited values from Main Menu space between control in Nav Menu widget (<a href=\\\"(https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16815)\\\">#16815<\\/a><\\/li>\\n<li>Fix: Order Summary titles style controls not applying on various devices in Cart widget<\\/li>\\n<li>Fix: Panel &quot;Need Help&quot; link is not correct in WooCommerce section in Site Settings<\\/li>\\n<\\/ul>\\n<h4>3.5.0 - 2021-11-01<\\/h4>\\n<ul>\\n<li>New: WooCommerce Checkout widget - Fully customize the content and style of your checkout page (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15282\\\">#15282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15990\\\">#15990<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13218\\\">#13218<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: WooCommerce Cart widget - Style your cart page the way you want with design flexibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15282\\\">#15282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13218\\\">#13218<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: WooCommerce My Account widget - Create a custom design for your my account pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11014\\\">#11014<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5383\\\">#5383<\\/a>)<\\/li>\\n<li>New: Progress Tracker widget - Motivate your customers to keep reading your site content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16576\\\">#16576<\\/a>)<\\/li>\\n<li>New: Meet WooCommerce Site Settings - Set your store pages within Elementor<\\/li>\\n<li>Experiment: Scroll Snap - Set the scene of every scroll (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10752\\\">#10752<\\/a>)<\\/li>\\n<li>Tweak: Changed infrastructure to prevent rendering bugs in Global Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16354\\\">#16354<\\/a>)<\\/li>\\n<li>Tweak: Added the option to open submission in a new tab in Form Submissions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14967\\\">#14967<\\/a>)<\\/li>\\n<li>Tweak: Added various responsive controls in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1851\\\">#1851<\\/a>)<\\/li>\\n<li>Tweak: Split Title and Price styling controls in Price List widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7688\\\">#7688<\\/a>)<\\/li>\\n<li>Tweak: Added various responsive capabilities to controls in Posts Archive widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Changed admin notice content when Pro installed without Core installed<\\/li>\\n<li>Tweak: Cleanup in <code>wp_options<\\/code> table<\\/li>\\n<li>Tweak: Changed Connect logic in Elementor top bar to simplify the connect process<\\/li>\\n<li>Tweak: Marked new Theme Builder as an Experiment and set to default for new sites<\\/li>\\n<li>Tweak: Enforced better security policies in various widgets and modules<\\/li>\\n<li>Tweak: Added load more button functionality to the Posts Archive widget<\\/li>\\n<li>Tweak: Renamed Elementor\'s responsive SCSS variables<\\/li>\\n<li>Tweak: Added dividers to horizontal layout in Nav Menu widget<\\/li>\\n<li>Tweak: Removed Google+ social network from Share Buttons widget<\\/li>\\n<li>Tweak: Convert usage of old Responsive class to use the new Breakpoints Manager<\\/li>\\n<li>Fix: jQuery in Heading doesn\'t work for not logged in users in Custom Code (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14515\\\">#14515<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14266\\\">#14266<\\/a>)<\\/li>\\n<li>Fix: Menu animation causing page horizontal scroll in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15184\\\">#15184<\\/a>)<\\/li>\\n<li>Fix: Wrong function call in Table of Content &amp; Post Excerpt widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16547\\\">#16547<\\/a>)<\\/li>\\n<li>Fix: Slides to Scroll control can\'t be set to Default if Widescreen mode has a value in Testimonial Carousel widget<\\/li>\\n<li>Fix: Sticky offset not working properly when changing device mode<\\/li>\\n<li>Fix: UTF character issues when exporting CSV file in Form Submissions<\\/li>\\n<li>Fix: Load More functionality doesn\'t work when the Posts widget placed inside an Archive template<\\/li>\\n<li>Fix: UI glitches and editing issues in Video Playlist widget<\\/li>\\n<\\/ul>\\n<h4>3.4.2 - 2021-10-12<\\/h4>\\n<ul>\\n<li>Fix: Icons color style conflicts when Font-Awesome Inline experiment is active in Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16435\\\">#16435<\\/a>)<\\/li>\\n<li>Fix: Mini Cart hides page content when closed in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16305\\\">#16305<\\/a>)<\\/li>\\n<li>Fix: UI glitches in the Editor edit mode when inserting Post Content widget and Font-Awesome Inline experiment is active in Single Post template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16358\\\">#16358<\\/a>)<\\/li>\\n<li>Fix: Slides per view controls disappeared from multiple breakpoints in Testimonial Carousel<\\/li>\\n<li>Fix: Product variations UI glitch in Menu Cart widget<\\/li>\\n<li>Fix: Buttons UI glitch on Safari browser in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.1 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Fix: Sticky functionality is not working if the Additional Custom Breakpoints experiment is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16186\\\">#16186<\\/a>)<\\/li>\\n<li>Fix: Slideshow skin UI glitch in Media Carousel widget<\\/li>\\n<li>Fix: Product price typography weight control is not working as expected in Menu Cart widget<\\/li>\\n<\\/ul>\\n<h4>3.4.0 - 2021-09-01<\\/h4>\\n<ul>\\n<li>Tweak: Added new Mini Cart layout type in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11312\\\">#11312<\\/a>)<\\/li>\\n<li>Tweak: Added styling options for Cart, Products, and Cart buttons in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14952\\\">#14952<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to open cart automatically when an item is added in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14119\\\">#14119<\\/a>)<\\/li>\\n<li>Tweak: Added the ability to remove an item from cart without reloading the page with an AJAX request (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9531\\\">#9531<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10875\\\">#10875<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11309\\\">#11309<\\/a>)<\\/li>\\n<li>Tweak: Added Load More AJAX functionality to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1284\\\">#1284<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14557\\\">#14557<\\/a>)<\\/li>\\n<li>Tweak: Added Vimeo support to the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15319\\\">#15319<\\/a>)<\\/li>\\n<li>Tweak: Improved asset loading performance by serving lighter JS files (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>)<\\/li>\\n<li>Tweak: Added query string to the URL only after the first video is played in Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15348\\\">#15348<\\/a>)<\\/li>\\n<li>Tweak: Added various layout options with more responsive controls and cart structure options in Menu Cart widget<\\/li>\\n<li>Tweak: Added the option to open the menu cart by click or hover in Menu Cart widget<\\/li>\\n<li>Tweak: Added the ability to choose a specific product to draw data from in WooCommerce Dynamic tags<\\/li>\\n<li>Tweak: Removed auto-scroll to the widget location when arriving from external URL in Video Playlist widget<\\/li>\\n<li>Tweak: Removed the Video Playlist widget from the Experiments list<\\/li>\\n<li>Tweak: Added descriptive error messages for MailChimp action after submit and on form submit in Forms widget<\\/li>\\n<li>Tweak: Added tooltip trigger None and Hover for link in Hotspot widget<\\/li>\\n<li>Tweak: Added responsive controls to Offset and Effects Offset in Sticky options<\\/li>\\n<li>Tweak: Added responsive control to Alignment in Testimonial Carousel widget<\\/li>\\n<li>Tweak: Adjusted Motion Effects module to support future feature<\\/li>\\n<li>Tweak: Added future compatibility to support better loading of <code>eicons<\\/code> font<\\/li>\\n<li>Tweak: Changed Rename Part title and button color in Theme Builder<\\/li>\\n<li>Fix: Products don\'t appear on the cart while editing in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15451\\\">#15451<\\/a>)<\\/li>\\n<li>Fix: Videos always start muted in the Video Playlist widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15292\\\">#15292<\\/a>)<\\/li>\\n<li>Fix: Unnecessary spacing if submenu indicator is set to None in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15365\\\">#15365<\\/a>)<\\/li>\\n<li>Fix: MailChimp double opt-in feature doesn\'t work in Forms widget<\\/li>\\n<li>Fix: Fetching MailChimp groups field blocks the loading of the rest of the fields in the Form widget<\\/li>\\n<li>Fix: Missing field IDs causes forms not to be sent in Forms widget<\\/li>\\n<li>Fix: Full Content Skin is not working properly when inserted twice on the same page in Posts widget<\\/li>\\n<li>Fix: Avoid Duplicates option doesn\'t exclude manual selections in Posts widget<\\/li>\\n<li>Fix: Submenu indicator alignment issue in Nav menu widget<\\/li>\\n<li>Fix: Query control deprecated message appears when debug mode is defined<\\/li>\\n<li>Fix: Tweet Button icon incorrect color and size when the icon is rendered as SVG in Blockquote widget<\\/li>\\n<li>Fix: Video icon size is not changing on Active state in Video Playlist widget<\\/li>\\n<li>Fix: Header icon color is not working in Table Of Content widget<\\/li>\\n<li>Fix: Icons style glitches when Font Awesome Inline experiment is active in Video Playlist widget<\\/li>\\n<li>Fix: Bullet markers are not visible on preview mode when Font Awesome Inline experiment is active in Table of Content widget<\\/li>\\n<li>Fix: UI Glitch when Font-Awesome Inline experiment is active in Price Table widget<\\/li>\\n<li>Fix: Submenu Indicator appears larger when Font Awesome Inline experiment is active in Nav Menu widget<\\/li>\\n<li>Fix: Part name is deleted when clicking on the &quot;Change&quot; Button without changing the name in Theme Builder<\\/li>\\n<li>Fix: Redundant pagination queries in the Editor<\\/li>\\n<li>Deprecated: Remove all usages of <code>ElementorUtils::get_create_new_post_url()<\\/code><\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-4-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.3.8 - 2021-08-23<\\/h4>\\n<ul>\\n<li>Fix: Products grid width issue when adjusting columns and rows in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16001\\\">#16001<\\/a>)<\\/li>\\n<li>Fix: Font Awesome Inline experiment causes icons glitch in Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/16045\\\">#16045<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA v3 <code>z-index<\\/code> is lower than the Section\'s background color<\\/li>\\n<li>Fix: Style missing when Font Awesome inline experiment is active in Post Info widget<\\/li>\\n<li>Fix: Font Awesome icons were not loaded in Post Info widget<\\/li>\\n<li>Fix: Zero character can\'t be used as a placeholder in Number field in Form widget<\\/li>\\n<li>Fix: Carousels are not working properly in the Editor when Additional Custom Breakpoints experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.7 - 2021-08-15<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Additional Custom Breakpoints in Nav Menu widget<\\/li>\\n<li>Tweak: Added support for Additional Custom breakpoints in Motion Effects<\\/li>\\n<li>Fix: Columns didn\'t respond to changes in Gallery widget if Additional Custom Breakpoints Experiment is active<\\/li>\\n<\\/ul>\\n<h4>3.3.6 - 2021-08-10<\\/h4>\\n<ul>\\n<li>Tweak: Added support for future feature in Nav Menu widget<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Related widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Upsells widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<li>Fix: WooCommerce responsive grid styles are not being reflected in Product Categories widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15857\\\">#15857<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.5 - 2021-08-01<\\/h4>\\n<ul>\\n<li>Fix: Responsive layout glitches in Products and Products Archive widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15773\\\">#15773<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA V3 integration conflict with required fields validation in Forms widget<\\/li>\\n<\\/ul>\\n<h4>3.3.4 - 2021-07-21<\\/h4>\\n<ul>\\n<li>Fix: Grid layout glitch in WooCommerce Products Archive widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15718\\\">#15718<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.3.3 - 2021-07-20<\\/h4>\\n<ul>\\n<li>Tweak: Added a descriptive message in Collect Submissions action after submit<\\/li>\\n<li>Tweak: Added future compatibility for Additional Custom Breakpoints for Pro widgets<\\/li>\\n<li>Fix: Some widget style breaks when Improved CSS Loading Experiment is active in certain cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15632\\\">#15632<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15683\\\">#15683<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15660\\\">#15660<\\/a>)<\\/li>\\n<li>Fix: Translation update keep appearing as available after install (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14297\\\">#14297<\\/a>)<\\/li>\\n<li>Fix: Wrong default icon color when using Font Awesome icons as inline SVG in Call to Action widget<\\/li>\\n<\\/ul>\\n<h4>3.3.2 - 2021-07-13<\\/h4>\\n<ul>\\n<li>Tweak: Updated plugin description<\\/li>\\n<li>Fix: MailChimp tags in form widget replaced existing tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Fix: Clicking videos from the items list in edit mode doesn\\u2019t initiate videos properly<\\/li>\\n<li>Fix: User unauthorized message when activated but not connected in Kit Library<\\/li>\\n<li>Fix: Carousel widgets did not support additional custom breakpoint responsive values<\\/li>\\n<li>Fix: Tab border is overridden by the Section background color in Video Playlist widget<\\/li>\\n<li>Fix: Widgets style breaks when Improved CSS Load experiment is active in a Single Page template and Post Content widget<\\/li>\\n<\\/ul>\\n<h4>3.3.1 - 2021-06-20<\\/h4>\\n<ul>\\n<li>Tweak: Added support for more Theme Builder display conditions in Export \\/ Import experiment<\\/li>\\n<li>Tweak: Adjusted License page heading structure for future feature<\\/li>\\n<li>Tweak: Adjusted Font Awesome icon for allowing support for future feature<\\/li>\\n<li>Fix: <code>frontend.min.js<\\/code> file size increased in Elementor Pro 3.3.0 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/15278\\\">#15278<\\/a>)<\\/li>\\n<li>Fix: Prevent conditions from being reset when object cache is enabled in site (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13299\\\">#13299<\\/a>)<\\/li>\\n<li>Fix: Custom Code publish modal responsiveness issues (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14519\\\">#14519<\\/a>)<\\/li>\\n<li>Fix: Populating fields with options programmatically doesn\'t appear in Submissions screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10671\\\">#10671<\\/a>)<\\/li>\\n<li>Fix: Large images are not shown on the Image Carousel widget when set via Toolset dynamic tag<\\/li>\\n<li>Fix: Enable inline editing to the inner content tabs in Video Playlist widget<\\/li>\\n<li>Fix: Clicking on the video list doesn\'t play videos properly in Video Playlist widget<\\/li>\\n<li>Fix: Hide Play Icon control when Image overlay is toggled off in Video Playlist widget<\\/li>\\n<li>Fix: Removed extra space below the player when viewing from mobile view in Video Playlist widget<\\/li>\\n<li>Fix: Import button is not working properly in Theme Builder interface<\\/li>\\n<li>Fix: Preview Dynamic Content as control is not updating preview and throws an error in Popup Builder<\\/li>\\n<\\/ul>\\n<h4>3.3.0 - 2021-06-08<\\/h4>\\n<ul>\\n<li>New: Video Playlist widget - Add Engaging Video Content to Your Website (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11859\\\">#11859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7803\\\">#7803<\\/a>)<\\/li>\\n<li>New: Hotspot widget - Create Interactive Images With Contextually Relevant Information (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7282\\\">#7282<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2768\\\">#2768<\\/a>)<\\/li>\\n<li>Tweak: Accessibility improvements for sub-menus in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13859\\\">#13859<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13810\\\">#13810<\\/a>)<\\/li>\\n<li>Tweak: MailChimp action after submit can now add new tags to existing subscribers in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11111\\\">#11111<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/forms\\/record\\/actions_before<\\/code> to filter the record before it sent to Actions After Submit in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14261\\\">#14261<\\/a>)<\\/li>\\n<li>Tweak: Yoast SEO breadcrumbs widget can be used in Elementor without the need of enabling them in Yoast setting<\\/li>\\n<li>Tweak: Added future support for widgets CSS conditional loading (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10329\\\">#10329<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/14229\\\">#14229<\\/a>)<\\/li>\\n<li>Tweak: Added future support for Sticky JS library conditional loading<\\/li>\\n<li>Tweak: Added future support for Import \\/ Export experiment<\\/li>\\n<li>Tweak: Preparations and fixes for Import Export Experiment in Pro version<\\/li>\\n<li>Tweak: Added gradient button capabilities to Login widget buttons<\\/li>\\n<li>Tweak: Added gradient button capabilities to Slides widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Price Table widget button<\\/li>\\n<li>Tweak: Added gradient button capabilities to Flip Box widget button<\\/li>\\n<li>Tweak: Added Code Highlight widget Developers Documentation<\\/li>\\n<li>Tweak: Adjusted Submissions page for future updates<\\/li>\\n<li>Tweak: Added <code>em<\\/code> and <code>%<\\/code> units for padding control in Carousel widgets<\\/li>\\n<li>Tweak: Shorten currency name to currency symbol in PayPal button widget<\\/li>\\n<li>Fix: Custom Fonts URLs should be replaced when replace URL is triggered (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7376\\\">#7376<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10382\\\">#10382<\\/a>)<\\/li>\\n<li>Fix: The currency symbol size changed in the Price Table widget if enabling sale (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13519\\\">#13519<\\/a>)<\\/li>\\n<li>Fix: Nav Menu widget is not loading Font Awesome submenu icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9907\\\">#9907<\\/a>)<\\/li>\\n<li>Fix: Hamburger toggle is not working in Nav menu widget<\\/li>\\n<li>Fix: Activation bug for IDN domains<\\/li>\\n<li>Fix: Conditions modal responsive glitches in Custom Code<\\/li>\\n<li>Fix: Duplicated strings in Custom Code module<\\/li>\\n<li>Fix: Enable resize option for code input field in Custom Code<\\/li>\\n<li>Fix: \\u201cSave &amp; Close \\u201cbutton in Custom Code\'s Conditions modal was not visible on small screen sizes<\\/li>\\n<li>Fix: Removing a column from a section in the navigator resulted in an empty section<\\/li>\\n<li>Fix: Recommend option is cut If the layout is not &quot;Standard&quot; in the Facebook Button widget<\\/li>\\n<li>Fix: Video item does not play without adding an image in Media Carousel widget<\\/li>\\n<li>Fix: <code>search-plus<\\/code> icon missing from panel in Media Carousel widget<\\/li>\\n<li>Fix: UI hover state glitch in Media Carousel widget<\\/li>\\n<li>Fix: PHP notice was thrown when trying to import a kit without overrideConditions parameter in Kit Import flow<\\/li>\\n<li>Fix: Templates conditions not imported if there are no conflicts in Import Export Experiment<\\/li>\\n<li>Fix: Non english values are not encoded properly on Submissions export<\\/li>\\n<li>Fix: Theme Builder import is not working properly<\\/li>\\n<li>Fix: UI glitch when no global widgets were found in Editor Panel<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-3-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.2.2 - 2021-05-05<\\/h4>\\n<ul>\\n<li>Tweak: Added support for Expert tier templates in Templates Library<\\/li>\\n<li>Tweak: Updated compatibility tag to support Elementor v3.2.x<\\/li>\\n<li>Tweak: Added compatibility for future Library improvements<\\/li>\\n<li>Fix: Toolset image dynamic field is not working with Gallery widget<\\/li>\\n<\\/ul>\\n<h4>3.2.1 - 2021-03-21<\\/h4>\\n<ul>\\n<li>Tweak: Added strings context in PayPal button and Price Table widgets<\\/li>\\n<li>Tweak: Added support for future Import \\/ Export Kit feature<\\/li>\\n<li>Fix: Submissions with over than 191 characters weren\'t indexed properly<\\/li>\\n<\\/ul>\\n<h4>3.2.0 - 2021-03-14<\\/h4>\\n<ul>\\n<li>New: PayPal Button widget - Collect PayPal payments directly from your site<\\/li>\\n<li>Experiment: Submissions - Save all of your form submissions in one place (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1686\\\">#1686<\\/a>)<\\/li>\\n<li>Tweak: Added Stay In Column option to Inner Section element (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7956\\\">#7956<\\/a>)<\\/li>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Tweak: Changed descriptive text in Create Custom Code screen<\\/li>\\n<li>Tweak: Added support for dynamic capabilities in Code Highlight widget<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>share-link<\\/code> library<\\/li>\\n<li>Tweak: Added support for future load on demand for <code>dialog<\\/code> library in Popup<\\/li>\\n<li>Tweak: Allow overwriting the assets URL when using a mirror domain<\\/li>\\n<li>Fix: Animation was triggered multiple times when accessing the viewport in certain cases in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13951\\\">#13951<\\/a>)<\\/li>\\n<li>Fix: Location is not being updated after a Custom Code snippet is published (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13971\\\">#13971<\\/a>)<\\/li>\\n<li>Fix: Custom Fonts CSS files were not updated after regenerating CSS files<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: Empty order buttons are displayed in Custom Fonts screen<\\/li>\\n<li>Fix: Typo in \'Reply To\' Email action after submit placeholder in Forms widget<\\/li>\\n<li>Fix: Unnecessary Save Draft button in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Custom Code<\\/li>\\n<li>Fix: Sanitized options in the editor to enforce better security policies<\\/li>\\n<li>Deprecated: See all deprecations to this version in our (<a href=\\\"https:\\/\\/developers.elementor.com\\/v3-2-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.1.1 - 2021-02-23<\\/h4>\\n<ul>\\n<li>Tweak: Adjusted \'Max Height\' control range in Table of Contents widget<\\/li>\\n<li>Fix: Popup event handler is undefined (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11475]\\\">#11475<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10690\\\">#10690<\\/a>)<\\/li>\\n<li>Fix: Conditions modal is not responsive in Custom Code<\\/li>\\n<li>Fix: RTL glitches in Code Highlight widget<\\/li>\\n<li>Fix: Minor UI glitches in Code Highlight widget<\\/li>\\n<li>Fix: Users can\'t get Pro Developer Edition version updates<\\/li>\\n<\\/ul>\\n<h4>3.1.0 - 2021-02-13<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Code - Add custom code snippets to your site, including <code>head<\\/code>, <code>body<\\/code> start and <code>body<\\/code> end<\\/li>\\n<li>New: Meet Code Highlight widget - showcase any syntax with highlighted UI (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5815\\\">#5815<\\/a>)<\\/li>\\n<li>Experiment: Improved Pro widgets performance by loading JS and Swiper assets conditionally in frontend (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8572\\\">#8572<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/experiment-optimized-asset-loading\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Compatibility Tag support in Elementor Pro (<a href=\\\"https:\\/\\/developers.elementor.com\\/compatibility-tag\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Rotating Text animation in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4625\\\">#4625<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added an option to set Selected color for Typing effect in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5403\\\">#5403<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7826\\\">#7826<\\/a>)<\\/li>\\n<li>Tweak: Added animation Loop option for Animated Headline (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9749\\\">#9749<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2457\\\">#2457<\\/a>)<\\/li>\\n<li>Tweak: Added timing options for Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4392\\\">#4392<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4242\\\">#4242<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8569\\\">#8569<\\/a>)<\\/li>\\n<li>Tweak: Added Word Wrap control to Code Highlight widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13577\\\">#13577<\\/a>)<\\/li>\\n<li>Tweak: Upgraded Font Awesome Pro library to v5.15.1<\\/li>\\n<li>Tweak: Improved method of loading field mapping repeater in Form widget (<a href=\\\"https:\\/\\/developers.elementor.com\\/how-to-add-a-repeater-control-to-elementor-add-on\\/\\\">Developer Documentation<\\/a>)<\\/li>\\n<li>Tweak: Added &quot;Show on Browsers&quot; Popup Advanced Rule<\\/li>\\n<li>Tweak: Added real-time JS handling to prevent redundant renders in Slides widget and all Carousel widgets<\\/li>\\n<li>Tweak: Import scroll utility from core and remove it from Pro<\\/li>\\n<li>Tweak: Added alignment options for Post Excerpt widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9757\\\">#9757<\\/a>)<\\/li>\\n<li>Tweak: Changed alignment control to work with selectors in Share Buttons<\\/li>\\n<li>Tweak: Upgraded to Webpack 5, Grunt-Webpack 4 and TerserPlugin instead of UglifyJsPlugin<\\/li>\\n<li>Fix: Steps Divider is not vertically aligned in Multi Step Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12569\\\">#12569<\\/a>)<\\/li>\\n<li>Fix: Slides are playing in an infinite loop mode even when the option is disabled in Slides Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6726\\\">#6726<\\/a>)<\\/li>\\n<li>Fix: Redundant spacing is added to Share Buttons widget<\\/li>\\n<li>Fix: Step buttons text is not updated without a page reload in Forms widget<\\/li>\\n<li>Fix: Overflow issue in certain animations in Animated Headline widget<\\/li>\\n<li>Fix: When dragging a new Testimonial Carousel there is a console error thrown<\\/li>\\n<li>Fix: Step Buttons are cut in mobile view in Multi Step Form<\\/li>\\n<li>Fix: Submit and Step buttons size differences when using Twenty Twenty theme<\\/li>\\n<li>Fix: Duplicate button Text Color control in Slides widget<\\/li>\\n<li>Fix: JS error is thrown when editing and saving global widgets<\\/li>\\n<li>Fix: <code>get_version<\\/code> API function may fail with Redis \\/ DB cache<\\/li>\\n<li>Fix: Multiple license check requests are created in certain cases<\\/li>\\n<li>Deprecated: Deprecate methods prefixed with an underscore and replace them with unprefixed methods<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-1-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>3.0.10 - 2021-01-20<\\/h4>\\n<ul>\\n<li>Tweak: Added Editing Handles string translation compatibility with Elementor v3.1.0<\\/li>\\n<\\/ul>\\n<h4>3.0.9 - 2020-12-29<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility to support Elementor 3.1.0<\\/li>\\n<li>Fix: Wrong phrasing of Import template success message in Theme Builder<\\/li>\\n<li>Fix: Border color glitch in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.8 - 2020-11-26<\\/h4>\\n<ul>\\n<li>Fix: Navigation arrows UI glitch in Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/13172\\\">#13172<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>3.0.7 - 2020-11-25<\\/h4>\\n<ul>\\n<li>Fix: Console Error when dragging  Testimonials Carousel widget<\\/li>\\n<li>Fix: Arrows of Testimonial and Reviews Carousel widgets navigate to the wrong direction in RTL websites<\\/li>\\n<li>Fix: Removed the conditional loading of Webpack<\\/li>\\n<li>Fix: Fatal error is thrown after deleting an associated custom taxonomy when Posts widget with Cards skin has a badge<\\/li>\\n<li>Fix: Upload JSON files only when the user allowed to prevent security issues<\\/li>\\n<li>Fix: Gallery not displayed in Theme Builder templates preview<\\/li>\\n<\\/ul>\\n<h4>3.0.6 - 2020-11-04<\\/h4>\\n<ul>\\n<li>Tweak: Updated the embedded post in Facebook Embed widget<\\/li>\\n<li>Fix: Minor UI glitches in Theme Builder\'s conditions screen footer<\\/li>\\n<li>Fix: Template type changes into Single Page after conditions change in Theme Builder<\\/li>\\n<li>Fix: Redundant Custom Caption option in Site Logo widget<\\/li>\\n<li>Fix: Removed unused code in Drip integration<\\/li>\\n<li>Fix: Removed Weibo and WeChat social networks due to website and links inactivity from Share Buttons widget<\\/li>\\n<li>Fix: Removed redundant code from Portfolio and Post Navigation widgets<\\/li>\\n<\\/ul>\\n<h4>3.0.5 - 2020-09-23<\\/h4>\\n<ul>\\n<li>Fix: If the default page layout is set to &quot;Canvas&quot; Headers and Footers cannot be edited<\\/li>\\n<li>Fix: Product Image Dynamic Tag throws an error when no image is set<\\/li>\\n<li>Fix: Missing Single document placeholder in Theme Builder<\\/li>\\n<li>Fix: Document editing handles inherit the <code>font-family<\\/code> from 3rd party source<\\/li>\\n<li>Fix: Can\'t add linebreaks to Textarea input when used as Multi Step Form<\\/li>\\n<li>Fix: Incorrect width in Facebook Page widget<\\/li>\\n<li>Fix: Added compatibility to allow the use of \'get_create_url\' in Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.4 - 2020-09-09<\\/h4>\\n<ul>\\n<li>Fix: Autogenerated screenshots appear in WP Media Library modal (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12304\\\">#12304<\\/a>)<\\/li>\\n<li>Fix: Make sure Elementor Posts widget Pagination doesn\'t interfere with 3rd party plugins (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Shrinking conditions indicator in Theme Builder<\\/li>\\n<li>Fix: Column can\'t be dragged and dropped if it populates a Global widget<\\/li>\\n<li>Fix: Styles are missing from Single templates in some edge cases<\\/li>\\n<\\/ul>\\n<h4>3.0.3 - 2020-09-02<\\/h4>\\n<ul>\\n<li>Fix: Pagination doesn\'t work in WordPress 5.5 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12126\\\">#12126<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12127\\\">#12127<\\/a>)<\\/li>\\n<li>Fix: Change delete template action to &quot;Move to Trash&quot; in the new Theme Builder view<\\/li>\\n<\\/ul>\\n<h4>3.0.2 - 2020-08-31<\\/h4>\\n<ul>\\n<li>Tweak: Replaced WordPress &quot;Learn More&quot; links with dynamic links for better control over time (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12312\\\">#12312<\\/a>)<\\/li>\\n<li>Tweak: UI tweaks to the Conditions screen In the new Theme Builder<\\/li>\\n<li>Fix: Motion Effects not working when assigned to a column and throws JS error when DOM optimization is disabled (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12299\\\">#12299<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12275\\\">#12275<\\/a>)<\\/li>\\n<li>Fix: Multiple Galleries display all the images in the Lightbox slideshow (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11809\\\">#11809<\\/a>)<\\/li>\\n<li>Fix: Old Theme Builder is being opened when accessing through the Finder<\\/li>\\n<li>Fix: Mixed templates import glitch in Theme Builder<\\/li>\\n<li>Fix: Card icon sizes in Theme Builder<\\/li>\\n<li>Fix: Preview button leads to <code>render_mode<\\/code> instead of preview when importing a template from the new Theme Builder<\\/li>\\n<\\/ul>\\n<h4>3.0.1 - 2020-08-26<\\/h4>\\n<ul>\\n<li>Tweak: Keep previous Theme Builder when accessing from the WP Dashboard for legacy support<\\/li>\\n<li>Tweak: Updated video tutorials in Theme Builder<\\/li>\\n<li>Tweak: Don\'t show auto-screenshots in the Media Library (Props <a href=\\\"https:\\/\\/github.com\\/black-eye\\\">@black-eye<\\/a>)<\\/li>\\n<li>Fix: Repeater items throws <code>childView<\\/code> is undefined message in Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12239\\\">#12239<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12221\\\">#12221<\\/a>)<\\/li>\\n<li>Fix: Misspelling of the word &quot;occurred&quot; in Form widget default error message (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12137\\\">#12137<\\/a>)<\\/li>\\n<li>Fix: Facebook comments not showing up (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/12157\\\">#12157<\\/a>)<\\/li>\\n<li>Fix: Check for conflicts in Theme Builder doesn\'t work properly<\\/li>\\n<li>Fix: Minor UI fixes in Theme Builder<\\/li>\\n<li>Fix: Dark mode glitches in Theme Builder<\\/li>\\n<li>Fix: Global Site Part toaster appears when you publish a Popup<\\/li>\\n<li>Fix: Site Parts aren\'t in the correct order in Theme Builder<\\/li>\\n<li>Fix: Date field caused forms to get corrupted in Forms widget<\\/li>\\n<li>Fix: Theme Builder application page is forbidden<\\/li>\\n<\\/ul>\\n<h4>3.0.0 - 2020-08-23<\\/h4>\\n<ul>\\n<li>New: Introducing the new and improved Theme Builder<\\/li>\\n<li>Tweak: Removed <code>.elementor-inner<\\/code> and <code>.elementor-column-wrap<\\/code> from DOM output to improve performance (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7351\\\">#7351<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7817\\\">#7817<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/dom-improvements-ahead-html-wrappers-removal-from-v3-0\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added contextual anchors ID support to Table of Contents widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10052\\\">#10052<\\/a>)<\\/li>\\n<li>Tweak: Added WeChat and Weibo social networks to Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11554\\\">#11554<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities for Redirect after Login\\/Logout in Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11343\\\">#11343<\\/a>)<\\/li>\\n<li>Tweak: Added Blend Mode and CSS Filters controls to adjust the Background Overlay in Flipbox widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11653\\\">#11653<\\/a>)<\\/li>\\n<li>Tweak: Added responsive capabilities to Toggle Button styling in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8269\\\">#8269<\\/a>)<\\/li>\\n<li>Tweak: Added responsive Text Alignment control in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11968\\\">#11968<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic content to Ribbon element in Call to Action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10364\\\">#10364<\\/a>)<\\/li>\\n<li>Tweak: Converted uses of Color and Typography Schemes to Global Colors and Fonts<\\/li>\\n<li>Tweak: Separated Title and Description control fields labels in Call to Action widget<\\/li>\\n<li>Tweak: Removed unnecessary style in WC Product with variations<\\/li>\\n<li>Tweak: Converted Portfolio, Posts and Share Buttons widgets to use CSS Variable-based Elementor Grid (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-dropping-support-ie\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added Date Modified option to Posts widget metadata<\\/li>\\n<li>Fix: PHP 7.4 compatibility to Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11355\\\">#11355<\\/a>)<\\/li>\\n<li>Fix: Divider alignment issue in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11628\\\">#11628<\\/a>)<\\/li>\\n<li>Fix: Color doesn\\u2019t change in Products Archive Description widget<\\/li>\\n<li>Fix: WC Product variations layout breaks when using Variation Swatches plugin<\\/li>\\n<li>Fix: WC Product variations layout issue<\\/li>\\n<li>Fix: WC Product variations mobile zoom-in glitch<\\/li>\\n<li>Fix: Can\'t edit a Popup after accessing Theme Style<\\/li>\\n<li>Fix: Twitter icon missing in Blockquote widget<\\/li>\\n<li>Fix: Removed redundant default text color from Share Buttons minimal skin<\\/li>\\n<li>Fix: UI glitch in Display Conditions modal<\\/li>\\n<li>Fix: Insert template button UI glitch in Templates Library<\\/li>\\n<li>Fix: Added sanitization to post titles in WordPress dashboard for better security<\\/li>\\n<li>Fix: Show when arriving from search engines rule doesn\'t work in Popup<\\/li>\\n<li>Fix: Child categories are shown with a different parent category in Query control<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v3-0-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>2.10.3 - 2020-06-29<\\/h4>\\n<ul>\\n<li>Fix: Form not being submitted when using &quot;Progress Bar&quot; and &quot;None&quot; view types in Multi Step Form (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11596\\\">#11596<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11610\\\">#11610<\\/a>)<\\/li>\\n<li>Fix: Missing &quot;for&quot; attribute in Password field label in Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8646\\\">#8646<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.10.2 - 2020-06-16<\\/h4>\\n<ul>\\n<li>Fix: Run step events only when in Multi Step Form mode (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11644\\\">#11644<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.10.1 - 2020-06-16<\\/h4>\\n<ul>\\n<li>Tweak: Improved License validation mechanism to avoid limitations<\\/li>\\n<li>Tweak: Changed control labels and ordering in Price Table, Lottie and Form widgets<\\/li>\\n<li>Fix: Popup close button vertical position glitch (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10921\\\">#10921<\\/a>)<\\/li>\\n<li>Fix: Radio field placement glitch when in Multi Step mode in Form widget<\\/li>\\n<li>Fix: Clicking <code>Enter<\\/code> key submits the form in Multi Step Form<\\/li>\\n<li>Fix: Hardened sanitization in Custom Attributes to avoid security issues<\\/li>\\n<\\/ul>\\n<h4>2.10.0 - 2020-06-07<\\/h4>\\n<ul>\\n<li>New: Introducing Multi-Step Forms - Breakdown long forms into simple steps (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5975\\\">#5975<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3911\\\">#3911<\\/a>)<\\/li>\\n<li>New: Introducing Lottie widget - easily add Lottie animations to your site, no coding needed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11026\\\">#11026<\\/a>)<\\/li>\\n<li>Tweak: Added spacing option to Posts widget pagination (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5682\\\">#5682<\\/a>)<\\/li>\\n<li>Tweak: Changed texts and logic for administrator plugin renewal notices<\\/li>\\n<li>Tweak: Added new Scroll Util for improved scrolling handling<\\/li>\\n<li>Tweak: Improved Motion Effects animation performance<\\/li>\\n<\\/ul>\\n<h4>2.9.5 - 2020-05-24<\\/h4>\\n<ul>\\n<li>Fix: Added sanitization to Custom Attributes control to avoid security issue<\\/li>\\n<\\/ul>\\n<h4>2.9.4 - 2020-05-07<\\/h4>\\n<ul>\\n<li>Fix: Hardened user role that is allowed to upload icon sets and unzip only allowed files in Custom Icons to prevent security vulnerability<\\/li>\\n<\\/ul>\\n<h4>2.9.3 - 2020-04-19<\\/h4>\\n<ul>\\n<li>Fix: Form shortcode IDs are not wrapped in double-quotes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11023\\\">#11023<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10932\\\">#10932<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10967\\\">#10967<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11000\\\">#11000<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/11049\\\">#11049<\\/a>)<\\/li>\\n<li>Fix: Escaped Form records metadata to prevent security vulnerability<\\/li>\\n<li>Fix: Closing &quot;Save Changes&quot; document confirmation modal causes Panel infinite loading<\\/li>\\n<li>Fix: Ken Burns effect not working when there is only one slide in Slides widget<\\/li>\\n<li>Fix: Document handles UI glitch<\\/li>\\n<\\/ul>\\n<h4>2.9.2 - 2020-03-25<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility with WordPress v5.4 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10745\\\">#10745<\\/a>)<\\/li>\\n<li>Fix: Image ratio number is displayed under the Archive Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10874\\\">#10874<\\/a>)<\\/li>\\n<li>Fix: Theme Style Link color setting overrides the Table of Content list style<\\/li>\\n<li>Fix: PHP notice when using dynamic user info <code>id<\\/code><\\/li>\\n<li>Fix: Navigation arrows direction is crossed on first drag in Slides Widget<\\/li>\\n<li>Fix: &quot;No headings were found on this page&quot; message was not displayed in the frontend in Table of Contents widget<\\/li>\\n<li>Fix: Container includes Popup tags by default in Table of Contents widget<\\/li>\\n<li>Fix: Twitter icon display issue when Font Awesome 4 support is disabled in Blockquote widget<\\/li>\\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action<\\/li>\\n<\\/ul>\\n<h4>2.9.1 - 2020-03-16<\\/h4>\\n<ul>\\n<li>Fix: Can\'t access Elementor Editor when there is Page Title widget in the page<\\/li>\\n<li>Fix: Applying styling to Post Content widget affects the Page and Post editing handles<\\/li>\\n<\\/ul>\\n<h4>2.9.0 - 2020-03-15<\\/h4>\\n<ul>\\n<li>New: Introducing Full Site Editing: Design header, footer, and content all in one place! (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4985\\\">#4985<\\/a>)<\\/li>\\n<li>New: Added Global Custom CSS for Your Entire Site in Theme Style (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3345\\\">#3345<\\/a>)<\\/li>\\n<li>New: Added Dynamic Colors tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6485\\\">#6485<\\/a>)<\\/li>\\n<li>Tweak: Added option to set the Site Part HTML Wrapper Tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9293\\\">#9293<\\/a>)<\\/li>\\n<li>Tweak: Added Link Attributes support to Pro widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5716\\\">#5716<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3642\\\">#3642<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9225\\\">#9225<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9079\\\">#9079<\\/a>)<\\/li>\\n<li>Tweak: Added Theme Style support in Theme Builder parts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10564\\\">#10564<\\/a>)<\\/li>\\n<li>Tweak: Avoid creating empty Custom Font<\\/li>\\n<li>Tweak: Added <code>aria-expanded<\\/code> attribute to Menu Cart widget<\\/li>\\n<li>Tweak: Moved Link Actions module to Core plugin<\\/li>\\n<li>Tweak: Changed the name of \\u201cTypeKit Web Fonts by Adobe\\u201d to \\u201cAdobe Fonts\\u201d<\\/li>\\n<li>Tweak: Removed redundant display conditions from Blockquote, Flipbox, Price Table, and Search Form widgets<\\/li>\\n<li>Tweak: Pro widgets are not draggable unless Elementor license has been activated<\\/li>\\n<li>Tweak: Remove redundant <code>label_block<\\/code> parameters from several controls<\\/li>\\n<li>Tweak: Converted controls selectors to CSS variables in Gallery widget<\\/li>\\n<li>Tweak: Replaced Stumbleupon with Mix in Reviews widget recommended icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10099\\\">#10099<\\/a>)<\\/li>\\n<li>Tweak: Added Mix to the Share Buttons network list (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10099\\\">#10099<\\/a>)<\\/li>\\n<li>Tweak: Added &quot;Open in new tab&quot; option to Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7924\\\">#7924<\\/a>)<\\/li>\\n<li>Tweak: Upgraded Font Awesome Pro library to v5.12.0<\\/li>\\n<li>Tweak: Added new Lightbox compatibility for Gallery and Media Carousel widgets<\\/li>\\n<li>Tweak: Expose external API for Swiper instances<\\/li>\\n<li>Tweak: Added compatibility to JS API in Theme Builder, Popups, Form widget and Global widget<\\/li>\\n<li>Tweak: Replaced nerd icons with new Elementor emojis<\\/li>\\n<li>Tweak: Added specific <code>color<\\/code> attribute to header title in Table of Contents widget<\\/li>\\n<li>Fix: Line break issues in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/10585\\\">#10585<\\/a>)<\\/li>\\n<li>Fix: Theme Style Link color overrides the Table of Content list style<\\/li>\\n<li>Fix: Active state glitches when using Table of contents widget with Sticky mode<\\/li>\\n<li>Fix: &quot;Graphic Element&quot; section appears as empty in case of unmarked Graphic Element in Call to Action widget<\\/li>\\n<li>Fix: Page Title widget render glitches in the Editor<\\/li>\\n<li>Fix: Image ratio parameter visible in some edge cases in Posts widget<\\/li>\\n<li>Fix: Image missing when sharing to Pinterest using Share Buttons widget<\\/li>\\n<li>Fix: Theme Style Link color setting override the list style in Table of Contents widget<\\/li>\\n<li>Deprecated: See all deprecations to this version in our <a href=\\\"https:\\/\\/developers.elementor.com\\/v2-9-0-planned-deprecations\\/\\\">Developers Deprecations Post<\\/a><\\/li>\\n<\\/ul>\\n<h4>2.8.5 - 2020-03-08<\\/h4>\\n<ul>\\n<li>Tweak: Added new Swiper parameter to all Pro carousels to allow 3rd party integration<\\/li>\\n<li>Fix: Missing closing bracket in Animated Headline widget<\\/li>\\n<li>Fix: Share buttons widgets show Font Awesome 4 icons on first drag in Editor<\\/li>\\n<\\/ul>\\n<h4>2.8.4 - 2020-02-16<\\/h4>\\n<ul>\\n<li>Tweak: Added Lightbox Title &amp; Description support to Gallery widget<\\/li>\\n<li>Tweak: Added RTL support for Slides widget<\\/li>\\n<li>Tweak: Display Lightbox images in Full size in Gallery widget<\\/li>\\n<li>Fix: Template with Slides widget not working properly when placed inside Tabs, Accordion and Toggle widget<\\/li>\\n<li>Fix: Dropdown menu lost styling after Elementor Pro v2.8 upgrade in Nav Menu widget<\\/li>\\n<li>Fix: Indent doesn\'t work on RTL websites in Table of Contents widget<\\/li>\\n<li>Fix: Query Control throws <code>Undefined index: q<\\/code> error<\\/li>\\n<li>Fix: Typography control not affecting dropdown menu in Nav Menu widget<\\/li>\\n<li>Fix: Discord forms integration fails to send submissions in some server configurations<\\/li>\\n<li>Fix: Rotating headlines don\'t align center in Animated Headline widget<\\/li>\\n<li>Fix: Custom secondary color displayed when not needed in Share buttons widget<\\/li>\\n<li>Fix: Motion Effects of certain objects are not functioning properly on Safari browser<\\/li>\\n<li>Fix: Missing eye icon in Single template footer preview button<\\/li>\\n<\\/ul>\\n<h4>2.8.3 - 2020-01-01<\\/h4>\\n<ul>\\n<li>Tweak: Updated Table of Contents widget panel location<\\/li>\\n<li>Fix: ACF URL Dynamic field throws <code>undefined index<\\/code> PHP notice (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9929\\\">#9929<\\/a>)<\\/li>\\n<li>Fix: Gallery lightbox pagination shows images from all tabs<\\/li>\\n<li>Fix: &quot;Reply To&quot; option not working in Form widget &quot;Email 2&quot; Action<\\/li>\\n<li>Fix: ACF Dynamic tag not working in Form widget Redirect action<\\/li>\\n<li>Fix: Underline option not working in Table of Contents widget Normal state<\\/li>\\n<li>Fix: Query Control <code>Undefined index: autocomplete<\\/code> notice in some cases<\\/li>\\n<li>Fix: Missing display condition to Read More Spacing control in Posts widget<\\/li>\\n<\\/ul>\\n<h4>2.8.2 - 2019-12-19<\\/h4>\\n<ul>\\n<li>Tweak: Improved scroll-spy and collapsing functionality in Table of Contents widget<\\/li>\\n<li>Fix: &quot;No products were found&quot; message not being displayed in an empty Products Archive<\\/li>\\n<li>Fix: Redundant <code>&lt;br&gt;<\\/code> tags in Single theme template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9927\\\">#9927<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9928\\\">#9928<\\/a>)<\\/li>\\n<li>Fix: Draft Popup shows up in Dynamic tag dropdown<\\/li>\\n<\\/ul>\\n<h4>2.8.1 - 2019-12-18<\\/h4>\\n<ul>\\n<li>Fix: Share Buttons widget not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9920\\\">#9920<\\/a>)<\\/li>\\n<li>Fix: Redundant <code>&lt;p&gt;<\\/code> tags added to Single Template posts<\\/li>\\n<\\/ul>\\n<h4>2.8.0 - 2019-12-18<\\/h4>\\n<ul>\\n<li>New: Table of Contents Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5171\\\">#5171<\\/a>)<\\/li>\\n<li>New: Added Font Awesome Pro Duotone font family support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9578\\\">#9578<\\/a>)<\\/li>\\n<li>Tweak: Added Lazy Load option to Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9763\\\">#9763<\\/a>)<\\/li>\\n<li>Tweak: Added Random order option to Gallery widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9269\\\">#9269<\\/a>)<\\/li>\\n<li>Tweak: Updated Font Awesome Pro to v5.11.2 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9578\\\">#9578<\\/a>)<\\/li>\\n<li>Tweak: Added preselect support for multiple default select values in Forms Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9324\\\">#9324<\\/a>)<\\/li>\\n<li>Tweak: Avoid duplicate queries for Custom Icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9579\\\">#9579<\\/a>)<\\/li>\\n<li>Tweak: Major performance improvements to Gallery widget<\\/li>\\n<li>Tweak: Avoid non-existing images in Gallery widget<\\/li>\\n<li>Tweak: Added <code>tabindex<\\/code>, <code>aria-expanded<\\/code>, <code>aria-hidden<\\/code> and <code>role=\\\"navigation\\\"<\\/code> accessibility attributes to Nav Menu widget<\\/li>\\n<li>Tweak: Changed button HTML tag from <code>button<\\/code> to <code>span<\\/code> in Call to Action and Flip Box widgets for better W3C compliance and accessibility<\\/li>\\n<li>Tweak: Removed Google+ from default networks in Share Buttons widget<\\/li>\\n<li>Tweak: Added compatibility for Library Connect<\\/li>\\n<li>Tweak: Added i18n to Toolset date dynamic tag<\\/li>\\n<li>Tweak: Added external link support to Gallery widget<\\/li>\\n<li>Tweak: Changed the link external attributes implementation to use <code>add_link_attributes()<\\/code> in Gallery widget<\\/li>\\n<li>Tweak: Updated references to the new Schemes system location<\\/li>\\n<li>Tweak: Avoid running Gallery handler when the gallery is empty<\\/li>\\n<li>Tweak: UI Tweaks in Editor Panel<\\/li>\\n<li>Tweak: Added responsive capabilities to Pointer Width control in Nav Menu widget<\\/li>\\n<li>Tweak: Added mobile support for responsive controls in Nav Menu widget<\\/li>\\n<li>Tweak: Refactor <code>register_controls()<\\/code> method in Posts widget skin trait<\\/li>\\n<li>Fix: ACF URL &quot;undefined Index&quot; notice (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7646\\\">#7646<\\/a>)<\\/li>\\n<li>Fix: WooCommerce Mini-Cart widget causes fatal error in edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9304\\\">#9304<\\/a>)<\\/li>\\n<li>Fix: <code>PHP Notice: Undefined index<\\/code> display for Author query (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9864\\\">#9864<\\/a>)<\\/li>\\n<li>Fix: Added compatibility for Button widget placed inside Swiper carousel (<a href=\\\"https:\\/\\/wordpress.org\\/support\\/topic\\/broken-buttons-since-elementor-2-8\\/\\\">Topic<\\/a>)<\\/li>\\n<li>Fix: Avoid empty spaces in Post info widget<\\/li>\\n<li>Tweak: Always show &quot;Custom label&quot; control in Login widget<\\/li>\\n<li>Fix: Nav Menu item typography selector in Nav Menu widget<\\/li>\\n<li>Fix: Facebook Like Button widget causes flickering<\\/li>\\n<li>Fix: WooCommerce mini-cart behaviour when using <code>plain<\\/code> permalinks format<\\/li>\\n<li>Fix: Avoid running Popup triggers when set without conditions<\\/li>\\n<li>Fix: Removed &quot;Date&quot; query from Products widget<\\/li>\\n<li>Fix: Slides widget when used as a Shortcode and is hidden<\\/li>\\n<li>Fix: Custom URL being accessed on swipe in Media Carousel<\\/li>\\n<li>Fix: Media Carousel widget Cube effect glitch<\\/li>\\n<li>Fix: Lightbox shows images from multiple Gallery widgets in the same page<\\/li>\\n<li>Fix: Image <code>alt<\\/code> Text not displayed on overlay in Gallery widget<\\/li>\\n<li>Fix: Gallery widget not visible in Posts widget Full Content skin<\\/li>\\n<li>Fix: WooCommerce mini-cart remove unnecessary hooks registration when WooCommerce integration set to <code>Disable<\\/code><\\/li>\\n<li>Fix: Slides widget button wrapping breaks in mobile view<\\/li>\\n<li>Fix: Dynamic capabilities with the Reviews widget<\\/li>\\n<li>Fix: Disabling autoplay doesn\'t work in Slides widget<\\/li>\\n<li>Fix: Posts widget Full Content skin not working on Single template<\\/li>\\n<li>Fix: Autocomplete not working for &quot;By Author&quot; condition in Display Conditions screen<\\/li>\\n<li>Fix: Posts widget alignment issue<\\/li>\\n<li>Fix: Product Variations Clear button not working in edge cases<\\/li>\\n<li>Fix: Styling issues in Form widget submit button<\\/li>\\n<\\/ul>\\n<h4>2.7.3 - 2019-10-28<\\/h4>\\n<ul>\\n<li>Tweak: Added RTL support to Galleries widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9213\\\">#9213<\\/a>)<\\/li>\\n<li>Tweak: Added Custom Icons compatibility for WordPress 5.3<\\/li>\\n<li>Fix: Missing template function declaration causes fatal error in WC mini-cart widget<\\/li>\\n<li>Fix: Pause on hover doesn\'t work in Carousel widgets<\\/li>\\n<li>Fix: Link-actions conflict with <code>?action=<\\/code> parameter in the URL<\\/li>\\n<li>Fix: Lightbox navigation not working in Gallery widget Single mode<\\/li>\\n<li>Fix: Ken burns effect not working on the 1st slide if Infinite Loop option is turned off in Carousel widgets<\\/li>\\n<li>Fix: Popup Advanced Rules detects internal links as external if current URL starts with <code>www<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.7.2 - 2019-10-06<\\/h4>\\n<ul>\\n<li>Fix: Slide Overlay not working when applying Ken burns effect in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9209\\\">#9209<\\/a>)<\\/li>\\n<li>Fix: Content width glitch in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Horizontal Alignment not working when applying custom style per slide in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Missing semicolon in Custom Fonts <code>font-display<\\/code> CSS<\\/li>\\n<\\/ul>\\n<h4>2.7.1 - 2019-09-26<\\/h4>\\n<ul>\\n<li>Fix: Background Overlay layer is over the slide content in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9180\\\">#9180<\\/a>)<\\/li>\\n<li>Fix: Duplicate images under &quot;All&quot; filter in Multiple Gallery<\\/li>\\n<\\/ul>\\n<h4>2.7.0 - 2019-09-24<\\/h4>\\n<ul>\\n<li>New: Enhanced Galleries widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1898\\\">#1898<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3103\\\">#3103<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4279\\\">#4279<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7631\\\">#7631<\\/a>)<\\/li>\\n<li>New: Dynamic Number (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5952\\\">#5952<\\/a>)<\\/li>\\n<li>New: Full content skin for Posts and Archive-posts widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4617\\\">#4617<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic number capability to Price List, Price Table, Counter, Star Rating, Progress Bar widgets<\\/li>\\n<li>Tweak: Added tags support to forms Mailchimp action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5418\\\">#5418<\\/a>)<\\/li>\\n<li>Tweak: User Profile Picture Dynamic Tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7947\\\">#7947<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8740\\\">#8740<\\/a>)<\\/li>\\n<li>Tweak: Added <code>font-display<\\/code> support to custom fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5993\\\">#5993<\\/a>, <a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-pro-2-7-custom-fonts-font-display-support\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added Text Shadow control to Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8800\\\">#8800<\\/a>)<\\/li>\\n<li>Tweak: Added Re-subscribe support to MailerLite (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8799\\\">#8799<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Facebook Embed widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/9030\\\">#9030<\\/a>)<\\/li>\\n<li>Tweak: Use <code>swiper.js<\\/code> instead of <code>slick.js<\\/code> in Slides widget (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-2-7-moving-sliders-from-slick-to-swiper\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/search_form\\/before_input<\\/code> action hook to Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5598\\\">#5598<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/search_form\\/after_input<\\/code> action hook to Search Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5598\\\">#5598<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic support for Custom field key (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7789\\\">#7789<\\/a>)<\\/li>\\n<li>Tweak: Increased expired license notice bar frequency<\\/li>\\n<li>Tweak: Changed the icon name of Slides widget<\\/li>\\n<li>Tweak: Added designated Finder\'s Icons for Custom icons &amp; Custom fonts<\\/li>\\n<li>Tweak: Use Ken Burns Effect as an external module<\\/li>\\n<li>Tweak: Remove Fontello conflicting CSS on import to Custom Icons sets<\\/li>\\n<li>Tweak: Editor Panel UI tweaks<\\/li>\\n<li>Tweak: Added DOM events on Popup show\\/hide (<a href=\\\"https:\\/\\/developers.elementor.com\\/elementor-pro-2-7-popup-events\\/\\\">Developers Blog Post<\\/a>)<\\/li>\\n<li>Tweak: Added option to change the variations field width in Add to Cart widget<\\/li>\\n<li>Tweak: Use select control instead of select2 in Menu Cart widget<\\/li>\\n<li>Tweak: Added conditions to the tabs instead of to each control in Share Buttons widget<\\/li>\\n<li>Tweak: Added Typography controls to HTML field in Forms widget<\\/li>\\n<li>Tweak: Allow edit selected Font file in Custom Font<\\/li>\\n<li>Tweak: Changed reCAPTCHA v3 error message<\\/li>\\n<li>Tweak: Remove the &quot;Save as Global&quot; option on Global widget context menu<\\/li>\\n<li>Fix: Corrected selector for <code>removeControlSpinner()<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8790\\\">#8790<\\/a>)<\\/li>\\n<li>Fix: Slides widget navigation icons misplacement (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8533\\\">#8533<\\/a>)<\\/li>\\n<li>Fix: Horizontal Scrollbar when Slider widget is set to Full Width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8527\\\">#8527<\\/a>)<\\/li>\\n<li>Fix: Inconsistent behavior when &quot;Infinite Loop&quot; enabled with &quot;Autoplay&quot; in Slides widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6726\\\">#6726<\\/a>)<\\/li>\\n<li>Fix: Ken Burns effect on Chrome transition glitches (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1671\\\">#1671<\\/a>)<\\/li>\\n<li>Fix: Nothing found message shows up inside the columns set in Posts Archive widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7347\\\">#7347<\\/a>)<\\/li>\\n<li>Fix: Responsive UI glitch in Popup Conditions modal tabs<\\/li>\\n<li>Fix: Removed unnecessary divider in Call to Action widget<\\/li>\\n<li>Fix: Custom Add To Cart * button style (size, position and background color) when <code>quantity<\\/code> is enabled.<\\/li>\\n<li>Fix: Add support for Document\\/PageBase in Theme Builder (Core &gt;=2.7.0)<\\/li>\\n<li>Fix: Ampersand character breaks email link in Share Buttons widget<\\/li>\\n<li>Fix: Correct custom font attachment <code>mime-type<\\/code> to show uploaded Custom Fonts<\\/li>\\n<li>Fix: Mini-Cart not refreshing in Menu Cart widget<\\/li>\\n<li>Fix: Cart drawer not working when WC Subscriptions plugin is activated<\\/li>\\n<li>Fix:  Querying CPT with custom taxonomies does not show the taxonomies before saving<\\/li>\\n<li>Fix: Double rendering on change caused console error in Theme Builder\'s conditions screen<\\/li>\\n<li>Fix: Translations and Strings in Share Buttons widget<\\/li>\\n<li>Fix: Avoid using offset if the source is Manual selection in Query Control<\\/li>\\n<li>Fix: Form being submitted although reCAPTCHA v3 validation failed in Forms widget<\\/li>\\n<\\/ul>\\n<h4>2.6.5 - 2019-08-26<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7<\\/li>\\n<li>Fix: Button style not working when <code>quantity<\\/code> is enabled in Custom Add To Cart widget<\\/li>\\n<li>Fix: Updated minified JS file fixed WhatsApp base URL in Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>2.6.4 - 2019-08-21<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.7<\\/li>\\n<li>Fix: Changed WhatsApp base URL in Share Buttons widget for cross-device compatibility<\\/li>\\n<li>Fix: Random slides order after several clicks on pagination in Testimonial Carousel widget<\\/li>\\n<\\/ul>\\n<h4>2.6.3 - 2019-08-18<\\/h4>\\n<ul>\\n<li>Fix: Core version rollback to <code>&gt;2.6.0<\\/code> causes a fatal error<\\/li>\\n<li>Fix: Duplicate images when slideshow skin is selected in Media Carousel lightbox<\\/li>\\n<li>Fix: Default bottom margin added to reCAPTCHA V3 badge<\\/li>\\n<li>Fix: Input glitch in reCAPTCHA V3 threshold settings<\\/li>\\n<\\/ul>\\n<h4>2.6.2 - 2019-07-30<\\/h4>\\n<ul>\\n<li>Tweak: Better accessibility support in Search Form widget<\\/li>\\n<li>Fix: UI glitched in Popup publish screen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8616\\\">#8616<\\/a>)<\\/li>\\n<li>Fix: &quot;Child of Term&quot; and &quot;Any child of term&quot; conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8695\\\">#8695<\\/a>)<\\/li>\\n<li>Fix: Restored <code>library_widget_templates<\\/code> action hook for 3rd party compatibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8687\\\">#8687<\\/a>)<\\/li>\\n<li>Fix: Twitter Icon missing in Blockquote widget<\\/li>\\n<li>Fix: Form reCAPTCHA v3 badge position not working<\\/li>\\n<li>Fix: Renewal notice bar appears in wrong situations<\\/li>\\n<li>Fix: Draft Icon Set loads empty Icon Library<\\/li>\\n<\\/ul>\\n<h4>2.6.1 - 2019-07-24<\\/h4>\\n<ul>\\n<li>Fix: Query Control autocomplete not retrieving results (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8672\\\">#8672<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8661\\\">#8661<\\/a>)<\\/li>\\n<li>Fix: Price Table features section not working (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8660\\\">#8660<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.6.0 - 2019-07-23<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Icon sets - including Fontello, IcoMoon and Fontastic support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/110\\\">#110<\\/a>)<\\/li>\\n<li>New: Added Font Awesome 5 Pro integration including 5,300+ icons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4430\\\">#4430<\\/a>)<\\/li>\\n<li>New: Added reCAPTCHA v3 integration to Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8213\\\">#8213<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6039\\\">#6039<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7165\\\">#7165<\\/a>)<\\/li>\\n<li>Tweak: Added Exit Animation for Popups (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7063\\\">#7063<\\/a>)<\\/li>\\n<li>Tweak: Added ACF Dynamic tag support for archive pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5147\\\">#5147<\\/a>)<\\/li>\\n<li>Tweak: Added Navigator Indicators for Custom CSS &amp; Motion Effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2180\\\">#2180<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities for Form Redirect action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7552\\\">#7552<\\/a>)<\\/li>\\n<li>Tweak: Added Logged In Message styling options for Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7928\\\">#7928<\\/a>)<\\/li>\\n<li>Tweak: Added <code>none<\\/code> breakpoint option to Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7916\\\">#7916<\\/a>)<\\/li>\\n<li>Tweak: Added option to place Post Terms dynamic tag without links (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8366\\\">#8366<\\/a>)<\\/li>\\n<li>Tweak: Added <code>elementor\\/query\\/query_results<\\/code> hook to Query Control to allow full control over results (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7912\\\">#7912<\\/a>)<\\/li>\\n<li>Tweak: Allow choosing Heading HTML tag in Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8090\\\">#8090<\\/a>)<\\/li>\\n<li>Tweak: Show popup on dynamic click even when <code>Avoid Multiple Popups<\\/code> option is selected (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8189\\\">#8189<\\/a>)<\\/li>\\n<li>Tweak: Added condition option to all of archive child pages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8256\\\">#8256<\\/a>)<\\/li>\\n<li>Tweak: Added <code>Effects Relative To<\\/code> control to Scrolling Effects<\\/li>\\n<li>Tweak: Allow shortcodes in HTML Form field<\\/li>\\n<li>Tweak: Removed donReach integration from Share Buttons widget due to service inconsistent stability<\\/li>\\n<li>Tweak: Changed MailChimp <code>List<\\/code> label to <code>Audience<\\/code><\\/li>\\n<li>Tweak: Improved Entrance and Exit animation behavior in Popup<\\/li>\\n<li>Tweak: Added <code>Deprecated Notice<\\/code> control to <code>Archive Products<\\/code> and <code>Woo Products<\\/code> widgets<\\/li>\\n<li>Tweak: Added default dynamic title for archives in Theme Builder<\\/li>\\n<li>Tweak: Added condition to show <code>Centered Slides<\\/code> control in Media Carousel widget<\\/li>\\n<li>Tweak: Added notice bar in the Editor when the license is expired or not activated<\\/li>\\n<li>Tweak: Replaced <code>select<\\/code> control with <code>choose<\\/code> control in Price List widget<\\/li>\\n<li>Tweak: Removed Font Awesome 4 dependencies from the Editor<\\/li>\\n<li>Tweak: Minor styling tweaks in the Popup publish modal<\\/li>\\n<li>Tweak: Hide ordering form in Products widget on front page<\\/li>\\n<li>Tweak: Removed page title markup when \'Hide Title\' is active<\\/li>\\n<li>Tweak: Added style controls for HTML field in Form widget<\\/li>\\n<li>Fix: Form widget Date picker makes the Popup builder disappear (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7240\\\">#7240<\\/a>)<\\/li>\\n<li>Fix: Sticky element stop point stops working on viewport resize (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7884\\\">#7884<\\/a>)<\\/li>\\n<li>Fix: Copy-Paste style not pasting the Pointer option in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8497\\\">#8497<\\/a>)<\\/li>\\n<li>Fix: Missing Print icon in Share Buttons (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8506\\\">#8506<\\/a>)<\\/li>\\n<li>Fix: UI style glitch in Blockquote widget when viewing from iPad<\\/li>\\n<li>Deprecated: <code>DB::save_editor()<\\/code> - Remove usage of this method (<a href=\\\"https:\\/\\/developers.elementor.com\\/v2-6-0-planned-deprecations\\/\\\">Deprecation Post<\\/a>)<\\/li>\\n<li>Deprecated: <code>DB::get_plain_editor()<\\/code> - Remove usage of this method (<a href=\\\"https:\\/\\/developers.elementor.com\\/v2-6-0-planned-deprecations\\/\\\">Deprecation Post<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.14 - 2019-07-14<\\/h4>\\n<ul>\\n<li>Fix: Better WC Related Product grid support to various themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8555\\\">#8555<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.13 - 2019-07-11<\\/h4>\\n<ul>\\n<li>Fix: Better WC grid support to various themes<\\/li>\\n<\\/ul>\\n<h4>2.5.12 - 2019-07-10<\\/h4>\\n<ul>\\n<li>Fix: Grid for WooCommerce Archive Product widget<\\/li>\\n<li>Fix: Remove redundant <code>whitespace<\\/code> CSS property causes style glitch in iPad<\\/li>\\n<li>Tweak: Added more compatibility for Elementor v2.6<\\/li>\\n<\\/ul>\\n<h4>2.5.11 - 2019-07-02<\\/h4>\\n<ul>\\n<li>Fix: Close icon missing from Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8460\\\">#8460<\\/a>)<\\/li>\\n<li>Fix: Elementor Pro v2.5.10 shows PHP notice regarding notice bar (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8461\\\">#8461<\\/a>)<\\/li>\\n<li>Fix: Fatal error when deleting used Pods fields (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8396\\\">#8396<\\/a>)<\\/li>\\n<li>Fix: Missing dropdown icon in conditions screen<\\/li>\\n<\\/ul>\\n<h4>2.5.10 - 2019-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.6<\\/li>\\n<li>Tweak: Error caused by empty Rows &amp; Columns values in Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8261\\\">#8261<\\/a>)<\\/li>\\n<li>Fix: Do not unset <code>product<\\/code> CPT if it\'s not from WooCommerce (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8160\\\">#8160<\\/a>)<\\/li>\\n<li>Fix: Column Spacing not working in WooCommerce Archive Products widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8285\\\">#8285<\\/a>)<\\/li>\\n<li>Fix: Title styling not working in Products Categories widget<\\/li>\\n<li>Fix: Empty value in Dynamic Pods Gallery dropdown using Safari browser<\\/li>\\n<li>Fix: WooCommerce archives included in &quot;All Archives&quot; condition<\\/li>\\n<\\/ul>\\n<h4>2.5.9 - 2019-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Removed <code>auto-confirm<\\/code> control from MailPoet to support new version of MailPoet<\\/li>\\n<li>Fix: Multiple Custom Fonts not rendered in the editor<\\/li>\\n<li>Fix: Products <code>sale<\\/code> query - handle exclude by manual selection.<\\/li>\\n<li>Fix: Product Categories grid row &amp; column style<\\/li>\\n<li>Fix: Form integration AJAX cache override<\\/li>\\n<li>Fix: Removed redundant CSS on Canvas &amp; Header-Footer page templates<\\/li>\\n<\\/ul>\\n<h4>2.5.8 - 2019-05-06<\\/h4>\\n<ul>\\n<li>Fix: Popup entrance animation not working in frontend<\\/li>\\n<li>Fix: Popup Exit Intent trigger activated multiple times<\\/li>\\n<\\/ul>\\n<h4>2.5.7 - 2019-05-05<\\/h4>\\n<ul>\\n<li>Fix: Embedded video keeps playing after a Popup is closed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7875\\\">#7875<\\/a>)<\\/li>\\n<li>Fix: Maximum call stack size exceeded error in Safari (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7824\\\">#7824<\\/a>)<\\/li>\\n<li>Fix: Entrance animations not appearing on Popup reopen (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7395\\\">#7395<\\/a>)<\\/li>\\n<li>Fix: WC variations select style glitch in several themes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/8008\\\">#8008<\\/a>)<\\/li>\\n<li>Fix: Theme Builder taxonomy conditions not retrieving proper results in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.5.6 - 2019-04-29<\\/h4>\\n<ul>\\n<li>Tweak: Removed <code>Shortcode<\\/code> dynamic from Image, Gallery and Media control<\\/li>\\n<li>Fix: Popup not inheriting entrance animation in responsive mode (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7809\\\">#7809<\\/a>)<\\/li>\\n<li>Fix: Terms autocomplete retrieves wrong results in Query Control<\\/li>\\n<li>Fix: Query Control Related by author glitches in edge cases<\\/li>\\n<li>Fix: Query Control using terms for Products widget<\\/li>\\n<li>Fix: Posts cards style glitch in small screens<\\/li>\\n<li>Fix: Display conditions delete icon missing in small screens<\\/li>\\n<li>Fix: Avoid rendering Menu Cart widget in WordPress native editor<\\/li>\\n<\\/ul>\\n<h4>2.5.5 - 2019-04-08<\\/h4>\\n<ul>\\n<li>Tweak: Allow text selection inside a Popup<\\/li>\\n<li>Fix: Added backwards compatibility for <code>tax_query<\\/code> in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7751\\\">#7751<\\/a>)<\\/li>\\n<li>Fix: Missing arguments for <code>widget_title<\\/code> filter (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7745\\\">#7745<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.4 - 2019-04-03<\\/h4>\\n<ul>\\n<li>Fix: Move Query from using <code>term_id<\\/code> to <code>term_taxonomy_id<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7653\\\">#7653<\\/a>)<\\/li>\\n<li>Fix: Offset manipulation hook removal in Query control<\\/li>\\n<li>Fix: Missing form field <code>ID<\\/code> in some edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7711\\\">#7711<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7660\\\">#7660<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.3 - 2019-03-31<\\/h4>\\n<ul>\\n<li>Tweak: Updated Google Calendar dynamic tag URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7673\\\">#7673<\\/a>)<\\/li>\\n<li>Fix: Missing form field names (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7651\\\">#7651<\\/a>)<\\/li>\\n<li>Fix: PHP 5.4 backward compatibility in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7633\\\">#7633<\\/a>)<\\/li>\\n<li>Fix: <code>products_deprecated<\\/code> Query Control module compatibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7654\\\">#7654<\\/a>)<\\/li>\\n<li>Fix: Changed query method from <code>term_id<\\/code> to <code>term_taxonomy_id<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7653\\\">#7653<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.5.2 - 2019-03-27<\\/h4>\\n<ul>\\n<li>Fix: Overwrite parent widget type in Global Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7632\\\">#7632<\\/a>)<\\/li>\\n<li>Fix: Avoid Duplicates option not working in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7635\\\">#7635<\\/a>)<\\/li>\\n<li>Fix: Manual Selection option not working in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7634\\\">#7634<\\/a>)<\\/li>\\n<li>Fix: Incorrect condition caused handlers issues inside popup<\\/li>\\n<\\/ul>\\n<h4>2.5.1 - 2019-03-26<\\/h4>\\n<ul>\\n<li>Fix: Query Control invalid call to deprecated action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7619\\\">#7619<\\/a>)<\\/li>\\n<li>Tweak: Renamed action hook from <code>elementor_pro\\/{$widget_name}\\/query\\/{$query_id}<\\/code> to <code>elementor\\/query\\/{$query_id}<\\/code><\\/li>\\n<li>Tweak: Renamed filter hook from <code>elementor_pro\\/query_control\\/get_query_args\\/current_query<\\/code> to <code>elementor\\/query\\/get_query_args\\/current_query<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.5.0 - 2019-03-26<\\/h4>\\n<ul>\\n<li>New: Introducing Motion Effects including Scrolling &amp; Mouse effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/72\\\">#72<\\/a>)<\\/li>\\n<li>New: Introducing Related Posts for Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7306\\\">#7306<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7490\\\">#7490<\\/a>)<\\/li>\\n<li>New: Introducing Date query for Query Control<\\/li>\\n<li>New: Introducing Sticky Posts support for Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2501\\\">#2501<\\/a>)<\\/li>\\n<li>Tweak: Added option to open a Popup by a custom selector (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6871\\\">#6871<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6876\\\">#6876<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7258\\\">#7258<\\/a>)<\\/li>\\n<li>Tweak: Option to count when Popup is closed in &quot;Show up to X times&quot; Advanced Rule<\\/li>\\n<li>Tweak: Added full border radius control options inside Popup<\\/li>\\n<li>Tweak: Changed exit intent icon in Popups<\\/li>\\n<li>Tweak: Show only one popup in its own preview<\\/li>\\n<li>Tweak: Added responsive support to Popup entrance animation control<\\/li>\\n<li>Tweak: Conditions - Singular <code>All Pages<\\/code> string changed to <code>Pages<\\/code><\\/li>\\n<li>Tweak: Added form field shortcode support for Drip tags (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7000\\\">#7000<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities to Price List widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7258\\\">#7258<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic capabilities to Custom Attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6779\\\">#6779<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities to Flip Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6986\\\">#6986<\\/a>)<\\/li>\\n<li>Tweak: Decrease <code>z-index<\\/code> for Nav Menu (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6869\\\">#6869<\\/a>)<\\/li>\\n<li>Tweak: Changed &quot;Scrolling Effects&quot; section label to &quot;Motion Effects&quot;<\\/li>\\n<li>Tweak: Use filter <code>get_meta_viewport<\\/code> for header templates (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7043\\\">#7043<\\/a>)<\\/li>\\n<li>Tweak: use filterable <code>Util::get_public_post_types()<\\/code> in Theme Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7172\\\">#7172<\\/a>)<\\/li>\\n<li>Tweak: Added Cloudflare rocket-loader support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7443\\\">#7443<\\/a>)<\\/li>\\n<li>Tweak: Added responsive support to WC Products Columns &amp; Rows Gap controls (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6913\\\">#6913<\\/a>)<\\/li>\\n<li>Tweak: WC Menu cart &quot;View Cart&quot; &amp; &quot;Checkout&quot; buttons styling<\\/li>\\n<li>Fix: Custom ID reset to default when dragging repeater<\\/li>\\n<li>Fix: Conflict between archive-products widget and WC customizer<\\/li>\\n<li>Fix: Add to Cart widget <code>spacing<\\/code> and <code>space-between<\\/code><\\/li>\\n<li>Fix: Library view when creating a new Header or Footer<\\/li>\\n<li>Fix: Post types labels missing on Add New Template modal<\\/li>\\n<\\/ul>\\n<h4>2.4.8 - 2019-03-11<\\/h4>\\n<ul>\\n<li>Fix: Missing query section in Products widget<\\/li>\\n<li>Fix: Missing Taxonomy controls in Products widget in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.4.7 - 2019-03-06<\\/h4>\\n<ul>\\n<li>Fix: Compatibility Global Widget with Elementor v2.5.0+<\\/li>\\n<\\/ul>\\n<h4>2.4.6 - 2019-03-04<\\/h4>\\n<ul>\\n<li>Fix: Pods gallery dynamic when empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7127\\\">#7127<\\/a>)<\\/li>\\n<li>Fix: Duplicate call for conditions screen issue<\\/li>\\n<li>Fix: Compatibility with Elementor v2.5.0<\\/li>\\n<\\/ul>\\n<h4>2.4.5 - 2019-02-18<\\/h4>\\n<ul>\\n<li>Fix: Image size issue in Testimonial Carousel (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7058\\\">#7058<\\/a>)<\\/li>\\n<li>Fix: MailChimp groups not saved in a form integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7083\\\">#7083<\\/a>)<\\/li>\\n<li>Fix: Show popup preview only on it\'s own preview<\\/li>\\n<li>Fix: Elementor dashboard templates URL corrupted links in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.4.4 - 2019-02-11<\\/h4>\\n<ul>\\n<li>Tweak: Added ACF Date Time Picker field support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6690\\\">#6690<\\/a>)<\\/li>\\n<li>Tweak: Changed the term of <code>All Posts<\\/code> condition to <code>Posts<\\/code><\\/li>\\n<li>Fix: Added <code>&lt;IfModule&gt;<\\/code> to avoid 500 error when <code>mod-headers<\\/code> is missing (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/7034\\\">#7034<\\/a>)<\\/li>\\n<li>Fix: Include post CSS deletion in Global Widget update (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6856\\\">#6856<\\/a>)<\\/li>\\n<li>Fix: <code>Textarea<\\/code> default value in Forms Widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6934\\\">#6934<\\/a>)<\\/li>\\n<li>Fix: MailPoet latest version caused fatal error (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6996\\\">#6996<\\/a>)<\\/li>\\n<li>Fix: Fatal Error caused by calling MailPoet deleted method<\\/li>\\n<li>Notice: MailPoet <code>Auto Confirm<\\/code> option will now default to &quot;On&quot;<\\/li>\\n<\\/ul>\\n<h4>2.4.3 - 2019-01-30<\\/h4>\\n<ul>\\n<li>Fix: Custom Add to Cart widget responsive alignment settings<\\/li>\\n<li>Fix: Links in Post Info widget<\\/li>\\n<li>Fix: WooCommerce <code>View Cart<\\/code> string translate<\\/li>\\n<li>Fix: Wrapper classes for header\\/footer templates (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6884\\\">#6884<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.4.2 - 2019-01-25<\\/h4>\\n<ul>\\n<li>Tweak: Added pixel units to Close Button position control in Popups<\\/li>\\n<li>Fix: Exclude error in WC Products widget<\\/li>\\n<\\/ul>\\n<h4>2.4.1 - 2019-01-24<\\/h4>\\n<ul>\\n<li>Tweak: Added CSS classes control to Popup (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6826\\\">#6826<\\/a>)<\\/li>\\n<li>Tweak: Added responsive image size to Testimonial Carousel widget<\\/li>\\n<li>Fix: PHP warning when Toolset Date dynamic is empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6842\\\">#6842<\\/a>)<\\/li>\\n<li>Fix: Support of exclude-ids in WC Products widget<\\/li>\\n<li>Fix: Popup close button not clickable<\\/li>\\n<li>Fix: Alignment justify issue of Add to Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6749\\\">#6749<\\/a>)<\\/li>\\n<li>Fix: Bad anchors breaks the page JS<\\/li>\\n<li>Fix: Popup overlay shown when turned off<\\/li>\\n<\\/ul>\\n<h4>2.4.0 - 2019-01-21<\\/h4>\\n<ul>\\n<li>New: Introducing Popup Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/628\\\">#628<\\/a>)<\\/li>\\n<li>New: Added <code>Popup<\\/code> Dynamic Tag<\\/li>\\n<li>New: Added <code>Popup<\\/code> forms action after submit<\\/li>\\n<li>New: Added User Info dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6322\\\">#6322<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic capabilities for &quot;Nothing Found&quot; message<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/theme_builder\\/archive\\/escape_nothing_found_message<\\/code> Filter to avoid HTML escaping in &quot;Nothing Found&quot; message (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6053\\\">#6053<\\/a>)<\\/li>\\n<li>Tweak: Added <code>add_doc_to_location<\\/code> method to Allow insertion of a document to a location<\\/li>\\n<li>Fix: <code>z-index<\\/code> issue with CTA widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6486\\\">#6486<\\/a>)<\\/li>\\n<li>Fix: Hide the Post Content widget and show it only in a Single document<\\/li>\\n<li>Fix: <code>selector<\\/code> replacement in Custom CSS<\\/li>\\n<li>Fix: Apply <code>the_content<\\/code> on the real content only<\\/li>\\n<li>Fix: CSS for WC products selector (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6559\\\">#6559<\\/a>)<\\/li>\\n<li>Fix: Odnoklassniki share URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6638\\\">#6638<\\/a>)<\\/li>\\n<li>Fix: Custom link new tab in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5766\\\">#5766<\\/a>)<\\/li>\\n<li>Fix: <code>nofollow<\\/code> link in Flip Box &amp; CTA widgets<\\/li>\\n<li>Fix: Post Terms in Post Info widget<\\/li>\\n<li>Fix: Added screen reader to some icons &amp; buttons for better accessibility (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5386\\\">#5386<\\/a>)<\\/li>\\n<li>Fix: Accessibility labels in Reviews widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6630\\\">#6630<\\/a>)<\\/li>\\n<li>Fix: Link to cart page not working when WooCommerce Subscriptions is active<\\/li>\\n<li>Fix: MailChimp Selected list not showing on reloading in Form widget<\\/li>\\n<li>Fix: Sub-menu arrow position in Nav Menu widget<\\/li>\\n<li>Fix: Conflict with WP Security Audit Log plugin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6648\\\">#6648<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.3.1 - 2018-12-19<\\/h4>\\n<ul>\\n<li>Fix: Template widget search functionality (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6473\\\">#6473<\\/a>)<\\/li>\\n<li>Fix: Apply <code>the_content<\\/code> filter to post content in theme builder<\\/li>\\n<\\/ul>\\n<h4>2.3.0 - 2018-12-17<\\/h4>\\n<ul>\\n<li>New: Introducing Discord Integration for Forms (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4218\\\">#4218<\\/a>)<\\/li>\\n<li>New: Introducing Slack Integration for Forms<\\/li>\\n<li>New: Introducing MailerLite Integration for Forms (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4462\\\">#4462<\\/a>)<\\/li>\\n<li>New: Activate Elementor Pro plugin by connecting to Elementor account<\\/li>\\n<li>Tweak: Added <code>elementor_pro\\/utils\\/get_public_post_types<\\/code> filter hook (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5900\\\">#5900<\\/a>)<\\/li>\\n<li>Tweak: Added <code>loop_start<\\/code> &amp; <code>the_content<\\/code> hooks for Post Content (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6173\\\">#6173<\\/a>)<\\/li>\\n<li>Tweak: Removed Custom Attributes from Page Settings<\\/li>\\n<li>Tweak: Always add the Custom CSS control to the Advanced tab<\\/li>\\n<li>Fix: In sub Term condition false positive in edge cases<\\/li>\\n<li>Fix: ToolSet Dynamic Image fallback<\\/li>\\n<li>Fix: Style glitch with the dropdown color in Nav Menu widget<\\/li>\\n<li>Fix: Style glitch in the Conditions screen in Safari browser<\\/li>\\n<li>Fix: Ribbon in the CTA widget obscures drop down menu (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6080\\\">#6080<\\/a>)<\\/li>\\n<li>Fix: The color of label won\'t change color in Widget login<\\/li>\\n<\\/ul>\\n<h4>2.2.5 - 2018-12-11<\\/h4>\\n<ul>\\n<li>New: Add Style Tab &amp; Custom CSS for Header &amp; Footer Templates.<\\/li>\\n<li>Tweak: Added a better identifier for subpages (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6362\\\">#6362<\\/a>)<\\/li>\\n<li>Tweak: Removed Custom Attributes from page settings<\\/li>\\n<li>Fix: Yahoo event URL date issue (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6354\\\">#6354<\\/a>)<\\/li>\\n<li>Fix: Allow timezone settings in Google event URL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6354\\\">#6354<\\/a>)<\\/li>\\n<li>Fix: Avoid <code>z-index<\\/code> changes by <code>nanocss<\\/code> in build process<\\/li>\\n<li>Fix: Added missing WC upsells products CSS<\\/li>\\n<li>Fix: Nav Menu dropdown losing color on hover<\\/li>\\n<li>Fix: WC Product Add-ons CSS compatibility<\\/li>\\n<\\/ul>\\n<h4>2.2.4 - 2018-12-04<\\/h4>\\n<ul>\\n<li>Fix: Global widget not saving changes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6340\\\">#6340<\\/a>)<\\/li>\\n<li>Fix: Dynamic tags support in Blockquote widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6334\\\">#6334<\\/a>)<\\/li>\\n<li>Fix: Forms Redirect URL action when using form field values with spaces<\\/li>\\n<\\/ul>\\n<h4>2.2.3 - 2018-11-29<\\/h4>\\n<ul>\\n<li>Fix: Missing &quot;Edit Template&quot; in Template widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6271\\\">#6271<\\/a>)<\\/li>\\n<li>Fix: Follow menu anchors with UTF8 characters in Nav Menu<\\/li>\\n<li>Fix: Show only supported templates in Template widget<\\/li>\\n<li>Fix: Revert conflicting fix for a default order for WC archive<\\/li>\\n<\\/ul>\\n<h4>2.2.2 - 2018-11-28<\\/h4>\\n<ul>\\n<li>Fix: Lightbox dynamic tag crashes the editor<\\/li>\\n<\\/ul>\\n<h4>2.2.1 - 2018-11-28<\\/h4>\\n<ul>\\n<li>New: Added <code>ACF File<\\/code> Dynamic tag to support text controls.<\\/li>\\n<li>Tweak: Added option to hide item count bubble when cart is empty in Menu Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6223\\\">#6223<\\/a>)<\\/li>\\n<li>Tweak: Added Actions group for Lightbox and Contact URL tags<\\/li>\\n<li>Tweak: Added filter <code>elementor_pro\\/dynamic_tags\\/shortcode\\/should_escape<\\/code> to avoid escaping in Shortcode dynamic tag<\\/li>\\n<li>Tweak: MailPoet3 integration allow Subscriber to to subscribe to multiple lists<\\/li>\\n<li>Tweak: Added front-end max file size validation for upload fields<\\/li>\\n<li>Tweak: Added <code>by-author<\\/code> per Post-Type condition for theme builder<\\/li>\\n<li>Fix: Template widget panel not showing the selected template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6271\\\">#6271<\\/a>)<\\/li>\\n<li>Fix: Conflict between ACF with Safari browser on Select option in Dynamic tag<\\/li>\\n<li>Fix: Add post classes only for the Single template<\\/li>\\n<li>Fix: Set document type as not editable for unsupported document like Global widget<\\/li>\\n<li>Fix: Avoid duplicate query for current WC product query<\\/li>\\n<li>Fix: Product Archive showing oldest products instead of latest<\\/li>\\n<li>Fix: CSS reset in Posts widget using cards skin<\\/li>\\n<\\/ul>\\n<h4>2.2.0 - 2018-11-19<\\/h4>\\n<ul>\\n<li>New: Introducing Custom Attributes (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/290\\\">#290<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3990\\\">#3990<\\/a>)<\\/li>\\n<li>New: Added evergreen option for Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4459\\\">#4459<\\/a>)<\\/li>\\n<li>New: Added expire actions option for Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5242\\\">#5242<\\/a>)<\\/li>\\n<li>New: Introducing Reviews widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3854\\\">#3854<\\/a>)<\\/li>\\n<li>New: Introducing Sitemap widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5594\\\">#5594<\\/a>)<\\/li>\\n<li>New: Added Request Parameter dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4934\\\">#4934<\\/a>)<\\/li>\\n<li>New: Added Shortcode dynamic tag<\\/li>\\n<li>New: Added Image and Video Lightbox dynamic tag<\\/li>\\n<li>New: Added Contact URL dynamic tag<\\/li>\\n<li>New: Added Featured Image Data dynamic tag<\\/li>\\n<li>New: Added default value to each field in the Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4268\\\">#4268<\\/a>)<\\/li>\\n<li>New: Added &quot;Any Child Of&quot; condition to template conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5321\\\">#5321<\\/a>)<\\/li>\\n<li>New: Added &quot;In Child&quot; condition to template conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5587\\\">#5587<\\/a>)<\\/li>\\n<li>Tweak: Added Form Redirect URL with form values (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2564\\\">#2564<\\/a>)<\\/li>\\n<li>Tweak: Added default post classes to template wrapper (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5959\\\">#5959<\\/a>)<\\/li>\\n<li>Tweak: Better labels for terms in Query control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6092\\\">#6092<\\/a>)<\\/li>\\n<li>Tweak: Renamed &quot;Child Of&quot; templates condition to &quot;Direct Child Of&quot;<\\/li>\\n<li>Tweak: Added <code>elementor\\/theme\\/get_location_templates\\/condition_sub_id<\\/code> filter hook to allow template condition translations<\\/li>\\n<li>Tweak: Load the Template Library widget via Ajax for better performance<\\/li>\\n<li>Tweak: Added 404 page title for Page Title dynamic tag<\\/li>\\n<li>Fix: Menu Cart Toggle has # URL link (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6141\\\">#6141<\\/a>)<\\/li>\\n<li>Fix: Alignment issue in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5790\\\">#5790<\\/a>)<\\/li>\\n<li>Fix: Avoid potential security risk in forms<\\/li>\\n<li>Fix: Template By Author condition conflicts with 404 page<\\/li>\\n<li>Fix: Restored WC Product Content widget in Single Product template<\\/li>\\n<li>Fix: Theme Builder Preview URLs for date archives and 404 pages<\\/li>\\n<li>Fix: Highlight active menu anchor items only when scrolled into view<\\/li>\\n<li>Fix: Carousel Pagination Progress style to support new Swiper version<\\/li>\\n<\\/ul>\\n<h4>2.1.13 - 2018-11-12<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for new brand Finder in v2.3.0<\\/li>\\n<li>Fix: Settings conflict when there are multiple carousels in the page<\\/li>\\n<\\/ul>\\n<h4>2.1.12 - 2018-11-05<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.3<\\/li>\\n<li>Tweak: Better performance for Template Library widget<\\/li>\\n<li>Fix: Fatal error if a taxonomy used in a dynamic field is removed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6029\\\">#6029<\\/a>)<\\/li>\\n<li>Fix: Date Time dynamic tag now respect site language (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6001\\\">#6001<\\/a>)<\\/li>\\n<li>Fix: Custom CSS printed twice in the front-end<\\/li>\\n<li>Fix: ACF Image field PHP warning (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/6051\\\">#6051<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.1.11 - 2018-10-22<\\/h4>\\n<ul>\\n<li>New: Added ACF local fields compatibility<\\/li>\\n<li>Tweak: Re-brand TypeKit by Adobe Fonts integration<\\/li>\\n<li>Fix: Exclude <code>is_embed<\\/code> from Singular condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5915\\\">#5915<\\/a>)<\\/li>\\n<li>Fix: Avoid conflict with Ad Blockers and Share Buttons<\\/li>\\n<li>Fix: Current date time dynamic tag now shows local time<\\/li>\\n<li>Fix: Avoid conflict with 3rd party plugins that filter the permalink<\\/li>\\n<li>Fix: Avoid PHP warning when no groups are selected for MailChimp integration<\\/li>\\n<li>Fix: Avoid PHP warning if checkbox field is empty for ACF<\\/li>\\n<li>Fix: Respect password protected for a WC single product template<\\/li>\\n<li>Fix: Respect <code>order<\\/code> settings for WC archive also without pagination<\\/li>\\n<\\/ul>\\n<h4>2.1.10 - 2018-10-09<\\/h4>\\n<ul>\\n<li>Tweak: Added responsive alignment control for Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5821\\\">#5821<\\/a>)<\\/li>\\n<li>Tweak: Added link control to Animated Headline widget<\\/li>\\n<li>Fix: Mobile nav menu jump on RTL (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5711\\\">#5711<\\/a>)<\\/li>\\n<li>Fix: Responsive alignment control in Add to Cart widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5830\\\">#5830<\\/a>)<\\/li>\\n<li>Fix: Added IE compatibility for Animated Headline widget<\\/li>\\n<li>Fix: Post Content widget is now shown only on <code>Single<\\/code> templates<\\/li>\\n<li>Fix: Query Control Pagination with offset<\\/li>\\n<\\/ul>\\n<h4>2.1.9 - 2018-09-17<\\/h4>\\n<ul>\\n<li>Tweak: Added Centered Slides option for Slideshow carousel<\\/li>\\n<li>Fix: Allow only public CPT for Manual Selection in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5091\\\">#5091<\\/a>)<\\/li>\\n<li>Fix: ACF Gallery option support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5344\\\">#5344<\\/a>)<\\/li>\\n<li>Fix: Page scrolling on resize when sticky is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5740\\\">#5740<\\/a>)<\\/li>\\n<li>Fix: Edit custom name for Global Widget in the Navigator (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5689\\\">#5689<\\/a>)<\\/li>\\n<li>Fix: Coverflow transition effect in Carousel<\\/li>\\n<li>Fix: Weird mobile behavior with Cube effect in Carousel<\\/li>\\n<li>Fix: Show the first thumbnail in the Slideshow carousel correctly<\\/li>\\n<\\/ul>\\n<h4>2.1.8 - 2018-09-12<\\/h4>\\n<ul>\\n<li>Tweak: Added styling options for WC Additional Information widget<\\/li>\\n<li>Tweak: Added styling options for \'View Cart\' link in Products widget<\\/li>\\n<li>Fix: 3rd party plugin support for WC single product template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5338\\\">#5338<\\/a>)<\\/li>\\n<li>Fix: Layout of Related Product widget with WC native style<\\/li>\\n<\\/ul>\\n<h4>2.1.7 - 2018-09-03<\\/h4>\\n<ul>\\n<li>New: WC Archive Description widget<\\/li>\\n<li>Tweak: Added blend mode to Slides widget background overlay (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5555\\\">#5555<\\/a>)<\\/li>\\n<li>Tweak: Added \'Current Subcategories\' option to Product Categories widget<\\/li>\\n<li>Fix: Added default vertical alignment in Author Box widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5589\\\">#5589<\\/a>)<\\/li>\\n<li>Tweak: Added more blend mode options for CTA widget<\\/li>\\n<li>Tweak: Improved plugin updater method based on WordPress version<\\/li>\\n<li>Fix: Improved IE compatibility for Posts and Portfolio widgets<\\/li>\\n<li>Fix: Added default gap for products pagination<\\/li>\\n<li>Fix: Post thumbnail flickering in Safari browser<\\/li>\\n<li>Fix: Close mobile nav menu on click only in full-width mode<\\/li>\\n<li>Fix: Added trailing slash to pagination links in Posts widget<\\/li>\\n<\\/ul>\\n<h4>2.1.6 - 2018-08-28<\\/h4>\\n<ul>\\n<li>New: WC Product Category Image widget and Dynamic tag (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5117\\\">#5117<\\/a>)<\\/li>\\n<li>Tweak: Allow HTML in Excerpt widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5491\\\">#5491<\\/a>)<\\/li>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2<\\/li>\\n<li>Tweak: Deprecated Follow option in the Facebook Button widget<\\/li>\\n<li>Fix: Posts widget grid in Safari &amp; IE11 (Depended on Elementor v2.2)<\\/li>\\n<li>Fix: Posts widget CSS when using cards skin in masonry mode<\\/li>\\n<li>Fix: ACF Image &amp; ACF URL option support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5344\\\">#5344<\\/a>)<\\/li>\\n<li>Fix: WC product gallery links in RTL<\\/li>\\n<li>Fix: Dynamic tags in Call To Action widget<\\/li>\\n<\\/ul>\\n<h4>2.1.5 - 2018-08-21<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the upcoming release of Elementor v2.2<\\/li>\\n<li>Fix: Posts Widget layout theme compatibility<\\/li>\\n<li>Fix: Added compatibility for WooCommerce native style<\\/li>\\n<\\/ul>\\n<h4>2.1.4 - 2018-08-19<\\/h4>\\n<ul>\\n<li>Fix: Layout issue compatibility with themes caused by v2.1 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5442\\\">#5442<\\/a>)<\\/li>\\n<li>Fix: Dynamic setting in Pricing Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5460\\\">#5460<\\/a>)<\\/li>\\n<li>Fix: Hide Target URL control if is not necessary in Blockquote widget<\\/li>\\n<li>Fix: Selector specificity for WooCommerce Products widget<\\/li>\\n<li>Fix: WooCommerce conflicts in the editor in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.1.3 - 2018-08-15<\\/h4>\\n<ul>\\n<li>Fix: Thumbnails in the Posts widget jumping (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5350\\\">#5350<\\/a>)<\\/li>\\n<li>Fix: Responsive grid in the Share Buttons widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5375\\\">#5375<\\/a>)<\\/li>\\n<li>Fix: Added missing <code>setup_postdata<\\/code> for Product Data Tabs widget<\\/li>\\n<li>Fix: Rollback to older version of Flip Box widget to resolve 3D depth issue (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5399\\\">#5399<\\/a>)<\\/li>\\n<li>Fix: Allowed types in the Upload File field are now case-insensitive (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5254\\\">#5254<\\/a>)<\\/li>\\n<li>Fix: Carousel behavior when using a single slide<\\/li>\\n<\\/ul>\\n<h4>2.1.2 - 2018-08-12<\\/h4>\\n<ul>\\n<li>Fix: Error when ACF Pro is not installed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5367\\\">#5367<\\/a>)<\\/li>\\n<li>Fix: Edge cases in Inspector where document is a boolean<\\/li>\\n<li>Fix: Edge cases for incorrect file fields in PODS<\\/li>\\n<\\/ul>\\n<h4>2.1.1 - 2018-08-09<\\/h4>\\n<ul>\\n<li>Fix: Highlighted text in Animated Headline widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5345\\\">#5345<\\/a>)<\\/li>\\n<li>Fix: Flip Box effect issues<\\/li>\\n<li>Fix: ACF Options page fields support (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5329\\\">#5329<\\/a>)<\\/li>\\n<li>Fix: Import Pro templates in edge cases<\\/li>\\n<\\/ul>\\n<h4>2.1.0 - 2018-08-07<\\/h4>\\n<ul>\\n<li>New: Introducing WooCommerce Builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1690\\\">#1690<\\/a>)<\\/li>\\n<li>New: Introducing 12 new dynamic tags &amp; widgets for WooCommerce: Gallery, Image, Price, Rating, Description, Breadcrumbs, Data Tabs, Stock, Related, Upsell, Title &amp; Archive<\\/li>\\n<li>New: Introducing Cart Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4220\\\">#4220<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4600\\\">#4600<\\/a>)<\\/li>\\n<li>New: Added integration with Toolset (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2949\\\">#2949<\\/a>)<\\/li>\\n<li>New: Added integration with Pods (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4129\\\">#4129<\\/a>)<\\/li>\\n<li>New: Added stick to bottom in scrolling effects (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4799\\\">#4799<\\/a>)<\\/li>\\n<li>New: Added Scrolling Effect to Widgets under advanced tab<\\/li>\\n<li>New: Introducing Internal URL Dynamic Tag<\\/li>\\n<li>Tweak: Added a Last Updated Date in the Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4597\\\">#4597<\\/a>)<\\/li>\\n<li>Tweak: Added Redirect after Logout option for Login widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4447\\\">#4447<\\/a>)<\\/li>\\n<li>Tweak: Avoid repeating posts when using more than one in the Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1878\\\">#1878<\\/a>)<\\/li>\\n<li>Tweak: Add Custom Query hook for Query control (<a href=\\\"https:\\/\\/developers.elementor.com\\/custom-query-filter\\/\\\">More Info<\\/a>) (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1748\\\">#1748<\\/a>)<\\/li>\\n<li>Tweak: Added form-message style (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1180\\\">#1180<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag for button on the Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4242\\\">#4242<\\/a>)<\\/li>\\n<li>Tweak: Added dynamic tag for Call to action widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4767\\\">#4767<\\/a>)<\\/li>\\n<li>Tweak: Added Dynamic Tags support for Google Map field (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4602\\\">#4602<\\/a>)<\\/li>\\n<li>Tweak: Added an support for <code>label|value<\\/code> in options field (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4594\\\">#4594<\\/a>)<\\/li>\\n<li>Tweak: Added <code>by-author<\\/code> condition for theme builder (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4681\\\">#4681<\\/a>)<\\/li>\\n<li>Tweak: Added Activate\\/Deactivate license key via WP-CLI command (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4149\\\">#4149<\\/a>)<\\/li>\\n<li>Tweak: Added <code>is_scroll<\\/code> trigger to scrolling effect (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4340\\\">#4340<\\/a>)<\\/li>\\n<li>Tweak: Added In Same Term support for Post Navigation widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4177\\\">#4177<\\/a>)<\\/li>\\n<li>Tweak: Added responsive control for Slides To Scroll control in all carousel widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3697\\\">#3697<\\/a>)<\\/li>\\n<li>Tweak: Added style options for Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1335\\\">#1335<\\/a>)<\\/li>\\n<li>Tweak: Added button CSS ID for Forms widget<\\/li>\\n<li>Tweak: Added pixel units to Post-Info divider height control<\\/li>\\n<li>Tweak: Rewrite sticky library to handle with stretch section, auto scroller &amp; more bugs<\\/li>\\n<li>Tweak: Re-organize the panel categories per document type<\\/li>\\n<li>Tweak: Added ACF support for <code>options-page<\\/code> fields<\\/li>\\n<li>Tweak: Added dynamic tag for Animated headlines<\\/li>\\n<li>Tweak: Added dynamic tag for BlockQuote widget<\\/li>\\n<li>Fix: Elementor Full Width template in GeneratePress theme (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4817\\\">#4817<\\/a>)<\\/li>\\n<li>Fix: Checkbox fields can accidentally be set to required (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4324\\\">#4324<\\/a>)<\\/li>\\n<li>Fix: Initial slide in Carousel widget<\\/li>\\n<li>Fix: Stay on current slide while editing in Carousel widget<\\/li>\\n<li>Fix: Default slides per device in Carousel widget<\\/li>\\n<li>Deprecated: Woo Products, Woo Elements &amp; Single elements widgets<\\/li>\\n<\\/ul>\\n<h4>2.0.18 - 2018-07-27<\\/h4>\\n<ul>\\n<li>Fix: Global widget error on saving page<\\/li>\\n<\\/ul>\\n<h4>2.0.17 - 2018-07-26<\\/h4>\\n<ul>\\n<li>Fix: Sub menu indicator direction in Nav Menu widget<\\/li>\\n<li>Fix: Change the title and icon for Global Widget when is moving<\\/li>\\n<li>Fix: CSS wrapper selector for Page Document<\\/li>\\n<\\/ul>\\n<h4>2.0.16 - 2018-07-16<\\/h4>\\n<ul>\\n<li>Tweak: CSS Filter Control module is now included in Elementor<\\/li>\\n<li>Fix: Border gap in Portfolio widget when item gap set as <code>0<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/5077\\\">#5077<\\/a>)<\\/li>\\n<li>Fix: Restore current query after get Global Widget data<\\/li>\\n<li>Fix: Add action item in History on unlink Global widget<\\/li>\\n<\\/ul>\\n<h4>2.0.15 - 2018-07-10<\\/h4>\\n<ul>\\n<li>Fix: Dropdown menu items collapsing when activated (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4996\\\">#4996<\\/a>)<\\/li>\\n<li>Fix: GMT offset in Countdown widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4997\\\">#4997<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>2.0.14 - 2018-07-08<\\/h4>\\n<ul>\\n<li>Tweak: Added set method to form record for developers (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4983\\\">#4983<\\/a>)<\\/li>\\n<li>Fix: Autoplay option for Carousels<\\/li>\\n<li>Fix: Close mobile menu on item click in the Nav Menu widget<\\/li>\\n<\\/ul>\\n<h4>2.0.13 - 2018-07-03<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for Elementor v2.1<\\/li>\\n<\\/ul>\\n<h4>2.0.12 - 2018-07-02<\\/h4>\\n<ul>\\n<li>Fix: Global widget PHP notices<\\/li>\\n<li>Fix: Slides widget active slide lost focus when clicking Editor tabs<\\/li>\\n<li>Fix: Form select field send all selected values on multiple selection<\\/li>\\n<li>Fix: Validate time field only if it\'s not empty<\\/li>\\n<li>Fix: ConvertKit API not saving name field<\\/li>\\n<\\/ul>\\n<h4>2.0.11 - 2018-06-12<\\/h4>\\n<ul>\\n<li>Fix: Theme Builder <code>author<\\/code> archive condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4593\\\">#4593<\\/a>)<\\/li>\\n<li>Fix: Respect password protected posts in Post Content widget<\\/li>\\n<li>Fix: Custom Fonts redirect to post edit screen in edge cases.<\\/li>\\n<\\/ul>\\n<h4>2.0.10 - 2018-06-05<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>elementor\\/theme\\/get_location_templates\\/template_id<\\/code> filter hook for multi-language plugins<\\/li>\\n<li>Fix: Dynamic Post Terms missing taxonomies if the taxonomy is registered to more then one post types (#4386)<\\/li>\\n<li>Fix: Fields shortcode missing after removing a field in Form widget<\\/li>\\n<li>Deprecated: <code>get_theme_templates_by_location<\\/code> is replaced by <code>get_location_templates<\\/code><\\/li>\\n<\\/ul>\\n<h4>2.0.9 - 2018-05-28<\\/h4>\\n<ul>\\n<li>Fix: Compatibility for PHP version 5.4<\\/li>\\n<\\/ul>\\n<h4>2.0.8 - 2018-05-28<\\/h4>\\n<ul>\\n<li>Tweak: Added Active state for Nav Menu dropdown<\\/li>\\n<li>Tweak: Added style for &quot;Nothing Found&quot; Message for Archive Posts widget<\\/li>\\n<li>Tweak: Removed caption control in Site Logo widget<\\/li>\\n<li>Tweak: Added option to position currency symbol before\\/after In Price Table widget<\\/li>\\n<li>Fix: Query control manual selection does not show more than 10 items (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4479\\\">#4479<\\/a>)<\\/li>\\n<li>Fix: Styling glitch with terms list in Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4342\\\">#4342<\\/a>)<\\/li>\\n<li>Fix: Sub terms missing in Query control in edge cases (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4527\\\">#4527<\\/a>)<\\/li>\\n<li>Fix: Avoid rendering a template if it\'s not published<\\/li>\\n<li>Fix: 404 Page style not working<\\/li>\\n<li>Fix: Price Table button with hover animation not working in editor<\\/li>\\n<li>Fix: Styling conflict in Call to Action widget<\\/li>\\n<li>Fix: Global Widget tab translation<\\/li>\\n<li>Fix: Adding parent wrapper class to Site Title widget<\\/li>\\n<\\/ul>\\n<h4>2.0.7 - 2018-05-16<\\/h4>\\n<ul>\\n<li>Fix: Content not found on section when single is set to &quot;All Singular&quot;<\\/li>\\n<li>Fix: Open 404 template library for 404 page<\\/li>\\n<li>Tweak: Added CSS prefix for dev files<\\/li>\\n<li>Tweak: Removed product post type from display conditions<\\/li>\\n<\\/ul>\\n<h4>2.0.6 - 2018-05-15<\\/h4>\\n<ul>\\n<li>Tweak: Set type on create new single template<\\/li>\\n<li>Tweak: Always show the conditions dialog in the Draft status<\\/li>\\n<li>Tweak: Added document type <code>widget<\\/code><\\/li>\\n<li>Tweak: Added Post Custom Field tag to URL category<\\/li>\\n<li>Fix: When ACF Field Groups are Empty (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4428\\\">#4428<\\/a>)<\\/li>\\n<li>Fix: Links inside carousel in edge cases<\\/li>\\n<li>Fix: Responsive issue in My Templates area<\\/li>\\n<li>Fix: Image alignment for post content with text alignment<\\/li>\\n<li>Fix: Post Content widget when preview post is missing<\\/li>\\n<li>Fix: Global Widget tab translation<\\/li>\\n<li>Fix: Style settings for Post \\/ Archive Title widgets<\\/li>\\n<\\/ul>\\n<h4>2.0.5 - 2018-05-08<\\/h4>\\n<ul>\\n<li>Fix: Creating a CPT with name like document-type breaks the editor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4203\\\">#4203<\\/a>)<\\/li>\\n<li>Fix: Added support for new version of reCAPTCHA<\\/li>\\n<li>Fix: Added fallback for controls after <code>post_status<\\/code><\\/li>\\n<li>Fix: Required field in forms widget<\\/li>\\n<li>Fix: Media Carousel in the Coverflow skin<\\/li>\\n<li>Fix: 404 Page show wrong template in edge cases<\\/li>\\n<li>Fix: Save the default menu in the Nav Menu widget<\\/li>\\n<\\/ul>\\n<h4>2.0.4 - 2018-05-02<\\/h4>\\n<ul>\\n<li>Tweak: Added parent\'s class for extended widgets<\\/li>\\n<li>Tweak: Set entire-site as default to avoid conflict with save without conditions<\\/li>\\n<li>Tweak: Initialize global model when it\'s needed<\\/li>\\n<li>Tweak: Removed some duplicate strings<\\/li>\\n<li>Tweak: Query control now includes empty terms<\\/li>\\n<li>Tweak: Design polish for conditions dialog<\\/li>\\n<li>Tweak: Decreasing <code>minimumInputLength<\\/code> to 1 of select2<\\/li>\\n<li>Fix: Editor not loading for single templates in edge cases<\\/li>\\n<li>Fix: Select2 in Safari takes it\'s time to get the original select width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4310\\\">#4310<\\/a>)<\\/li>\\n<li>Fix: Slides per view not working for some effects<\\/li>\\n<li>Fix: New slides not showing in the editor<\\/li>\\n<li>Fix: Editor for section without a defined location, defaults to content area<\\/li>\\n<\\/ul>\\n<h4>2.0.3 - 2018-04-24<\\/h4>\\n<ul>\\n<li>Tweak: Optimize CSS for Post Info widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4214\\\">#4214<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4216\\\">#4216<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4225\\\">#4225<\\/a>)<\\/li>\\n<li>Fix: Double render on frontend view in core locations<\\/li>\\n<li>Fix: Masonry not working in edge cases<\\/li>\\n<li>Fix: Added default setting for Author Info tag<\\/li>\\n<\\/ul>\\n<h4>2.0.2 - 2018-04-18<\\/h4>\\n<ul>\\n<li>Fix: Regenerate conditions to include all templates<\\/li>\\n<\\/ul>\\n<h4>2.0.1 - 2018-04-17<\\/h4>\\n<ul>\\n<li>Tweak: Added div wrapper for Nothing Found massage (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4136\\\">#4136<\\/a>)<\\/li>\\n<li>Tweak: Show empty categories in Query Control &amp; Display Conditions (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/4127\\\">#4127<\\/a>)<\\/li>\\n<li>Tweak: Added Divider control for Post Info widget<\\/li>\\n<li>Fix: Update admin links in Yoast Breadcrumbs widget<\\/li>\\n<li>Fix: Sticky element conflict with clearfix CSS<\\/li>\\n<li>Fix: Compatibility for PHP version 5.4.32 &amp; 5.5.16 and below<\\/li>\\n<li>Fix: Avoid running <code>wp_head<\\/code> hooks twice<\\/li>\\n<\\/ul>\\n<h4>2.0.0 - 2018-04-16<\\/h4>\\n<ul>\\n<li>New: Introducing Theme Builder - <a href=\\\"https:\\/\\/elementor.com\\/introducing-theme-builder\\/\\\">Release Post<\\/a> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/417\\\">#417<\\/a>)<\\/li>\\n<li>New: Introducing Locations API to inject custom location templates<\\/li>\\n<li>New: Introducing Display Conditions for all dynamic templates<\\/li>\\n<li>New: Introducing Dynamic Tag feature - a new way to add dynamic content to your design<\\/li>\\n<li>New: Introducing Role manager to allow &quot;Content Only mode&quot; (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/483\\\">#483<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/653\\\">#653<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/885\\\">#885<\\/a>)<\\/li>\\n<li>New: Introducing 9 new dynamic widgets: Archive Posts, Archive Title, Post Content, Post Info, Post Title, Post Excerpt, Featured Image, Site Logo &amp; Site Name (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/543\\\">#543<\\/a>)<\\/li>\\n<li>New: Introducing Developers area with guides and API documentation - <a href=\\\"https:\\/\\/elementor.com\\/introducing-elementor-developer-api\\/\\\">Release Post<\\/a> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/451\\\">#451<\\/a>)<\\/li>\\n<li>New: Introducing <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor-hello-theme\\\">Elementor Hello Theme<\\/a> - A demonstration theme for developers<\\/li>\\n<li>New: Added new type of templates: Header, Footer, Single and Archive (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2761\\\">#2761<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2623\\\">#2623<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2109\\\">#2109<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2061\\\">#2061<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2439\\\">#2439<\\/a>)<\\/li>\\n<li>New: Design 404 page with Single template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1558\\\">#1558<\\/a>)<\\/li>\\n<li>New: Design Search Results with Archive template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3196\\\">#3196<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2590\\\">#2590<\\/a>)<\\/li>\\n<li>New: Added Scrolling Effect for sections including <em>Sticky Element<\\/em> per device (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2412\\\">#2412<\\/a>)<\\/li>\\n<li>New: Integration with Custom Fields (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2054\\\">#2054<\\/a>)<\\/li>\\n<li>New: Partial support for Toolset integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2949\\\">#2949<\\/a>)<\\/li>\\n<li>New: Partial support for Pods integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2169\\\">#2169<\\/a>)<\\/li>\\n<li>New: Partial support for ACF integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2041\\\">#2041<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2059\\\">#2059<\\/a>)<\\/li>\\n<li>Tweak: Add custom fields support for ActiveCampaign (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3531\\\">#3531<\\/a>)<\\/li>\\n<li>Tweak: Allow brackets in Forms Tel field<\\/li>\\n<li>Tweak: Added currency format control for Price Table widget<\\/li>\\n<li>Tweak: Reduced API request for some servers<\\/li>\\n<li>Fix: Dropdown <code>border-radius<\\/code> in Nav Menu widget<\\/li>\\n<li>Fix: Price List widget layout breaks in edge cases<\\/li>\\n<li>Note: This version requires Elementor v2.0.6<\\/li>\\n<\\/ul>\\n<h4>1.15.6 - 2018-03-28<\\/h4>\\n<ul>\\n<li>Fix: Removed duplicate Custom CSS section (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3938\\\">#3938<\\/a>)<\\/li>\\n<li>Fix: <code>box-shadow<\\/code> issue with cards skin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3940\\\">#3940<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.15.5 - 2018-03-27<\\/h4>\\n<ul>\\n<li>Fix: Added global widget compatibility for Elementor v2.0<\\/li>\\n<li>Fix: Reduced API request for some servers<\\/li>\\n<\\/ul>\\n<h4>1.15.4 - 2018-03-26<\\/h4>\\n<ul>\\n<li>Tweak: Allow brackets in phone field<\\/li>\\n<li>Tweak: Added compatibility with Yoast 7.0.+<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v2.0<\\/li>\\n<li>Fix: Support for multiple carousel setting in editor<\\/li>\\n<li>Fix: <code>on_export<\\/code> issue in forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3890\\\">#3890<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.15.3 - 2018-03-07<\\/h4>\\n<ul>\\n<li>Tweak: Added unique class to field group div (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3595\\\">#3595<\\/a>)<\\/li>\\n<li>Fix: Screen Options missing when Pro is active (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3622\\\">#3622<\\/a>)<\\/li>\\n<li>Fix: Allow label styling even when <code>show labels<\\/code> is set hide (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3544\\\">#3544<\\/a>)<\\/li>\\n<li>Fix: Typography control not working in edge cases<\\/li>\\n<li>Fix: Safari compatibility for Search widget<\\/li>\\n<\\/ul>\\n<h4>1.15.2 - 2018-02-27<\\/h4>\\n<ul>\\n<li>Fix: Only add support mine-type if needed (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3543\\\">#3543<\\/a>)<\\/li>\\n<li>Fix: Better support for Old Typekit kits<\\/li>\\n<\\/ul>\\n<h4>1.15.1 - 2018-02-21<\\/h4>\\n<ul>\\n<li>Tweak: Custom font title placeholder is not <code>enter font family<\\/code><\\/li>\\n<li>Tweak: Custom font title set as required<\\/li>\\n<li>Fix: Custom font, <code>font-face<\\/code> enqueued only once if used in global (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3513\\\">#3513<\\/a>)<\\/li>\\n<li>Fix: Added workaround for upload validation which relies on a PHP extension (fileinfo) with inconsistent reporting behavior.<\\/li>\\n<\\/ul>\\n<h4>1.15.0 - 2018-02-19<\\/h4>\\n<ul>\\n<li>New: Added custom fonts manager for self hosted fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/852\\\">#852<\\/a>)<\\/li>\\n<li>New: Integration with Adobe TypeKit fonts (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/631\\\">#631<\\/a>)<\\/li>\\n<li>Tweak: Clear menu from Nav Menu widget on template export<\\/li>\\n<li>Tweak: Allow zero for GetResponse integration as <code>day of cycle<\\/code><\\/li>\\n<\\/ul>\\n<h4>1.14.2 - 2018-02-13<\\/h4>\\n<ul>\\n<li>Fix: Global widget content that got affected by previous update<\\/li>\\n<\\/ul>\\n<h4>1.14.1 - 2018-02-13<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>none<\\/code> option to content animation in CTA widget<\\/li>\\n<li>Tweak: Added <code>form_id<\\/code> to ActiveCampaign integration (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/3422\\\">#3422<\\/a>)<\\/li>\\n<li>Fix: Page crashed when Global widget not found.<\\/li>\\n<\\/ul>\\n<h4>1.14.0 - 2018-02-12<\\/h4>\\n<ul>\\n<li>New: Added Call to Action widget<\\/li>\\n<li>Tweak: MailPoet pull field mapping from MailPoet instead of hardcoded<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v2.0<\\/li>\\n<li>Fix: Allow zero (0) to be accepted as a field value<\\/li>\\n<li>Fix: Login form when custom login URL is set<\\/li>\\n<li>Fix: Added Day of cycle control to GetResponse integration<\\/li>\\n<\\/ul>\\n<h4>1.13.2 - 2018-01-23<\\/h4>\\n<ul>\\n<li>Tweak: Added placeholder to Password field<\\/li>\\n<li>Tweak: Removed <code>subscriber_already_exists_message<\\/code> control to prevent potential data leakage<\\/li>\\n<li>Fix: MailPoet Subscriber Already Exists error validation against translated string directly from MailPoet<\\/li>\\n<li>Fix: Changed <code>imagesLoaded()<\\/code> to Vanilla JS to avoid compatibility issues with some themes<\\/li>\\n<li>Fix: Only validate Tel field if not empty<\\/li>\\n<li>Fix: Stop slider while editing<\\/li>\\n<\\/ul>\\n<h4>1.13.1 - 2018-01-16<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility with old PHP versions<\\/li>\\n<\\/ul>\\n<h4>1.13.0 - 2018-01-16<\\/h4>\\n<ul>\\n<li>New: Added File Upload field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1482\\\">#1482<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2974\\\">#2974<\\/a>)<\\/li>\\n<li>New: Added Acceptance field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1693\\\">#1693<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2974\\\">#2974<\\/a>)<\\/li>\\n<li>New: Added Date field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1868\\\">#1868<\\/a>)<\\/li>\\n<li>New: Added Time field for Forms widget<\\/li>\\n<li>New: Added Password field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2164\\\">#2164<\\/a>)<\\/li>\\n<li>New: Added HTML field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1500\\\">#1500<\\/a>)<\\/li>\\n<li>Tweak: Added characters validation for Tel field<\\/li>\\n<li>Tweak: Added min &amp; max validation for Number field<\\/li>\\n<li>Tweak: Added multiple selection for Select field<\\/li>\\n<li>Tweak: Added donReach integration for Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>1.12.3 - 2018-01-09<\\/h4>\\n<ul>\\n<li>Fix: Render element plain content instead of parsed content when not needed in global widget<\\/li>\\n<li>Fix: Apply <code>url-encoding<\\/code> to &quot;Tweet&quot; button text in Blockquote widget to prevent unexpected corruption of the tweet text<\\/li>\\n<li>Fix: Removed My Account link from dashboard widget<\\/li>\\n<\\/ul>\\n<h4>1.12.2 - 2018-01-03<\\/h4>\\n<ul>\\n<li>Tweak: Added animation none for Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2964\\\">#2964<\\/a>)<\\/li>\\n<li>Fix: Active license button style<\\/li>\\n<\\/ul>\\n<h4>1.12.1 - 2018-01-02<\\/h4>\\n<ul>\\n<li>Tweak: Removed theme-element widgets from plain content<\\/li>\\n<li>Tweak: Set all theme-element widgets to extend same widget Base<\\/li>\\n<li>Tweak: Removed credit URL in forms meta data<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.9<\\/li>\\n<li>Fix: Validate Get response Error as real error<\\/li>\\n<li>Fix: Removed responsive height control from Facebook Page widget<\\/li>\\n<\\/ul>\\n<h4>1.12.0 - 2017-12-20<\\/h4>\\n<ul>\\n<li>New: Added Drip integration to Forms<\\/li>\\n<li>New: Added ActiveCampaign integration to Forms<\\/li>\\n<li>New: Added ConverKit integration to Forms<\\/li>\\n<li>New: Added GetResponse integration to Forms<\\/li>\\n<li>New: Added form <code>id<\\/code>, <code>name<\\/code> attributes to handle integration with auto collectors like HubSpot<\\/li>\\n<li>New: Added Global API key for MailChimp to improve the workflow<\\/li>\\n<li>Tweak: Better error handling and message display for Forms<\\/li>\\n<li>Fix: PHP notice Undefined variable <code>$cc_header<\\/code> (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2934\\\">#2934<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.11.0 - 2017-12-11<\\/h4>\\n<ul>\\n<li>New: Added a native Comments widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/543\\\">#543<\\/a>)<\\/li>\\n<li>New: Added an Author Box widget<\\/li>\\n<li>New: Added a Post Navigation widget<\\/li>\\n<li>New: Added a Yoast Breadcrumbs widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2749\\\">#2749<\\/a>)<\\/li>\\n<li>Tweak: Added a close button to search widget under Full Screen skin (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2762\\\">#2762<\\/a>)<\\/li>\\n<li>Fix: Allow currency symbol to appear even if price isn\'t numeric<\\/li>\\n<li>Fix: Edge cases when the nav menu is empty in a stretched section<\\/li>\\n<li>Fix: Added fallback when you remove the <code>space-between<\\/code> on Swiper carousel<\\/li>\\n<\\/ul>\\n<h4>1.10.2 - 2017-12-03<\\/h4>\\n<ul>\\n<li>Fix: Missing save widget icon (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2878\\\">#2878<\\/a>)<\\/li>\\n<li>Fix: Global widgets not saving edits (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2874\\\">#2874<\\/a>)<\\/li>\\n<li>Fix: Removed <code>white-space: nowrap;<\\/code> property from vertical menu in Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2815\\\">#2815<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.10.1 - 2017-11-30<\\/h4>\\n<ul>\\n<li>Tweak: Added default value for search form<\\/li>\\n<li>Tweak: Order template list A-Z in the library widget<\\/li>\\n<li>Tweak: get_users\\/authors query is now done using AJAX only, for better performance in Query Control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2865\\\">#2865<\\/a>)<\\/li>\\n<li>Fix: When adding <code>.00<\\/code> it is not displayed on the front<\\/li>\\n<li>Fix: Make sure space between is numeric for carousel control<\\/li>\\n<li>Fix: Added space for radio &amp; checkbox fields in form widget<\\/li>\\n<\\/ul>\\n<h4>1.10.0 - 2017-11-15<\\/h4>\\n<ul>\\n<li>New: Added native Search form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2576\\\">#2576<\\/a>)<\\/li>\\n<li>Tweak: Added Slides To Scroll &amp; Loop controls to Media Carousel and Testimonials widgets<\\/li>\\n<li>Tweak: Added Inline editing to Blockquote widget<\\/li>\\n<li>Fix: Animated Headline color bug (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2516\\\">#2516<\\/a>)<\\/li>\\n<li>Fix: Animated Headline with Rotating skin<\\/li>\\n<li>Fix: RTL fix for Animated Headline widget in \'typing\' and \'clip\' animations<\\/li>\\n<li>Fix: Empty menu cause jQuery to crash in Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2662\\\">#2662<\\/a>)<\\/li>\\n<li>Fix: Custom CSS gone after reloading the editor<\\/li>\\n<\\/ul>\\n<h4>1.9.5 - 2017-10-27<\\/h4>\\n<ul>\\n<li>Fix: Broken Global widget with JS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2639\\\">#2639<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.9.4 - 2017-10-24<\\/h4>\\n<ul>\\n<li>Tweak: Improved UI for notices and license page<\\/li>\\n<li>Fix: Update system conflict with other EDD plugins<\\/li>\\n<li>Fix: WooCommerce frontend hooks on Elementor editor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2577\\\">#2577<\\/a>)<\\/li>\\n<li>Fix: Removed default border left in Nav Menu dropdown CSS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2496\\\">#2496<\\/a>)<\\/li>\\n<li>Fix: Increased submenu max-width (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2558\\\">#2558<\\/a>)<\\/li>\\n<li>Fix: Save global templates without their defaults<\\/li>\\n<li>Fix: Horizontal scrolling issue with posts grid<\\/li>\\n<\\/ul>\\n<h4>1.9.3 - 2017-10-03<\\/h4>\\n<ul>\\n<li>Fix: Condition slide style that got affected by previous update<\\/li>\\n<\\/ul>\\n<h4>1.9.2 - 2017-10-02<\\/h4>\\n<ul>\\n<li>New: Added integration with MailPoet 3 for Forms actions<\\/li>\\n<li>Fix: Removed height control from Testimonial carousel in mobile editing mode<\\/li>\\n<li>Fix: Removed bottom padding when there\'s no pagination in Testimonial carousel<\\/li>\\n<li>Fix: Added condition for slides style section in skin bubble mode<\\/li>\\n<li>Fix: Slides per view control for mobile editing in Testimonial carousel<\\/li>\\n<li>Fix: Navigation Arrows icons matched with common Elementor Navigation Arrows<\\/li>\\n<\\/ul>\\n<h4>1.9.1 - 2017-09-28<\\/h4>\\n<ul>\\n<li>Fix: Slides per view for slideshow carousel<\\/li>\\n<li>Fix: Final polish for the new Testimonial Carousel widget<\\/li>\\n<li>Fix: Don\'t play video if slide type is not video<\\/li>\\n<li>Fix: Removed slides style section condition (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2497\\\">#2497<\\/a>)<\\/li>\\n<li>Fix: Set cursor as pointer for slideshow thumbnails<\\/li>\\n<\\/ul>\\n<h4>1.9.0 - 2017-09-26<\\/h4>\\n<ul>\\n<li>New: Added Media Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/216\\\">#216<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/347\\\">#347<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2209\\\">#2209<\\/a>)<\\/li>\\n<li>New: Added Testimonial Carousel widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/715\\\">#715<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.8.3 - 2017-09-24<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility for WordPress 4.8.2 &amp; 4.7.6<\\/li>\\n<li>Fix: Remove slashes from Form sent data<\\/li>\\n<\\/ul>\\n<h4>1.8.2 - 2017-09-19<\\/h4>\\n<ul>\\n<li>Tweak: Added target URL for the tweet message in Blockquote widget<\\/li>\\n<li>Tweak: Render the slide height before the slider is finished loading<\\/li>\\n<li>Fix: Space between words for Animated Headline widget<\\/li>\\n<li>Fix: RTL compatibility for Animated Headline widget<\\/li>\\n<li>Fix: Italic font style for Animated Headline widget<\\/li>\\n<li>Fix: Excluded Menu widget from the WP Editor text rendering<\\/li>\\n<\\/ul>\\n<h4>1.8.1 - 2017-09-18<\\/h4>\\n<ul>\\n<li>Fix: WCAG Compatible &quot;required&quot; field attribute for W3C validation (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2391\\\">#2391<\\/a>)<\\/li>\\n<li>Fix: Print the main menu only when is necessary in Menu widget<\\/li>\\n<li>Fix: Use CSS media query instead of JS to hide items in Menu widget to avoid flickering on page load (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2381\\\">#2381<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.8.0 - 2017-09-12<\\/h4>\\n<ul>\\n<li>New: Added Nav Menu widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1406\\\">#1406<\\/a>)<\\/li>\\n<li>Fix: Field ID for checkbox control in Form widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2279\\\">#2279<\\/a>)<\\/li>\\n<li>Fix: Style for Blockquote widget included<\\/li>\\n<\\/ul>\\n<h4>1.7.2 - 2017-09-07<\\/h4>\\n<ul>\\n<li>Tweak: Loading Facebook SDK via JS for better compatibility with caching plugins<\\/li>\\n<li>Fix: Responsive Embed Facebook post widget for Safari iOS (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2340\\\">#2340<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.7.1 - 2017-09-05<\\/h4>\\n<ul>\\n<li>Fix: Facebook SDK version<\\/li>\\n<\\/ul>\\n<h4>1.7.0 - 2017-09-05<\\/h4>\\n<ul>\\n<li>New: Added Facebook Button widget for Like, Recommend, Share and Follow<\\/li>\\n<li>New: Added Facebook Embed widget for Post, Video and Comment<\\/li>\\n<li>New: Added Facebook Comments widget<\\/li>\\n<li>New: Added Facebook Page widget (Previously known as Like Box)<\\/li>\\n<li>New: Added Blockquote widget with Tweet button<\\/li>\\n<li>Tweak: Added Facebook SDK integration for all Facebook widgets<\\/li>\\n<li>Fix: Animated headline rotating with long words<\\/li>\\n<\\/ul>\\n<h4>1.6.1 - 2017-08-28<\\/h4>\\n<ul>\\n<li>Fix: Animated Headline marker gets in front of neighboring spans even when &quot;Bring to Front&quot; is not set<\\/li>\\n<li>Fix: Stroke animation in Animated Headline for MS Edge browser<\\/li>\\n<li>Fix: Animated headline with more than 1-word per rotation<\\/li>\\n<li>Fix: Animated Headline in two lines<\\/li>\\n<li>Fix: Some errors in Global widget<\\/li>\\n<\\/ul>\\n<h4>1.6.0 - 2017-08-22<\\/h4>\\n<ul>\\n<li>New: Added Animated Headline widget<\\/li>\\n<li>New: Added Hidden field for Forms widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2038\\\">#2038<\\/a>)<\\/li>\\n<li>Tweak: Added notice to update Elementor to v1.6.5 or higher<\\/li>\\n<li>Fix: CSS Animations names no longer minified, in order to prevent unexpected conflicts<\\/li>\\n<\\/ul>\\n<h4>1.5.9 - 2017-08-16<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.7<\\/li>\\n<li>Fix: Portfolio compatibility for GeneratePress theme<\\/li>\\n<li>Fix: Portfolio filter compatibility for RTL<\\/li>\\n<li>Fix: Pagination apply for all posts widget in the page<\\/li>\\n<li>Fix: Global form widget with MailChimp integration not saving<\\/li>\\n<\\/ul>\\n<h4>1.5.8 - 2017-07-25<\\/h4>\\n<ul>\\n<li>Tweak: Added compatibility for the future release of Elementor v1.6<\\/li>\\n<li>Fix: Improved backward compatibility for query control rename<\\/li>\\n<\\/ul>\\n<h4>1.5.7 - 2017-07-24<\\/h4>\\n<ul>\\n<li>Tweak: Moved JS render of reCAPTCHA to a separate file<\\/li>\\n<li>Tweak: Display the label in the reCAPTCHA field for better experience<\\/li>\\n<li>Tweak: Rename <code>panel-posts-control<\\/code> to <code>query-control<\\/code> and added fallback support<\\/li>\\n<li>Tweak: Added compatibility for the future release of Elementor with history feature<\\/li>\\n<li>Fix: reCAPTCHA preview on the editor<\\/li>\\n<li>Fix: Manual selection (query control) has stopped working after saving (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/2000\\\">#2000<\\/a>)<\\/li>\\n<li>Fix: Added condition for icon size control in Share Buttons widget<\\/li>\\n<\\/ul>\\n<h4>1.5.6 - 2017-07-12<\\/h4>\\n<ul>\\n<li>Fix: Query Control correction for taxonomies (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1963\\\">#1963<\\/a>)<\\/li>\\n<li>Fix: Custom CSS override scheme color in the editor<\\/li>\\n<li>Fix: Added order by Menu Order for Query Control in WC widget<\\/li>\\n<li>Fix: Glitch with Flip Box background overlay<\\/li>\\n<\\/ul>\\n<h4>1.5.5 - 2017-07-03<\\/h4>\\n<ul>\\n<li>Tweak: Moved reCAPTCHA render to handler &amp; load only if a form is exist<\\/li>\\n<li>Fix: MailChimp integration: Default number of items returned by API increased to 999<\\/li>\\n<li>Fix: MailChimp integration: Refresh the groups list if API is changed<\\/li>\\n<li>Fix: Sorted items in filter bar by A-Z<\\/li>\\n<li>Fix: Editor glitch with Elementor v1.5 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1927\\\">#1927<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.5.4 - 2017-06-22<\\/h4>\\n<ul>\\n<li>Tweak: Improved compatibility for Elementor v1.5<\\/li>\\n<li>Fix: URL default for Add To Cart widget<\\/li>\\n<li>Fix: Allowed <code>date<\\/code> and <code>birthday<\\/code> fields as text for MailChimp integration<\\/li>\\n<\\/ul>\\n<h4>1.5.3 - 2017-06-19<\\/h4>\\n<ul>\\n<li>Tweak: Make flip-box height responsive control<\\/li>\\n<li>Fix: Facebook share count now gets retrieved by Elementor (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1829\\\">#1829<\\/a>)<\\/li>\\n<li>Fix: Global form widget with MailChimp integration not saving<\\/li>\\n<\\/ul>\\n<h4>1.5.2 - 2017-06-13<\\/h4>\\n<ul>\\n<li>Fix: Custom CSS panel location compatibility for the old versions<\\/li>\\n<\\/ul>\\n<h4>1.5.1 - 2017-06-12<\\/h4>\\n<ul>\\n<li>Fix: MailChimp update existing user registration<\\/li>\\n<li>Fix: Global widget with JS in the editor mode<\\/li>\\n<li>Fix: Label section condition in Login widget<\\/li>\\n<li>Fix: Changes to unlinked global widget do not appear in the editor<\\/li>\\n<\\/ul>\\n<h4>1.5.0 - 2017-05-23<\\/h4>\\n<ul>\\n<li>New: Added Cards, a new skin for Posts widget<\\/li>\\n<li>New: Added Exclude option to post query control group<\\/li>\\n<li>Tweak: Added <code>post_class()<\\/code> for each post in the loop<\\/li>\\n<li>Tweak: Added <code>.elementor-posts-masonry<\\/code> class when Masonry layout is enabled<\\/li>\\n<li>Tweak: Added compatibility for the next release of Elementor v1.5.0<\\/li>\\n<li>Tweak: CSS <code>autoprefixer<\\/code> now supports last 5 versions of browsers<\\/li>\\n<li>Tweak: Added <code>imageLoaded<\\/code> library for Posts &amp; Portfolio widgets<\\/li>\\n<\\/ul>\\n<h4>1.4.4 - 2017-05-18<\\/h4>\\n<ul>\\n<li>Fix: Force Mailchimp API to return all lists and not just 10 (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1683\\\">#1683<\\/a>)<\\/li>\\n<li>Fix: Added <code>.elementor-form<\\/code> class to Login form to fix style glitch<\\/li>\\n<\\/ul>\\n<h4>1.4.3 - 2017-05-14<\\/h4>\\n<ul>\\n<li>Tweak: Added Redirect After Login option to Login widget<\\/li>\\n<li>Tweak: Stay in the current page after logout in Login widget<\\/li>\\n<li>Tweak: Preparation for Elementor settings tabs in future version<\\/li>\\n<li>Fix: Pinterest in Share Buttons widget now sharing the URL alone<\\/li>\\n<li>Fix: Bug with <code>active<\\/code> class in portfolio filter item<\\/li>\\n<li>Fix: Higher specific list-style-type <code>none<\\/code> for filter items to override some theme style<\\/li>\\n<\\/ul>\\n<h4>1.4.2 - 2017-05-06<\\/h4>\\n<ul>\\n<li>Fix: Temporary patch for form field shortcode in some servers<\\/li>\\n<\\/ul>\\n<h4>1.4.1 - 2017-05-03<\\/h4>\\n<ul>\\n<li>Fix: Bug with custom success message in form widget<\\/li>\\n<li>Fix: Bug with meta data in email action<\\/li>\\n<\\/ul>\\n<h4>1.4.0 - 2017-05-03<\\/h4>\\n<ul>\\n<li>New: Forms: integration with MailChimp<\\/li>\\n<li>New: Forms: integration with MailPoet<\\/li>\\n<li>New: Forms: Added Email 2 action for email confirmation<\\/li>\\n<li>New: Forms: Added shortcodes for fields<\\/li>\\n<li>New: Forms: Added custom ID for fields<\\/li>\\n<li>New: Forms: Added option to edit email HTML template (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1180\\\">#1180<\\/a>)<\\/li>\\n<li>New: Added Login widget<\\/li>\\n<li>Tweak: Move <code>send_html<\\/code> control to <code>email_content_type<\\/code><\\/li>\\n<li>Fix: Email still sent even if validation failed in form widget<\\/li>\\n<\\/ul>\\n<h4>1.3.2 - 2017-05-01<\\/h4>\\n<ul>\\n<li>New: Added action <code>elementor_pro\\/init<\\/code> for better integration with Elementor Pro<\\/li>\\n<li>Fix: Posts without featured image in Posts widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1234\\\">#1234<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1382\\\">#1382<\\/a>)<\\/li>\\n<li>Fix: reCAPTCHA &amp; Honeypot fields with new method<\\/li>\\n<li>Fix: Added border width control in Share Buttons to avoid a glitch on Chrome browser<\\/li>\\n<li>Fix: Border radius glitch on hover in Share Buttons<\\/li>\\n<\\/ul>\\n<h4>1.3.1 - 2017-04-25<\\/h4>\\n<ul>\\n<li>Fix: Conflict update with revision history module<\\/li>\\n<\\/ul>\\n<h4>1.3.0 - 2017-04-25<\\/h4>\\n<ul>\\n<li>New: Added Share Buttons widget (<a href=\\\"https:\\/\\/wordpress.org\\/support\\/topic\\/social-sharing-buttons-is-it-possible\\/\\\">Topic<\\/a>)<\\/li>\\n<li>New: Added Custom CSS for Page Settings<\\/li>\\n<li>New: Added Masonry layout for Portfolio widget<\\/li>\\n<li>New: Added Cc &amp; Bcc options to email action (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1181\\\">#1181<\\/a>)<\\/li>\\n<li>New: Introduced <code>ElementorProModulesFormsClassesAction_Base<\\/code> class for better 3rd party integration for forms<\\/li>\\n<li>Tweak: Debugger module now also shows errors from Pro<\\/li>\\n<li>Tweak: Added options for Elementor Library<\\/li>\\n<li>Tweak: New base posts module for optimized performance<\\/li>\\n<li>Tweak: Adjusting Posts \\/ Portfolio to the new structure<\\/li>\\n<li>Fix: Export for posts \\/ portfolio<\\/li>\\n<li>Fix: Duplicate repeater field with switcher control (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1442\\\">#1442<\\/a>)<\\/li>\\n<li>Fix: Post per Page in the query control<\\/li>\\n<li>Fix: Metadata does not come through on form emails (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1566\\\">#1566<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.2.6 - 2017-04-19<\\/h4>\\n<ul>\\n<li>Fix: Added compatibility with WooCommerce 3.0 - Products &amp; Add to Cart widgets<\\/li>\\n<\\/ul>\\n<h4>1.2.5 - 2017-04-18<\\/h4>\\n<ul>\\n<li>Fix: Offset query for posts widgets (Posts, Portfolio and Products)<\\/li>\\n<\\/ul>\\n<h4>1.2.4 - 2017-03-21<\\/h4>\\n<ul>\\n<li>Tweak: Added Indian Rupee sign to Price Table widget<\\/li>\\n<li>Fix: Portfolio grid for IE11<\\/li>\\n<li>Fix: Link target blank in Price List widget<\\/li>\\n<li>Fix: Active item for filter bar in Portfolio widget<\\/li>\\n<\\/ul>\\n<h4>1.2.3 - 2017-03-06<\\/h4>\\n<ul>\\n<li>Tweak: Fully compatible with Elementor v1.3.0<\\/li>\\n<li>Tweak: Added trigger for after form submission in Forms widget<\\/li>\\n<li>Tweak: Changed handle name in reCAPTCHA field to avoid conflict with other contact forms<\\/li>\\n<li>Fix: Portfolio filter syntax in Non-Latin languages<\\/li>\\n<li>Fix: Added <code>no-repeat<\\/code> property for slide with <code>background-size:contain<\\/code><\\/li>\\n<li>Fix: Condition control &amp; Import value in Posts widgets<\\/li>\\n<li>Fix: Offset and Pagination in WordPress (<a href=\\\"https:\\/\\/codex.wordpress.org\\/Making_Custom_Queries_using_Offset_and_Pagination\\\">More Info<\\/a>)<\\/li>\\n<li>Fix: Submit handler bubbling for custom events in Forms widget<\\/li>\\n<\\/ul>\\n<h4>1.2.2 - 2017-02-23<\\/h4>\\n<ul>\\n<li>Tweak: Change name from Side A\\/B to Front and Back in Flip Box widget<\\/li>\\n<li>Fix: Error when saving third party widgets in the global widget<\\/li>\\n<li>Fix: Image position &quot;none&quot; remains visible in editor preview (Posts)<\\/li>\\n<li>Fix: Hide the pagination when there are no links<\\/li>\\n<\\/ul>\\n<h4>1.2.1 - 2017-02-21<\\/h4>\\n<ul>\\n<li>Fix: Firefox Flip Box 3D compatibility<\\/li>\\n<\\/ul>\\n<h4>1.2.0 - 2017-02-21<\\/h4>\\n<ul>\\n<li>New: Added Flip Box widget<\\/li>\\n<li>New: Added Ken Burns effect for slides<\\/li>\\n<li>New: Added Masonry layout for Posts widget<\\/li>\\n<li>New: Added Pagination option for Posts widget<\\/li>\\n<li>Tweak: Added background size contain to slides<\\/li>\\n<li>Tweak: Improve Query control by preload items<\\/li>\\n<li>Fix: Text color for Checkbox and Radio fields<\\/li>\\n<\\/ul>\\n<h4>1.1.2 - 2017-02-05<\\/h4>\\n<ul>\\n<li>Tweak: Added <code>aria-required<\\/code> for better accessibility in forms widget<\\/li>\\n<li>Fix: Conflict Call to <code>undefined<\\/code> method in Posts &amp; Portfolio widgets (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1271\\\">#1271<\\/a>, <a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1266\\\">#1266<\\/a>)<\\/li>\\n<li>Fix: Submit button HTML after error sending<\\/li>\\n<li>Fix: Success message for <code>skip_email<\\/code> function<\\/li>\\n<li>Notice: Elementor 1.2.0 or later now required<\\/li>\\n<\\/ul>\\n<h4>1.1.1 - 2017-01-24<\\/h4>\\n<ul>\\n<li>Fix: Can\'t save global widgets when <code>WP_DEBUG<\\/code> is <code>true<\\/code><\\/li>\\n<li>Fix: Undefined variable in WC widgets<\\/li>\\n<li>Fix: Removed duplicate strings<\\/li>\\n<\\/ul>\\n<h4>1.1.0 - 2017-01-24<\\/h4>\\n<ul>\\n<li>New: Price Table widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/102\\\">#102<\\/a>)<\\/li>\\n<li>New: WooCommerce Add to Cart widget<\\/li>\\n<li>New: WooCommerce Categories widget<\\/li>\\n<li>New: WooCommerce Elements widget<\\/li>\\n<li>New: Honeypot field for Forms widgets<\\/li>\\n<li>Tweak: Added inline options for taxonomies &amp; authors if is less than 15 items<\\/li>\\n<li>Tweak: Added Required Mark for fields in Forms widget<\\/li>\\n<li>Fix: CSS selectors priority in Slides widget<\\/li>\\n<li>Fix: CSS bug in Price List widget<\\/li>\\n<li>Fix: Update all Post CSS files that includes specific Global Widget<\\/li>\\n<\\/ul>\\n<h4>1.0.9 - 2017-01-18<\\/h4>\\n<ul>\\n<li>Fix: Auto complete bug in query controls<\\/li>\\n<li>Fix: Render template with escaping slashes<\\/li>\\n<li>Fix: Reply-to field in Forms widget<\\/li>\\n<\\/ul>\\n<h4>1.0.8 - 2017-01-11<\\/h4>\\n<ul>\\n<li>Tweak: Code adjustments for Elementor API<\\/li>\\n<li>Fix: Removed go pro link from plugins page in admin<\\/li>\\n<\\/ul>\\n<h4>1.0.7 - 2017-01-05<\\/h4>\\n<ul>\\n<li>Tweak: Added filter by featured \\/ sale for WC Products widget<\\/li>\\n<li>Tweak: Added author control in Portfolio widget<\\/li>\\n<li>Tweak: Code adjustments for Elementor API<\\/li>\\n<li>Fix: Added support for empty image ratio<\\/li>\\n<li>Fix: Avoid nesting a sidebar within a template that will appear in the sidebar itself<\\/li>\\n<\\/ul>\\n<h4>1.0.6 - 2017-01-01<\\/h4>\\n<ul>\\n<li>Tweak: Added Auto-updates for local translation files<\\/li>\\n<li>Fix: Custom CSS for Global widgets<\\/li>\\n<li>Fix: Remove <code>nonce<\\/code> field (Fix some cache plugins)<\\/li>\\n<\\/ul>\\n<h4>1.0.5 - 2016-12-27<\\/h4>\\n<ul>\\n<li>Fix: Slide element bug fix - \'Link apply on\' logic<\\/li>\\n<li>Fix: Removed unique wrapper for Custom CSS in order to allow media queries (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1086\\\">#1086<\\/a>)<\\/li>\\n<\\/ul>\\n<h4>1.0.4 - 2016-12-21<\\/h4>\\n<ul>\\n<li>Tweak: Mobile Editing for fields in the form widget<\\/li>\\n<li>Tweak: Mobile Editing for posts<\\/li>\\n<li>Tweak: Allow send form as HTML<\\/li>\\n<li>Tweak: Improved auto upgrades for Multisite installation<\\/li>\\n<li>Tweak: Improve editor rendering experience for Portfolio widget<\\/li>\\n<li>Fix: Posts widget check if image exist<\\/li>\\n<li>Fix: Changed the clone method for global widget (<a href=\\\"https:\\/\\/github.com\\/elementor\\/elementor\\/issues\\/1042\\\">#1042<\\/a>)<\\/li>\\n<li>Fix: Bug slides in RTL (removed direction control)<\\/li>\\n<li>Fix: Slides with no height jumps when changing slides<\\/li>\\n<\\/ul>\\n<h4>1.0.3 - 2016-12-13<\\/h4>\\n<ul>\\n<li>Fix: Added escape placeholder for HTML Entities in form widget<\\/li>\\n<li>Fix: Countdown widget RTL bug<\\/li>\\n<li>Fix: Remove redundant #elementor selector for control style<\\/li>\\n<li>Fix: Added prefixing with \'0\' for one digit number in Countdown widget<\\/li>\\n<\\/ul>\\n<h4>1.0.2 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Fix: Page layout collapses when inserting reCAPTCHA field in Form<\\/li>\\n<\\/ul>\\n<h4>1.0.1 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Fix: WordPress widgets disappear from Editor when Elementor Pro active<\\/li>\\n<\\/ul>\\n<h4>1.0.0 - 2016-12-12<\\/h4>\\n<ul>\\n<li>Initial release<\\/li>\\n<\\/ul>\\\";}\",\"new_version\":\"3.32.2\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"6.8.3\",\"elementor_requires\":\"3.0.1\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/package_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJkb3dubG9hZF9iZXRhIjpmYWxzZSwiZmlsZV9rZXkiOiIxIiwiaWF0IjoxNzU5ODI0MzY3LCJleHAiOjE3NTk5MTA3Njd9.r9tOObJ7JA8TzkguEyN6nBCKMYT5-qprg6My4TdaYDk\\/package_download\",\"download_link\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/package_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJkb3dubG9hZF9iZXRhIjpmYWxzZSwiZmlsZV9rZXkiOiIxIiwiaWF0IjoxNzU5ODI0MzY3LCJleHAiOjE3NTk5MTA3Njd9.r9tOObJ7JA8TzkguEyN6nBCKMYT5-qprg6My4TdaYDk\\/package_download\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/storage.googleapis.com\\/web-public-files\\/Web%20Assets\\/icons\\/icon.svg\"},\"canary_deployment\":{\"plugin_info\":{\"new_version\":\"3.7.0\",\"name\":\"Elementor Pro\",\"slug\":\"elementor-pro\",\"url\":\"https:\\/\\/elementor.com\\/pro\\/changelog\\/\",\"homepage\":\"https:\\/\\/elementor.com\\/pro\\/\",\"requires\":\"5.0\",\"tested\":\"6.8.3\",\"elementor_requires\":\"3.0.1\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/previous_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ2ZXJzaW9uIjoiMy43LjAiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJpYXQiOjE3NTk4MjQzNjcsImV4cCI6MTc1OTkxMDc2N30.OutgEbnBGuWvPEdPpaefe6582wtXTLwI4ayn3jsTdhA\\/previous_download\",\"download_link\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/previous_download\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ2ZXJzaW9uIjoiMy43LjAiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJpYXQiOjE3NTk4MjQzNjcsImV4cCI6MTc1OTkxMDc2N30.OutgEbnBGuWvPEdPpaefe6582wtXTLwI4ayn3jsTdhA\\/previous_download\",\"banners\":{\"2x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-1544x500.png?rev=1475479\",\"1x\":\"https:\\/\\/ps.w.org\\/elementor\\/assets\\/banner-772x250.png?rev=1475479\"},\"icons\":{\"svg\":\"https:\\/\\/storage.googleapis.com\\/web-public-files\\/Web%20Assets\\/icons\\/icon.svg\"}},\"conditions\":[[{\"type\":\"language\",\"languages\":[\"he_IL\",\"nl_NL\",\"en_GB\",\"en_NZ\",\"en_ZA\",\"en_AU\",\"en_CA\",\"sv_SE\",\"da_DK\",\"fr_FR\",\"nl_NL\",\"nb_NO\",\"de_AT\",\"fi\",\"it_IT\",\"nn_NO\",\"de_CH\",\"en_GB\",\"is_IS\",\"ga\",\"fr_BE\",\"nl_BE\",\"ast\",\"lb_LU\",\"es_ES\",\"pt_PT\",\"mlt\"],\"operator\":\"in\"}]]},\"translations\":[{\"language\":\"fa_IR\",\"updated\":\"2024-04-29 14:12:39+0000\",\"package\":\"https:\\/\\/plugin-downloads.elementor.com\\/v2\\/translation\\/eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsaWNlbnNlIjoiYncyOWdnanRlYnRqdjJpOHF2cWI0NWEyeG40eDk3YmkiLCJ1cmwiOiJodHRwOi8vbXl0ZXN0ZGVzaWduLnh5ei9lbGVtZW50b3IiLCJsYW5ndWFnZSI6ImZhX0lSIiwiaWF0IjoxNzU5ODI0MzY3fQ.GggmKFCjXq9tjKGld97e6QV9eH3ApVPP9PQ-E3SVx4s\\/translation\"}],\"cloud\":false}\";}", "off");
INSERT INTO `wp_abz7_options` VALUES("74745", "_transient_timeout_action_scheduler_last_pastdue_actions_check", "1759847200", "off");
INSERT INTO `wp_abz7_options` VALUES("74746", "_transient_action_scheduler_last_pastdue_actions_check", "1759825600", "off");

/* INSERT TABLE DATA: wp_abz7_postmeta */
INSERT INTO `wp_abz7_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("3", "5", "_elementor_edit_mode", "builder");
INSERT INTO `wp_abz7_postmeta` VALUES("4", "5", "_elementor_template_type", "kit");
INSERT INTO `wp_abz7_postmeta` VALUES("5", "6", "_edit_lock", "1744449793:1");
INSERT INTO `wp_abz7_postmeta` VALUES("7", "6", "_elementor_edit_mode", "builder");
INSERT INTO `wp_abz7_postmeta` VALUES("8", "6", "_elementor_template_type", "wp-page");
INSERT INTO `wp_abz7_postmeta` VALUES("9", "6", "_elementor_version", "3.13.4");
INSERT INTO `wp_abz7_postmeta` VALUES("10", "6", "_elementor_pro_version", "3.13.1");
INSERT INTO `wp_abz7_postmeta` VALUES("29", "6", "_rankmath__data", "[{\"id\":\"08779c4\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\",\"isLinked\":true},\"min_height\":{\"unit\":\"vh\",\"size\":80,\"sizes\":[]},\"min_height_tablet\":{\"unit\":\"vh\",\"size\":65,\"sizes\":[]},\"min_height_mobile\":{\"unit\":\"vh\",\"size\":\"\",\"sizes\":[]},\"background_image\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/pageRightBar.svg\",\"id\":1817,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"top right\",\"background_repeat\":\"no-repeat\",\"background_overlay_background\":\"classic\",\"background_overlay_image\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/05\\/doctor-4.png\",\"id\":2805,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_overlay_position\":\"initial\",\"background_overlay_xpos\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"background_overlay_ypos\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"background_overlay_repeat\":\"no-repeat\",\"background_overlay_size\":\"initial\",\"background_overlay_bg_width\":{\"unit\":\"%\",\"size\":30,\"sizes\":[]},\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":0.050000000000000003,\"sizes\":[]},\"overlay_blend_mode\":\"luminosity\",\"__globals__\":{\"border_color\":\"\"},\"background_overlay_xpos_mobile\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"background_overlay_ypos_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"background_overlay_bg_width_mobile\":{\"unit\":\"px\",\"size\":180,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"10ae2d3\"}],\"background_background\":\"classic\",\"background_xpos\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"background_xpos_tablet\":{\"unit\":\"em\",\"size\":0,\"sizes\":[]},\"background_xpos_mobile\":{\"unit\":\"em\",\"size\":0,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"background_overlay_position_tablet\":\"center left\",\"background_overlay_position_mobile\":\"top left\",\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"flex_align_items_tablet\":\"center\"},\"elements\":[{\"id\":\"0d779d5\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"min_height\":{\"unit\":\"vh\",\"size\":\"\",\"sizes\":[]},\"min_height_tablet\":{\"unit\":\"vh\",\"size\":\"\",\"sizes\":[]},\"min_height_mobile\":{\"unit\":\"vh\",\"size\":0,\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_gap\":{\"unit\":\"px\",\"size\":13,\"sizes\":[],\"column\":\"13\",\"row\":\"13\",\"isLinked\":true},\"flex_align_content\":\"space-around\",\"background_background\":\"classic\",\"background_image\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/Big-dots.svg\",\"id\":106,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"top right\",\"background_repeat\":\"no-repeat\",\"background_size_mobile\":\"initial\",\"background_bg_width_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"5997ed3\"}],\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"125c19e\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"flex_direction_mobile\":\"row\",\"flex_justify_content_mobile\":\"space-between\",\"flex_gap_mobile\":{\"unit\":\"px\",\"size\":10,\"sizes\":[],\"column\":\"10\",\"row\":\"10\",\"isLinked\":true},\"flex_wrap_mobile\":\"nowrap\",\"jedv_conditions\":[{\"_id\":\"8ee3c73\"}],\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"782a2de\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0646\\u0627\\u0645 \\u062f\\u06a9\\u062a\\u0631 \\u0645\\u062d\\u062a\\u0631\\u0645\",\"title_color\":\"#133154\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"_flex_align_self\":\"center\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"\"},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhBold_FaNum\",\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"6be6758\"}],\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":24,\"sizes\":[]},\"header_size\":\"h1\"},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"4467f5f\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0634.\\u0646 123456\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"button_text_color\":\"#13315499\",\"border_radius\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"text_padding\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"15\",\"bottom\":\"8\",\"left\":\"15\",\"isLinked\":false},\"_flex_align_self\":\"center\",\"__globals__\":{\"background_color\":\"globals\\/colors?id=4a0ac7d\",\"button_text_color\":\"\",\"button_background_hover_color\":\"\",\"hover_color\":\"\",\"typography_typography\":\"\"},\"typography_font_weight\":\"normal\",\"border_border\":\"none\",\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"7c03fca\"}]},\"elements\":[],\"widgetType\":\"button\"}],\"isInner\":true},{\"id\":\"d1cca02\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0645\\u062a\\u062e\\u0635\\u0635 \\u0645\\u063a\\u0632 \\u0648 \\u0627\\u0639\\u0635\\u0627\\u0628 \\u0627\\u0632 \\u062f\\u0627\\u0646\\u0634\\u06af\\u0627\\u0647 \\u06cc\\u0632\\u062f\",\"header_size\":\"div\",\"title_color\":\"#133154\",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"__globals__\":{\"title_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"\"},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhBold_FaNum\",\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_font_weight\":\"900\",\"_padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"15\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"a84642b\"}]},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"d56c250\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/05\\/seprator.svg\",\"id\":2822},\"library\":\"svg\"},\"align\":\"right\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"_margin\":{\"unit\":\"rem\",\"top\":\"-1.8\",\"right\":\"0\",\"bottom\":\"-2.3\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_flex_align_self\":\"flex-start\",\"jedv_conditions\":[{\"_id\":\"5598f0c\"}]},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"effaf8c\",\"elType\":\"widget\",\"settings\":{\"editor\":\"\\u062f\\u0631 \\u0627\\u06cc\\u0646 \\u0642\\u0633\\u0645\\u062a \\u0634\\u0645\\u0627 \\u0628\\u0627\\u06cc\\u062f \\u0646\\u0627\\u0645 \\u062f\\u06a9\\u062a\\u0631 \\u0631\\u0627 \\u0642\\u0631\\u0627\\u0631 \\u062f\\u0627\\u062f\\u0647 \\u0648 \\u062a\\u0648\\u0636\\u06cc\\u062d\\u0627\\u062a \\u06a9\\u0648\\u062a\\u0627\\u0647\\u06cc \\u0627\\u0632 \\u0631\\u0632\\u0648\\u0645\\u0647 \\u0648 \\u0639\\u0645\\u0644\\u06a9\\u0631\\u062f \\u0627\\u06cc\\u0634\\u0627\\u0646 \\u0630\\u06a9\\u0631 \\u0646\\u0645\\u0627\\u06cc\\u06cc\\u062f. \\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a \\u0686\\u0627\\u067e\\u06af\\u0631\\u0647\\u0627 \\u0648 \\u0645\\u062a\\u0648\\u0646 \\u0628\\u0644\\u06a9\\u0647 \\u0631\\u0648\\u0632\\u0646\\u0627\\u0645\\u0647 \\u0648 \\u0645\\u062c\\u0644\\u0647 \\u062f\\u0631 \\u0633\\u062a\\u0648\\u0646 \\u0648 \\u0633\\u0637\\u0631\\u0622\\u0646\\u0686\\u0646\\u0627\\u0646 \\u06a9\\u0647 \\u0644\\u0627\\u0632\\u0645 \\u0627\\u0633\\u062a \\u0648 \\u0628\\u0631\\u0627\\u06cc \\u0634\\u0631\\u0627\\u06cc\\u0637 \\u0641\\u0639\\u0644\\u06cc \\u062a\\u06a9\\u0646\\u0648\\u0644\\u0648\\u0698\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0646\\u06cc\\u0627\\u0632 \\u0648 \\u06a9\\u0627\\u0631\\u0628\\u0631\\u062f\\u0647\\u0627\\u06cc \\u0645\\u062a\\u0646\\u0648\\u0639 \\u0628\\u0627 \\u0647\\u062f\\u0641 \\u0628\\u0647\\u0628\\u0648\\u062f \\u0627\\u0628\\u0632\\u0627\\u0631\\u0647\\u0627\\u06cc \\u06a9\\u0627\\u0631\\u0628\\u0631\\u062f\\u06cc \\u0645\\u06cc \\u0628\\u0627\\u0634\\u062f.\",\"align\":\"justify\",\"text_color\":\"#133154BD\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_line_height\":{\"unit\":\"rem\",\"size\":2,\"sizes\":[]},\"_margin\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"__globals__\":{\"typography_typography\":\"\"},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"43e964c\"}],\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"68ef034\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_align_items\":\"center\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[],\"column\":\"0\",\"row\":\"0\",\"isLinked\":true},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"padding\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"__globals__\":{\"border_color\":\"globals\\/colors?id=4a0ac7d\"},\"flex_wrap_mobile\":\"nowrap\",\"padding_mobile\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"bb66211\"}],\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"d97dbe1\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"\",\"library\":\"\"},\"title_text\":\"\\u06af\\u0648\\u0627\\u0647\\u06cc\\u0646\\u0627\\u0645\\u0647\\u200c\\u0647\\u0627\",\"description_text\":\"25 \\u0645\\u062c\\u0648\\u0632 \\u0631\\u0633\\u0645\\u06cc\",\"title_size\":\"div\",\"text_align\":\"right\",\"title_bottom_space\":{\"unit\":\"px\",\"size\":3,\"sizes\":[]},\"title_typography_typography\":\"custom\",\"title_typography_font_family\":\"YekanBakh_FaNum\",\"title_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"title_typography_font_weight\":\"900\",\"description_typography_typography\":\"custom\",\"description_typography_font_family\":\"YekanBakh_FaNum\",\"description_typography_font_size\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"_element_width\":\"initial\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":17.431999999999999},\"_flex_size\":\"none\",\"__globals__\":{\"title_typography_typography\":\"\",\"description_color\":\"globals\\/colors?id=text\",\"description_typography_typography\":\"\"},\"_element_width_mobile\":\"initial\",\"_element_custom_width_mobile\":{\"unit\":\"px\",\"size\":81.483999999999995},\"jedv_conditions\":[{\"_id\":\"4a96a34\"}],\"_element_width_tablet\":\"initial\",\"_element_custom_width_tablet\":{\"unit\":\"px\",\"size\":81.891000000000005}},\"elements\":[],\"widgetType\":\"icon-box\"},{\"id\":\"ed9428d\",\"elType\":\"widget\",\"settings\":{\"carousel\":[{\"id\":61,\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/Logo_NIKE.png\"},{\"id\":62,\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/Under_armour_logo.png\"},{\"id\":63,\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/puma.png\"},{\"id\":64,\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/adidas.png\"}],\"thumbnail_size\":\"full\",\"slides_to_show\":\"4\",\"navigation\":\"none\",\"gallery_vertical_align\":\"center\",\"image_spacing_custom\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"slides_to_show_mobile\":\"2\",\"jedv_conditions\":[{\"_id\":\"7db31ce\"}],\"slides_to_show_tablet\":\"2\"},\"elements\":[],\"widgetType\":\"image-carousel\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"378d306\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"50\"},\"flex_justify_content\":\"flex-end\",\"_flex_order_mobile\":\"start\",\"jedv_conditions\":[{\"_id\":\"518a1da\"}],\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"ed6397c\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/05\\/doctor-4.png\",\"id\":2805,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"css_filters_css_filter\":\"custom\",\"css_filters_contrast\":{\"unit\":\"px\",\"size\":130,\"sizes\":[]},\"css_filters_saturate\":{\"unit\":\"px\",\"size\":125,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"d8fc647\"}]},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"8c1fe8b\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"jedv_conditions\":[{\"_id\":\"31c8710\"}],\"margin\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"3\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"ff662fe\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"background_background\":\"gradient\",\"background_color_b\":\"#FFFFFF\",\"background_gradient_angle\":{\"unit\":\"deg\",\"size\":270,\"sizes\":[]},\"background_overlay_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_overlay_position\":\"initial\",\"background_overlay_xpos\":{\"unit\":\"%\",\"size\":103,\"sizes\":[]},\"background_overlay_xpos_tablet\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"background_overlay_xpos_mobile\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"background_overlay_ypos\":{\"unit\":\"px\",\"size\":-38,\"sizes\":[]},\"background_overlay_repeat\":\"no-repeat\",\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"25\",\"right\":\"25\",\"bottom\":\"25\",\"left\":\"25\",\"isLinked\":true},\"__globals__\":{\"background_color\":\"globals\\/colors?id=e71cf48\"},\"flex_gap\":{\"unit\":\"px\",\"size\":20,\"sizes\":[],\"column\":\"20\",\"row\":\"20\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"30\",\"left\":\"10\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"4a98fd5\"}],\"flex_gap_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[],\"column\":\"0\",\"row\":\"0\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"d0f24f9\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/Small-Dots.svg\",\"id\":193,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":-50,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"0afe509\"}],\"width_mobile\":{\"unit\":\"%\",\"size\":70,\"sizes\":[]},\"_offset_y_end_mobile\":{\"unit\":\"rem\",\"size\":-2.5499999999999998,\"sizes\":[]},\"_offset_x_end_mobile\":{\"unit\":\"rem\",\"size\":0.5,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"905beef\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":20},\"_flex_size\":\"none\",\"_element_width\":\"initial\",\"boxed_width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"boxed_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"flex_align_items\":\"flex-start\",\"flex_direction_mobile\":\"row\",\"flex_align_items_mobile\":\"flex-start\",\"flex_gap_mobile\":{\"unit\":\"px\",\"size\":20,\"sizes\":[],\"column\":\"20\",\"row\":\"20\",\"isLinked\":true},\"_flex_size_mobile\":\"none\",\"jedv_conditions\":[{\"_id\":\"a5340fa\"}],\"flex_justify_content\":\"space-between\",\"width_tablet\":{\"unit\":\"px\",\"size\":216.18799999999999},\"_element_width_tablet\":\"initial\",\"flex_gap\":{\"unit\":\"px\",\"size\":35,\"sizes\":[],\"column\":\"35\",\"row\":\"35\",\"isLinked\":true},\"_flex_align_self\":\"flex-start\",\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"width_mobile\":{\"unit\":\"%\",\"size\":98,\"sizes\":[]}},\"elements\":[{\"id\":\"70d26d6\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true},\"padding\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"3\",\"isLinked\":false},\"z_index\":5,\"flex_align_items\":\"flex-start\",\"margin\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"2ef9124\"}],\"margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"flex_align_items_mobile\":\"center\",\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"content_width\":\"full\",\"boxed_width_mobile\":{\"unit\":\"%\",\"size\":95,\"sizes\":[]}},\"elements\":[{\"id\":\"c4bffe5\",\"elType\":\"container\",\"settings\":{\"flex_align_items\":\"center\",\"flex_gap\":{\"unit\":\"px\",\"size\":12,\"sizes\":[],\"column\":\"12\",\"row\":\"12\",\"isLinked\":true},\"background_background\":\"classic\",\"background_color\":\"#FFFFFF\",\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"25\",\"isLinked\":false},\"padding\":{\"unit\":\"rem\",\"top\":\"1.3\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"css_classes\":\"headingRoundedBgService\",\"jedv_conditions\":[{\"_id\":\"50ad584\"}],\"content_width\":\"full\",\"background_image_mobile\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position_mobile\":\"center center\",\"background_repeat_mobile\":\"repeat\",\"background_size_mobile\":\"cover\"},\"elements\":[{\"id\":\"64bb9ba\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u0631\\u06a9\\u0632 \\u0645\\u0646\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhBold_FaNum\",\"jedv_conditions\":[{\"_id\":\"ef9c0f8\"}],\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"bfcecc3\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/05\\/seprator.svg\",\"id\":2822},\"library\":\"svg\"},\"align\":\"right\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"_margin\":{\"unit\":\"rem\",\"top\":\"-1.8\",\"right\":\"0\",\"bottom\":\"-2.3\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"5598f0c\"}]},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"d38b0a1\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0631\\u0632\\u0631\\u0648 \\u0628\\u0635\\u0648\\u0631\\u062a \\u0622\\u0646\\u0644\\u0627\\u06cc\\u0646 \\u0648 \\u062a\\u0644\\u0641\\u0646\\u06cc\",\"header_size\":\"span\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"ef9c0f8\"}],\"__globals__\":{\"title_color\":\"globals\\/colors?id=text\"},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"af82ab1\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_weight\":\"normal\",\"background_color\":\"#FFFFFF00\",\"text_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_element_custom_width\":{\"unit\":\"%\",\"size\":14.821},\"__globals__\":{\"button_text_color\":\"globals\\/colors?id=22571cf\",\"typography_typography\":\"\",\"hover_color\":\"globals\\/colors?id=primary\"},\"typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"border_border\":\"none\",\"align_mobile\":\"right\",\"_padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"_flex_size_mobile\":\"grow\",\"jedv_conditions\":[{\"_id\":\"99c9a2f\",\"jedv_condition\":\"wp-is-mobile\"}],\"_flex_align_self\":\"center\",\"jedv_type\":\"hide\",\"_padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"hover_color\":\"#362FD9\",\"_margin\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0.5\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1.5\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_flex_align_self_mobile\":\"flex-start\"},\"elements\":[],\"widgetType\":\"button\"}],\"isInner\":true},{\"id\":\"39e3f45\",\"elType\":\"container\",\"settings\":{\"boxed_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"boxed_width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"boxed_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"content_width\":\"full\",\"jedv_conditions\":[{\"_id\":\"fce0aa8\"}],\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"c42cffd\",\"elType\":\"widget\",\"settings\":{\"lisitng_id\":\"121\",\"not_found_message\":\"\\u0647\\u06cc\\u0686 \\u062f\\u0627\\u062f\\u0647 \\u0627\\u06cc \\u06cc\\u0627\\u0641\\u062a \\u0646\\u0634\\u062f\",\"posts_query\":[],\"terms_meta_query\":[],\"users_meta_query\":[],\"columns\":\"5\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"_z_index\":10,\"carousel_enabled\":\"yes\",\"arrows_box_size\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"arrow_bg_color\":\"#F5F5F5\",\"__globals__\":{\"arrow_color\":\"globals\\/colors?id=secondary\",\"arrow_bg_color\":\"globals\\/colors?id=4a0ac7d\",\"arrow_color_hover\":\"globals\\/colors?id=e71cf48\",\"arrow_bg_color_hover\":\"globals\\/colors?id=primary\"},\"columns_mobile\":\"2\",\"jedv_conditions\":[{\"_id\":\"1ffba64\"}],\"arrows_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"prev_top_position\":{\"unit\":\"%\",\"size\":59,\"sizes\":[]},\"prev_top_position_tablet\":{\"unit\":\"%\",\"size\":70,\"sizes\":[]},\"prev_top_position_mobile\":{\"unit\":\"px\",\"size\":-12,\"sizes\":[]},\"prev_hor_position\":\"right\",\"prev_left_position_mobile\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"prev_right_position\":{\"unit\":\"%\",\"size\":-22,\"sizes\":[]},\"prev_right_position_mobile\":{\"unit\":\"%\",\"size\":88,\"sizes\":[]},\"next_top_position\":{\"unit\":\"%\",\"size\":59,\"sizes\":[]},\"next_top_position_tablet\":{\"unit\":\"%\",\"size\":70,\"sizes\":[]},\"next_top_position_mobile\":{\"unit\":\"px\",\"size\":-12,\"sizes\":[]},\"next_right_position\":{\"unit\":\"%\",\"size\":-25.5,\"sizes\":[]},\"next_right_position_mobile\":{\"unit\":\"%\",\"size\":76,\"sizes\":[]},\"columns_tablet\":\"3\",\"vertical_gap\":{\"unit\":\"px\",\"size\":35,\"sizes\":[]},\"prev_right_position_tablet\":{\"unit\":\"%\",\"size\":-39,\"sizes\":[]},\"next_right_position_tablet\":{\"unit\":\"%\",\"size\":-47,\"sizes\":[]},\"horizontal_gap_mobile\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"10\",\"bottom\":\"0\",\"left\":\"10\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"jet-listing-grid\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"443af35\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"margin\":{\"unit\":\"rem\",\"top\":\"6\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"0210fa8\"}],\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"5dd3d64\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/05\\/Banner-min-min.png\",\"id\":3310,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"image_border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"74867c1\"}],\"image_border_radius_mobile\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"654e699\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"2f996a8\"}],\"margin\":{\"unit\":\"rem\",\"top\":\"6\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"147f613\",\"elType\":\"container\",\"settings\":{\"flex_gap\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true},\"background_background\":\"gradient\",\"background_color\":\"#FAFAFA\",\"background_color_b\":\"#FFFFFF\",\"background_overlay_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_overlay_position\":\"initial\",\"background_overlay_xpos\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"background_overlay_xpos_tablet\":{\"unit\":\"vw\",\"size\":0,\"sizes\":[]},\"background_overlay_xpos_mobile\":{\"unit\":\"vw\",\"size\":0,\"sizes\":[]},\"background_overlay_ypos\":{\"unit\":\"px\",\"size\":-15,\"sizes\":[]},\"background_overlay_repeat\":\"no-repeat\",\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"__globals__\":{\"background_color\":\"globals\\/colors?id=e71cf48\",\"background_color_b\":\"\"},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"a6aa79d\"}],\"flex_wrap_mobile\":\"nowrap\",\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":false},\"boxed_width\":{\"unit\":\"px\",\"size\":1000,\"sizes\":[]}},\"elements\":[{\"id\":\"ba72bb5\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"z_index\":5,\"flex_align_items\":\"center\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"2ef9124\"}],\"margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"boxed_width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false}},\"elements\":[{\"id\":\"6033f12\",\"elType\":\"container\",\"settings\":{\"flex_align_items\":\"center\",\"flex_gap\":{\"unit\":\"px\",\"size\":12,\"sizes\":[],\"column\":\"12\",\"row\":\"12\",\"isLinked\":true},\"background_background\":\"classic\",\"background_color\":\"#FFFFFF\",\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"25\",\"left\":\"25\",\"isLinked\":false},\"padding\":{\"unit\":\"rem\",\"top\":\"1.3\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"css_classes\":\"headingRoundedBgCenter\",\"jedv_conditions\":[{\"_id\":\"50ad584\"}]},\"elements\":[{\"id\":\"cbd0b08\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0648\\u0627\\u0628\\u0642 \\u06a9\\u0627\\u0631\\u06cc \\u0645\\u0646\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhBold_FaNum\",\"jedv_conditions\":[{\"_id\":\"ef9c0f8\"}],\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"0f9342f\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/05\\/seprator.svg\",\"id\":2822},\"library\":\"svg\"},\"align\":\"right\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"_margin\":{\"unit\":\"rem\",\"top\":\"-1.8\",\"right\":\"0\",\"bottom\":\"-2.3\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"5598f0c\"}]},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"315e7a7\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0637\\u06cc \\u0627\\u06cc\\u0646 \\u0633\\u0627\\u0644 \\u0647\\u0627 \\u0686\\u0647 \\u06a9\\u0627\\u0631\\u0647\\u0627 \\u06a9\\u0631\\u062f\\u0645\",\"header_size\":\"span\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"ef9c0f8\"}],\"__globals__\":{\"title_color\":\"globals\\/colors?id=text\"},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"931aca9\",\"elType\":\"widget\",\"settings\":{\"list\":[{\"list_title\":\"\\u0633\\u0627\\u0644 1390 \\u062a\\u0627 1395\",\"list_content\":\"<p>\\u0631\\u0626\\u06cc\\u0633 \\u0647\\u06cc\\u0627\\u062a \\u0639\\u0644\\u0645\\u06cc \\u062f\\u0627\\u0646\\u0634\\u06af\\u0627\\u0647 \\u062a\\u0647\\u0631\\u0627\\u0646<\\/p>\",\"_id\":\"60748c9\",\"image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\"},\"thumbnail_size\":\"full\"},{\"list_title\":\"\\u0633\\u0627\\u0644 1395 \\u062a\\u0627 1399\",\"list_content\":\"<p>\\u0631\\u0626\\u06cc\\u0633 \\u0628\\u06cc\\u0645\\u0627\\u0631\\u0633\\u062a\\u0627\\u0646 \\u06cc\\u0632\\u062f<\\/p>\",\"_id\":\"55c5594\",\"image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\"},\"thumbnail_size\":\"full\"},{\"list_title\":\"\\u0633\\u0627\\u0644 1399 \\u062a\\u0627 1401\",\"list_content\":\"<p>\\u0627\\u0633\\u062a\\u0627\\u062f \\u062a\\u0645\\u0627\\u0645 \\u062f\\u0627\\u0646\\u0634\\u06af\\u0627\\u0647 \\u0634\\u06cc\\u0631\\u0627\\u0632<\\/p>\",\"image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\"},\"thumbnail_size\":\"full\",\"_id\":\"6dddc97\"},{\"list_title\":\"\\u062f\\u0631\\u062d\\u0627\\u0644 \\u062d\\u0627\\u0636\\u0631\",\"list_content\":\"<p>\\u0631\\u0626\\u06cc\\u0633 \\u0647\\u06cc\\u0627\\u062a \\u0645\\u062f\\u06cc\\u0631\\u0647 \\u0628\\u06cc\\u0645\\u0627\\u0631\\u0633\\u062a\\u0627\\u0646<\\/p>\",\"image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\"},\"thumbnail_size\":\"full\",\"_id\":\"6e15c98\"}],\"title_color\":\"#362FD9\",\"tile_typography_typography\":\"custom\",\"tile_typography_font_family\":\"YekanBakh_FaNum\",\"tile_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"tile_typography_font_weight\":\"900\",\"title_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"7\",\"left\":\"0\",\"isLinked\":false},\"content_color\":\"#133154\",\"content_typography_typography\":\"custom\",\"content_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"bg_color\":\"#F5F5F5\",\"button_box_shadow_box_shadow_type\":\"yes\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":0,\"blur\":10,\"spread\":0,\"color\":\"rgba(0, 0, 0, 0)\"},\"_margin\":{\"unit\":\"rem\",\"top\":\"2\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"__globals__\":{\"tile_typography_typography\":\"\",\"title_color\":\"globals\\/colors?id=primary\",\"content_color\":\"globals\\/colors?id=text\",\"bg_color\":\"globals\\/colors?id=4a0ac7d\",\"theme_color\":\"globals\\/colors?id=primary\"},\"jedv_conditions\":[{\"_id\":\"e4b5fd8\"}],\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"tile_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"content_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"gap\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"be-timeline\"},{\"id\":\"292868e\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0622\\u06cc\\u0627 \\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u06cc\\u0634\\u062a\\u0631\\u06cc \\u0646\\u06cc\\u0627\\u0632 \\u062f\\u0627\\u0631\\u06cc\\u062f\\u061f\",\"header_size\":\"div\",\"title_color\":\"#133154\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"typography_font_weight\":\"900\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"\"},\"align\":\"center\",\"jedv_conditions\":[{\"_id\":\"8777509\"}],\"_margin\":{\"unit\":\"rem\",\"top\":\"2\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"ce01650\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0635\\u0641\\u062d\\u0647 \\u062f\\u0631\\u0628\\u0627\\u0631\\u0647 \\u0645\\u0646\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_font_weight\":\"normal\",\"background_color\":\"#362FD9\",\"border_radius\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"30\",\"bottom\":\"12\",\"left\":\"30\",\"isLinked\":false},\"__globals__\":{\"background_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"\",\"hover_color\":\"globals\\/colors?id=primary\"},\"link\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/about-me\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"jedv_conditions\":[{\"_id\":\"cd63ab5\"}],\"button_background_hover_color\":\"#FFFFFF\"},\"elements\":[],\"widgetType\":\"button\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"e3bf3e4\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"margin\":{\"unit\":\"rem\",\"top\":\"6\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"9b30d0e\"}],\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"05eef3b\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/Banner2-min.png\",\"id\":266,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"image_border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"c110609\"}],\"image_border_radius_mobile\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":false},{\"id\":\"ddf6e0b\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"background_background\":\"classic\",\"background_image\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/Time-bg.svg\",\"id\":312,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"top right\",\"background_repeat\":\"no-repeat\",\"padding\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"2\",\"left\":\"0\",\"isLinked\":false},\"css_classes\":\"timing\",\"background_size_mobile\":\"cover\",\"jedv_conditions\":[{\"_id\":\"d6500d5\"}],\"background_size_tablet\":\"cover\",\"margin\":{\"unit\":\"rem\",\"top\":\"6\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"4\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":false}},\"elements\":[{\"id\":\"1957d33\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"background_background\":\"classic\",\"background_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"initial\",\"background_xpos\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"background_xpos_tablet\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"background_xpos_mobile\":{\"unit\":\"%\",\"size\":0,\"sizes\":[]},\"background_ypos\":{\"unit\":\"px\",\"size\":-15,\"sizes\":[]},\"background_repeat\":\"no-repeat\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"148b7c2\"}],\"flex_gap_tablet\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true},\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[],\"column\":\"0\",\"row\":\"0\",\"isLinked\":true},\"flex_wrap_tablet\":\"wrap\"},\"elements\":[{\"id\":\"5c9e650\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/clock-min.png\",\"id\":353,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"align\":\"left\",\"width\":{\"unit\":\"custom\",\"size\":\"auto\",\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_y\":{\"size\":35,\"unit\":\"px\"},\"_offset_x_end\":{\"size\":1,\"unit\":\"px\"},\"_z_index\":0,\"align_mobile\":\"left\",\"width_mobile\":{\"unit\":\"%\",\"size\":35,\"sizes\":[]},\"_offset_x_end_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"jedv_type\":\"hide\",\"jedv_conditions\":[{\"jedv_condition\":\"wp-is-mobile\",\"_id\":\"2ee40ee\"}],\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"hide_tablet\":\"hidden-tablet\",\"hide_mobile\":\"hidden-mobile\",\"height\":{\"unit\":\"px\",\"size\":300,\"sizes\":[]},\"object-fit\":\"contain\"},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"4f338c0\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":25},\"flex_align_items\":\"center\",\"_flex_size\":\"none\",\"_element_width\":\"initial\",\"flex_justify_content\":\"space-between\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"7b3f649\"}],\"width_tablet\":{\"unit\":\"%\",\"size\":23},\"_flex_size_tablet\":\"grow\",\"_element_width_tablet\":\"initial\",\"flex_direction\":\"column\",\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"750cabf\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/Big-dots.svg\",\"id\":106,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"width\":{\"unit\":\"%\",\"size\":90,\"sizes\":[]},\"_offset_y\":{\"unit\":\"px\",\"size\":35,\"sizes\":[]},\"_margin\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-5\",\"left\":\"0\",\"isLinked\":false},\"_flex_order\":\"end\",\"_offset_x\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"_offset_y_end\":{\"unit\":\"px\",\"size\":-45,\"sizes\":[]},\"jedv_type\":\"hide\",\"jedv_conditions\":[{\"jedv_condition\":\"wp-is-mobile\",\"_id\":\"a41d77a\"}],\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-3\",\"left\":\"0\",\"isLinked\":false},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"hide_mobile\":\"hidden-mobile\"},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"6f0b198\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"z_index\":5,\"flex_align_items\":\"center\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"2ef9124\"}],\"margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"boxed_width\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false}},\"elements\":[{\"id\":\"f438c2a\",\"elType\":\"container\",\"settings\":{\"flex_align_items\":\"center\",\"flex_gap\":{\"unit\":\"px\",\"size\":12,\"sizes\":[],\"column\":\"12\",\"row\":\"12\",\"isLinked\":true},\"background_background\":\"classic\",\"background_color\":\"#FFFFFF\",\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"25\",\"left\":\"25\",\"isLinked\":false},\"padding\":{\"unit\":\"rem\",\"top\":\"1.3\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"css_classes\":\"headingRoundedBgCenter\",\"jedv_conditions\":[{\"_id\":\"50ad584\"}]},\"elements\":[{\"id\":\"a479687\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0633\\u0627\\u0639\\u0627\\u062a \\u06a9\\u0627\\u0631\\u06cc \\u0645\\u0646\\n\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhBold_FaNum\",\"jedv_conditions\":[{\"_id\":\"ef9c0f8\"}],\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"3ff47ad\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/05\\/seprator.svg\",\"id\":2822},\"library\":\"svg\"},\"align\":\"right\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"_margin\":{\"unit\":\"rem\",\"top\":\"-1.8\",\"right\":\"0\",\"bottom\":\"-2.3\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"5598f0c\"}]},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"eec5cce\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u062f\\u0631\\u062e\\u062f\\u0645\\u062a \\u0634\\u0645\\u0627 \\u0647\\u0633\\u062a\\u06cc\\u0645\\n\\n\",\"header_size\":\"span\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"ef9c0f8\"}],\"__globals__\":{\"title_color\":\"globals\\/colors?id=text\"},\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"a8e4af7\",\"elType\":\"container\",\"settings\":{\"flex_align_items\":\"center\",\"flex_gap\":{\"unit\":\"px\",\"size\":10,\"sizes\":[],\"column\":\"10\",\"row\":\"10\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"13059b7\"}],\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"00e6c5d\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0648\\u0632\\u0647\\u0627\\u06cc\\u06cc \\u06a9\\u0647 \\u0647\\u0633\\u062a\\u06cc\\u0645\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_font_weight\":\"900\",\"background_color\":\"#FFFFFF00\",\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"text_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"__globals__\":{\"typography_typography\":\"\",\"button_text_color\":\"globals\\/colors?id=primary\"},\"border_border\":\"none\",\"jedv_conditions\":[{\"_id\":\"a03bdcb\"}]},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"e1ab3cf\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0648\\u0632\\u0647\\u0627\\u06cc\\u06cc \\u06a9\\u0647 \\u0646\\u06cc\\u0633\\u062a\\u0640\\u0640\\u0640\\u0645\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_font_weight\":\"900\",\"background_color\":\"#FFFFFF00\",\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"text_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"__globals__\":{\"typography_typography\":\"\",\"button_text_color\":\"globals\\/colors?id=secondary\"},\"border_border\":\"none\",\"jedv_conditions\":[{\"_id\":\"0a120c1\"}]},\"elements\":[],\"widgetType\":\"button\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"d5c4986\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"jedv_conditions\":[{\"_id\":\"6eb3d7f\"}],\"content_width\":\"full\",\"width_tablet\":{\"unit\":\"%\",\"size\":74},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"_flex_size\":\"none\",\"_element_width_tablet\":\"initial\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[],\"column\":\"0\",\"row\":\"0\",\"isLinked\":true},\"flex_wrap\":\"nowrap\",\"flex_direction_tablet\":\"row\",\"flex_wrap_mobile\":\"wrap\",\"width\":{\"unit\":\"%\",\"size\":75,\"sizes\":[]},\"padding\":{\"unit\":\"rem\",\"top\":\"2\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"952a0dc\",\"elType\":\"container\",\"settings\":{\"flex_gap\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"flex_align_items_mobile\":\"center\",\"jedv_conditions\":[{\"_id\":\"e638187\"}],\"_flex_size_tablet\":\"shrink\",\"flex_direction\":\"column\",\"flex_align_items\":\"flex-start\",\"_flex_size\":\"none\",\"_flex_grow\":0,\"_flex_shrink\":2,\"_flex_grow_tablet\":0,\"_flex_shrink_tablet\":1,\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":32},\"_element_width\":\"initial\",\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"bf17f84\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0634\\u0646\\u0628\\u0647 : 8 \\u0635\\u0628\\u062d \\u0627\\u0644\\u06cc 15 \\u0639\\u0635\\u0631\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"button_text_color\":\"#362FD9\",\"background_color\":\"#362FD90F\",\"border_radius\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"17\",\"bottom\":\"17\",\"left\":\"17\",\"isLinked\":true},\"text_padding\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"30\",\"bottom\":\"16\",\"left\":\"30\",\"isLinked\":false},\"_element_custom_width\":{\"unit\":\"%\",\"size\":72,\"sizes\":[]},\"__globals__\":{\"typography_typography\":\"\",\"button_text_color\":\"globals\\/colors?id=primary\",\"background_color\":\"\"},\"_css_classes\":\"time-btn\",\"border_border\":\"none\",\"jedv_conditions\":[{\"_id\":\"0b35cd8\"}],\"align_tablet\":\"right\",\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"text_padding_tablet\":{\"unit\":\"px\",\"top\":\"13\",\"right\":\"20\",\"bottom\":\"13\",\"left\":\"20\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"4270d84\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u06cc\\u06a9\\u0634\\u0646\\u0628\\u0647 : \\u0631\\u0632\\u0631\\u0648 \\u0641\\u0639\\u0627\\u0644 \\u0646\\u06cc\\u0633\\u062a\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_font_weight\":\"900\",\"button_text_color\":\"#CDCDCD\",\"background_color\":\"#CDCDCD1F\",\"border_radius\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"17\",\"bottom\":\"17\",\"left\":\"17\",\"isLinked\":true},\"text_padding\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"30\",\"bottom\":\"16\",\"left\":\"30\",\"isLinked\":false},\"_flex_align_self\":\"flex-start\",\"__globals__\":{\"typography_typography\":\"\",\"button_text_color\":\"globals\\/colors?id=secondary\",\"background_color\":\"\"},\"_css_classes\":\"time-btn\",\"border_border\":\"none\",\"_flex_align_self_mobile\":\"center\",\"jedv_conditions\":[{\"_id\":\"e5686d2\"}],\"text_padding_tablet\":{\"unit\":\"px\",\"top\":\"13\",\"right\":\"20\",\"bottom\":\"13\",\"left\":\"20\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"6e20cd3\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u062f\\u0648\\u0634\\u0646\\u0628\\u0647 : 10 \\u0635\\u0628\\u062d \\u0627\\u0644\\u06cc 18 \\u0639\\u0635\\u0631\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"button_text_color\":\"#362FD9\",\"background_color\":\"#362FD90F\",\"border_radius\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"17\",\"bottom\":\"17\",\"left\":\"17\",\"isLinked\":true},\"text_padding\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"30\",\"bottom\":\"16\",\"left\":\"30\",\"isLinked\":false},\"__globals__\":{\"typography_typography\":\"\",\"button_text_color\":\"globals\\/colors?id=primary\",\"background_color\":\"\"},\"_element_custom_width\":{\"unit\":\"%\",\"size\":72,\"sizes\":[]},\"_css_classes\":\"time-btn\",\"border_border\":\"none\",\"jedv_conditions\":[{\"_id\":\"7905bb2\"}],\"align_tablet\":\"right\",\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"text_padding_tablet\":{\"unit\":\"px\",\"top\":\"13\",\"right\":\"20\",\"bottom\":\"13\",\"left\":\"20\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"1b69e44\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0633\\u0647\\u200c\\u0634\\u0646\\u0628\\u0647 : 8 \\u0635\\u0628\\u062d \\u0627\\u0644\\u06cc 16 \\u0639\\u0635\\u0631\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"button_text_color\":\"#362FD9\",\"background_color\":\"#362FD90F\",\"border_radius\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"17\",\"bottom\":\"17\",\"left\":\"17\",\"isLinked\":true},\"text_padding\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"30\",\"bottom\":\"16\",\"left\":\"30\",\"isLinked\":false},\"__globals__\":{\"typography_typography\":\"\",\"button_text_color\":\"globals\\/colors?id=primary\",\"background_color\":\"\"},\"_element_custom_width\":{\"unit\":\"%\",\"size\":72,\"sizes\":[]},\"_css_classes\":\"time-btn\",\"border_border\":\"none\",\"jedv_conditions\":[{\"_id\":\"f474f4d\"}],\"align_tablet\":\"right\",\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"text_padding_tablet\":{\"unit\":\"px\",\"top\":\"13\",\"right\":\"20\",\"bottom\":\"13\",\"left\":\"20\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"5bbb540\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0686\\u0647\\u0627\\u0631\\u0634\\u0646\\u0628\\u0647 : \\u0631\\u0632\\u0631\\u0648 \\u0641\\u0639\\u0627\\u0644 \\u0646\\u06cc\\u0633\\u062a\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_font_weight\":\"900\",\"button_text_color\":\"#CDCDCD\",\"background_color\":\"#CDCDCD1F\",\"border_radius\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"17\",\"bottom\":\"17\",\"left\":\"17\",\"isLinked\":true},\"text_padding\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"30\",\"bottom\":\"16\",\"left\":\"30\",\"isLinked\":false},\"_flex_align_self\":\"flex-start\",\"__globals__\":{\"typography_typography\":\"\",\"button_text_color\":\"globals\\/colors?id=secondary\",\"background_color\":\"\"},\"_css_classes\":\"time-btn\",\"border_border\":\"none\",\"_flex_align_self_mobile\":\"center\",\"jedv_conditions\":[{\"_id\":\"2b25494\"}],\"text_padding_tablet\":{\"unit\":\"px\",\"top\":\"13\",\"right\":\"20\",\"bottom\":\"13\",\"left\":\"20\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"button\"}],\"isInner\":true},{\"id\":\"36814ab\",\"elType\":\"container\",\"settings\":{\"flex_gap\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"flex_align_items_mobile\":\"center\",\"jedv_conditions\":[{\"_id\":\"6de64ab\"}],\"_flex_size_tablet\":\"shrink\",\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":40,\"sizes\":[]},\"width_tablet\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]}},\"elements\":[{\"id\":\"7e07ee1\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u067e\\u0646\\u062c\\u0634\\u0646\\u0628\\u0647 : 10 \\u0635\\u0628\\u062d \\u0627\\u0644\\u06cc 16 \\u0639\\u0635\\u0631\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"button_text_color\":\"#362FD9\",\"background_color\":\"#362FD90F\",\"border_radius\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"17\",\"bottom\":\"17\",\"left\":\"17\",\"isLinked\":true},\"text_padding\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"30\",\"bottom\":\"16\",\"left\":\"30\",\"isLinked\":false},\"__globals__\":{\"typography_typography\":\"\",\"button_text_color\":\"globals\\/colors?id=primary\",\"background_color\":\"\"},\"_element_custom_width\":{\"unit\":\"%\",\"size\":72,\"sizes\":[]},\"_css_classes\":\"time-btn\",\"border_border\":\"none\",\"jedv_conditions\":[{\"_id\":\"9eb0dca\"}],\"align_tablet\":\"right\",\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"text_padding_tablet\":{\"unit\":\"px\",\"top\":\"13\",\"right\":\"20\",\"bottom\":\"13\",\"left\":\"20\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"f5210e9\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u062c\\u0645\\u0639\\u0647 : 9 \\u0635\\u0628\\u062d \\u0627\\u0644\\u06cc 15 \\u0639\\u0635\\u0631\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"button_text_color\":\"#362FD9\",\"background_color\":\"#362FD90F\",\"border_radius\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"17\",\"bottom\":\"17\",\"left\":\"17\",\"isLinked\":true},\"text_padding\":{\"unit\":\"px\",\"top\":\"17\",\"right\":\"30\",\"bottom\":\"16\",\"left\":\"30\",\"isLinked\":false},\"__globals__\":{\"typography_typography\":\"\",\"button_text_color\":\"globals\\/colors?id=primary\",\"background_color\":\"\"},\"_element_custom_width\":{\"unit\":\"%\",\"size\":72,\"sizes\":[]},\"_css_classes\":\"time-btn\",\"border_border\":\"none\",\"jedv_conditions\":[{\"_id\":\"93faefd\"}],\"align_tablet\":\"right\",\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"text_padding_tablet\":{\"unit\":\"px\",\"top\":\"13\",\"right\":\"20\",\"bottom\":\"13\",\"left\":\"20\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"6472314\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_align_items\":\"center\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"flex_justify_content_mobile\":\"center\",\"jedv_conditions\":[{\"_id\":\"fc068c2\"}]},\"elements\":[{\"id\":\"308f22d\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0622\\u0646\\u0644\\u0627\\u06cc\\u0646\",\"icon_align\":\"right\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_font_weight\":\"900\",\"button_text_color\":\"#FAFAFA\",\"background_color\":\"#362FD9\",\"border_radius\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"text_padding\":{\"unit\":\"px\",\"top\":\"12\",\"right\":\"30\",\"bottom\":\"12\",\"left\":\"30\",\"isLinked\":false},\"__globals__\":{\"typography_typography\":\"\",\"button_text_color\":\"globals\\/colors?id=e71cf48\",\"background_color\":\"\",\"hover_color\":\"globals\\/colors?id=primary\"},\"button_box_shadow_box_shadow_type\":\"yes\",\"button_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":5,\"blur\":15,\"spread\":0,\"color\":\"rgba(53.999999999999986, 47.000000000000014, 217.00000000000003, 0.27)\"},\"_element_custom_width\":{\"unit\":\"%\",\"size\":72,\"sizes\":[]},\"_flex_size\":\"shrink\",\"jedv_conditions\":[{\"_id\":\"243a685\"}],\"link\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/reservation\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"button_background_hover_color\":\"#FFFFFF\",\"text_padding_tablet\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"30\",\"bottom\":\"10\",\"left\":\"30\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"86aea63\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/phone.svg\",\"id\":464},\"library\":\"svg\"},\"title_text\":\"0351234\",\"description_text\":\"\",\"position\":\"left\",\"position_mobile\":\"left\",\"title_size\":\"div\",\"icon_space\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"icon_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"text_align\":\"left\",\"content_vertical_alignment\":\"middle\",\"jedv_conditions\":[{\"_id\":\"c9d840f\"}]},\"elements\":[],\"widgetType\":\"icon-box\"}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true}],\"isInner\":true}],\"isInner\":false},{\"id\":\"04e1074\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"margin\":{\"unit\":\"rem\",\"top\":\"7\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"c35e4ee\"}],\"flex_wrap_tablet\":\"wrap\",\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"flex_align_items\":\"flex-start\",\"flex_gap_tablet\":{\"unit\":\"px\",\"size\":30,\"sizes\":[],\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"a9a4ba8\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":65.010000000000005},\"_flex_size\":\"none\",\"_element_width\":\"initial\",\"flex_direction_mobile\":\"row\",\"jedv_conditions\":[{\"_id\":\"d3ddb9c\"}],\"_flex_size_tablet\":\"grow\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"flex_gap\":{\"unit\":\"px\",\"size\":30,\"sizes\":[],\"column\":\"30\",\"row\":\"30\",\"isLinked\":true},\"flex_gap_tablet\":{\"unit\":\"px\",\"size\":20,\"sizes\":[],\"column\":\"20\",\"row\":\"20\",\"isLinked\":true},\"flex_gap_mobile\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true}},\"elements\":[{\"id\":\"0adb2c5\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_justify_content\":\"space-between\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"5513ca0\"}]},\"elements\":[{\"id\":\"d3dfc85\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u0627\\u062e\\u0628\\u0627\\u0631 \",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"header_size\":\"h3\",\"title_color\":\"#362FD9\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhBold_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"typography_font_weight\":\"900\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"\"},\"jedv_conditions\":[{\"_id\":\"ed0efc5\"}]},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"1aaeb5b\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"button_text_color\":\"#DBDBDB\",\"background_color\":\"#FFFFFF00\",\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"text_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"__globals__\":{\"button_text_color\":\"globals\\/colors?id=22571cf\",\"typography_typography\":\"\",\"hover_color\":\"globals\\/colors?id=primary\"},\"link\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/blog\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"typography_font_weight\":\"normal\",\"hover_color\":\"#362FD9\",\"border_border\":\"none\",\"_flex_align_self\":\"flex-end\",\"jedv_conditions\":[{\"_id\":\"bc696b0\"}],\"icon_indent\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"button\"}],\"isInner\":true},{\"id\":\"187741a\",\"elType\":\"widget\",\"settings\":{\"tabs\":[{\"item_label\":\"\\u062a\\u06a9\\u0646\\u0648\\u0644\\u0648\\u0698\\u06cc\",\"_id\":\"f83e86b\",\"selected_item_icon\":{\"value\":\"\",\"library\":\"\"},\"item_template_id\":\"619\"},{\"item_label\":\"\\u0648\\u0631\\u062f\\u067e\\u0631\\u0633\",\"_id\":\"27f2818\",\"selected_item_icon\":{\"value\":\"\",\"library\":\"\"},\"item_template_id\":\"643\"},{\"item_label\":\"\\u0637\\u0631\\u0627\\u062d\\u06cc \\u0633\\u0627\\u06cc\\u062a\",\"_id\":\"a93e1ae\",\"selected_item_icon\":{\"value\":\"\",\"library\":\"\"},\"item_template_id\":\"649\"},{\"_id\":\"bf54106\",\"selected_item_icon\":{\"value\":\"\",\"library\":\"\"},\"item_label\":\"\\u0645\\u0648\\u0628\\u0627\\u06cc\\u0644\",\"item_template_id\":\"652\"}],\"tabs_control_label_typography_typography\":\"custom\",\"tabs_control_label_typography_font_family\":\"YekanBakh_FaNum\",\"tabs_control_label_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"tabs_control_background_background\":\"classic\",\"tabs_control_background_color\":\"#FAFAFA\",\"tabs_control_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"15\",\"isLinked\":false},\"tabs_control_border_radius\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"tabs_control_background_active_background\":\"classic\",\"tabs_content_padding\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"__globals__\":{\"tabs_container_background_color\":\"\",\"tabs_content_wrapper_background_color\":\"\",\"tabs_control_background_color\":\"globals\\/colors?id=e71cf48\",\"tabs_control_label_typography_typography\":\"\",\"tabs_control_label_color\":\"globals\\/colors?id=primary\",\"tabs_control_label_color_hover\":\"globals\\/colors?id=text\",\"tabs_control_icon_color_hover\":\"globals\\/colors?id=text\",\"tabs_control_label_color_active\":\"globals\\/colors?id=e71cf48\",\"tabs_control_background_active_color\":\"globals\\/colors?id=primary\"},\"tabs_position_mobile\":\"top\",\"auto_switch\":\"\",\"ajax_template\":\"\",\"tab_control_switching\":\"\",\"tab_control_switching_offset\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"606b351\"}],\"tabs_control_wrapper_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"tabs_control_wrapper_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"tabs_control_label_typography_font_size_mobile\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"tabs_control_padding\":{\"unit\":\"px\",\"top\":\"8\",\"right\":\"20\",\"bottom\":\"10\",\"left\":\"20\",\"isLinked\":false},\"tabs_control_padding_mobile\":{\"unit\":\"px\",\"top\":\"7\",\"right\":\"10\",\"bottom\":\"8\",\"left\":\"10\",\"isLinked\":false},\"tabs_control_margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"8\",\"isLinked\":false},\"tabs_content_padding_mobile\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"jet-tabs\"}],\"isInner\":true},{\"id\":\"3d64460\",\"elType\":\"container\",\"settings\":{\"background_background\":\"classic\",\"border_radius\":{\"unit\":\"px\",\"top\":\"25\",\"right\":\"25\",\"bottom\":\"25\",\"left\":\"25\",\"isLinked\":true},\"padding\":{\"unit\":\"rem\",\"top\":\"0.7\",\"right\":\"1.5\",\"bottom\":\"0.8\",\"left\":\"1.5\",\"isLinked\":false},\"__globals__\":{\"background_color\":\"globals\\/colors?id=e71cf48\"},\"flex_direction_mobile\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":5,\"sizes\":[],\"column\":\"5\",\"row\":\"5\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"f98bf01\"}],\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"0.8\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":false}},\"elements\":[{\"id\":\"f3b4aa2\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_justify_content\":\"space-between\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"flex_align_items\":\"center\",\"jedv_conditions\":[{\"_id\":\"67ab62b\"}]},\"elements\":[{\"id\":\"52652c3\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u0648\\u06cc\\u062f\\u06cc\\u0648\\u0647\\u0627\",\"header_size\":\"h3\",\"title_color\":\"#362FD9\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhBold_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"\"},\"jedv_conditions\":[{\"_id\":\"ce3812f\"}]},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"71ad80f\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0647\\u0645\\u0647\",\"link\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/category\\/%d9%88%db%8c%d8%af%db%8c%d9%88\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"button_text_color\":\"#DBDBDB\",\"background_color\":\"#FFFFFF00\",\"border_radius\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"text_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"__globals__\":{\"button_text_color\":\"globals\\/colors?id=22571cf\",\"typography_typography\":\"\",\"hover_color\":\"globals\\/colors?id=primary\"},\"typography_font_weight\":\"normal\",\"hover_color\":\"#362FD9\",\"border_border\":\"none\",\"jedv_conditions\":[{\"_id\":\"f4a8c1d\"}]},\"elements\":[],\"widgetType\":\"button\"}],\"isInner\":true},{\"id\":\"6eb9516\",\"elType\":\"widget\",\"settings\":{\"lisitng_id\":\"599\",\"columns\":\"1\",\"posts_num\":4,\"not_found_message\":\"\\u0647\\u06cc\\u0686 \\u062f\\u0627\\u062f\\u0647 \\u0627\\u06cc \\u06cc\\u0627\\u0641\\u062a \\u0646\\u0634\\u062f\",\"posts_query\":[{\"_id\":\"041740c\",\"type\":\"tax_query\",\"tax_query_taxonomy\":\"category\",\"tax_query_terms\":\"9\"}],\"terms_meta_query\":[],\"users_meta_query\":[],\"vertical_gap\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"bf0db25\"}]},\"elements\":[],\"widgetType\":\"jet-listing-grid\"},{\"id\":\"3b354c7\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/Small-Dots.svg\",\"id\":193,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"image_size\":\"full\",\"width\":{\"unit\":\"%\",\"size\":90,\"sizes\":[]},\"_offset_y\":{\"unit\":\"px\",\"size\":-34,\"sizes\":[]},\"_offset_x\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"_offset_x_end\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"_offset_y_end\":{\"unit\":\"px\",\"size\":-45,\"sizes\":[]},\"_position\":\"absolute\",\"_z_index\":-1,\"jedv_conditions\":[{\"_id\":\"4bac992\"}]},\"elements\":[],\"widgetType\":\"image\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"6dd5ba6\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"margin\":{\"unit\":\"rem\",\"top\":\"5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"efdf8ba\"}],\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[],\"column\":\"0\",\"row\":\"0\",\"isLinked\":true},\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0\",\"left\":\"1\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"6088c76\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u062f\\u06cc\\u062f\\u06af\\u0627\\u0647 \\u0647\\u0627\\u06cc \\u0634\\u0645\\u0627\",\"header_size\":\"h3\",\"title_color\":\"#362FD9\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhBold_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"__globals__\":{\"title_color\":\"globals\\/colors?id=primary\",\"typography_typography\":\"\"},\"jedv_conditions\":[{\"_id\":\"ce3812f\"}]},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"1ae786c\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0627\\u0641\\u062a\\u062e\\u0627\\u0631 \\u0645\\u0646 \\u06cc\\u0627\\u0631\\u06cc \\u0631\\u0633\\u0627\\u0646\\u06cc \\u0634\\u0645\\u0627\\u0633\\u062a\\n\",\"header_size\":\"span\",\"align\":\"right\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"ef9c0f8\"}],\"__globals__\":{\"title_color\":\"globals\\/colors?id=text\"}},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"275dd3e\",\"elType\":\"widget\",\"settings\":{\"lisitng_id\":\"710\",\"columns\":\"2\",\"not_found_message\":\"\\u0647\\u06cc\\u0686 \\u062f\\u0627\\u062f\\u0647 \\u0627\\u06cc \\u06cc\\u0627\\u0641\\u062a \\u0646\\u0634\\u062f\",\"posts_query\":[{\"_id\":\"073f878\",\"tax_query_taxonomy\":\"category\"}],\"terms_meta_query\":[],\"users_meta_query\":[],\"columns_mobile\":\"1\",\"posts_num\":4,\"carousel_enabled\":\"yes\",\"arrows_box_size\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"arrow_color\":\"#CDCDCD\",\"arrow_bg_color\":\"#FAFAFA\",\"arrow_color_hover\":\"#FFFFFF\",\"prev_top_position\":{\"unit\":\"px\",\"size\":-40,\"sizes\":[]},\"prev_left_position\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"next_top_position\":{\"unit\":\"px\",\"size\":-40,\"sizes\":[]},\"next_hor_position\":\"left\",\"next_left_position\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"__globals__\":{\"arrow_bg_color\":\"globals\\/colors?id=e71cf48\",\"arrow_color\":\"globals\\/colors?id=secondary\",\"arrow_color_hover\":\"\",\"arrow_bg_color_hover\":\"globals\\/colors?id=primary\"},\"jedv_conditions\":[{\"_id\":\"81115bf\"}],\"arrows_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_margin\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"jet-listing-grid\"}],\"isInner\":false}]");
INSERT INTO `wp_abz7_postmeta` VALUES("28", "6", "_elementor_page_settings", "a:2:{s:10:\"hide_title\";s:3:\"yes\";s:10:\"custom_css\";s:449:\".timing .elementor-button i{\n    font-size: 7px;\n}\n.jet-tabs__content-wrapper {\n    overflow: visible;\n}\n.PageRadiusCorner::before,.PageRadiusCorner::after{\n	display:block !important;\n}\n@media (max-width:480px){\n.elementor-6 .elementor-element.elementor-element-187741a > .elementor-widget-container > .jet-tabs > .jet-tabs__control-wrapper {\n    overflow-x: scroll;\n    flex-wrap: nowrap;\n    width: 100%;\n}\n.jet-tabs__control {\n    flex: none;\n}\n}\";}");
INSERT INTO `wp_abz7_postmeta` VALUES("27", "6", "_wp_page_template", "elementor_header_footer");
INSERT INTO `wp_abz7_postmeta` VALUES("39", "5", "_edit_lock", "1704279502:1");
INSERT INTO `wp_abz7_postmeta` VALUES("41", "12", "_edit_last", "1");
INSERT INTO `wp_abz7_postmeta` VALUES("42", "12", "_edit_lock", "1680244815:1");
INSERT INTO `wp_abz7_postmeta` VALUES("9043", "1163", "elementor_font_files", "a:1:{i:0;a:7:{s:11:\"font_weight\";s:6:\"normal\";s:10:\"font_style\";s:6:\"normal\";s:4:\"woff\";a:2:{s:2:\"id\";s:4:\"1157\";s:3:\"url\";s:77:\"https://presite.ir/doctor/wp-content/uploads/2023/03/YekanBakhFaNum-Bold.woff\";}s:5:\"woff2\";a:2:{s:2:\"id\";s:4:\"1158\";s:3:\"url\";s:78:\"https://presite.ir/doctor/wp-content/uploads/2023/03/YekanBakhFaNum-Bold.woff2\";}s:3:\"ttf\";a:2:{s:2:\"id\";s:0:\"\";s:3:\"url\";s:0:\"\";}s:3:\"svg\";a:2:{s:2:\"id\";s:0:\"\";s:3:\"url\";s:0:\"\";}s:3:\"eot\";a:2:{s:2:\"id\";s:0:\"\";s:3:\"url\";s:0:\"\";}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("47", "12", "elementor_font_files", "a:1:{i:0;a:7:{s:11:\"font_weight\";s:6:\"normal\";s:10:\"font_style\";s:6:\"normal\";s:4:\"woff\";a:2:{s:2:\"id\";s:4:\"1161\";s:3:\"url\";s:80:\"https://presite.ir/doctor/wp-content/uploads/2023/03/YekanBakhFaNum-Regular.woff\";}s:5:\"woff2\";a:2:{s:2:\"id\";s:4:\"1162\";s:3:\"url\";s:81:\"https://presite.ir/doctor/wp-content/uploads/2023/03/YekanBakhFaNum-Regular.woff2\";}s:3:\"ttf\";a:2:{s:2:\"id\";s:0:\"\";s:3:\"url\";s:0:\"\";}s:3:\"svg\";a:2:{s:2:\"id\";s:0:\"\";s:3:\"url\";s:0:\"\";}s:3:\"eot\";a:2:{s:2:\"id\";s:0:\"\";s:3:\"url\";s:0:\"\";}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("48", "12", "elementor_font_face", "@font-face {\n	font-family: \'YekanBakh_FaNum\';\n	font-style: normal;\n	font-weight: normal;\n	font-display: auto;\n	src: url(\'https://presite.ir/doctor/wp-content/uploads/2023/03/YekanBakhFaNum-Regular.woff2\') format(\'woff2\'),\n		url(\'https://presite.ir/doctor/wp-content/uploads/2023/03/YekanBakhFaNum-Regular.woff\') format(\'woff\');\n}\n");
INSERT INTO `wp_abz7_postmeta` VALUES("52", "5", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("53", "5", "_elementor_page_settings", "a:108:{s:13:\"system_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"اولیه\";s:5:\"color\";s:7:\"#362FD9\";}i:1;a:3:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:6:\"متن\";s:5:\"color\";s:7:\"#133154\";}i:2;a:3:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:13:\"رنگ دوم\";s:5:\"color\";s:7:\"#CDCDCD\";}i:3;a:3:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"شدت\";s:5:\"color\";s:7:\"#61CE70\";}}s:13:\"custom_colors\";a:4:{i:0;a:3:{s:3:\"_id\";s:7:\"4a0ac7d\";s:5:\"title\";s:17:\"رنگ طوسی 1\";s:5:\"color\";s:7:\"#F5F5F5\";}i:1;a:3:{s:3:\"_id\";s:7:\"e71cf48\";s:5:\"title\";s:17:\"رنگ طوسی 2\";s:5:\"color\";s:7:\"#FAFAFA\";}i:2;a:3:{s:3:\"_id\";s:7:\"fc446c3\";s:5:\"title\";s:17:\"رنگ طوسی 3\";s:5:\"color\";s:7:\"#DBDBDB\";}i:3;a:3:{s:3:\"_id\";s:7:\"22571cf\";s:5:\"title\";s:22:\"رنگ متن طوسی\";s:5:\"color\";s:7:\"#A8A8A8\";}}s:17:\"system_typography\";a:4:{i:0;a:4:{s:3:\"_id\";s:7:\"primary\";s:5:\"title\";s:10:\"اولیه\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:15:\"YekanBakh_FaNum\";}i:1;a:4:{s:3:\"_id\";s:9:\"secondary\";s:5:\"title\";s:13:\"رنگ دوم\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:15:\"YekanBakh_FaNum\";}i:2;a:4:{s:3:\"_id\";s:4:\"text\";s:5:\"title\";s:6:\"متن\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:15:\"YekanBakh_FaNum\";}i:3;a:5:{s:3:\"_id\";s:6:\"accent\";s:5:\"title\";s:6:\"شدت\";s:21:\"typography_typography\";s:6:\"custom\";s:22:\"typography_font_family\";s:19:\"YekanBakhBold_FaNum\";s:22:\"typography_font_weight\";s:3:\"900\";}}s:17:\"custom_typography\";a:0:{}s:21:\"default_generic_fonts\";s:10:\"Sans-serif\";s:9:\"site_name\";s:59:\"سایت آماده پزشک متخصص + رزرو نوبت\";s:19:\"page_title_selector\";s:14:\"h1.entry-title\";s:27:\"hello_footer_copyright_text\";s:41:\"کلیه‌ی حقوق محفوظ است.\";s:15:\"activeItemIndex\";i:4;s:11:\"__globals__\";a:43:{s:26:\"body_typography_typography\";s:29:\"globals/typography?id=primary\";s:27:\"form_field_background_color\";s:25:\"globals/colors?id=e71cf48\";s:23:\"form_field_accent_color\";s:25:\"globals/colors?id=primary\";s:33:\"form_field_focus_background_color\";s:25:\"globals/colors?id=4a0ac7d\";s:27:\"form_field_focus_text_color\";s:22:\"globals/colors?id=text\";s:32:\"form_label_typography_typography\";s:29:\"globals/typography?id=primary\";s:32:\"form_field_typography_typography\";s:0:\"\";s:28:\"button_typography_typography\";s:29:\"globals/typography?id=primary\";s:23:\"button_background_color\";s:25:\"globals/colors?id=primary\";s:23:\"button_hover_text_color\";s:25:\"globals/colors?id=primary\";s:29:\"button_hover_background_color\";s:0:\"\";s:25:\"button_hover_border_color\";s:25:\"globals/colors?id=primary\";s:19:\"button_border_color\";s:25:\"globals/colors?id=primary\";s:25:\"mobile_browser_background\";s:25:\"globals/colors?id=primary\";s:21:\"body_background_color\";s:0:\"\";s:40:\"error_message_text_typography_typography\";s:29:\"globals/typography?id=primary\";s:40:\"error_message_link_typography_typography\";s:29:\"globals/typography?id=primary\";s:42:\"message_message_text_typography_typography\";s:29:\"globals/typography?id=primary\";s:41:\"notice_message_link_typography_typography\";s:29:\"globals/typography?id=primary\";s:36:\"message_button_typography_typography\";s:29:\"globals/typography?id=primary\";s:33:\"message_buttons_normal_text_color\";s:25:\"globals/colors?id=e71cf48\";s:39:\"message_buttons_normal_background_color\";s:25:\"globals/colors?id=primary\";s:32:\"message_buttons_hover_text_color\";s:25:\"globals/colors?id=primary\";s:28:\"message_buttons_border_color\";s:25:\"globals/colors?id=primary\";s:34:\"message_buttons_hover_border_color\";s:25:\"globals/colors?id=primary\";s:38:\"message_buttons_hover_background_color\";s:25:\"globals/colors?id=e71cf48\";s:26:\"message_message_icon_color\";s:25:\"globals/colors?id=primary\";s:26:\"message_message_text_color\";s:22:\"globals/colors?id=text\";s:23:\"info_message_text_color\";s:22:\"globals/colors?id=text\";s:39:\"info_message_text_typography_typography\";s:29:\"globals/typography?id=primary\";s:23:\"info_message_icon_color\";s:25:\"globals/colors?id=primary\";s:33:\"info_button_typography_typography\";s:29:\"globals/typography?id=primary\";s:25:\"info_buttons_border_color\";s:25:\"globals/colors?id=primary\";s:30:\"info_buttons_normal_text_color\";s:25:\"globals/colors?id=e71cf48\";s:36:\"info_buttons_normal_background_color\";s:25:\"globals/colors?id=primary\";s:29:\"info_buttons_hover_text_color\";s:25:\"globals/colors?id=primary\";s:35:\"info_buttons_hover_background_color\";s:25:\"globals/colors?id=e71cf48\";s:31:\"info_buttons_hover_border_color\";s:25:\"globals/colors?id=primary\";s:17:\"link_normal_color\";s:25:\"globals/colors?id=primary\";s:16:\"link_hover_color\";s:22:\"globals/colors?id=text\";s:24:\"h1_typography_typography\";s:0:\"\";s:24:\"h2_typography_typography\";s:0:\"\";s:24:\"h3_typography_typography\";s:0:\"\";}s:11:\"viewport_md\";i:768;s:11:\"viewport_lg\";i:1025;s:15:\"container_width\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:1350;s:5:\"sizes\";a:0:{}}s:26:\"body_typography_typography\";s:6:\"custom\";s:27:\"body_typography_font_family\";s:15:\"YekanBakh_FaNum\";s:17:\"button_text_color\";s:7:\"#FFFFFF\";s:20:\"button_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"15\";s:5:\"right\";s:2:\"15\";s:6:\"bottom\";s:2:\"15\";s:4:\"left\";s:2:\"15\";s:8:\"isLinked\";b:1;}s:14:\"button_padding\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"15\";s:5:\"right\";s:2:\"25\";s:6:\"bottom\";s:2:\"15\";s:4:\"left\";s:2:\"25\";s:8:\"isLinked\";b:0;}s:32:\"form_label_typography_typography\";s:6:\"custom\";s:33:\"form_label_typography_font_family\";s:15:\"YekanBakh_FaNum\";s:32:\"form_field_typography_typography\";s:6:\"custom\";s:33:\"form_field_typography_font_family\";s:15:\"YekanBakh_FaNum\";s:23:\"form_field_accent_color\";s:7:\"#362FD9\";s:27:\"form_field_background_color\";s:7:\"#FAFAFA\";s:24:\"form_field_border_border\";s:4:\"none\";s:24:\"form_field_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"13\";s:5:\"right\";s:2:\"13\";s:6:\"bottom\";s:2:\"13\";s:4:\"left\";s:2:\"13\";s:8:\"isLinked\";b:1;}s:27:\"form_field_focus_text_color\";s:7:\"#133154\";s:33:\"form_field_focus_background_color\";s:7:\"#F5F5F5\";s:30:\"form_field_focus_border_border\";s:4:\"none\";s:18:\"form_field_padding\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"15\";s:5:\"right\";s:2:\"15\";s:6:\"bottom\";s:2:\"15\";s:4:\"left\";s:2:\"15\";s:8:\"isLinked\";b:1;}s:28:\"button_typography_typography\";s:6:\"custom\";s:29:\"button_typography_font_family\";s:15:\"YekanBakh_FaNum\";s:23:\"button_background_color\";s:7:\"#362FD9\";s:20:\"button_border_border\";s:5:\"solid\";s:19:\"button_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"2\";s:6:\"bottom\";s:1:\"2\";s:4:\"left\";s:1:\"2\";s:8:\"isLinked\";b:1;}s:23:\"button_hover_text_color\";s:7:\"#362FD9\";s:29:\"button_hover_background_color\";s:7:\"#FAFAFA\";s:26:\"button_hover_border_border\";s:5:\"solid\";s:25:\"button_hover_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"2\";s:6:\"bottom\";s:1:\"2\";s:4:\"left\";s:1:\"2\";s:8:\"isLinked\";b:1;}s:19:\"button_border_color\";s:7:\"#362FD9\";s:25:\"button_hover_border_color\";s:7:\"#362FD9\";s:25:\"mobile_browser_background\";s:7:\"#362FD9\";s:9:\"site_logo\";a:5:{s:3:\"url\";s:67:\"https://presite.ir/doctor/wp-content/uploads/2023/03/new-logo-2.svg\";s:2:\"id\";i:2750;s:4:\"size\";s:0:\"\";s:3:\"alt\";s:0:\"\";s:6:\"source\";s:7:\"library\";}s:28:\"woocommerce_notices_elements\";a:3:{i:0;s:8:\"wc_error\";i:1;s:10:\"wc_message\";i:2;s:7:\"wc_info\";}s:40:\"error_message_text_typography_typography\";s:6:\"custom\";s:41:\"error_message_text_typography_font_family\";s:15:\"YekanBakh_FaNum\";s:40:\"error_message_link_typography_typography\";s:6:\"custom\";s:41:\"error_message_link_typography_font_family\";s:15:\"YekanBakh_FaNum\";s:30:\"error_notice_box_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"20\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:2:\"20\";s:8:\"isLinked\";b:1;}s:42:\"message_message_text_typography_typography\";s:6:\"custom\";s:43:\"message_message_text_typography_font_family\";s:15:\"YekanBakh_FaNum\";s:41:\"notice_message_link_typography_typography\";s:6:\"custom\";s:42:\"notice_message_link_typography_font_family\";s:15:\"YekanBakh_FaNum\";s:32:\"message_notice_box_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"20\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:2:\"20\";s:8:\"isLinked\";b:1;}s:36:\"message_button_typography_typography\";s:6:\"custom\";s:37:\"message_button_typography_font_family\";s:15:\"YekanBakh_FaNum\";s:33:\"message_buttons_normal_text_color\";s:7:\"#FAFAFA\";s:44:\"message_buttons_normal_background_background\";s:7:\"classic\";s:39:\"message_buttons_normal_background_color\";s:7:\"#362FD9\";s:32:\"message_buttons_hover_text_color\";s:7:\"#362FD9\";s:43:\"message_buttons_hover_background_background\";s:7:\"classic\";s:34:\"message_buttons_hover_border_color\";s:7:\"#362FD9\";s:27:\"message_buttons_border_type\";s:5:\"solid\";s:28:\"message_buttons_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"2\";s:6:\"bottom\";s:1:\"2\";s:4:\"left\";s:1:\"2\";s:8:\"isLinked\";b:1;}s:28:\"message_buttons_border_color\";s:7:\"#362FD9\";s:29:\"message_buttons_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"15\";s:5:\"right\";s:2:\"15\";s:6:\"bottom\";s:2:\"15\";s:4:\"left\";s:2:\"15\";s:8:\"isLinked\";b:1;}s:23:\"message_buttons_padding\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"12\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:2:\"12\";s:4:\"left\";s:2:\"20\";s:8:\"isLinked\";b:0;}s:29:\"info_notice_box_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"20\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:2:\"20\";s:8:\"isLinked\";b:1;}s:41:\"info_buttons_normal_background_background\";s:7:\"classic\";s:40:\"info_buttons_hover_background_background\";s:7:\"classic\";s:24:\"info_buttons_border_type\";s:5:\"solid\";s:25:\"info_buttons_border_width\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"2\";s:6:\"bottom\";s:1:\"2\";s:4:\"left\";s:1:\"2\";s:8:\"isLinked\";b:1;}s:26:\"info_buttons_border_radius\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"15\";s:5:\"right\";s:2:\"15\";s:6:\"bottom\";s:2:\"15\";s:4:\"left\";s:2:\"15\";s:8:\"isLinked\";b:1;}s:20:\"info_buttons_padding\";a:6:{s:4:\"unit\";s:2:\"px\";s:3:\"top\";s:2:\"12\";s:5:\"right\";s:2:\"20\";s:6:\"bottom\";s:2:\"12\";s:4:\"left\";s:2:\"20\";s:8:\"isLinked\";b:0;}s:17:\"link_normal_color\";s:7:\"#362FD9\";s:16:\"link_hover_color\";s:7:\"#133154\";s:24:\"h1_typography_typography\";s:6:\"custom\";s:25:\"h1_typography_font_family\";s:15:\"YekanBakh_FaNum\";s:23:\"h1_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:26;s:5:\"sizes\";a:0:{}}s:25:\"h1_typography_line_height\";a:3:{s:4:\"unit\";s:3:\"rem\";s:4:\"size\";i:2;s:5:\"sizes\";a:0:{}}s:24:\"h2_typography_typography\";s:6:\"custom\";s:25:\"h2_typography_font_family\";s:15:\"YekanBakh_FaNum\";s:23:\"h2_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:23;s:5:\"sizes\";a:0:{}}s:25:\"h2_typography_line_height\";a:3:{s:4:\"unit\";s:3:\"rem\";s:4:\"size\";i:2;s:5:\"sizes\";a:0:{}}s:24:\"h3_typography_typography\";s:6:\"custom\";s:25:\"h3_typography_font_family\";s:15:\"YekanBakh_FaNum\";s:23:\"h3_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:25:\"h3_typography_line_height\";a:3:{s:4:\"unit\";s:3:\"rem\";s:4:\"size\";i:2;s:5:\"sizes\";a:0:{}}s:26:\"message_message_text_color\";s:7:\"#133154\";s:26:\"message_message_icon_color\";s:7:\"#362FD9\";s:38:\"message_buttons_hover_background_color\";s:7:\"#FAFAFA\";s:23:\"info_message_text_color\";s:7:\"#133154\";s:39:\"info_message_text_typography_typography\";s:6:\"custom\";s:40:\"info_message_text_typography_font_family\";s:15:\"YekanBakh_FaNum\";s:23:\"info_message_icon_color\";s:7:\"#362FD9\";s:33:\"info_button_typography_typography\";s:6:\"custom\";s:34:\"info_button_typography_font_family\";s:15:\"YekanBakh_FaNum\";s:30:\"info_buttons_normal_text_color\";s:7:\"#FAFAFA\";s:36:\"info_buttons_normal_background_color\";s:7:\"#362FD9\";s:29:\"info_buttons_hover_text_color\";s:7:\"#362FD9\";s:35:\"info_buttons_hover_background_color\";s:7:\"#FAFAFA\";s:31:\"info_buttons_hover_border_color\";s:7:\"#362FD9\";s:25:\"info_buttons_border_color\";s:7:\"#362FD9\";s:30:\"h1_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:23;s:5:\"sizes\";a:0:{}}s:30:\"h2_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:20;s:5:\"sizes\";a:0:{}}s:30:\"h3_typography_font_size_mobile\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:18;s:5:\"sizes\";a:0:{}}s:25:\"body_typography_font_size\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:16;s:5:\"sizes\";a:0:{}}s:16:\"site_description\";s:51:\"یک سایت دیگر از ابزار وردپرس\";}");
INSERT INTO `wp_abz7_postmeta` VALUES("54", "5", "_rankmath__data", "[]");
INSERT INTO `wp_abz7_postmeta` VALUES("62", "5", "_elementor_version", "3.13.4");
INSERT INTO `wp_abz7_postmeta` VALUES("63", "5", "_elementor_pro_version", "3.13.1");
INSERT INTO `wp_abz7_postmeta` VALUES("408", "61", "_wp_attached_file", "2023/03/Logo_NIKE.png");
INSERT INTO `wp_abz7_postmeta` VALUES("409", "61", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:85;s:6:\"height\";i:30;s:4:\"file\";s:21:\"2023/03/Logo_NIKE.png\";s:8:\"filesize\";i:779;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("410", "62", "_wp_attached_file", "2023/03/Under_armour_logo.png");
INSERT INTO `wp_abz7_postmeta` VALUES("411", "62", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:70;s:6:\"height\";i:40;s:4:\"file\";s:29:\"2023/03/Under_armour_logo.png\";s:8:\"filesize\";i:1189;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("412", "63", "_wp_attached_file", "2023/03/puma.png");
INSERT INTO `wp_abz7_postmeta` VALUES("413", "63", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:61;s:6:\"height\";i:45;s:4:\"file\";s:16:\"2023/03/puma.png\";s:8:\"filesize\";i:1251;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("414", "64", "_wp_attached_file", "2023/03/adidas.png");
INSERT INTO `wp_abz7_postmeta` VALUES("415", "64", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:67;s:6:\"height\";i:40;s:4:\"file\";s:18:\"2023/03/adidas.png\";s:8:\"filesize\";i:879;s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("614", "87", "_wp_attached_file", "2023/03/mgh-min.png");
INSERT INTO `wp_abz7_postmeta` VALUES("615", "87", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:500;s:6:\"height\";i:804;s:4:\"file\";s:19:\"2023/03/mgh-min.png\";s:8:\"filesize\";i:176684;s:5:\"sizes\";a:4:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:19:\"mgh-min-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:170638;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:19:\"mgh-min-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:20967;}s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"mgh-min-187x300.png\";s:5:\"width\";i:187;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:98668;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"mgh-min-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:44649;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("773", "106", "_wp_attached_file", "2023/03/Big-dots.svg");
INSERT INTO `wp_abz7_postmeta` VALUES("774", "106", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:6567;s:5:\"width\";i:101;s:6:\"height\";i:101;}");
INSERT INTO `wp_abz7_postmeta` VALUES("888", "119", "_edit_lock", "1685434007:1");
INSERT INTO `wp_abz7_postmeta` VALUES("889", "120", "_wp_attached_file", "2023/03/service-1-min.png");
INSERT INTO `wp_abz7_postmeta` VALUES("890", "120", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:550;s:6:\"height\";i:550;s:4:\"file\";s:25:\"2023/03/service-1-min.png\";s:8:\"filesize\";i:122447;s:5:\"sizes\";a:4:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:25:\"service-1-min-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:144987;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:25:\"service-1-min-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:20607;}s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"service-1-min-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:144987;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"service-1-min-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:41452;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("891", "119", "_thumbnail_id", "120");
INSERT INTO `wp_abz7_postmeta` VALUES("892", "121", "_listing_data", "a:3:{s:6:\"source\";s:5:\"posts\";s:9:\"post_type\";s:7:\"service\";s:3:\"tax\";s:8:\"category\";}");
INSERT INTO `wp_abz7_postmeta` VALUES("893", "121", "_listing_type", "elementor");
INSERT INTO `wp_abz7_postmeta` VALUES("894", "121", "_elementor_page_settings", "a:3:{s:17:\"listing_post_type\";s:7:\"service\";s:11:\"listing_tax\";s:8:\"category\";s:13:\"preview_width\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:300;s:5:\"sizes\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("906", "121", "_rankmath__data", "[{\"id\":\"5684782\",\"elType\":\"container\",\"settings\":{\"css_classes\":\"serviceGrid\",\"flex_gap\":{\"unit\":\"px\",\"size\":12,\"sizes\":[],\"column\":\"12\",\"row\":\"12\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"10\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"f667e03\"}]},\"elements\":[{\"id\":\"86f1598\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\"},\"image_size\":\"medium\",\"link_to\":\"custom\",\"image_border_border\":\"solid\",\"image_border_width\":{\"unit\":\"px\",\"top\":\"5\",\"right\":\"5\",\"bottom\":\"5\",\"left\":\"5\",\"isLinked\":true},\"image_border_radius\":{\"unit\":\"%\",\"top\":\"50\",\"right\":\"50\",\"bottom\":\"50\",\"left\":\"50\",\"isLinked\":true},\"image_border_radius_tablet\":{\"unit\":\"%\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"image_border_radius_mobile\":{\"unit\":\"%\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"__dynamic__\":{\"link\":\"[elementor-tag id=\\\"dbb2cc7\\\" name=\\\"post-url\\\" settings=\\\"%7B%7D\\\"]\",\"image\":\"[elementor-tag id=\\\"739c8e5\\\" name=\\\"post-featured-image\\\" settings=\\\"%7B%7D\\\"]\"},\"__globals__\":{\"image_border_color\":\"globals\\/colors?id=4a0ac7d\"},\"jedv_conditions\":[{\"_id\":\"ef1e666\"}],\"height\":{\"unit\":\"px\",\"size\":190,\"sizes\":[]},\"height_tablet\":{\"unit\":\"px\",\"size\":150,\"sizes\":[]},\"object-fit\":\"cover\"},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"29bd9c8\",\"elType\":\"widget\",\"settings\":{\"title\":\"\",\"header_size\":\"span\",\"align\":\"center\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhBold_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"_css_classes\":\"myHeadingDot\",\"__globals__\":{\"typography_typography\":\"\",\"title_color\":\"globals\\/colors?id=text\"},\"__dynamic__\":{\"title\":\"[elementor-tag id=\\\"e4a4ac5\\\" name=\\\"post-title\\\" settings=\\\"%7B%7D\\\"]\",\"link\":\"[elementor-tag id=\\\"8a11c3e\\\" name=\\\"post-url\\\" settings=\\\"%7B%7D\\\"]\"},\"title_color\":\"#133154\",\"jedv_conditions\":[{\"_id\":\"06c13a9\"}]},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}]");
INSERT INTO `wp_abz7_postmeta` VALUES("895", "121", "_elementor_edit_mode", "builder");
INSERT INTO `wp_abz7_postmeta` VALUES("896", "121", "_elementor_template_type", "jet-listing-items");
INSERT INTO `wp_abz7_postmeta` VALUES("897", "121", "_elementor_version", "3.13.4");
INSERT INTO `wp_abz7_postmeta` VALUES("898", "121", "_elementor_pro_version", "3.13.1");
INSERT INTO `wp_abz7_postmeta` VALUES("899", "121", "_edit_lock", "1685518096:1");
INSERT INTO `wp_abz7_postmeta` VALUES("905", "121", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("1518", "193", "_wp_attached_file", "2023/03/Small-Dots.svg");
INSERT INTO `wp_abz7_postmeta` VALUES("1519", "193", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:7193;s:5:\"width\";i:80;s:6:\"height\";i:80;}");
INSERT INTO `wp_abz7_postmeta` VALUES("2007", "266", "_wp_attached_file", "2023/03/Banner2-min.png");
INSERT INTO `wp_abz7_postmeta` VALUES("2008", "266", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1196;s:6:\"height\";i:120;s:4:\"file\";s:23:\"2023/03/Banner2-min.png\";s:8:\"filesize\";i:49269;s:5:\"sizes\";a:7:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:23:\"Banner2-min-300x120.png\";s:5:\"width\";i:300;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35292;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:23:\"Banner2-min-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15068;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:22:\"Banner2-min-600x60.png\";s:5:\"width\";i:600;s:6:\"height\";i:60;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:38639;}s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"Banner2-min-300x30.png\";s:5:\"width\";i:300;s:6:\"height\";i:30;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9830;}s:5:\"large\";a:5:{s:4:\"file\";s:24:\"Banner2-min-1024x103.png\";s:5:\"width\";i:1024;s:6:\"height\";i:103;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:102795;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:23:\"Banner2-min-150x120.png\";s:5:\"width\";i:150;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:18884;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"Banner2-min-768x77.png\";s:5:\"width\";i:768;s:6:\"height\";i:77;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:60401;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("30190", "3310", "_wp_attached_file", "2023/05/Banner-min-min.png");
INSERT INTO `wp_abz7_postmeta` VALUES("30191", "3310", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1196;s:6:\"height\";i:120;s:4:\"file\";s:26:\"2023/05/Banner-min-min.png\";s:8:\"filesize\";i:57094;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"Banner-min-min-300x30.png\";s:5:\"width\";i:300;s:6:\"height\";i:30;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9837;}s:5:\"large\";a:5:{s:4:\"file\";s:27:\"Banner-min-min-1024x103.png\";s:5:\"width\";i:1024;s:6:\"height\";i:103;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:93241;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"Banner-min-min-150x120.png\";s:5:\"width\";i:150;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:16259;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:25:\"Banner-min-min-768x77.png\";s:5:\"width\";i:768;s:6:\"height\";i:77;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:54641;}s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:26:\"Banner-min-min-300x120.png\";s:5:\"width\";i:300;s:6:\"height\";i:120;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:34514;s:9:\"uncropped\";b:0;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:25:\"Banner-min-min-600x60.png\";s:5:\"width\";i:600;s:6:\"height\";i:60;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35346;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:26:\"Banner-min-min-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10344;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("2425", "312", "_wp_attached_file", "2023/03/Time-bg.svg");
INSERT INTO `wp_abz7_postmeta` VALUES("2426", "312", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:214;s:5:\"width\";i:1198;s:6:\"height\";i:385;}");
INSERT INTO `wp_abz7_postmeta` VALUES("4791", "599", "_edit_lock", "1685445215:2");
INSERT INTO `wp_abz7_postmeta` VALUES("4797", "599", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("2783", "353", "_wp_attached_file", "2023/03/clock-min.png");
INSERT INTO `wp_abz7_postmeta` VALUES("2784", "353", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:445;s:6:\"height\";i:409;s:4:\"file\";s:21:\"2023/03/clock-min.png\";s:8:\"filesize\";i:38529;s:5:\"sizes\";a:4:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:21:\"clock-min-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:70941;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:21:\"clock-min-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12160;}s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"clock-min-300x276.png\";s:5:\"width\";i:300;s:6:\"height\";i:276;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:62754;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"clock-min-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:23316;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("3702", "464", "_wp_attached_file", "2023/03/phone.svg");
INSERT INTO `wp_abz7_postmeta` VALUES("3703", "464", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:943;s:5:\"width\";i:512;s:6:\"height\";i:512;}");
INSERT INTO `wp_abz7_postmeta` VALUES("4784", "599", "_listing_data", "a:3:{s:6:\"source\";s:5:\"posts\";s:9:\"post_type\";s:4:\"post\";s:3:\"tax\";s:8:\"category\";}");
INSERT INTO `wp_abz7_postmeta` VALUES("4785", "599", "_listing_type", "elementor");
INSERT INTO `wp_abz7_postmeta` VALUES("4786", "599", "_elementor_page_settings", "a:2:{s:17:\"listing_post_type\";s:4:\"post\";s:11:\"listing_tax\";s:8:\"category\";}");
INSERT INTO `wp_abz7_postmeta` VALUES("4798", "599", "_rankmath__data", "[{\"id\":\"19ce90b\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_direction_mobile\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true},\"flex_wrap_mobile\":\"nowrap\",\"flex_align_items\":\"center\",\"flex_wrap\":\"nowrap\",\"jedv_conditions\":[{\"_id\":\"6ee8881\"}],\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"bc0e1d2\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\"},\"image_size\":\"thumbnail\",\"width\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"15\",\"bottom\":\"15\",\"left\":\"15\",\"isLinked\":true},\"image_box_shadow_box_shadow_type\":\"yes\",\"image_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":5,\"blur\":15,\"spread\":0,\"color\":\"rgba(19.000000000000043, 49.00000000000004, 84.00000000000003, 0.1)\"},\"__dynamic__\":{\"image\":\"[elementor-tag id=\\\"f1a9576\\\" name=\\\"post-featured-image\\\" settings=\\\"%7B%7D\\\"]\",\"link\":\"[elementor-tag id=\\\"f1c6cd3\\\" name=\\\"post-url\\\" settings=\\\"%7B%7D\\\"]\"},\"space\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"space_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"space_mobile\":{\"unit\":\"px\",\"size\":64,\"sizes\":[]},\"_flex_size\":\"none\",\"link_to\":\"custom\",\"jedv_conditions\":[{\"_id\":\"6622ac8\"}],\"height\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"object-fit\":\"contain\"},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"e116448\",\"elType\":\"widget\",\"settings\":{\"title\":\"\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_font_weight\":\"900\",\"__globals__\":{\"typography_typography\":\"\",\"title_color\":\"\"},\"__dynamic__\":{\"title\":\"[elementor-tag id=\\\"e4a4ac5\\\" name=\\\"post-title\\\" settings=\\\"%7B%7D\\\"]\",\"link\":\"[elementor-tag id=\\\"8a11c3e\\\" name=\\\"post-url\\\" settings=\\\"%7B%7D\\\"]\"},\"typography_line_height\":{\"unit\":\"px\",\"size\":24,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"title_color\":\"#133154\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-0.5,\"sizes\":[]},\"_flex_size\":\"shrink\",\"jedv_conditions\":[{\"_id\":\"0064c1c\"}],\"header_size\":\"span\"},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}]");
INSERT INTO `wp_abz7_postmeta` VALUES("4787", "599", "_elementor_edit_mode", "builder");
INSERT INTO `wp_abz7_postmeta` VALUES("4788", "599", "_elementor_template_type", "jet-listing-items");
INSERT INTO `wp_abz7_postmeta` VALUES("4789", "599", "_elementor_version", "3.13.4");
INSERT INTO `wp_abz7_postmeta` VALUES("4790", "599", "_elementor_pro_version", "3.13.1");
INSERT INTO `wp_abz7_postmeta` VALUES("4262", "1", "_edit_lock", "1679757134:1");
INSERT INTO `wp_abz7_postmeta` VALUES("4263", "526", "_wp_attached_file", "2023/03/Apple-Update-1.jpg");
INSERT INTO `wp_abz7_postmeta` VALUES("4264", "526", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:822;s:6:\"height\";i:522;s:4:\"file\";s:26:\"2023/03/Apple-Update-1.jpg\";s:8:\"filesize\";i:44780;s:5:\"sizes\";a:6:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:26:\"Apple-Update-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12305;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:26:\"Apple-Update-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3062;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:26:\"Apple-Update-1-600x381.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:381;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:25471;}s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"Apple-Update-1-300x191.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:191;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9410;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"Apple-Update-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4861;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:26:\"Apple-Update-1-768x488.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:488;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36308;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("4268", "528", "_edit_lock", "1679831650:1");
INSERT INTO `wp_abz7_postmeta` VALUES("4267", "1", "_thumbnail_id", "526");
INSERT INTO `wp_abz7_postmeta` VALUES("4269", "529", "_wp_attached_file", "2023/03/Beyond-iPhone-13-Better-Blue-Face-ID.jpg");
INSERT INTO `wp_abz7_postmeta` VALUES("4270", "529", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:915;s:6:\"height\";i:580;s:4:\"file\";s:48:\"2023/03/Beyond-iPhone-13-Better-Blue-Face-ID.jpg\";s:8:\"filesize\";i:37250;s:5:\"sizes\";a:6:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:48:\"Beyond-iPhone-13-Better-Blue-Face-ID-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11455;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:48:\"Beyond-iPhone-13-Better-Blue-Face-ID-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3046;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:48:\"Beyond-iPhone-13-Better-Blue-Face-ID-600x380.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:380;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18625;}s:6:\"medium\";a:5:{s:4:\"file\";s:48:\"Beyond-iPhone-13-Better-Blue-Face-ID-300x190.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7101;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:48:\"Beyond-iPhone-13-Better-Blue-Face-ID-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4879;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:48:\"Beyond-iPhone-13-Better-Blue-Face-ID-768x487.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:487;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26533;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("4274", "531", "_listing_data", "a:3:{s:6:\"source\";s:5:\"posts\";s:9:\"post_type\";s:4:\"post\";s:3:\"tax\";s:8:\"category\";}");
INSERT INTO `wp_abz7_postmeta` VALUES("4273", "528", "_thumbnail_id", "529");
INSERT INTO `wp_abz7_postmeta` VALUES("4275", "531", "_listing_type", "elementor");
INSERT INTO `wp_abz7_postmeta` VALUES("4276", "531", "_elementor_page_settings", "a:3:{s:17:\"listing_post_type\";s:4:\"post\";s:11:\"listing_tax\";s:8:\"category\";s:13:\"preview_width\";a:3:{s:4:\"unit\";s:2:\"px\";s:4:\"size\";i:300;s:5:\"sizes\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("4296", "531", "_rankmath__data", "[{\"id\":\"60ec1f7\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"css_classes\":\"over-post\",\"jedv_conditions\":[{\"_id\":\"2248f61\"}]},\"elements\":[{\"id\":\"2ab04f8\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\"},\"image_size\":\"medium_large\",\"__dynamic__\":{\"image\":\"[elementor-tag id=\\\"21cf27d\\\" name=\\\"post-featured-image\\\" settings=\\\"%7B%7D\\\"]\"},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"5120a10\"}],\"height\":{\"unit\":\"px\",\"size\":200,\"sizes\":[]},\"object-fit\":\"cover\"},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"1018940\",\"elType\":\"widget\",\"settings\":{\"layout\":\"above\",\"bg_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\"},\"bg_image_size\":\"thumbnail\",\"title\":\"\",\"description\":\"\",\"title_tag\":\"span\",\"button\":\"\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"image_min_width\":{\"unit\":\"px\",\"size\":36,\"sizes\":[]},\"image_min_height\":{\"unit\":\"px\",\"size\":33,\"sizes\":[]},\"title_typography_typography\":\"custom\",\"title_typography_font_family\":\"YekanBakhBold_FaNum\",\"title_typography_font_size\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"content_bg_color\":\"#FFFDFD00\",\"title_color\":\"#362FD9\",\"transformation\":\"\",\"overlay_color_hover\":\"#FFFFFF00\",\"effect_duration\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"_padding\":{\"unit\":\"px\",\"top\":\"5\",\"right\":\"5\",\"bottom\":\"5\",\"left\":\"5\",\"isLinked\":true},\"_element_width\":\"auto\",\"_position\":\"absolute\",\"_offset_orientation_h\":\"end\",\"_offset_x_end\":{\"size\":9,\"unit\":\"px\"},\"_offset_y\":{\"size\":10,\"unit\":\"px\"},\"_background_background\":\"classic\",\"_background_color\":\"#FFFFFF\",\"_border_radius\":{\"unit\":\"px\",\"top\":\"13\",\"right\":\"13\",\"bottom\":\"13\",\"left\":\"13\",\"isLinked\":true},\"__dynamic__\":{\"bg_image\":\"[elementor-tag id=\\\"97dbf8f\\\" name=\\\"author-profile-picture\\\" settings=\\\"%7B%7D\\\"]\",\"title\":\"[elementor-tag id=\\\"2c246f9\\\" name=\\\"comments-number\\\" settings=\\\"%7B%22format_no_comments%22%3A%220%20%D8%AF%DB%8C%D8%AF%DA%AF%D8%A7%D9%87%22%2C%22format_one_comments%22%3A%221%20%D8%AF%DB%8C%D8%AF%DA%AF%D8%A7%D9%87%22%2C%22format_many_comments%22%3A%22%7Bnumber%7D%20%D8%AF%DB%8C%D8%AF%DA%AF%D8%A7%D9%87%22%7D\\\"]\"},\"__globals__\":{\"title_typography_typography\":\"\",\"title_color\":\"globals\\/colors?id=primary\",\"_background_color\":\"\"},\"jedv_conditions\":[{\"_id\":\"75ceeb8\"}]},\"elements\":[],\"widgetType\":\"call-to-action\"},{\"id\":\"c42fc3f\",\"elType\":\"widget\",\"settings\":{\"title\":\"\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"typography_font_weight\":\"900\",\"__globals__\":{\"typography_typography\":\"\",\"title_color\":\"globals\\/colors?id=e71cf48\"},\"__dynamic__\":{\"title\":\"[elementor-tag id=\\\"e4a4ac5\\\" name=\\\"post-title\\\" settings=\\\"%7B%7D\\\"]\",\"link\":\"[elementor-tag id=\\\"8a11c3e\\\" name=\\\"post-url\\\" settings=\\\"%7B%7D\\\"]\"},\"typography_line_height\":{\"unit\":\"rem\",\"size\":2,\"sizes\":[]},\"_position\":\"absolute\",\"_offset_orientation_v\":\"end\",\"title_color\":\"#FAFAFA\",\"_padding\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1.2\",\"bottom\":\"0.5\",\"left\":\"1\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"5f4fb2f\"}],\"header_size\":\"span\",\"typography_line_height_tablet\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"rem\",\"size\":\"\",\"sizes\":[]},\"_padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":false}]");
INSERT INTO `wp_abz7_postmeta` VALUES("4277", "531", "_elementor_edit_mode", "builder");
INSERT INTO `wp_abz7_postmeta` VALUES("4278", "531", "_elementor_template_type", "jet-listing-items");
INSERT INTO `wp_abz7_postmeta` VALUES("4279", "531", "_elementor_version", "3.13.4");
INSERT INTO `wp_abz7_postmeta` VALUES("4280", "531", "_elementor_pro_version", "3.13.1");
INSERT INTO `wp_abz7_postmeta` VALUES("4281", "531", "_edit_lock", "1685445219:2");
INSERT INTO `wp_abz7_postmeta` VALUES("4295", "531", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("4967", "528", "_edit_last", "1");
INSERT INTO `wp_abz7_postmeta` VALUES("4968", "528", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("4971", "619", "_elementor_source", "post");
INSERT INTO `wp_abz7_postmeta` VALUES("4972", "619", "_elementor_edit_mode", "builder");
INSERT INTO `wp_abz7_postmeta` VALUES("4973", "619", "_elementor_template_type", "section");
INSERT INTO `wp_abz7_postmeta` VALUES("4974", "619", "_elementor_version", "3.13.4");
INSERT INTO `wp_abz7_postmeta` VALUES("4975", "619", "_elementor_pro_version", "3.13.1");
INSERT INTO `wp_abz7_postmeta` VALUES("4976", "619", "_edit_lock", "1685353517:1");
INSERT INTO `wp_abz7_postmeta` VALUES("4982", "619", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("4983", "619", "_rankmath__data", "[{\"id\":\"f75d608\",\"elType\":\"container\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"8f18ecf\"}]},\"elements\":[{\"id\":\"346ffd5\",\"elType\":\"widget\",\"settings\":{\"lisitng_id\":\"531\",\"columns\":\"2\",\"not_found_message\":\"\\u0647\\u06cc\\u0686 \\u062f\\u0627\\u062f\\u0647 \\u0627\\u06cc \\u06cc\\u0627\\u0641\\u062a \\u0646\\u0634\\u062f\",\"posts_query\":[{\"_id\":\"073f878\",\"type\":\"tax_query\",\"tax_query_taxonomy\":\"category\",\"tax_query_terms\":\"3\"}],\"terms_meta_query\":[],\"users_meta_query\":[],\"columns_mobile\":\"1\",\"posts_num\":4,\"carousel_enabled\":\"yes\",\"arrows_box_size\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"arrow_color\":\"#CDCDCD\",\"arrow_bg_color\":\"#F5F5F5\",\"arrow_color_hover\":\"#FFFFFF\",\"prev_top_position\":{\"unit\":\"px\",\"size\":-40,\"sizes\":[]},\"prev_left_position\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"next_top_position\":{\"unit\":\"px\",\"size\":-40,\"sizes\":[]},\"next_hor_position\":\"left\",\"next_left_position\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"__globals__\":{\"arrow_bg_color\":\"globals\\/colors?id=4a0ac7d\",\"arrow_color\":\"globals\\/colors?id=secondary\",\"arrow_color_hover\":\"\",\"arrow_bg_color_hover\":\"globals\\/colors?id=primary\"},\"arrows_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"7ae819d\"}],\"arrows_box_size_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"arrows_size_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"arrows\":\"\",\"prev_top_position_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"prev_left_position_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"next_top_position_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"next_left_position_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"jet-listing-grid\"}],\"isInner\":false}]");
INSERT INTO `wp_abz7_postmeta` VALUES("5107", "634", "_edit_lock", "1679917883:1");
INSERT INTO `wp_abz7_postmeta` VALUES("5108", "635", "_wp_attached_file", "2023/03/Firefox-Scroll-1.jpg");
INSERT INTO `wp_abz7_postmeta` VALUES("5109", "635", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:915;s:6:\"height\";i:580;s:4:\"file\";s:28:\"2023/03/Firefox-Scroll-1.jpg\";s:8:\"filesize\";i:45222;s:5:\"sizes\";a:6:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:28:\"Firefox-Scroll-1-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12827;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:28:\"Firefox-Scroll-1-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3324;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:28:\"Firefox-Scroll-1-600x380.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:380;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22671;}s:6:\"medium\";a:5:{s:4:\"file\";s:28:\"Firefox-Scroll-1-300x190.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:190;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8838;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:28:\"Firefox-Scroll-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5383;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:28:\"Firefox-Scroll-1-768x487.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:487;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31875;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("5113", "637", "_edit_lock", "1679917884:1");
INSERT INTO `wp_abz7_postmeta` VALUES("5112", "634", "_thumbnail_id", "635");
INSERT INTO `wp_abz7_postmeta` VALUES("5114", "638", "_wp_attached_file", "2023/03/iphone-se-4-modified.jpg");
INSERT INTO `wp_abz7_postmeta` VALUES("5115", "638", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:822;s:6:\"height\";i:522;s:4:\"file\";s:32:\"2023/03/iphone-se-4-modified.jpg\";s:8:\"filesize\";i:33748;s:5:\"sizes\";a:6:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:32:\"iphone-se-4-modified-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14094;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:32:\"iphone-se-4-modified-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3350;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:32:\"iphone-se-4-modified-600x381.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:381;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:24457;}s:6:\"medium\";a:5:{s:4:\"file\";s:32:\"iphone-se-4-modified-300x191.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:191;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9183;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:32:\"iphone-se-4-modified-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5633;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:32:\"iphone-se-4-modified-768x488.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:488;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34601;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("5119", "640", "_edit_lock", "1679832359:1");
INSERT INTO `wp_abz7_postmeta` VALUES("5118", "637", "_thumbnail_id", "661");
INSERT INTO `wp_abz7_postmeta` VALUES("5125", "641", "_wp_attached_file", "2023/03/Redmi_K50_Gaming_Edition_Blau-e1645017270905.jpg");
INSERT INTO `wp_abz7_postmeta` VALUES("5126", "641", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:822;s:6:\"height\";i:522;s:4:\"file\";s:56:\"2023/03/Redmi_K50_Gaming_Edition_Blau-e1645017270905.jpg\";s:8:\"filesize\";i:34287;s:5:\"sizes\";a:6:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:56:\"Redmi_K50_Gaming_Edition_Blau-e1645017270905-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12410;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:56:\"Redmi_K50_Gaming_Edition_Blau-e1645017270905-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2895;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:56:\"Redmi_K50_Gaming_Edition_Blau-e1645017270905-600x381.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:381;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:23470;}s:6:\"medium\";a:5:{s:4:\"file\";s:56:\"Redmi_K50_Gaming_Edition_Blau-e1645017270905-300x191.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:191;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8386;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:56:\"Redmi_K50_Gaming_Edition_Blau-e1645017270905-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4687;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:56:\"Redmi_K50_Gaming_Edition_Blau-e1645017270905-768x488.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:488;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33898;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("5130", "643", "_elementor_source", "post");
INSERT INTO `wp_abz7_postmeta` VALUES("5129", "640", "_thumbnail_id", "641");
INSERT INTO `wp_abz7_postmeta` VALUES("5131", "643", "_elementor_edit_mode", "builder");
INSERT INTO `wp_abz7_postmeta` VALUES("5132", "643", "_elementor_template_type", "section");
INSERT INTO `wp_abz7_postmeta` VALUES("5133", "643", "_elementor_version", "3.13.4");
INSERT INTO `wp_abz7_postmeta` VALUES("5134", "643", "_elementor_pro_version", "3.13.1");
INSERT INTO `wp_abz7_postmeta` VALUES("5135", "643", "_edit_lock", "1685353507:1");
INSERT INTO `wp_abz7_postmeta` VALUES("5141", "643", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("5142", "643", "_rankmath__data", "[{\"id\":\"0b9fa59\",\"elType\":\"container\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"45e9b0e\"}]},\"elements\":[{\"id\":\"2b4a6db\",\"elType\":\"widget\",\"settings\":{\"lisitng_id\":\"531\",\"columns\":\"2\",\"not_found_message\":\"\\u0647\\u06cc\\u0686 \\u062f\\u0627\\u062f\\u0647 \\u0627\\u06cc \\u06cc\\u0627\\u0641\\u062a \\u0646\\u0634\\u062f\",\"posts_query\":[{\"_id\":\"073f878\",\"type\":\"tax_query\",\"tax_query_taxonomy\":\"category\",\"tax_query_terms\":\"5\"}],\"terms_meta_query\":[],\"users_meta_query\":[],\"columns_mobile\":\"1\",\"posts_num\":4,\"carousel_enabled\":\"yes\",\"arrows_box_size\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"arrow_color\":\"#CDCDCD\",\"arrow_bg_color\":\"#F5F5F5\",\"arrow_color_hover\":\"#FFFFFF\",\"prev_top_position\":{\"unit\":\"px\",\"size\":-40,\"sizes\":[]},\"prev_left_position\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"next_top_position\":{\"unit\":\"px\",\"size\":-40,\"sizes\":[]},\"next_hor_position\":\"left\",\"next_left_position\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"__globals__\":{\"arrow_bg_color\":\"globals\\/colors?id=4a0ac7d\",\"arrow_color\":\"globals\\/colors?id=secondary\",\"arrow_color_hover\":\"\",\"arrow_bg_color_hover\":\"globals\\/colors?id=primary\"},\"arrows_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"04e2ba7\"}],\"arrows_box_size_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"arrows_size_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"arrows\":\"\"},\"elements\":[],\"widgetType\":\"jet-listing-grid\"}],\"isInner\":false}]");
INSERT INTO `wp_abz7_postmeta` VALUES("5180", "649", "_elementor_source", "post");
INSERT INTO `wp_abz7_postmeta` VALUES("5181", "649", "_elementor_edit_mode", "builder");
INSERT INTO `wp_abz7_postmeta` VALUES("5182", "649", "_elementor_template_type", "section");
INSERT INTO `wp_abz7_postmeta` VALUES("5183", "649", "_elementor_version", "3.13.4");
INSERT INTO `wp_abz7_postmeta` VALUES("5184", "649", "_elementor_pro_version", "3.13.1");
INSERT INTO `wp_abz7_postmeta` VALUES("5185", "649", "_edit_lock", "1685354365:1");
INSERT INTO `wp_abz7_postmeta` VALUES("5191", "649", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("5192", "649", "_rankmath__data", "[{\"id\":\"4ac0656\",\"elType\":\"container\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"4ed76ff\"}]},\"elements\":[{\"id\":\"c42ca55\",\"elType\":\"widget\",\"settings\":{\"lisitng_id\":\"531\",\"columns\":\"2\",\"not_found_message\":\"\\u0647\\u06cc\\u0686 \\u062f\\u0627\\u062f\\u0647 \\u0627\\u06cc \\u06cc\\u0627\\u0641\\u062a \\u0646\\u0634\\u062f\",\"posts_query\":[{\"_id\":\"073f878\",\"type\":\"tax_query\",\"tax_query_taxonomy\":\"category\",\"tax_query_terms\":\"6\"}],\"terms_meta_query\":[],\"users_meta_query\":[],\"columns_mobile\":\"1\",\"posts_num\":4,\"carousel_enabled\":\"yes\",\"arrows_box_size\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"arrow_color\":\"#CDCDCD\",\"arrow_bg_color\":\"#F5F5F5\",\"arrow_color_hover\":\"#FFFFFF\",\"prev_top_position\":{\"unit\":\"px\",\"size\":-40,\"sizes\":[]},\"prev_left_position\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"next_top_position\":{\"unit\":\"px\",\"size\":-40,\"sizes\":[]},\"next_hor_position\":\"left\",\"next_left_position\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"__globals__\":{\"arrow_bg_color\":\"globals\\/colors?id=4a0ac7d\",\"arrow_color\":\"globals\\/colors?id=secondary\",\"arrow_color_hover\":\"\",\"arrow_bg_color_hover\":\"globals\\/colors?id=primary\"},\"arrows_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"1b88385\"}],\"arrows_box_size_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"arrows_size_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"arrows\":\"\"},\"elements\":[],\"widgetType\":\"jet-listing-grid\"}],\"isInner\":false}]");
INSERT INTO `wp_abz7_postmeta` VALUES("5202", "652", "_elementor_source", "post");
INSERT INTO `wp_abz7_postmeta` VALUES("5203", "652", "_elementor_edit_mode", "builder");
INSERT INTO `wp_abz7_postmeta` VALUES("5204", "652", "_elementor_template_type", "section");
INSERT INTO `wp_abz7_postmeta` VALUES("5205", "652", "_elementor_version", "3.13.4");
INSERT INTO `wp_abz7_postmeta` VALUES("5206", "652", "_elementor_pro_version", "3.13.1");
INSERT INTO `wp_abz7_postmeta` VALUES("5207", "652", "_edit_lock", "1685353514:1");
INSERT INTO `wp_abz7_postmeta` VALUES("5213", "652", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("5214", "652", "_rankmath__data", "[{\"id\":\"e59b28f\",\"elType\":\"container\",\"settings\":{\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"815b3d3\"}]},\"elements\":[{\"id\":\"36864a6\",\"elType\":\"widget\",\"settings\":{\"lisitng_id\":\"531\",\"columns\":\"2\",\"not_found_message\":\"\\u0647\\u06cc\\u0686 \\u062f\\u0627\\u062f\\u0647 \\u0627\\u06cc \\u06cc\\u0627\\u0641\\u062a \\u0646\\u0634\\u062f\",\"posts_query\":[{\"_id\":\"073f878\",\"type\":\"tax_query\",\"tax_query_taxonomy\":\"category\",\"tax_query_terms\":\"4\"}],\"terms_meta_query\":[],\"users_meta_query\":[],\"columns_mobile\":\"1\",\"posts_num\":4,\"carousel_enabled\":\"yes\",\"arrows_box_size\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"arrow_color\":\"#CDCDCD\",\"arrow_bg_color\":\"#F5F5F5\",\"arrow_color_hover\":\"#FFFFFF\",\"prev_top_position\":{\"unit\":\"px\",\"size\":-40,\"sizes\":[]},\"prev_left_position\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"next_top_position\":{\"unit\":\"px\",\"size\":-40,\"sizes\":[]},\"next_hor_position\":\"left\",\"next_left_position\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"__globals__\":{\"arrow_bg_color\":\"globals\\/colors?id=4a0ac7d\",\"arrow_color\":\"globals\\/colors?id=secondary\",\"arrow_color_hover\":\"\",\"arrow_bg_color_hover\":\"globals\\/colors?id=primary\"},\"arrows_size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"776e4e6\"}],\"arrows_box_size_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"arrows_size_mobile\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"arrows\":\"\"},\"elements\":[],\"widgetType\":\"jet-listing-grid\"}],\"isInner\":false}]");
INSERT INTO `wp_abz7_postmeta` VALUES("5280", "661", "_wp_attached_file", "2023/03/MIUI-14-2.jpg");
INSERT INTO `wp_abz7_postmeta` VALUES("5281", "661", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:822;s:6:\"height\";i:522;s:4:\"file\";s:21:\"2023/03/MIUI-14-2.jpg\";s:8:\"filesize\";i:55058;s:5:\"sizes\";a:6:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:21:\"MIUI-14-2-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18620;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:21:\"MIUI-14-2-100x100.jpg\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4466;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:21:\"MIUI-14-2-600x381.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:381;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37786;}s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"MIUI-14-2-300x191.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:191;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14896;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"MIUI-14-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7496;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:21:\"MIUI-14-2-768x488.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:488;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:51741;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("5734", "709", "_wp_attached_file", "2023/03/user-min.png");
INSERT INTO `wp_abz7_postmeta` VALUES("5735", "709", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:343;s:6:\"height\";i:329;s:4:\"file\";s:20:\"2023/03/user-min.png\";s:8:\"filesize\";i:44991;s:5:\"sizes\";a:4:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:20:\"user-min-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:92517;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:20:\"user-min-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13321;}s:6:\"medium\";a:5:{s:4:\"file\";s:20:\"user-min-300x288.png\";s:5:\"width\";i:300;s:6:\"height\";i:288;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:87704;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:20:\"user-min-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:27184;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("5736", "710", "_listing_data", "a:3:{s:6:\"source\";s:19:\"custom_content_type\";s:9:\"post_type\";s:7:\"reviews\";s:3:\"tax\";s:8:\"category\";}");
INSERT INTO `wp_abz7_postmeta` VALUES("5737", "710", "_listing_type", "elementor");
INSERT INTO `wp_abz7_postmeta` VALUES("5738", "710", "_elementor_page_settings", "a:4:{s:14:\"listing_source\";s:19:\"custom_content_type\";s:17:\"listing_post_type\";s:7:\"reviews\";s:11:\"listing_tax\";s:8:\"category\";s:8:\"cct_type\";s:7:\"reviews\";}");
INSERT INTO `wp_abz7_postmeta` VALUES("5750", "710", "_rankmath__data", "[{\"id\":\"9bc50d2\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[],\"column\":\"0\",\"row\":\"0\",\"isLinked\":true},\"flex_wrap_mobile\":\"nowrap\",\"background_background\":\"classic\",\"border_radius\":{\"unit\":\"px\",\"top\":\"40\",\"right\":\"40\",\"bottom\":\"40\",\"left\":\"40\",\"isLinked\":true},\"padding\":{\"unit\":\"rem\",\"top\":\"2\",\"right\":\"2\",\"bottom\":\"2\",\"left\":\"2\",\"isLinked\":true},\"__globals__\":{\"background_color\":\"globals\\/colors?id=e71cf48\"},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"3d46c86\"}]},\"elements\":[{\"id\":\"8940b89\",\"elType\":\"container\",\"settings\":{\"boxed_width_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"flex_direction\":\"row\",\"flex_direction_mobile\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":10,\"sizes\":[],\"column\":\"10\",\"row\":\"10\",\"isLinked\":true},\"flex_wrap_mobile\":\"nowrap\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"6de27c6\"}]},\"elements\":[{\"id\":\"1808577\",\"elType\":\"widget\",\"settings\":{\"image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\"},\"image_size\":\"thumbnail\",\"width\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"width_tablet\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"width_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"image_border_radius\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"15\",\"bottom\":\"15\",\"left\":\"15\",\"isLinked\":true},\"image_box_shadow_box_shadow_type\":\"yes\",\"image_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":5,\"blur\":15,\"spread\":0,\"color\":\"rgba(19.000000000000043, 49.00000000000004, 84.00000000000003, 0.1)\"},\"_flex_align_self\":\"center\",\"__dynamic__\":{\"image\":\"[elementor-tag id=\\\"87fd98a\\\" name=\\\"jet-cct-image\\\" settings=\\\"%7B%22content_type_field%22%3A%22reviews__review_pic%22%7D\\\"]\"},\"height\":{\"unit\":\"px\",\"size\":50,\"sizes\":[]},\"object-fit\":\"cover\",\"jedv_conditions\":[{\"_id\":\"019fea3\"}]},\"elements\":[],\"widgetType\":\"image\"},{\"id\":\"f5d6dd4\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"flex_direction_mobile\":\"column\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[],\"column\":\"0\",\"row\":\"0\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"068b338\"}]},\"elements\":[{\"id\":\"cb835c9\",\"elType\":\"widget\",\"settings\":{\"title\":\"\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhBold_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":15,\"sizes\":[]},\"__globals__\":{\"typography_typography\":\"\",\"title_color\":\"\"},\"__dynamic__\":{\"title\":\"[elementor-tag id=\\\"c52f251\\\" name=\\\"jet-cct-field\\\" settings=\\\"%7B%22content_type_field%22%3A%22reviews__review_name%22%7D\\\"]\"},\"typography_line_height\":{\"unit\":\"px\",\"size\":24,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"title_color\":\"#133154\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-0.5,\"sizes\":[]},\"header_size\":\"div\",\"jedv_conditions\":[{\"_id\":\"9dcc77e\"}]},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"2ce07c0\",\"elType\":\"widget\",\"settings\":{\"title\":\"\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"__globals__\":{\"typography_typography\":\"\",\"title_color\":\"globals\\/colors?id=primary\"},\"__dynamic__\":{\"title\":\"[elementor-tag id=\\\"c52f251\\\" name=\\\"jet-cct-field\\\" settings=\\\"%7B%22content_type_field%22%3A%22reviews__review_role%22%7D\\\"]\"},\"typography_line_height\":{\"unit\":\"px\",\"size\":24,\"sizes\":[]},\"_offset_orientation_v\":\"end\",\"typography_letter_spacing\":{\"unit\":\"px\",\"size\":-0.5,\"sizes\":[]},\"header_size\":\"span\",\"title_color\":\"#362FD9\",\"jedv_conditions\":[{\"_id\":\"5a24e58\"}]},\"elements\":[],\"widgetType\":\"heading\"}],\"isInner\":true}],\"isInner\":true},{\"id\":\"3059e62\",\"elType\":\"widget\",\"settings\":{\"editor\":\"\",\"align\":\"justify\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_line_height\":{\"unit\":\"px\",\"size\":25,\"sizes\":[]},\"__globals__\":{\"typography_typography\":\"\",\"text_color\":\"\"},\"__dynamic__\":{\"editor\":\"[elementor-tag id=\\\"5ed392b\\\" name=\\\"jet-cct-field\\\" settings=\\\"%7B%22content_type_field%22%3A%22reviews__review_text%22%7D\\\"]\"},\"text_color\":\"#133154CC\",\"_margin\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"0.7\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"65fca01\"}]},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":false}]");
INSERT INTO `wp_abz7_postmeta` VALUES("5739", "710", "_elementor_edit_mode", "builder");
INSERT INTO `wp_abz7_postmeta` VALUES("5740", "710", "_elementor_template_type", "jet-listing-items");
INSERT INTO `wp_abz7_postmeta` VALUES("5741", "710", "_elementor_version", "3.13.4");
INSERT INTO `wp_abz7_postmeta` VALUES("5742", "710", "_elementor_pro_version", "3.13.1");
INSERT INTO `wp_abz7_postmeta` VALUES("5743", "710", "_edit_lock", "1685445196:2");
INSERT INTO `wp_abz7_postmeta` VALUES("5749", "710", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("5875", "725", "_wp_attached_file", "2023/03/user2-min.png");
INSERT INTO `wp_abz7_postmeta` VALUES("5876", "725", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:414;s:6:\"height\";i:419;s:4:\"file\";s:21:\"2023/03/user2-min.png\";s:8:\"filesize\";i:32468;s:5:\"sizes\";a:4:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:21:\"user2-min-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:55711;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:21:\"user2-min-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8573;}s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"user2-min-296x300.png\";s:5:\"width\";i:296;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:54766;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"user2-min-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17155;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("5878", "726", "_wp_attached_file", "2023/03/user3-min.png");
INSERT INTO `wp_abz7_postmeta` VALUES("5879", "726", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:415;s:6:\"height\";i:414;s:4:\"file\";s:21:\"2023/03/user3-min.png\";s:8:\"filesize\";i:54962;s:5:\"sizes\";a:4:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:21:\"user3-min-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:87738;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:21:\"user3-min-100x100.png\";s:5:\"width\";i:100;s:6:\"height\";i:100;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13125;}s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"user3-min-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:87621;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"user3-min-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:26091;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("5979", "738", "_elementor_source", "post");
INSERT INTO `wp_abz7_postmeta` VALUES("5980", "738", "_elementor_edit_mode", "builder");
INSERT INTO `wp_abz7_postmeta` VALUES("5981", "738", "_elementor_template_type", "footer");
INSERT INTO `wp_abz7_postmeta` VALUES("5982", "738", "_elementor_version", "3.13.4");
INSERT INTO `wp_abz7_postmeta` VALUES("5983", "738", "_elementor_pro_version", "3.13.1");
INSERT INTO `wp_abz7_postmeta` VALUES("5984", "738", "_edit_lock", "1685444418:2");
INSERT INTO `wp_abz7_postmeta` VALUES("5985", "738", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("5986", "738", "_rankmath__data", "[{\"id\":\"ec3230f\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"column\":\"0\",\"row\":\"0\",\"isLinked\":true},\"flex_direction_tablet\":\"column\",\"background_background\":\"classic\",\"margin\":{\"unit\":\"rem\",\"top\":\"5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"__globals__\":{\"background_color\":\"globals\\/colors?id=e71cf48\"},\"jedv_conditions\":[{\"_id\":\"7d820d6\"}],\"margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"0\",\"bottom\":\"1\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"flex_gap_tablet\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true}},\"elements\":[{\"id\":\"f0a9ab7\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"66.6666\"},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"column\",\"flex_wrap\":\"nowrap\",\"jedv_conditions\":[{\"_id\":\"feff028\"}],\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"flex_justify_content_tablet\":\"center\",\"flex_justify_content_mobile\":\"center\"},\"elements\":[{\"id\":\"8e3340d\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/comment.svg\",\"id\":739},\"library\":\"svg\"},\"title_text\":\"\\u0645\\u0634\\u0627\\u0648\\u0631\\u0647 \\u0631\\u0627\\u06cc\\u06af\\u0627\\u0646\",\"description_text\":\"\\u0628\\u0627 \\u0627\\u0641\\u062a\\u062e\\u0627\\u0631 \\u0645\\u0646\\u062a\\u0638\\u0631 \\u0634\\u0646\\u06cc\\u062f\\u0646 \\u0635\\u062f\\u0627\\u06cc\\u062a\\u0627\\u0646 \\u0647\\u0633\\u062a\\u06cc\\u0645\",\"position\":\"right\",\"position_mobile\":\"right\",\"title_size\":\"div\",\"icon_space\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"icon_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"text_align\":\"right\",\"title_bottom_space\":{\"unit\":\"px\",\"size\":5,\"sizes\":[]},\"title_color\":\"#133154\",\"title_typography_typography\":\"custom\",\"title_typography_font_family\":\"YekanBakh_FaNum\",\"title_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"title_typography_font_weight\":\"900\",\"description_color\":\"#13315485\",\"description_typography_typography\":\"custom\",\"description_typography_font_family\":\"YekanBakh_FaNum\",\"description_typography_font_size\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"_flex_align_self\":\"flex-start\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"\",\"description_color\":\"\",\"description_typography_typography\":\"\"},\"jedv_conditions\":[{\"_id\":\"25e85c0\"}]},\"elements\":[],\"widgetType\":\"icon-box\"},{\"id\":\"436c54d\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/24.svg\",\"id\":740},\"library\":\"svg\"},\"title_text\":\"\\u067e\\u0634\\u062a\\u06cc\\u0628\\u0627\\u0646\\u06cc \\u062d\\u0631\\u0641\\u0647 \\u0627\\u06cc\",\"description_text\":\"\\u067e\\u0627\\u0633\\u062e\\u06af\\u0648\\u06cc\\u06cc \\u062f\\u0631 \\u0647\\u0631 \\u0633\\u0627\\u0639\\u062a \\u0627\\u0632 \\u0634\\u0628\\u0627\\u0646\\u0647 \\u0631\\u0648\\u0632\",\"position\":\"right\",\"position_mobile\":\"right\",\"title_size\":\"div\",\"icon_space\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"icon_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"text_align\":\"right\",\"title_bottom_space\":{\"unit\":\"px\",\"size\":5,\"sizes\":[]},\"title_color\":\"#133154\",\"title_typography_typography\":\"custom\",\"title_typography_font_family\":\"YekanBakh_FaNum\",\"title_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"title_typography_font_weight\":\"900\",\"description_color\":\"#13315485\",\"description_typography_typography\":\"custom\",\"description_typography_font_family\":\"YekanBakh_FaNum\",\"description_typography_font_size\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"_flex_align_self\":\"flex-start\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"\",\"description_color\":\"\",\"description_typography_typography\":\"\"},\"jedv_conditions\":[{\"_id\":\"d6b4d40\"}]},\"elements\":[],\"widgetType\":\"icon-box\"},{\"id\":\"03cfd07\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/online.svg\",\"id\":741},\"library\":\"svg\"},\"title_text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0622\\u0646\\u0644\\u0627\\u06cc\\u0646 \\u0633\\u0631\\u06cc\\u0639\",\"description_text\":\"\\u0633\\u0631\\u06cc\\u0639\\u060c \\u0627\\u06cc\\u0645\\u0646\\u060c \\u0645\\u062f\\u0631\\u0646 \\u0648 \\u0628\\u062f\\u0648\\u0646 \\u0647\\u0632\\u06cc\\u0646\\u0647 \\u0627\\u0636\\u0627\\u0641\\u06cc\",\"position\":\"right\",\"position_mobile\":\"right\",\"title_size\":\"div\",\"icon_space\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"icon_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"text_align\":\"right\",\"title_bottom_space\":{\"unit\":\"px\",\"size\":5,\"sizes\":[]},\"title_color\":\"#133154\",\"title_typography_typography\":\"custom\",\"title_typography_font_family\":\"YekanBakh_FaNum\",\"title_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"title_typography_font_weight\":\"900\",\"description_color\":\"#13315485\",\"description_typography_typography\":\"custom\",\"description_typography_font_family\":\"YekanBakh_FaNum\",\"description_typography_font_size\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"_flex_align_self\":\"flex-start\",\"__globals__\":{\"title_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"\",\"description_color\":\"\",\"description_typography_typography\":\"\"},\"jedv_conditions\":[{\"_id\":\"6968e73\"}]},\"elements\":[],\"widgetType\":\"icon-box\"}],\"isInner\":true},{\"id\":\"a20f769\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":\"33.3333\"},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_justify_content\":\"flex-end\",\"flex_justify_content_tablet\":\"center\",\"flex_justify_content_mobile\":\"space-between\",\"jedv_conditions\":[{\"_id\":\"5ae93ad\"}],\"flex_gap\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"7f71491\",\"elType\":\"widget\",\"settings\":{\"text\":\"\\u062a\\u0644\\u0641\\u0646 \\u062a\\u0645\\u0627\\u0633\",\"link\":{\"url\":\"\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"icon_align\":\"right\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakhBold_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"button_text_color\":\"#362FD9\",\"background_color\":\"#FFFFFF00\",\"text_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":true},\"__globals__\":{\"typography_typography\":\"\",\"button_text_color\":\"globals\\/colors?id=primary\",\"background_color\":\"\"},\"_element_custom_width\":{\"unit\":\"%\",\"size\":72,\"sizes\":[]},\"icon_indent\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"_flex_align_self\":\"center\",\"custom_css\":\"selector i{\\n    font-size: 7px;\\n}\",\"border_border\":\"none\",\"jedv_conditions\":[{\"_id\":\"a4a3e66\"}]},\"elements\":[],\"widgetType\":\"button\"},{\"id\":\"8e2df09\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/phone.svg\",\"id\":464},\"library\":\"svg\"},\"title_text\":\"035<strong>1234<\\/strong>\",\"description_text\":\"\",\"position\":\"left\",\"position_mobile\":\"left\",\"title_size\":\"div\",\"icon_space\":{\"unit\":\"px\",\"size\":8,\"sizes\":[]},\"icon_size\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"text_align\":\"left\",\"content_vertical_alignment\":\"middle\",\"title_typography_typography\":\"custom\",\"title_typography_font_family\":\"YekanBakh_FaNum\",\"title_typography_font_size\":{\"unit\":\"px\",\"size\":21,\"sizes\":[]},\"_flex_align_self\":\"center\",\"jedv_conditions\":[{\"_id\":\"90ddeb9\"}],\"__globals__\":{\"title_typography_typography\":\"\"}},\"elements\":[],\"widgetType\":\"icon-box\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"05479bd\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_gap\":{\"unit\":\"px\",\"size\":35,\"column\":\"35\",\"row\":\"35\",\"isLinked\":true},\"flex_direction_tablet\":\"row\",\"flex_wrap_tablet\":\"wrap\",\"margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"c0f3c7e\"}],\"padding\":{\"unit\":\"rem\",\"top\":\"2\",\"right\":\"0\",\"bottom\":\"2\",\"left\":\"0\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"2\",\"right\":\"1\",\"bottom\":\"2\",\"left\":\"1\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"8fae740\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":45},\"width_tablet\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_gap\":{\"unit\":\"px\",\"size\":12,\"sizes\":[],\"column\":\"12\",\"row\":\"12\",\"isLinked\":true},\"_flex_size\":\"none\",\"_element_width\":\"initial\",\"jedv_conditions\":[{\"_id\":\"f5085dd\"}],\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"16c3d99\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0632\\u0646\\u062f\\u06af\\u06cc\\u0646\\u0627\\u0645\\u0647 \\u0645\\u0646\",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"header_size\":\"span\",\"title_color\":\"#133154\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"typography_font_weight\":\"900\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"__globals__\":{\"title_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"\"},\"jedv_conditions\":[{\"_id\":\"e49d778\"}],\"_z_index\":1},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"a7674f7\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/05\\/seprator.svg\",\"id\":2822},\"library\":\"svg\"},\"align\":\"right\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"_margin\":{\"unit\":\"rem\",\"top\":\"-1.8\",\"right\":\"0\",\"bottom\":\"-2.3\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"5598f0c\"}]},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"2e70052\",\"elType\":\"widget\",\"settings\":{\"editor\":\"\\u0644\\u0648\\u0631\\u0645 \\u0627\\u06cc\\u067e\\u0633\\u0648\\u0645 \\u0645\\u062a\\u0646 \\u0633\\u0627\\u062e\\u062a\\u06af\\u06cc \\u0628\\u0627 \\u062a\\u0648\\u0644\\u06cc\\u062f \\u0633\\u0627\\u062f\\u06af\\u06cc \\u0646\\u0627\\u0645\\u0641\\u0647\\u0648\\u0645 \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e\\u060c \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0627\\u0633\\u062a\\u060c \\u0686\\u0627\\u067e\\u06af\\u0631\\u0647\\u0627 \\u0648 \\u0645\\u062a\\u0648\\u0646 \\u0628\\u0644\\u06a9\\u0647 \\u0631\\u0648\\u0632\\u0646\\u0627\\u0645\\u0647 \\u0648 \\u0645\\u062c\\u0644\\u0647 \\u062f\\u0631 \\u0633\\u062a\\u0648\\u0646 \\u0648 \\u0633\\u0637\\u0631\\u0622\\u0646\\u0686\\u0646\\u0627\\u0646 \\u06a9\\u0647 \\u0644\\u0627\\u0632\\u0645 \\u0627\\u0633\\u062a\\u060c \\u0648 \\u0628\\u0631\\u0627\\u06cc \\u0634\\u0631\\u0627\\u06cc\\u0637 \\u0641\\u0639\\u0644\\u06cc \\u062a\\u06a9\\u0646\\u0648\\u0644\\u0648\\u0698\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0646\\u06cc\\u0627\\u0632\\u060c \\u0648 \\u06a9\\u0627\\u0631\\u0628\\u0631\\u062f\\u0647\\u0627\\u06cc \\u0645\\u062a\\u0646\\u0648\\u0639 \\u0628\\u0627 \\u0647\\u062f\\u0641 \\u0628\\u0647\\u0628\\u0648\\u062f \\u0627\\u0628\\u0632\\u0627\\u0631\\u0647\\u0627\\u06cc \\u06a9\\u0627\\u0631\\u0628\\u0631\\u062f\\u06cc \\u0645\\u06cc \\u0628\\u0627\\u0634\\u062f\\u060c \\u06a9\\u062a\\u0627\\u0628\\u0647\\u0627\\u06cc \\u0632\\u06cc\\u0627\\u062f\\u06cc \\u062f\\u0631 \\u0634\\u0635\\u062a \\u0648 \\u0633\\u0647 \\u062f\\u0631\\u0635\\u062f \\u0634\\u0646\\u0627\\u062e\\u062a \\u0641\\u0631\\u0627\\u0648\\u0627\\u0646 \\u062c\\u0627\\u0645\\u0639\\u0647 \\u0648 \\u0645\\u062a\\u062e\\u0635\\u0635\\u0627\\u0646 \\u0631\\u0627 \\u0645\\u06cc \\u0637\\u0644\\u0628\\u062f \\u0627\\u0632 \\u0635\\u0646\\u0639\\u062a \\u0686\\u0627\\u067e\\u060c \\u0648 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9 \\u0648 \\u0628\\u0647 \\u0634\\u0645\\u0627 \\u0627\\u0645\\u06a9\\u0627\\u0646 \\u0637\\u0631\\u0627\\u062d\\u06cc \\u062c\\u0630\\u0627\\u0628 \\u0648 \\u062a\\u0645\\u0627\\u0645 \\u0639\\u06cc\\u0627\\u0631\\u06cc \\u0631\\u0627 \\u062e\\u0648\\u0627\\u0647\\u062f \\u062f\\u0627\\u062f.\",\"align\":\"justify\",\"text_color\":\"#133154BD\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"typography_line_height\":{\"unit\":\"px\",\"size\":26,\"sizes\":[]},\"_margin\":{\"unit\":\"rem\",\"top\":\"0.3\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"__globals__\":{\"typography_typography\":\"\"},\"jedv_conditions\":[{\"_id\":\"53b5e59\"}],\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"text-editor\"},{\"id\":\"bbc6960\",\"elType\":\"widget\",\"settings\":{\"social_icon_list\":[{\"social_icon\":{\"value\":\"fab fa-facebook\",\"library\":\"fa-brands\"},\"_id\":\"5e27611\"},{\"social_icon\":{\"value\":\"fab fa-twitter\",\"library\":\"fa-brands\"},\"_id\":\"6ab846c\"},{\"social_icon\":{\"value\":\"fab fa-whatsapp\",\"library\":\"fa-brands\"},\"_id\":\"49e89fa\"},{\"_id\":\"b9418fc\",\"social_icon\":{\"value\":\"fab fa-instagram\",\"library\":\"fa-brands\"}},{\"_id\":\"3ad4bf5\",\"social_icon\":{\"value\":\"fab fa-telegram\",\"library\":\"fa-brands\"}}],\"align\":\"\",\"icon_color\":\"custom\",\"icon_secondary_color\":\"#F5F5F5\",\"icon_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"icon_padding\":{\"unit\":\"em\",\"size\":0.59999999999999998,\"sizes\":[]},\"icon_spacing\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"image_border_border\":\"solid\",\"image_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"image_border_color\":\"#F5F5F5\",\"border_radius\":{\"unit\":\"px\",\"top\":\"13\",\"right\":\"13\",\"bottom\":\"13\",\"left\":\"13\",\"isLinked\":true},\"hover_primary_color\":\"#362FD90F\",\"hover_secondary_color\":\"#362FD9\",\"hover_border_color\":\"#362FD90F\",\"__globals__\":{\"icon_primary_color\":\"globals\\/colors?id=4a0ac7d\",\"icon_secondary_color\":\"globals\\/colors?id=22571cf\",\"image_border_color\":\"globals\\/colors?id=4a0ac7d\",\"hover_primary_color\":\"\",\"hover_secondary_color\":\"globals\\/colors?id=primary\",\"hover_border_color\":\"\"},\"jedv_conditions\":[{\"_id\":\"4b6951f\"}]},\"elements\":[],\"widgetType\":\"social-icons\"}],\"isInner\":true},{\"id\":\"88d33f4\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":13},\"width_tablet\":{\"unit\":\"%\",\"size\":47,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"_flex_size\":\"none\",\"_element_width\":\"initial\",\"jedv_conditions\":[{\"_id\":\"85b3318\"}],\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"flex_gap\":{\"unit\":\"px\",\"size\":12,\"sizes\":[],\"column\":\"12\",\"row\":\"12\",\"isLinked\":true}},\"elements\":[{\"id\":\"1910566\",\"elType\":\"widget\",\"settings\":{\"title\":\"\\u0644\\u06cc\\u0646\\u06a9\\u200c\\u0647\\u0627\\u06cc \\u0645\\u0647\\u0645\",\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"header_size\":\"span\",\"title_color\":\"#133154\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":16,\"sizes\":[]},\"typography_font_weight\":\"900\",\"_element_custom_width\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"__globals__\":{\"title_color\":\"globals\\/colors?id=text\",\"typography_typography\":\"\"},\"jedv_conditions\":[{\"_id\":\"fcb16e8\"}]},\"elements\":[],\"widgetType\":\"heading\"},{\"id\":\"0030c6e\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/05\\/seprator.svg\",\"id\":2822},\"library\":\"svg\"},\"align\":\"right\",\"size\":{\"unit\":\"px\",\"size\":60,\"sizes\":[]},\"_margin\":{\"unit\":\"rem\",\"top\":\"-1.8\",\"right\":\"0\",\"bottom\":\"-2.3\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"jedv_conditions\":[{\"_id\":\"5598f0c\"}]},\"elements\":[],\"widgetType\":\"icon\"},{\"id\":\"d12933c\",\"elType\":\"widget\",\"settings\":{\"icon_list\":[{\"text\":\"\\u0631\\u0632\\u0631\\u0648 \\u0622\\u0646\\u0644\\u0627\\u06cc\\u0646 \\u0646\\u0648\\u0628\\u062a\",\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"_id\":\"3169051\",\"link\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/reservation\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"}},{\"text\":\"\\u062f\\u0631\\u0628\\u0627\\u0631\\u0647 \\u0645\\u0646\",\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"link\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/about-me\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"_id\":\"f5689c8\"},{\"text\":\"\\u062a\\u0645\\u0627\\u0633 \\u0628\\u0627 \\u0645\\u0646\",\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"link\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/contact\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"_id\":\"20d2ae6\"},{\"text\":\"\\u0641\\u0631\\u0648\\u0634\\u06af\\u0627\\u0647 \\u0645\\u062d\\u0635\\u0648\\u0644\\u0627\\u062a\",\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"link\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/shop\\/\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"_id\":\"fb55f2f\"},{\"text\":\"\\u0642\\u0648\\u0627\\u0646\\u06cc\\u0646 \\u0633\\u0627\\u06cc\\u062a\",\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"link\":{\"url\":\"#\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"_id\":\"52508ae\"},{\"text\":\"\\u062d\\u0631\\u06cc\\u0645 \\u062e\\u0635\\u0648\\u0635\\u06cc\",\"selected_icon\":{\"value\":\"fas fa-circle\",\"library\":\"fa-solid\"},\"link\":{\"url\":\"#\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"_id\":\"3372170\"}],\"space_between\":{\"unit\":\"px\",\"size\":11,\"sizes\":[]},\"icon_size\":{\"unit\":\"px\",\"size\":7,\"sizes\":[]},\"text_color\":\"#133154BD\",\"icon_typography_typography\":\"custom\",\"icon_typography_font_family\":\"YekanBakh_FaNum\",\"icon_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"__globals__\":{\"icon_typography_typography\":\"\",\"icon_color\":\"globals\\/colors?id=secondary\",\"icon_color_hover\":\"globals\\/colors?id=primary\",\"text_color_hover\":\"globals\\/colors?id=primary\"},\"jedv_conditions\":[{\"_id\":\"b836ad6\"}],\"space_between_tablet\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"_margin\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_margin_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"_margin_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[],\"widgetType\":\"icon-list\"}],\"isInner\":true},{\"id\":\"88ca9f1\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":36},\"width_tablet\":{\"unit\":\"%\",\"size\":48,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_justify_content\":\"center\",\"flex_gap\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true},\"border_border\":\"solid\",\"border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"border_radius\":{\"unit\":\"px\",\"top\":\"25\",\"right\":\"25\",\"bottom\":\"25\",\"left\":\"25\",\"isLinked\":true},\"padding\":{\"unit\":\"rem\",\"top\":\"1.7\",\"right\":\"2\",\"bottom\":\"1.7\",\"left\":\"2\",\"isLinked\":false},\"_flex_size\":\"none\",\"_element_width\":\"initial\",\"__globals__\":{\"border_color\":\"globals\\/colors?id=secondary\"},\"jedv_conditions\":[{\"_id\":\"0016feb\"}],\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"33ed659\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"\",\"library\":\"\"},\"title_text\":\"<strong>\\u0622\\u062f\\u0631\\u0633<\\/strong> \\u0645\\u0646\",\"description_text\":\"\\u06cc\\u0632\\u062f\\u060c \\u0628\\u0644\\u0648\\u0627\\u0631 \\u0637\\u0631\\u0627\\u062d\\u0627\\u0646 \\u0633\\u0627\\u06cc\\u062a\\u060c \\u062e\\u06cc\\u0627\\u0628\\u0627\\u0646 \\u0648\\u0631\\u062f\\u067e\\u0631\\u0633\\u060c \\u06a9\\u0648\\u0686\\u0647 \\u0627\\u0648\\u0644\\u060c \\u0637\\u0628\\u0642\\u0647 2\",\"position\":\"right\",\"position_mobile\":\"right\",\"title_size\":\"div\",\"icon_space\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"icon_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"text_align\":\"right\",\"title_bottom_space\":{\"unit\":\"px\",\"size\":5,\"sizes\":[]},\"title_color\":\"#133154\",\"title_typography_typography\":\"custom\",\"title_typography_font_family\":\"YekanBakh_FaNum\",\"title_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"description_color\":\"#13315485\",\"description_typography_typography\":\"custom\",\"description_typography_font_family\":\"YekanBakh_FaNum\",\"description_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"__globals__\":{\"title_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"\",\"description_color\":\"\",\"description_typography_typography\":\"\"},\"jedv_conditions\":[{\"_id\":\"1460ee5\"}]},\"elements\":[],\"widgetType\":\"icon-box\"},{\"id\":\"37c1dc5\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"\",\"library\":\"\"},\"title_text\":\"<strong>\\u062a\\u0644\\u0641\\u0646<\\/strong> \\u0645\\u0646\",\"description_text\":\"0351234 - 09131234567\",\"position\":\"right\",\"position_mobile\":\"right\",\"title_size\":\"div\",\"icon_space\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"icon_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"text_align\":\"right\",\"title_bottom_space\":{\"unit\":\"px\",\"size\":5,\"sizes\":[]},\"title_color\":\"#133154\",\"title_typography_typography\":\"custom\",\"title_typography_font_family\":\"YekanBakh_FaNum\",\"title_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"description_color\":\"#13315485\",\"description_typography_typography\":\"custom\",\"description_typography_font_family\":\"YekanBakh_FaNum\",\"description_typography_font_size\":{\"unit\":\"px\",\"size\":13,\"sizes\":[]},\"__globals__\":{\"title_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"\",\"description_color\":\"\",\"description_typography_typography\":\"\"},\"jedv_conditions\":[{\"_id\":\"6851f9f\"}]},\"elements\":[],\"widgetType\":\"icon-box\"},{\"id\":\"98b0e9a\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":\"\",\"library\":\"\"},\"title_text\":\"<strong>\\u0627\\u06cc\\u0645\\u06cc\\u0644<\\/strong> \\u0645\\u0646\",\"description_text\":\"example@yoursite.com\",\"position\":\"right\",\"position_mobile\":\"right\",\"title_size\":\"div\",\"icon_space\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"icon_size\":{\"unit\":\"px\",\"size\":22,\"sizes\":[]},\"text_align\":\"right\",\"title_bottom_space\":{\"unit\":\"px\",\"size\":5,\"sizes\":[]},\"title_color\":\"#133154\",\"title_typography_typography\":\"custom\",\"title_typography_font_family\":\"YekanBakh_FaNum\",\"title_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"description_color\":\"#13315485\",\"description_typography_typography\":\"custom\",\"description_typography_font_family\":\"YekanBakh_FaNum\",\"description_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"__globals__\":{\"title_color\":\"globals\\/colors?id=text\",\"title_typography_typography\":\"\",\"description_color\":\"\",\"description_typography_typography\":\"\"},\"jedv_conditions\":[{\"_id\":\"3441bc9\"}]},\"elements\":[],\"widgetType\":\"icon-box\"}],\"isInner\":true}],\"isInner\":false},{\"id\":\"ad1c1c5\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"flex_direction_mobile\":\"row\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"10\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"e856ec6\"}],\"flex_align_items\":\"center\",\"flex_gap\":{\"unit\":\"px\",\"size\":0,\"sizes\":[],\"column\":\"0\",\"row\":\"0\",\"isLinked\":true},\"flex_gap_mobile\":{\"unit\":\"px\",\"size\":10,\"sizes\":[],\"column\":\"10\",\"row\":\"10\",\"isLinked\":true},\"flex_wrap_mobile\":\"wrap\",\"background_background\":\"classic\",\"background_color_b\":\"\",\"background_gradient_angle\":{\"unit\":\"deg\",\"size\":270,\"sizes\":[]},\"background_image\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/footerBar.svg\",\"id\":2041,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"bottom center\",\"background_repeat\":\"no-repeat\",\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0\",\"right\":\"1\",\"bottom\":\"0.7\",\"left\":\"1\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"__globals__\":{\"border_color\":\"\",\"background_color\":\"\",\"background_color_b\":\"\"}},\"elements\":[{\"id\":\"695382b\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":76},\"background_background\":\"gradient\",\"background_color\":\"#FAFAFA\",\"background_color_b\":\"#FFFFFF00\",\"background_gradient_angle\":{\"unit\":\"deg\",\"size\":270,\"sizes\":[]},\"border_radius\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"_flex_order_mobile\":\"end\",\"_flex_size\":\"none\",\"_element_width\":\"initial\",\"__globals__\":{\"background_color\":\"\",\"background_color_b\":\"\"},\"jedv_conditions\":[{\"_id\":\"22c79b6\"}],\"border_radius_mobile\":{\"unit\":\"px\",\"top\":\"10\",\"right\":\"10\",\"bottom\":\"10\",\"left\":\"10\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"5\",\"right\":\"10\",\"bottom\":\"5\",\"left\":\"10\",\"isLinked\":false},\"width_tablet\":{\"unit\":\"%\",\"size\":70,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"padding\":{\"unit\":\"rem\",\"top\":\"0.8\",\"right\":\"1\",\"bottom\":\"0.8\",\"left\":\"1\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"78d2ffb\",\"elType\":\"widget\",\"settings\":{\"editor\":\"1402 - \\u06a9\\u0644\\u06cc\\u0647 \\u062d\\u0642\\u0648\\u0642 \\u0628\\u0631\\u0627\\u06cc \\u0633\\u0627\\u06cc\\u062a \\u0622\\u0645\\u0627\\u062f\\u0647 \\u067e\\u0632\\u0634\\u06a9\\u06cc + \\u0631\\u0632\\u0631\\u0648 \\u0646\\u0648\\u0628\\u062a\\u060c \\u0645\\u062d\\u0641\\u0648\\u0638 \\u0628\\u0648\\u062f\\u0647 \\u0648 \\u0647\\u0631 \\u06af\\u0648\\u0646\\u0647 \\u06a9\\u067e\\u06cc \\u0628\\u0631\\u062f\\u0627\\u0631\\u06cc \\u067e\\u06cc\\u06af\\u0631\\u062f \\u0642\\u0627\\u0646\\u0648\\u0646\\u06cc \\u062f\\u0627\\u0631\\u062f.\",\"align\":\"justify\",\"text_color\":\"#13315470\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_line_height\":{\"unit\":\"px\",\"size\":26,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"__globals__\":{\"typography_typography\":\"\"},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"5776af2\"}],\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true},{\"id\":\"f927216\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":4},\"width_mobile\":{\"unit\":\"%\",\"size\":15},\"_flex_size\":\"none\",\"_element_width\":\"initial\",\"_element_width_mobile\":\"initial\",\"jedv_conditions\":[{\"_id\":\"5129b0d\"}],\"width_tablet\":{\"unit\":\"%\",\"size\":6,\"sizes\":[]},\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"6\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[{\"id\":\"4a9b5d9\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/arrow-up.svg\",\"id\":775},\"library\":\"svg\"},\"link\":{\"url\":\"#top\",\"is_external\":\"\",\"nofollow\":\"\",\"custom_attributes\":\"\"},\"align\":\"left\",\"align_mobile\":\"left\",\"size\":{\"unit\":\"px\",\"size\":24,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"18ff56d\"}],\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-8\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"icon\"}],\"isInner\":true},{\"id\":\"e493720\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":20,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":80},\"flex_direction\":\"column\",\"background_background\":\"classic\",\"border_radius\":{\"unit\":\"px\",\"top\":\"13\",\"right\":\"13\",\"bottom\":\"13\",\"left\":\"13\",\"isLinked\":true},\"_flex_size\":\"none\",\"__globals__\":{\"background_color\":\"globals\\/colors?id=primary\"},\"_element_width_mobile\":\"initial\",\"jedv_conditions\":[{\"_id\":\"fe2859f\"}],\"width_tablet\":{\"unit\":\"%\",\"size\":24,\"sizes\":[]},\"padding\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"0.5\",\"bottom\":\"0.5\",\"left\":\"0.5\",\"isLinked\":false},\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"0880b84\",\"elType\":\"widget\",\"settings\":{\"editor\":\"\\u0645\\u062d\\u0644 \\u0642\\u0631\\u0627\\u0631\\u06af\\u06cc\\u0631\\u06cc \\u0646\\u0645\\u0627\\u062f \\u0647\\u0627\\u06cc \\u0645\\u062c\\u0648\\u0632 \\u0633\\u0627\\u06cc\\u062a \\u0634\\u0645\\u0627\",\"align\":\"center\",\"text_color\":\"#FFFFFF\",\"typography_typography\":\"custom\",\"typography_font_family\":\"YekanBakh_FaNum\",\"typography_font_size\":{\"unit\":\"px\",\"size\":12,\"sizes\":[]},\"typography_line_height\":{\"unit\":\"px\",\"size\":26,\"sizes\":[]},\"_margin\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"__globals__\":{\"typography_typography\":\"\"},\"typography_font_size_mobile\":{\"unit\":\"px\",\"size\":10,\"sizes\":[]},\"typography_line_height_mobile\":{\"unit\":\"px\",\"size\":18,\"sizes\":[]},\"jedv_conditions\":[{\"_id\":\"5776af2\"}],\"typography_font_size_tablet\":{\"unit\":\"px\",\"size\":9,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"text-editor\"}],\"isInner\":true}],\"isInner\":false}]");
INSERT INTO `wp_abz7_postmeta` VALUES("5988", "739", "_wp_attached_file", "2023/03/comment.svg");
INSERT INTO `wp_abz7_postmeta` VALUES("5989", "739", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:572;s:5:\"width\";i:512;s:6:\"height\";i:512;}");
INSERT INTO `wp_abz7_postmeta` VALUES("5991", "740", "_wp_attached_file", "2023/03/24.svg");
INSERT INTO `wp_abz7_postmeta` VALUES("5992", "740", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:691;s:5:\"width\";i:512;s:6:\"height\";i:512;}");
INSERT INTO `wp_abz7_postmeta` VALUES("5994", "741", "_wp_attached_file", "2023/03/online.svg");
INSERT INTO `wp_abz7_postmeta` VALUES("5995", "741", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:655;s:5:\"width\";i:512;s:6:\"height\";i:512;}");
INSERT INTO `wp_abz7_postmeta` VALUES("6013", "738", "_elementor_conditions", "a:1:{i:0;s:15:\"include/general\";}");
INSERT INTO `wp_abz7_postmeta` VALUES("6309", "775", "_wp_attached_file", "2023/03/arrow-up.svg");
INSERT INTO `wp_abz7_postmeta` VALUES("6310", "775", "_wp_attachment_metadata", "a:3:{s:8:\"filesize\";i:286;s:5:\"width\";i:512;s:6:\"height\";i:512;}");
INSERT INTO `wp_abz7_postmeta` VALUES("6307", "774", "_wp_attached_file", "2023/03/namads.png");
INSERT INTO `wp_abz7_postmeta` VALUES("6308", "774", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:160;s:6:\"height\";i:25;s:4:\"file\";s:18:\"2023/03/namads.png\";s:8:\"filesize\";i:5076;s:5:\"sizes\";a:2:{s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:17:\"namads-100x25.png\";s:5:\"width\";i:100;s:6:\"height\";i:25;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2189;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"namads-150x25.png\";s:5:\"width\";i:150;s:6:\"height\";i:25;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3653;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("6355", "780", "_menu_item_type", "post_type");
INSERT INTO `wp_abz7_postmeta` VALUES("6356", "780", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_abz7_postmeta` VALUES("6357", "780", "_menu_item_object_id", "6");
INSERT INTO `wp_abz7_postmeta` VALUES("6358", "780", "_menu_item_object", "page");
INSERT INTO `wp_abz7_postmeta` VALUES("6359", "780", "_menu_item_target", "");
INSERT INTO `wp_abz7_postmeta` VALUES("6360", "780", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_abz7_postmeta` VALUES("6361", "780", "_menu_item_xfn", "");
INSERT INTO `wp_abz7_postmeta` VALUES("6362", "780", "_menu_item_url", "");
INSERT INTO `wp_abz7_postmeta` VALUES("6364", "781", "_edit_lock", "1685520230:1");
INSERT INTO `wp_abz7_postmeta` VALUES("6365", "783", "_edit_lock", "1685518808:1");
INSERT INTO `wp_abz7_postmeta` VALUES("6366", "785", "_edit_lock", "1685522940:1");
INSERT INTO `wp_abz7_postmeta` VALUES("6367", "783", "_edit_last", "1");
INSERT INTO `wp_abz7_postmeta` VALUES("6368", "783", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("6369", "781", "_edit_last", "1");
INSERT INTO `wp_abz7_postmeta` VALUES("6370", "781", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("6371", "785", "_edit_last", "1");
INSERT INTO `wp_abz7_postmeta` VALUES("6372", "785", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("6373", "790", "_menu_item_type", "post_type");
INSERT INTO `wp_abz7_postmeta` VALUES("6374", "790", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_abz7_postmeta` VALUES("6375", "790", "_menu_item_object_id", "785");
INSERT INTO `wp_abz7_postmeta` VALUES("6376", "790", "_menu_item_object", "page");
INSERT INTO `wp_abz7_postmeta` VALUES("6377", "790", "_menu_item_target", "");
INSERT INTO `wp_abz7_postmeta` VALUES("6378", "790", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_abz7_postmeta` VALUES("6379", "790", "_menu_item_xfn", "");
INSERT INTO `wp_abz7_postmeta` VALUES("6380", "790", "_menu_item_url", "");
INSERT INTO `wp_abz7_postmeta` VALUES("6402", "793", "_elementor_template_type", "header");
INSERT INTO `wp_abz7_postmeta` VALUES("6382", "791", "_menu_item_type", "post_type");
INSERT INTO `wp_abz7_postmeta` VALUES("6383", "791", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_abz7_postmeta` VALUES("6384", "791", "_menu_item_object_id", "783");
INSERT INTO `wp_abz7_postmeta` VALUES("6385", "791", "_menu_item_object", "page");
INSERT INTO `wp_abz7_postmeta` VALUES("6386", "791", "_menu_item_target", "");
INSERT INTO `wp_abz7_postmeta` VALUES("6387", "791", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_abz7_postmeta` VALUES("6388", "791", "_menu_item_xfn", "");
INSERT INTO `wp_abz7_postmeta` VALUES("6389", "791", "_menu_item_url", "");
INSERT INTO `wp_abz7_postmeta` VALUES("6401", "793", "_elementor_edit_mode", "builder");
INSERT INTO `wp_abz7_postmeta` VALUES("6391", "792", "_menu_item_type", "post_type");
INSERT INTO `wp_abz7_postmeta` VALUES("6392", "792", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_abz7_postmeta` VALUES("6393", "792", "_menu_item_object_id", "781");
INSERT INTO `wp_abz7_postmeta` VALUES("6394", "792", "_menu_item_object", "page");
INSERT INTO `wp_abz7_postmeta` VALUES("6395", "792", "_menu_item_target", "");
INSERT INTO `wp_abz7_postmeta` VALUES("6396", "792", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_abz7_postmeta` VALUES("6397", "792", "_menu_item_xfn", "");
INSERT INTO `wp_abz7_postmeta` VALUES("6398", "792", "_menu_item_url", "");
INSERT INTO `wp_abz7_postmeta` VALUES("6400", "793", "_elementor_source", "post");
INSERT INTO `wp_abz7_postmeta` VALUES("6403", "793", "_elementor_version", "3.13.4");
INSERT INTO `wp_abz7_postmeta` VALUES("6404", "793", "_elementor_pro_version", "3.13.1");
INSERT INTO `wp_abz7_postmeta` VALUES("6405", "793", "_edit_lock", "1704279998:1");
INSERT INTO `wp_abz7_postmeta` VALUES("6406", "794", "_wp_attached_file", "2023/03/loogoo.png");
INSERT INTO `wp_abz7_postmeta` VALUES("6407", "794", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:220;s:6:\"height\";i:75;s:4:\"file\";s:18:\"2023/03/loogoo.png\";s:8:\"filesize\";i:3733;s:5:\"sizes\";a:2:{s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:17:\"loogoo-100x75.png\";s:5:\"width\";i:100;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1937;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:17:\"loogoo-150x75.png\";s:5:\"width\";i:150;s:6:\"height\";i:75;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2902;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_abz7_postmeta` VALUES("6408", "793", "_wp_page_template", "default");
INSERT INTO `wp_abz7_postmeta` VALUES("6409", "793", "_rankmath__data", "[{\"id\":\"9e92925\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"column\",\"background_background\":\"classic\",\"background_image\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/topBar.svg\",\"id\":1750,\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"top left\",\"background_repeat\":\"no-repeat\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"ea02b46\"}],\"custom_css\":\"selector:after {\\n    content: \\\"\\\";\\n    width: 30%;\\n    height: 100%;\\n    background: var(--e-global-color-primary);\\n    position: absolute;\\n    border-radius: 0 0 0 50px;\\n    z-index: -1;\\n}\\n\\n@media only screen and (max-width: 768px) { selector:after {\\n    width: 40%;\\n    border-radius: 0 0 0 30px;\\n\\n}\\n}\\n\"},\"elements\":[{\"id\":\"b129442\",\"elType\":\"container\",\"settings\":{\"flex_direction\":\"row\",\"background_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_position\":\"top left\",\"background_repeat\":\"no-repeat\",\"background_overlay_background\":\"classic\",\"background_overlay_image\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"},\"background_overlay_position\":\"top right\",\"background_overlay_repeat\":\"no-repeat\",\"background_overlay_size\":\"contain\",\"background_overlay_opacity\":{\"unit\":\"px\",\"size\":1,\"sizes\":[]},\"padding\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"0\",\"bottom\":\"0.5\",\"left\":\"0\",\"isLinked\":false},\"jedv_conditions\":[{\"_id\":\"587258d\"}],\"background_size_mobile\":\"initial\",\"background_bg_width_mobile\":{\"unit\":\"px\",\"size\":100,\"sizes\":[]},\"background_overlay_position_mobile\":\"top right\",\"background_overlay_xpos_mobile\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]},\"background_overlay_size_tablet\":\"contain\",\"background_overlay_size_mobile\":\"contain\",\"background_overlay_bg_width_tablet\":{\"unit\":\"%\",\"size\":40,\"sizes\":[]},\"background_overlay_bg_width_mobile\":{\"unit\":\"%\",\"size\":50,\"sizes\":[]},\"flex_align_items\":\"center\",\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"0.5\",\"right\":\"1\",\"bottom\":\"0.5\",\"left\":\"1\",\"isLinked\":false},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"0.7\",\"right\":\"1\",\"bottom\":\"0.7\",\"left\":\"1\",\"isLinked\":false},\"__globals__\":{\"background_color\":\"\"},\"flex_gap_tablet\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true},\"background_overlay_image_mobile\":{\"url\":\"\",\"id\":\"\",\"size\":\"\",\"alt\":\"\",\"source\":\"library\"}},\"elements\":[{\"id\":\"7fa36d0\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":20},\"boxed_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"boxed_width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"boxed_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"_flex_size\":\"none\",\"jedv_conditions\":[{\"_id\":\"331c751\"}],\"_element_width\":\"initial\",\"width_tablet\":{\"unit\":\"%\",\"size\":22.315999999999999},\"width_mobile\":{\"unit\":\"%\",\"size\":33},\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"row\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"flex_direction\":\"row\",\"flex_justify_content\":\"flex-start\",\"_element_width_tablet\":\"initial\",\"_element_width_mobile\":\"initial\",\"padding_tablet\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true},\"padding_mobile\":{\"unit\":\"rem\",\"top\":\"\",\"right\":\"\",\"bottom\":\"\",\"left\":\"\",\"isLinked\":true}},\"elements\":[{\"id\":\"7301cb7\",\"elType\":\"widget\",\"settings\":{\"__dynamic__\":{\"image\":\"[elementor-tag id=\\\"\\\" name=\\\"site-logo\\\" settings=\\\"%7B%7D\\\"]\",\"link\":\"[elementor-tag id=\\\"\\\" name=\\\"site-url\\\" settings=\\\"%7B%7D\\\"]\"},\"align\":\"right\",\"width_mobile\":{\"unit\":\"px\",\"size\":\"\",\"sizes\":[]},\"_flex_align_self\":\"center\",\"jedv_conditions\":[{\"_id\":\"6ef0952\"}],\"width\":{\"unit\":\"%\",\"size\":100,\"sizes\":[]}},\"elements\":[],\"widgetType\":\"theme-site-logo\"}],\"isInner\":true},{\"id\":\"a4b4875\",\"elType\":\"container\",\"settings\":{\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":50},\"boxed_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"boxed_width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"boxed_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"_flex_size\":\"none\",\"jedv_conditions\":[{\"_id\":\"331c751\"}],\"_element_width\":\"initial\",\"width_tablet\":{\"unit\":\"%\",\"size\":32},\"width_mobile\":{\"unit\":\"%\",\"size\":10,\"sizes\":[]},\"flex_direction_tablet\":\"row\",\"flex_direction_mobile\":\"row\",\"flex_justify_content_tablet\":\"flex-end\",\"flex_justify_content_mobile\":\"flex-end\",\"flex_justify_content\":\"center\",\"flex_align_items\":\"center\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_element_width_tablet\":\"initial\"},\"elements\":[{\"id\":\"6f1aa37\",\"elType\":\"widget\",\"settings\":{\"menu\":\"%d9%85%d9%86%d9%88-%d8%a7%d8%b5%d9%84%db%8c\",\"pointer\":\"none\",\"menu_typography_typography\":\"custom\",\"menu_typography_font_family\":\"YekanBakh_FaNum\",\"menu_typography_font_size\":{\"unit\":\"px\",\"size\":14,\"sizes\":[]},\"color_menu_item\":\"#133154\",\"padding_horizontal_menu_item\":{\"unit\":\"px\",\"size\":0,\"sizes\":[]},\"menu_space_between\":{\"unit\":\"px\",\"size\":30,\"sizes\":[]},\"__globals__\":{\"menu_typography_typography\":\"\",\"color_menu_item\":\"globals\\/colors?id=text\",\"color_menu_item_hover\":\"globals\\/colors?id=text\",\"toggle_color\":\"globals\\/colors?id=text\",\"color_dropdown_item\":\"globals\\/colors?id=text\",\"dropdown_typography_typography\":\"\",\"color_dropdown_item_hover\":\"globals\\/colors?id=primary\",\"background_color_dropdown_item_hover\":\"globals\\/colors?id=e71cf48\",\"dropdown_border_color\":\"globals\\/colors?id=fc446c3\"},\"full_width\":\"stretch\",\"toggle_background_color\":\"#FFFFFF00\",\"jedv_type\":\"hide\",\"jedv_conditions\":[{\"jedv_condition\":\"wp-is-mobile\",\"_id\":\"9a012e7\"}],\"color_menu_item_hover\":\"#133154\",\"toggle_color\":\"#133154\",\"submenu_icon\":{\"value\":\"fas fa-angle-down\",\"library\":\"fa-solid\"},\"color_dropdown_item\":\"#133154\",\"dropdown_typography_typography\":\"custom\",\"dropdown_typography_font_family\":\"YekanBakh_FaNum\",\"dropdown_typography_font_weight\":\"normal\",\"dropdown_border_border\":\"solid\",\"dropdown_border_width\":{\"unit\":\"px\",\"top\":\"1\",\"right\":\"1\",\"bottom\":\"1\",\"left\":\"1\",\"isLinked\":true},\"dropdown_border_radius\":{\"unit\":\"px\",\"top\":\"15\",\"right\":\"15\",\"bottom\":\"15\",\"left\":\"15\",\"isLinked\":true},\"dropdown_box_shadow_box_shadow_type\":\"yes\",\"dropdown_box_shadow_box_shadow\":{\"horizontal\":0,\"vertical\":7,\"blur\":12,\"spread\":0,\"color\":\"rgba(0, 0, 0, 0.03)\"},\"_padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"_padding_tablet\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"hide_mobile\":\"hidden-mobile\",\"custom_css\":\"selector .elementor-menu-toggle {\\r\\n    padding: 0;\\r\\n}\"},\"elements\":[],\"widgetType\":\"nav-menu\"},{\"id\":\"582c4d2\",\"elType\":\"widget\",\"settings\":{\"selected_icon\":{\"value\":{\"url\":\"https:\\/\\/presite.ir\\/doctor\\/wp-content\\/uploads\\/2023\\/03\\/app.svg\",\"id\":826},\"library\":\"svg\"},\"size\":{\"unit\":\"px\",\"size\":20,\"sizes\":[]},\"_flex_align_self\":\"center\",\"jedv_conditions\":[{\"_id\":\"0e742c7\",\"jedv_condition\":\"wp-is-mobile\"}],\"primary_color\":\"#FFFFFF\",\"__dynamic__\":{\"link\":\"[elementor-tag id=\\\"2f21cbc\\\" name=\\\"popup\\\" settings=\\\"%7B%22popup%22%3A%222693%22%7D\\\"]\"},\"hide_desktop\":\"hidden-desktop\",\"hide_tablet\":\"hidden-tablet\",\"_margin_mobile\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"-8\",\"left\":\"0\",\"isLinked\":false}},\"elements\":[],\"widgetType\":\"icon\"}],\"isInner\":true},{\"id\":\"5c2bc2d\",\"elType\":\"container\",\"settings\":{\"boxed_width\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"boxed_width_tablet\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"boxed_width_mobile\":{\"unit\":\"%\",\"size\":\"\",\"sizes\":[]},\"flex_direction\":\"row\",\"jedv_conditions\":[{\"_id\":\"331c751\",\"jedv_condition\":\"wp-is-mobile\"}],\"jedv_type\":\"hide\",\"content_width\":\"full\",\"width\":{\"unit\":\"%\",\"size\":27,\"sizes\":[]},\"flex_justify_content\":\"flex-end\",\"padding\":{\"unit\":\"px\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"isLinked\":false},\"width_tablet\":{\"unit\":\"%\",\"size\":41,\"sizes\":[]},\"width_mobile\":{\"unit\":\"%\",\"size\":47},\"flex_gap_tablet\":{\"unit\":\"px\",\"size\":15,\"sizes\":[],\"column\":\"15\",\"row\":\"15\",\"isLinked\":true},\"flex_a