<?php

namespace Abzarwp\Appointments;

use Jet_Dashboard\Dashboard as Dashboard;

class PersinaDate
{
    public function __construct()
    {
        add_filter("jet-dashboard/js-page-templates", [$this, "register_templates"]);
    }
    public function register_templates($templates)
    {
        $templates['jet-apb-persian-settings'] = JET_APB_PATH . 'abzarwp/persian/templates/admin/persian-settings.php';
        return $templates;
    }
    /**
     * [get_subpage_slug description]
     * @return [type] [description]
     */
    public function get_parent_slug()
    {
        return 'settings-page';
    }
    /**
     * [get_page_link description]
     * @return [type] [description]
     */
    public function get_page_link()
    {

        return Dashboard::get_instance()->get_dashboard_page_url($this->get_parent_slug(), $this->get_page_slug());
    }
    /**
     * [get_category description]
     * @return [type] [description]
     */
    public function get_category()
    {
        return 'jet-appointments-booking';
    }
    /**
     * Returns module slug
     *
     * @return void
     */
    public function get_page_slug()
    {
        return 'jet-apb-persian-settings';
    }

    /**
     * [get_page_name description]
     * @return [type] [description]
     */
    public function get_page_name()
    {
        return esc_html__('Persian Settings', 'jet-appointments-booking');
    }

    /**
     * [page_templates description]
     * @param  array  $templates [description]
     * @param  string $subpage   [description]
     * @return [type]            [description]
     */
    public function page_templates($templates = array(), $page = false, $subpage = false)
    {
        $templates['jet-apb-persian-settings'] = JET_APB_PATH . 'abzarwp/persian/templates/admin/persian-settings.php';

        return $templates;
    }
}
