(function ($) {
  'use strict';

  // Valid field types for dynamic options
  const validFieldTypes = ['text', 'number', 'email', 'url', 'date', 'time', 'phone'];

  // Initialize dynamic fields for JEBookingFormBuilder
  if (typeof JEBookingFormBuilder !== 'undefined') {
    const events = ['click', '.jet-form-editor__buttons', '.jet-form-canvas__field-remove', '.jet-form-canvas__add'];
    $(document).on(events.join(' '), function () {
      payamitoJetDynamicFields(payaitoGenerateOptions(JEBookingFormBuilder.result));
    });

    // Initial load
    payamitoJetDynamicFields(payaitoGenerateOptions(JEBookingFormBuilder.result));
  }

  // Initialize dynamic fields for JetFBActions
  if (typeof JetFBActions !== 'undefined') {
    $('#payamito_jet_metabox').on('click', function () {
      payamitoJetDynamicFields(payamitoJetFormBuilderGenerateOptions(JetFBActions.getFormFieldsBlocks()));
    });
  }

  // Generate options for JEBookingFormBuilder
  function payaitoGenerateOptions(fields) {
    const options = {};
    if (!Array.isArray(fields)) return options;

    fields.forEach(field => {
      const { name, label, type } = field.settings || {};
      if (name && label && validFieldTypes.includes(type)) {
        options[name] = label;
      }
    });

    return options;
  }

  // Generate options for JetFBActions
  function payamitoJetFormBuilderGenerateOptions(fields) {
    const options = {};
    if (!Array.isArray(fields)) return options;

    fields.forEach(field => {
      if (field.attributes && field.name && field.label && field.attributes.field_type) {
        const { name, label, attributes: { field_type: type } } = field;
        if (name && validFieldTypes.includes(type)) {
          options[name] = label;
        }
      }
    });

    return options;
  }

  // Update dynamic select fields
  function payamitoJetDynamicFields(options) {
    if (!Object.keys(options).length) return;

    $('[data-options="dynamic"]').each(function () {
      const $select = $(this);
      const selected = $select.val();
      const defaultOptions = $select.data('default-options') || {};

      // Merge default options with dynamic options
      const mergedOptions = { ...defaultOptions, ...options };

      // Clear and rebuild select options
      $select.empty();
      Object.entries(mergedOptions).forEach(([name, label]) => {
        if (name && label) {
          const option = new Option(label, name, false, name === selected);
          $select.append(option);
        }
      });
    });
  }

  // Handle user meta copy to textarea
  $('[data-copy-user-meta="copy"]').on('change', function () {
    const selectedValue = $(this).val();
    if (!selectedValue) return;

    const dataID = $(this).data('copy-texarea');
    const $textarea = $(`[data-texarea="${dataID}"]`);
    if ($textarea.length) {
      const currentValue = $textarea.val().trim();
      $textarea.val(currentValue ? `${currentValue} {${selectedValue}}` : `{${selectedValue}}`);
    }
  });
})(jQuery);
