<?php

namespace Payamito\Modules\Booking;

if (!class_exists('Plugin')) {
    class Plugin
    {
        protected static $_instance = null;

        public static function get_instance()
        {
            if (is_null(self::$_instance)) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }

        public function is_booking_exist()
        {
            return class_exists('JET_ABAF\Plugin');
        }

        public function __construct()
        {
            if ($this->is_booking_exist()) {
                $this->load_files();
                $this->init();
            }
        }

        public function load_files()
        {
            $files = [
                __DIR__ . '/callbacks.php',
                __DIR__ . '/meta-box.php'
            ];

            foreach ($files as $file) {
                if (file_exists($file)) {
                    require_once $file;
                } else {
                    error_log('Payamito_Booking_Plugin: Failed to load file ' . $file);
                }
            }
        }

        public function init()
        {
            Callbacks::get_instance();
            self::create_metabox();
        }

        public static function update_table()
        {
            payamito_jet_insert_table_column('form_id', 'jet_apartment_bookings');
            payamito_jet_insert_table_column('phone_number', 'jet_apartment_bookings');
        }

        public static function create_metabox()
        {
            if (is_admin() && class_exists('Metabox')) {
                Metabox::get_instance();
            }
        }
    }

    Plugin::get_instance();
}