<?php

namespace Payamito\Modules\Booking;

if (!class_exists('Metabox')) {
    class Metabox
    {
        public static $prefix = 'payamito_jet_booking';
        private static $_instance = null;

        public static function get_instance()
        {
            if (is_null(self::$_instance)) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }

        public function __construct()
        {
            add_action('kianfr_payamito_jet_metabox_save_after', [__CLASS__, 'save'], 10, 1);
            add_filter('payamito/jet/engine/create/metabox', [__CLASS__, 'register_meta_box']);
        }

        public static function save($settings)
        {
            global $post;
            $save_settings = [];

            foreach (['user', 'admin'] as $client) {
                $booking_settings = $settings["payamito_jet_booking_$client"] ?? [];
                $save_settings[$client]['enable'] = !empty($booking_settings['enable']);

                foreach (\Payamito_Jet_Engine_Metabox::get_status() as $status => $name) {
                    $status_settings = $booking_settings['status'] ?? [];
                    $status_prefix = $status . '_';

                    $save_settings[$client][$status] = [
                        'enable' => !empty($status_settings[$status_prefix . 'enable']),
                        'enable_pattern' => !empty($status_settings[$status_prefix . 'pattern-enable']),
                        'pattern_id' => sanitize_text_field($status_settings[$status_prefix . 'pattern-id'] ?? ''),
                        'pattern' => array_map('sanitize_text_field', (array) ($status_settings[$status_prefix . 'pattern'] ?? [])),
                        'text_tag' => sanitize_text_field($status_settings[$status_prefix . 'text-tag'] ?? ''),
                        'text' => sanitize_textarea_field($status_settings[$status_prefix . 'text'] ?? '')
                    ];
                }
            }

            if ($post->ID) {
                update_post_meta($post->ID, '_payamito_jet_booking', $save_settings);
            }
        }

        public static function register_meta_box($sections)
        {
            $sections['admin'][] = self::add_fields('admin');
            $sections['user'][] = self::add_fields('user');
            return $sections;
        }

        public static function add_fields($suffix)
        {
            if (defined('JET_ABAF_VERSION')) {
                return [
                    'id' => "payamito_jet_booking_$suffix",
                    'type' => 'accordion',
                    'accordions' => [
                        [
                            'title' => esc_html__('Bookings', 'payamito-jet-engine'),
                            'fields' => [
                                [
                                    'id' => 'enable',
                                    'type' => 'switcher',
                                    'title' => esc_html__('Enable', 'payamito-jet-engine'),
                                    'text_width' => 100,
                                    'default' => false
                                ],
                                [
                                    'id' => 'status',
                                    'type' => 'tabbed',
                                    'dependency' => ['enable', '==', 'true'],
                                    'tabs' => \Payamito_Jet_Engine_Metabox::generate_status_fileds(
                                        \Payamito_Jet_Engine_Metabox::get_status(),
                                        self::get_default_tags_bookings()
                                    )
                                ]
                            ]
                        ]
                    ]
                ];
            }

            return [
                'type' => 'notice',
                'style' => 'info',
                'content' => esc_html__('Jet Bookings Plugin is not installed', 'payamito-jet-engine')
            ];
        }

        public static function get_default_tags_bookings()
        {
            global $wpdb;

            $primary_columns = [
                'booking_id'      => esc_html__('ID', 'payamito-jet-engine'),
                'apartment_id'    => esc_html__('Apartment ID', 'payamito-jet-engine'),
                'apartment_title' => esc_html__('Apartment Title', 'payamito-jet-engine'),
                'check_in_date'   => esc_html__('Check In Date', 'payamito-jet-engine'),
                'check_out_date'  => esc_html__('Check Out Date', 'payamito-jet-engine'),
                'order_id'        => esc_html__('Order ID', 'payamito-jet-engine'),
                'status_title'    => esc_html__('Status Title', 'payamito-jet-engine'),
                'status'          => esc_html__('Status', 'payamito-jet-engine'),
                'user_id'         => esc_html__('User ID', 'payamito-jet-engine')
            ];

            $columns = array_column(
                $wpdb->get_results("SHOW COLUMNS FROM {$wpdb->prefix}jet_apartment_bookings", ARRAY_A),
                'Field'
            );

            $all_columns = array_fill_keys($columns, '');
            unset($all_columns['form_id'], $all_columns['phone_number']);

            foreach ($all_columns as $key => &$value) {
                $value = $key;
            }

            return array_merge($all_columns, $primary_columns);
        }
    }
}