<?php

namespace Payamito\Modules;

class Modules
{
    protected static $_instance = null;

    public static function get_instance()
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct()
    {
        $this->load_modules();
    }

    public function load_modules()
    {
        $module_path = __DIR__ . '/booking/booking.php';
        if (file_exists($module_path)) {
            require_once $module_path;
        } else {
            error_log('Payamito_Modules: Failed to load module file ' . $module_path);
        }
    }
}
